/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.weixin.weioa365.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.fieldextends.model.FieldExtendsVO;
import cn.myapps.authtime.fieldextends.service.FieldExtendsProcess;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.authtime.workcalendar.calendar.model.CalendarVO;
import cn.myapps.authtime.workcalendar.calendar.service.CalendarProcess;
import cn.myapps.common.Environment;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.Base64Util;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.json.JsonTmpUtil;
import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.EncodingAttributes;
import it.sauronsoftware.jave.InputFormatException;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="MyappsServiceAction")
@RequestMapping(value={"/weioa365/services"})
@Scope(value="prototype")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class MyappsServiceController {
    private static final String weioa365_addr = "https://yun.weioa365.com/{site_id}";
    protected static final String ACTION_RESULT_KEY = "status";
    protected static final int ACTION_RESULT_VALUE_SUCCESS = 1;
    protected static final int ACTION_RESULT_VALUE_FAULT = 0;
    protected static final String ACTION_MESSAGE_KEY = "message";
    protected static final String ACTION_DATA_KEY = "data";
    protected ParamsTable params;
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpSession session;
    protected Map<String, Object> dataMap = new HashMap<String, Object>();

    @RequestMapping(value={"/getDepartments.action"})
    public Map<String, Object> getDepartments() {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            ArrayList depts = new ArrayList();
            depts.addAll(process.doQueryByDomainAndValid(domainId, 1));
            for (DepartmentVO dept : depts) {
                list.add(this.department2Map(dept));
            }
            return this.addActionResult(true, "", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/updateDepartment.action"})
    public Map<String, Object> updateDepartment() {
        try {
            JSONObject dept;
            String id;
            DepartmentVO vo;
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate) && (vo = (DepartmentVO)process.doView(id = (dept = JSONObject.fromObject((Object)postDate)).getString("id"))) != null) {
                vo.setName(dept.getString("name"));
                vo.setWeixinDeptId(dept.getString("weixinDeptId"));
                String superior = dept.getString("superior");
                if (!StringUtil.isBlank((String)superior)) {
                    DepartmentVO superiorVO = (DepartmentVO)process.doView(superior);
                    vo.setSuperior(superiorVO);
                }
                process.doUpdate((AuthtimeValueObject)vo);
            }
            return this.addActionResult(true, "", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/createDepartment.action"})
    public Map<String, Object> createDepartment() {
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            DomainVO domain = (DomainVO)domainProcess.doView(domainId);
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate)) {
                JSONObject dept = JSONObject.fromObject((Object)postDate);
                String id = dept.getString("id");
                DepartmentVO d = new DepartmentVO();
                d.setId(id);
                d.setName(dept.getString("name"));
                d.setLevel(dept.getInt("level"));
                d.setDomain(domain);
                d.setDomainid(domainId);
                d.setWeixinDeptId(dept.getString("weixinDeptId"));
                String superior = dept.getString("superior");
                if (!StringUtil.isBlank((String)superior)) {
                    DepartmentVO superiorVO = (DepartmentVO)process.doView(superior);
                    d.setSuperior(superiorVO);
                }
                process.doCreate((AuthtimeValueObject)d);
            }
            return this.addActionResult(true, "", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/updateDepartments.action"})
    public Map<String, Object> updateDepartments() {
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate)) {
                try {
                    JSONArray arr = JsonTmpUtil.fromObject((Object)postDate);
                    for (JSONObject dept : arr) {
                        String id = dept.getString("id");
                        DepartmentVO vo = (DepartmentVO)process.doView(id);
                        if (vo == null) continue;
                        vo.setName(dept.getString("name"));
                        vo.setWeixinDeptId(dept.getString("weixinDeptId"));
                        String superior = dept.getString("superior");
                        if (!StringUtil.isBlank((String)superior)) {
                            DepartmentVO superiorVO = (DepartmentVO)process.doView(superior);
                            vo.setSuperior(superiorVO);
                        }
                        process.doUpdate((AuthtimeValueObject)vo);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return this.addActionResult(true, "", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getDepartmentsByLevel.action"})
    public Map<String, Object> getDepartmentsByLevel() {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            int level = params.getParameterAsInteger("level");
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            ArrayList depts = new ArrayList();
            depts.addAll(process.getDepartmentByLevel(level, domainId));
            for (DepartmentVO dept : depts) {
                list.add(this.department2Map(dept));
            }
            return this.addActionResult(true, "", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getDepartmentsByLevelAndName.action"})
    public Map<String, Object> getDepartmentsByLevelAndName() {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate)) {
                JSONObject jo = JSONObject.fromObject((Object)postDate);
                Map map = (Map)JSONObject.toBean((JSONObject)jo, Map.class);
                params.putAll(map);
            }
            int level = Integer.valueOf(params.getParameterAsString("level"));
            String name = params.getParameterAsString("name");
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            ArrayList<DepartmentVO> depts = new ArrayList<DepartmentVO>();
            depts.add(process.getDepartmentByNameAndLevel(name, level, domainId));
            for (DepartmentVO dept : depts) {
                list.add(this.department2Map(dept));
            }
            return this.addActionResult(true, "", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getDepartmentsByParams.action"})
    public Map<String, Object> getDepartmentsByParams() {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate)) {
                JSONObject jo = JSONObject.fromObject((Object)postDate);
                Map map = (Map)JSONObject.toBean((JSONObject)jo, Map.class);
                params.putAll(map);
            }
            params.setParameter("t_domain.id", (Object)domainId);
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            ArrayList depts = new ArrayList();
            String application = params.getParameterAsString("application");
            depts.addAll(process.doQueryByDomainAndApplication(domainId, application));
            for (DepartmentVO dept : depts) {
                list.add(this.department2Map(dept));
            }
            return this.addActionResult(true, "", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getUsersByParams.action"})
    public Map<String, Object> getUsersByParams() {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            params.setParameter("t_domainid", (Object)domainId);
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate)) {
                JSONObject jo = JSONObject.fromObject((Object)postDate);
                Map map = (Map)JSONObject.toBean((JSONObject)jo, Map.class);
                params.putAll(map);
            }
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            ArrayList users = new ArrayList();
            String status = params.getParameterAsString("sm_dimission");
            String superior = params.getParameterAsString("t_superior");
            String _currpage = params.getParameterAsString("_currpage");
            String _pagelines = params.getParameterAsString("_pagelines");
            int page = _currpage != null && _currpage.length() > 0 ? Integer.parseInt(_currpage) : 1;
            int lines = _pagelines != null && _pagelines.length() > 0 ? Integer.parseInt(_pagelines) : Integer.MAX_VALUE;
            users.addAll(process.doQueryLikeStatusLikeSuperior(domainId, status, superior, page, lines));
            for (UserVO u : users) {
                list.add(this.user2Map(u));
            }
            return this.addActionResult(true, "", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/updateUser.action"})
    public Map<String, Object> updateUser() {
        try {
            JSONObject user;
            String id;
            UserVO vo;
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate) && (vo = (UserVO)process.doView(id = (user = JSONObject.fromObject((Object)postDate)).getString("id"))) != null) {
                vo.setName(user.getString("name"));
                vo.setEmail(user.getString("email"));
                vo.setTelephone(user.getString("telephone"));
                vo.setAvatar(user.getString("avatar"));
                if (!StringUtils.isBlank((String)user.getString("extattr"))) {
                    FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess)ProcessFactory.createProcess(FieldExtendsProcess.class);
                    List fieldExtendses = fieldExtendsProcess.queryFieldExtendsByTable(domainId, "tableUser");
                    ArrayList<FieldExtendsVO> fes = new ArrayList<FieldExtendsVO>();
                    for (int i = 0; i < fieldExtendses.size(); ++i) {
                        FieldExtendsVO fevo = (FieldExtendsVO)fieldExtendses.get(i);
                        if (fevo == null || !fevo.getEnabel().booleanValue()) continue;
                        fes.add(fevo);
                    }
                    if (user.containsKey((Object)"extattr") && !fes.isEmpty()) {
                        JSONObject extattr = JSONObject.fromObject((Object)user.getString("extattr"));
                        JSONArray attrs = extattr.getJSONArray("attrs");
                        block3: for (FieldExtendsVO fe : fes) {
                            String name = fe.getLabel();
                            for (JSONObject attr : attrs) {
                                if (!name.equals(attr.getString("name"))) continue;
                                String fieldName = fe.getName();
                                fieldName = fieldName.replaceFirst("f", "F");
                                Method method = UserVO.class.getMethod("set" + fieldName, String.class);
                                method.invoke((Object)vo, attr.getString("value"));
                                continue block3;
                            }
                        }
                    }
                }
                process.doUpdate((AuthtimeValueObject)vo);
            }
            return this.addActionResult(true, "", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/createUser.action"})
    public Map<String, Object> createUser() {
        try {
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            DepartmentProcess deptprocess = AuthTimeServiceManager.departmentRuntimeService();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            CalendarProcess calendarProcess = (CalendarProcess)ProcessFactory.createProcess(CalendarProcess.class);
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            DomainVO domain = (DomainVO)domainProcess.doView(domainId);
            List calendars = (List)calendarProcess.doQueryByNameAndDomain("Standard_Calendar", domain.getId(), 1, 1);
            CalendarVO calendar = calendars.isEmpty() ? null : (CalendarVO)calendars.get(0);
            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess)ProcessFactory.createProcess(FieldExtendsProcess.class);
            List fieldExtendses = fieldExtendsProcess.queryFieldExtendsByTable(domain.getId(), "tableUser");
            ArrayList<FieldExtendsVO> fes = new ArrayList<FieldExtendsVO>();
            for (int i = 0; i < fieldExtendses.size(); ++i) {
                FieldExtendsVO fevo = (FieldExtendsVO)fieldExtendses.get(i);
                if (fevo == null || !fevo.getEnabel().booleanValue()) continue;
                fes.add(fevo);
            }
            String postDate = this.getPostDataAsString();
            if (!StringUtil.isBlank((String)postDate)) {
                JSONObject extattr;
                JSONObject u = JSONObject.fromObject((Object)postDate);
                String id = u.getString("id");
                UserVO user = new UserVO();
                user.setId(id);
                user.setName(u.getString("name"));
                user.setTelephone(u.getString("telephone"));
                user.setEmail(u.getString("email"));
                user.setAvatar(u.getString("avatar"));
                user.setLoginno(u.getString("loginno"));
                user.setLoginpwd(u.getString("loginpwd"));
                user.setDomainid(domainId);
                String deptId = u.getString("defaultDepartment");
                if (!StringUtil.isBlank((String)deptId)) {
                    Collection depts = user.getUserDepartmentRoleSets();
                    UserDepartmentRoleSet set = new UserDepartmentRoleSet(id, deptId, "");
                    depts.add(set);
                    user.setUserDepartmentRoleSets(depts);
                    user.setDefaultDepartment(deptId);
                }
                if (u.containsKey((Object)"extattr") && (extattr = u.getJSONObject("extattr")) != null && !fes.isEmpty()) {
                    JSONArray attrs = extattr.getJSONArray("attrs");
                    block3: for (FieldExtendsVO fe : fes) {
                        String name = fe.getLabel();
                        for (JSONObject attr : attrs) {
                            if (!name.equals(attr.getString("name"))) continue;
                            String fieldName = fe.getName();
                            fieldName = fieldName.replaceFirst("f", "F");
                            Method method = UserVO.class.getMethod("set" + fieldName, String.class);
                            method.invoke((Object)user, attr.getString("value"));
                            continue block3;
                        }
                    }
                }
                RoleDesignTimeService roleService = AuthTimeServiceManager.roleRuntimeService();
                Collection apps = domain.getApplications();
                for (Application app : apps) {
                    Collection roles;
                    if (!app.isActivated() || (roles = roleService.getDefaultRolesByApplication(app.getApplicationid())) == null || roles.size() <= 0) continue;
                    for (Role role : roles) {
                        UserDepartmentRoleSet set = new UserDepartmentRoleSet(user.getId(), "", role.getId());
                        user.getUserDepartmentRoleSets().add(set);
                    }
                }
                user.setCalendarType(calendar != null ? calendar.getId() : null);
                process.doCreate((AuthtimeValueObject)user);
            }
            return this.addActionResult(true, "", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getDefaultAppMenus.action"})
    public Map<String, Object> getDefaultAppMenus() {
        try {
            String redirect_uri = null;
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            LinkedHashMap<String, JSONArray> agentMemus = new LinkedHashMap<String, JSONArray>();
            JSONArray txlMenu = new JSONArray();
            JSONObject txlItem1 = new JSONObject();
            txlItem1.put((Object)"name", (Object)"\u901a\u8baf\u5f55");
            txlItem1.put((Object)"type", (Object)"view");
            txlItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/contacts/index.jsp?SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            txlMenu.add((Object)txlItem1);
            JSONObject txlItem2 = new JSONObject();
            txlItem2.put((Object)"name", (Object)"\u5e38\u7528");
            txlItem2.put((Object)"type", (Object)"view");
            txlItem2.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/contacts/index.jsp?action=favoriteContacts&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            txlMenu.add((Object)txlItem2);
            agentMemus.put("tj99c93073961f81501", txlMenu);
            JSONArray kqMenu = new JSONArray();
            JSONObject kqItem1 = new JSONObject();
            kqItem1.put((Object)"name", (Object)"\u7b7e\u5230");
            kqItem1.put((Object)"type", (Object)"view");
            kqItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/attendance/sign.jsp?action=signin&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            kqMenu.add((Object)kqItem1);
            JSONObject kqItem2 = new JSONObject();
            kqItem2.put((Object)"name", (Object)"\u7b7e\u9000");
            kqItem2.put((Object)"type", (Object)"view");
            kqItem2.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/attendance/sign.jsp?action=signout&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            kqMenu.add((Object)kqItem2);
            JSONObject kqItem3 = new JSONObject();
            kqItem3.put((Object)"name", (Object)"\u8003\u52e4\u8bb0\u5f55");
            kqItem3.put((Object)"type", (Object)"view");
            kqItem3.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/attendance/wap/record.jsp?SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            kqMenu.add((Object)kqItem3);
            agentMemus.put("tj79858601a04b1a524", kqMenu);
            JSONArray pmMenu = new JSONArray();
            JSONObject pmItem1 = new JSONObject();
            pmItem1.put((Object)"name", (Object)"\u65b0\u5efa\u4efb\u52a1");
            pmItem1.put((Object)"type", (Object)"view");
            pmItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/pm/wap/index.jsp?action=createTask&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            pmMenu.add((Object)pmItem1);
            JSONObject pmItem2 = new JSONObject();
            pmItem2.put((Object)"name", (Object)"\u4efb\u52a1\u4e2d\u5fc3");
            pmItem2.put((Object)"type", (Object)"view");
            pmItem2.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/pm/wap/index.jsp?action=taskList&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            pmMenu.add((Object)pmItem2);
            JSONObject pmItem3 = new JSONObject();
            pmItem3.put((Object)"name", (Object)"\u9879\u76ee");
            pmItem3.put((Object)"type", (Object)"view");
            pmItem3.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/pm/wap/index.jsp?action=project&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            pmMenu.add((Object)pmItem3);
            agentMemus.put("tj79858601a04b1a523", pmMenu);
            JSONArray erpMenu = new JSONArray();
            JSONObject erpItem1 = new JSONObject();
            erpItem1.put((Object)"name", (Object)"\u62a5\u8868");
            erpItem1.put((Object)"type", (Object)"view");
            erpItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/extendedReport/erpReport/index.jsp?SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            erpMenu.add((Object)erpItem1);
            JSONObject erpItem2 = new JSONObject();
            erpItem2.put((Object)"name", (Object)"\u6570\u636e\u67e5\u8be2");
            erpItem2.put((Object)"type", (Object)"view");
            erpItem2.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/extendedReport/erpSearch/searchDept.jsp?SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            erpMenu.add((Object)erpItem2);
            JSONObject erpItem3 = new JSONObject();
            erpItem3.put((Object)"name", (Object)"\u8ba2\u5355");
            JSONArray erpItem3_subMenus = new JSONArray();
            JSONObject erpItem3_subItem1 = new JSONObject();
            erpItem3_subItem1.put((Object)"name", (Object)"\u91c7\u8d2d\u8ba2\u5355");
            erpItem3_subItem1.put((Object)"type", (Object)"view");
            erpItem3_subItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/extendedReport/erpOrder/orderPurchase.jsp?SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            erpItem3_subMenus.add((Object)erpItem3_subItem1);
            JSONObject erpItem3_subItem2 = new JSONObject();
            erpItem3_subItem2.put((Object)"name", (Object)"\u9500\u552e\u8ba2\u5355");
            erpItem3_subItem2.put((Object)"type", (Object)"view");
            erpItem3_subItem2.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/extendedReport/erpOrder/orderSale.jsp?SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            erpItem3_subMenus.add((Object)erpItem3_subItem2);
            erpItem3.put((Object)"sub_button", (Object)erpItem3_subMenus);
            erpMenu.add((Object)erpItem3);
            agentMemus.put("tj79858601a04b1a525", erpMenu);
            JSONArray oaMenu = new JSONArray();
            JSONObject oaItem1 = new JSONObject();
            oaItem1.put((Object)"name", (Object)"\u8fdb\u5165\u7cfb\u7edf");
            oaItem1.put((Object)"type", (Object)"view");
            oaItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/portal/index.html?application=11de-f053-df18d577-aeb6-19a7865cfdb6&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            oaMenu.add((Object)oaItem1);
            agentMemus.put("tj79858601a04b1a521", oaMenu);
            JSONArray crmMenu = new JSONArray();
            JSONObject crmItem1 = new JSONObject();
            crmItem1.put((Object)"name", (Object)"\u8fdb\u5165\u7cfb\u7edf");
            crmItem1.put((Object)"type", (Object)"view");
            crmItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/portal/index.html?application=11e6-429d-dd7a3284-86a2-074015f7cc96&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            crmMenu.add((Object)crmItem1);
            agentMemus.put("tj26a121bfc140b42d6", crmMenu);
            JSONArray xmglMenu = new JSONArray();
            JSONObject xmglItem1 = new JSONObject();
            xmglItem1.put((Object)"name", (Object)"\u8fdb\u5165\u7cfb\u7edf");
            xmglItem1.put((Object)"type", (Object)"view");
            xmglItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/portal/index.html?application=11e6-2d1c-908d1c9b-abde-35dbfa83876a&SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            xmglMenu.add((Object)xmglItem1);
            agentMemus.put("tje841b64d2ee8024111", xmglMenu);
            JSONArray qmMenu = new JSONArray();
            JSONObject qmItem1 = new JSONObject();
            qmItem1.put((Object)"name", (Object)"\u5f85\u586b\u5199");
            qmItem1.put((Object)"type", (Object)"view");
            redirect_uri = URLEncoder.encode("https://yun.weioa365.com/{site_id}/qm/wap/pendlist.jsp?SET_COOKIE_SITEID={site_id}".replace("{site_id}", Environment.getMACAddress()), "utf-8");
            qmItem1.put((Object)"url", (Object)("https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri=" + redirect_uri + "&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect"));
            qmMenu.add((Object)qmItem1);
            JSONObject qmItem2 = new JSONObject();
            qmItem2.put((Object)"name", (Object)"\u95ee\u5377\u4e2d\u5fc3");
            qmItem2.put((Object)"type", (Object)"view");
            redirect_uri = URLEncoder.encode("https://yun.weioa365.com/{site_id}/qm/wap/center.jsp?SET_COOKIE_SITEID={site_id}".replace("{site_id}", Environment.getMACAddress()), "utf-8");
            qmItem2.put((Object)"url", (Object)("https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri=" + redirect_uri + "&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect"));
            qmMenu.add((Object)qmItem2);
            agentMemus.put("tje841b64d2ee8024112", qmMenu);
            JSONArray km = new JSONArray();
            JSONObject kmItem1 = new JSONObject();
            kmItem1.put((Object)"name", (Object)"\u8fdb\u5165\u7cfb\u7edf");
            kmItem1.put((Object)"type", (Object)"view");
            kmItem1.put((Object)"url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?appid={appid}&redirect_uri={client_addr}/km/wap/index.jsp?SET_COOKIE_SITEID={site_id}&response_type=code&scope=snsapi_base&state={domainId}#wechat_redirect");
            km.add((Object)kmItem1);
            agentMemus.put("tje841b64d2ee8024113", km);
            return this.addActionResult(true, "", agentMemus);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/updateWeixinProxyType.action"})
    public Map<String, Object> updateWeixinProxyType() {
        try {
            DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            String weixinProxyType = params.getParameterAsString("weixinProxyType");
            DomainVO vo = (DomainVO)process.doView(domainId);
            if (vo != null) {
                vo.setWeixinProxyType(weixinProxyType);
                process.doUpdate((AuthtimeValueObject)vo);
            }
            return this.addActionResult(true, "", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/upload.action"})
    public Map<String, Object> upload() {
        Object is = null;
        FileOutputStream os = null;
        try {
            ParamsTable params = this.getParams();
            String fileName = this.request.getSession().getServletContext().getRealPath(params.getParameterAsString("fileName"));
            String base64File = this.getPostDataAsString();
            if (!StringUtils.isBlank((String)base64File)) {
                byte[] data = Base64Util.decodeByte((String)base64File);
                os = new FileOutputStream(fileName);
                os.write(data);
                os.close();
                if (fileName.toLowerCase().endsWith(".amr")) {
                    this.changeToMp3(fileName, fileName.replace(".amr", ".mp3"));
                }
            }
            return this.addActionResult(true, "", "success");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/imgCompress.action"})
    public Map<String, Object> imgCompress() {
        try {
            ParamsTable params = this.getParams();
            String userId = params.getParameterAsString("userId");
            String imgUri = params.getParameterAsString("imgUri");
            if (!StringUtil.isBlank((String)userId)) {
                MyappsServiceController.scaleImageWithParams(imgUri, userId, 100, 100, true, "jpg");
                return this.addActionResult(true, "", "success");
            }
            return this.addActionResult(false, "", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    public static void scaleImageWithParams(String imgUri, String userId, int width, int height, boolean auto, String format) {
        try {
            URL url = new URL(imgUri);
            BufferedImage bufferedImage = ImageIO.read(url);
            if (auto) {
                ArrayList<Integer> paramsArrayList = MyappsServiceController.getAutoWidthAndHeight(bufferedImage, width, height);
                width = paramsArrayList.get(0);
                height = paramsArrayList.get(1);
            }
            Image image = bufferedImage.getScaledInstance(width, height, 1);
            BufferedImage outputImage = new BufferedImage(width, height, 1);
            Graphics graphics = outputImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            String contextPath = Environment.getInstance().getRealPath("\\uploads\\avatar\\");
            File file = new File(contextPath);
            if (!file.exists() && !file.isDirectory()) {
                file.mkdir();
            }
            String fileName = userId + "." + format;
            ImageIO.write((RenderedImage)outputImage, format, new File(contextPath + fileName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int parseDoubleToInt(double sourceDouble) {
        int result = 0;
        result = (int)sourceDouble;
        return result;
    }

    private static ArrayList<Integer> getAutoWidthAndHeight(BufferedImage bufferedImage, int width_scale, int height_scale) {
        double scale_h;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        double scale_w = MyappsServiceController.getDot2Decimal(width_scale, width);
        if (scale_w < (scale_h = MyappsServiceController.getDot2Decimal(height_scale, height))) {
            arrayList.add(MyappsServiceController.parseDoubleToInt(scale_w * (double)width));
            arrayList.add(MyappsServiceController.parseDoubleToInt(scale_w * (double)height));
        } else {
            arrayList.add(MyappsServiceController.parseDoubleToInt(scale_h * (double)width));
            arrayList.add(MyappsServiceController.parseDoubleToInt(scale_h * (double)height));
        }
        return arrayList;
    }

    public static double getDot2Decimal(int a, int b) {
        BigDecimal bigDecimal_1 = new BigDecimal(a);
        BigDecimal bigDecimal_2 = new BigDecimal(b);
        BigDecimal bigDecimal_result = bigDecimal_1.divide(bigDecimal_2, new MathContext(4));
        Double double1 = new Double(bigDecimal_result.toString());
        return double1;
    }

    private void changeToMp3(String sourcePath, String targetPath) {
        File source = new File(sourcePath);
        File target = new File(targetPath);
        AudioAttributes audio = new AudioAttributes();
        Encoder encoder = new Encoder();
        audio.setCodec("libmp3lame");
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setFormat("mp3");
        attrs.setAudioAttributes(audio);
        try {
            encoder.encode(source, target, attrs);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InputFormatException inputFormatException) {
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    private Map<String, Object> department2Map(DepartmentVO dept) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", dept.getId());
        map.put("name", dept.getName());
        map.put("superior", dept.getSuperior() != null ? dept.getSuperior().getId() : "");
        map.put("level", dept.getLevel());
        map.put("weixinDeptId", StringUtil.isBlank((String)dept.getWeixinDeptId()) ? "" : dept.getWeixinDeptId());
        map.put("valid", dept.getValid());
        return map;
    }

    private Map<String, Object> user2Map(UserVO u) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", u.getId());
        map.put("name", u.getName());
        map.put("loginno", u.getLoginno());
        map.put("telephone", StringUtil.isBlank((String)u.getTelephone()) ? "" : u.getTelephone());
        map.put("email", StringUtil.isBlank((String)u.getEmail()) ? "" : u.getEmail());
        map.put("defaultDepartment", StringUtil.isBlank((String)u.getDefaultDepartment()) ? "" : u.getDefaultDepartment());
        map.put("superior", u.getSuperior() != null ? u.getSuperior().getId() : "");
        map.put("avatar", StringUtil.isBlank((String)u.getAvatar()) ? "" : u.getAvatar());
        map.put("level", u.getLevel());
        map.put(ACTION_RESULT_KEY, u.getStatus());
        JSONArray departments = new JSONArray();
        Collection _departments = u.getDepartments();
        if (!_departments.isEmpty()) {
            for (DepartmentVO dept : _departments) {
                if (StringUtil.isBlank((String)dept.getWeixinDeptId())) continue;
                departments.add((Object)dept.getId());
            }
        }
        map.put("departments", departments.toString());
        FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess)ProcessFactory.createProcess(FieldExtendsProcess.class);
        List fieldExtendses = fieldExtendsProcess.queryFieldExtendsByTable(u.getDomain().getId(), "tableUser");
        ArrayList<FieldExtendsVO> fes = new ArrayList<FieldExtendsVO>();
        for (int i = 0; i < fieldExtendses.size(); ++i) {
            FieldExtendsVO fevo = (FieldExtendsVO)fieldExtendses.get(i);
            if (fevo == null || !fevo.getEnabel().booleanValue()) continue;
            fes.add(fevo);
        }
        JSONObject extattr = new JSONObject();
        if (!fes.isEmpty()) {
            JSONArray attrs = new JSONArray();
            for (FieldExtendsVO fe : fes) {
                JSONObject attr;
                String label = fe.getLabel();
                String fieldName = fe.getName();
                String _fieldName = fieldName.replaceFirst("f", "F");
                Method method = UserVO.class.getMethod("get" + _fieldName, null);
                Object value = method.invoke((Object)u, null);
                if (value != null) {
                    attr = new JSONObject();
                    attr.put((Object)"name", (Object)label);
                    attr.put((Object)"value", (Object)value.toString());
                    attrs.add((Object)attr);
                    continue;
                }
                attr = new JSONObject();
                attr.put((Object)"name", (Object)label);
                attr.put((Object)"value", (Object)"");
                attrs.add((Object)attr);
            }
            extattr.put((Object)"attrs", (Object)attrs);
            if (extattr != null && extattr.getJSONArray("attrs").size() > 0) {
                map.put("extattr", extattr.toString());
            }
        }
        return map;
    }

    private String getPostDataAsString() {
        StringBuffer info = new StringBuffer();
        try {
            int iRead;
            HttpServletRequest request = this.request;
            ServletInputStream in = request.getInputStream();
            BufferedInputStream buf = new BufferedInputStream((InputStream)in);
            byte[] buffer = new byte[1024];
            while ((iRead = buf.read(buffer)) != -1) {
                info.append(new String(buffer, 0, iRead, "UTF-8"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info.toString();
    }

    public Map<String, Object> getUsers() {
        try {
            ArrayList list = new ArrayList();
            ParamsTable params = this.getParams();
            String siteId = params.getParameterAsString("site_id");
            String domainId = params.getParameterAsString("domain_id");
            UserProcess userPorcess = AuthTimeServiceManager.userRuntimeService();
            Collection user = userPorcess.queryByDomain(domainId);
            for (UserVO u : user) {
                if (u.getStatus() != 1) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", u.getId());
                map.put("name", u.getName());
                map.put("superior", u.getSuperior().getId());
                map.put("level", u.getLevel());
                list.add(map);
            }
            return this.addActionResult(true, "", list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    public ParamsTable getParams() {
        ParamsTable params = ParamsTable.convertHTTP((HttpServletRequest)this.request);
        params.setSessionid(this.request.getSession().getId());
        if (params.getParameter("_pagelines") == null) {
            params.setParameter("_pagelines", (Object)"10");
        }
        return params;
    }

    public ParamsTable getParams(HttpServletRequest request) {
        this.params = ParamsTable.convertHTTP((HttpServletRequest)request);
        this.params.setSessionid(request.getSession().getId());
        if (this.params.getParameter("_pagelines") == null) {
            this.params.setParameter("_pagelines", (Object)"10");
        }
        return this.params;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public Map<String, Object> addActionResult(boolean isSuccess, String message, Object data) {
        this.dataMap.put(ACTION_RESULT_KEY, isSuccess ? 1 : 0);
        this.dataMap.put(ACTION_MESSAGE_KEY, message);
        if (data != null) {
            this.dataMap.put(ACTION_DATA_KEY, data);
        }
        return this.dataMap;
    }
}

