/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.weixin.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.support.weixin.WeixinServiceProxy;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="WeixinServiceAction")
@RequestMapping(value={"/api/portal/weixin/jsapi"})
@Scope(value="prototype")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class WeixinServiceController {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpSession session;
    protected static final String ACTION_RESULT_KEY = "status";
    protected static final int ACTION_RESULT_VALUE_SUCCESS = 1;
    protected static final int ACTION_RESULT_VALUE_FAULT = 0;
    protected static final String ACTION_MESSAGE_KEY = "message";
    protected static final String ACTION_DATA_KEY = "data";
    protected ParamsTable params;
    protected Map<String, Object> dataMap = new HashMap<String, Object>();

    @RequestMapping(value={"/getJsapiConfig.action"})
    public Map<String, Object> getJsapiConfig() {
        try {
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String url = params.getParameterAsString("_url");
            Map config = WeixinServiceProxy.getJsapiConfig((String)url, (String)user.getDomainid());
            return this.addActionResult(true, "", config);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/upload.action"})
    public Map<String, Object> doUpload() {
        try {
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String serverId = params.getParameterAsString("serverId");
            String folder = params.getParameterAsString("folder");
            String fileType = params.getParameterAsString("fileType");
            folder = StringUtil.isBlank((String)folder) ? "photo" : folder;
            fileType = StringUtil.isBlank((String)fileType) ? "jpg" : fileType;
            String path = "/uploads/" + folder + "/" + Calendar.getInstance().get(1) + "/" + UUID.randomUUID().toString() + "." + fileType;
            File dir = new File(PropertyUtil.getPath() + File.separator + "uploads" + File.separator + folder + File.separator + Calendar.getInstance().get(1));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            WeixinServiceProxy.downloadMedia((String)user.getDomainid(), (String)serverId, (String)path);
            return this.addActionResult(true, "", path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/PMupload.action"})
    public Map<String, Object> doPMUpload() {
        try {
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String serverId = params.getParameterAsString("serverId");
            String taskid = params.getParameterAsString("taskid");
            String folder = params.getParameterAsString("folder");
            String fileType = params.getParameterAsString("fileType");
            String time = params.getParameterAsString("time");
            folder = StringUtil.isBlank((String)folder) ? "photo" : folder;
            fileType = StringUtil.isBlank((String)fileType) ? "jpg" : fileType;
            String path = "/uploads/" + folder + "/" + UUID.randomUUID().toString() + "." + fileType;
            String fileName = PropertyUtil.getPath() + path;
            File dir = new File(PropertyUtil.getPath() + "/uploads/" + folder);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            WeixinServiceProxy.downloadMedia((String)user.getDomainid(), (String)serverId, (String)path);
            fileName = fileName.replace(".amr", ".mp3");
            File f2 = new File(fileName);
            HashMap<String, String> resultInfo = new HashMap<String, String>();
            HashMap<String, String> fileMap = new HashMap<String, String>();
            HashMap<String, HashMap<String, String>> fileMap2 = new HashMap<String, HashMap<String, String>>();
            String name = f2.getName();
            String id = UUID.randomUUID().toString();
            long size = f2.length();
            resultInfo.put("id", id);
            resultInfo.put("name", name);
            resultInfo.put("size", String.valueOf(size));
            resultInfo.put("taskid", taskid);
            resultInfo.put("url", path);
            fileMap.put("id", id);
            fileMap.put("name", name);
            fileMap.put("time", time);
            fileMap2.put(id, fileMap);
            return this.addActionResult(true, "", resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    public ParamsTable getParams() {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)this.request);
            this.params.setSessionid(this.request.getSession().getId());
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public ParamsTable getParams(HttpServletRequest request) {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)request);
            this.params.setSessionid(request.getSession().getId());
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public WebUser getUser() {
        WebUser user = null;
        if (this.session == null || AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request) == null) {
            if (this.isFromWeixin()) {
                return this.getUserFromCookie();
            }
            return null;
        }
        user = AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request);
        return user;
    }

    private boolean isFromWeixin() {
        HttpServletRequest request = this.request;
        String userAgent = request.getHeader("user-agent");
        return userAgent.contains("MicroMessenger");
    }

    private WebUser getUserFromCookie() {
        HttpServletRequest request = this.request;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            JSONObject jo;
            String loginno;
            String value;
            Cookie cookie = cookies[i];
            if (!"WEB_USER_COOKIE_KEY".equals(cookie.getName()) || (value = Security.decryptPassword((String)cookie.getValue())) == null || StringUtil.isBlank((String)(loginno = (jo = JSONObject.fromObject((Object)value)).getString("loginNo")))) continue;
            try {
                UserProcess process = AuthTimeServiceManager.userRuntimeService();
                UserVO user = process.login(loginno);
                if (user == null) continue;
                WebUser webUser = new WebUser((IUser)user);
                WebUser.setWebUser((WebUser)webUser, (HttpServletRequest)request);
                return webUser;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public Map<String, Object> addActionResult(boolean isSuccess, String message, Object data) {
        this.dataMap.put(ACTION_RESULT_KEY, isSuccess ? 1 : 0);
        this.dataMap.put(ACTION_MESSAGE_KEY, message);
        if (data != null) {
            this.dataMap.put(ACTION_DATA_KEY, data);
        }
        return this.dataMap;
    }
}

