/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.weixin;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.fieldextends.model.FieldExtendsVO;
import cn.myapps.authtime.fieldextends.service.FieldExtendsProcess;
import cn.myapps.authtime.logger.model.LogVO;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.authtime.workcalendar.calendar.model.CalendarVO;
import cn.myapps.authtime.workcalendar.calendar.service.CalendarProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.runtime.logger.service.LogHelper;
import cn.myapps.runtime.logger.service.LogProcess;
import cn.myapps.support.weixin.Weioa365WeixinService;
import cn.myapps.support.weixin.WeixinHandleException;
import cn.myapps.support.weixin.model.Department;
import cn.myapps.support.weixin.model.Message;
import cn.myapps.support.weixin.model.New;
import cn.myapps.support.weixin.model.NewsMessage;
import cn.myapps.support.weixin.model.TextMessage;
import cn.myapps.support.weixin.model.User;
import cn.myapps.support.weixin.service.EventCallbackService;
import cn.myapps.support.weixin.service.MediaService;
import cn.myapps.support.weixin.service.MessageService;
import cn.myapps.support.weixin.service.QyApiService;
import cn.myapps.support.weixin.util.ImageUtil;
import cn.myapps.support.weixin.util.JsapiTicketSignUtil;
import cn.myapps.support.weixin.util.WeixinHttpsRequestUtil;
import cn.myapps.support.weixin.util.WeixinSecretCache;
import cn.myapps.support.weixin.util.aes.WXBizMsgCrypt;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.sequence.Sequence;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class WeixinService {
    public static JSONObject synchFromWeixin(DomainVO domain) throws Exception {
        JSONObject result = new JSONObject();
        JSONArray errors = new JSONArray();
        int USER_ADD_SUCCESS = 0;
        int DEPT_ADD_SUCCESS = 0;
        int USER_ADD_FAIL = 0;
        int DEPT_ADD_FAIL = 0;
        if (!WeixinService.validLicenseAuth()) {
            return result;
        }
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domain.getId()));
            List wxDepts = QyApiService.getDepartmentList((String)access_token);
            if (wxDepts.isEmpty()) {
                throw new OBPMValidateException("\u5fae\u4fe1\u4f01\u4e1a\u53f7\u90e8\u95e8\u4e3a\u7a7a");
            }
            HashMap<Integer, DepartmentVO> deptMapping = new HashMap<Integer, DepartmentVO>();
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            for (Department department : wxDepts) {
                JSONObject deptInfo = new JSONObject();
                boolean DEPT_ADD_RESULT = false;
                if (department.getLevel() == 0) {
                    List roots = (List)deptProcess.getDepartmentByLevel(0, domain.getId());
                    DepartmentVO root = (DepartmentVO)roots.get(0);
                    if (!root.getName().equals(department.getName())) {
                        root.setName(department.getName());
                        root.setWeixinDeptId(String.valueOf(department.getId()));
                        try {
                            deptProcess.doUpdate((AuthtimeValueObject)root);
                            DEPT_ADD_RESULT = true;
                        }
                        catch (Exception e) {
                            deptInfo.put((Object)"NAME", (Object)root.getName());
                            deptInfo.put((Object)"ERROR", (Object)"\u90e8\u95e8\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
                            deptInfo.put((Object)"TIP", (Object)e.getMessage());
                            e.printStackTrace();
                        }
                    } else {
                        DEPT_ADD_RESULT = true;
                    }
                    deptMapping.put(department.getId(), root);
                }
                if (department.getLevel() != 0) {
                    Collection vos = deptProcess.doQueryByDomainAndWeixinDept(String.valueOf(department.getId()), domain.getId());
                    if (vos.isEmpty()) {
                        DepartmentVO vo1 = deptProcess.getDepartmentByNameAndLevel(department.getName(), department.getLevel(), domain.getId());
                        if (vo1 != null) {
                            vo1.setWeixinDeptId(String.valueOf(department.getId()));
                            try {
                                deptProcess.doUpdate((AuthtimeValueObject)vo1);
                                DEPT_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                deptInfo.put((Object)"NAME", (Object)vo1.getName());
                                deptInfo.put((Object)"ERROR", (Object)"\u90e8\u95e8\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
                                deptInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                            deptMapping.put(department.getId(), vo1);
                        } else {
                            DepartmentVO d = new DepartmentVO();
                            d.setName(department.getName());
                            d.setLevel(department.getLevel());
                            d.setDomain(domain);
                            d.setDomainid(domain.getId());
                            d.setSuperior((DepartmentVO)deptMapping.get(department.getParentid()));
                            d.setWeixinDeptId(String.valueOf(department.getId()));
                            try {
                                deptProcess.doCreate((AuthtimeValueObject)d);
                                DEPT_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                deptInfo.put((Object)"NAME", (Object)d.getName());
                                deptInfo.put((Object)"ERROR", (Object)"\u90e8\u95e8\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
                                deptInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                            deptMapping.put(department.getId(), d);
                        }
                    } else {
                        DepartmentVO vo2 = (DepartmentVO)vos.iterator().next();
                        boolean needUpdate = false;
                        if (!vo2.getName().equals(department.getName())) {
                            vo2.setName(department.getName());
                            needUpdate = true;
                        }
                        if (vo2.getLevel() != department.getLevel()) {
                            vo2.setLevel(department.getLevel());
                            vo2.setSuperior((DepartmentVO)deptMapping.get(department.getParentid()));
                            needUpdate = true;
                        }
                        if (needUpdate) {
                            try {
                                deptProcess.doUpdate((AuthtimeValueObject)vo2);
                                DEPT_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                deptInfo.put((Object)"NAME", (Object)vo2.getName());
                                deptInfo.put((Object)"ERROR", (Object)"\u90e8\u95e8\u63d2\u5165\u6570\u636e\u5e93\u5931\u8d25");
                                deptInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            DEPT_ADD_RESULT = true;
                        }
                        deptMapping.put(department.getId(), vo2);
                    }
                }
                if (DEPT_ADD_RESULT) {
                    ++DEPT_ADD_SUCCESS;
                } else {
                    ++DEPT_ADD_FAIL;
                }
                if (deptInfo.isEmpty()) continue;
                errors.add((Object)deptInfo);
            }
            RoleDesignTimeService rp = AuthTimeServiceManager.roleRuntimeService();
            Collection apps = domain.getApplications();
            ArrayList<Role> roles = new ArrayList<Role>();
            if (!apps.isEmpty()) {
                for (Application app : apps) {
                    if (!app.isActivated()) continue;
                    roles.addAll(rp.getDefaultRolesByApplication(app.getId()));
                }
            }
            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess)ProcessFactory.createProcess(FieldExtendsProcess.class);
            List fieldExtendses = fieldExtendsProcess.queryFieldExtendsByTable(domain.getId(), "tableUser");
            ArrayList<FieldExtendsVO> fes = new ArrayList<FieldExtendsVO>();
            for (int i = 0; i < fieldExtendses.size(); ++i) {
                FieldExtendsVO fevo = (FieldExtendsVO)fieldExtendses.get(i);
                if (fevo == null || !fevo.getEnabel().booleanValue()) continue;
                fes.add(fevo);
            }
            CalendarProcess calendarProcess = (CalendarProcess)ProcessFactory.createProcess(CalendarProcess.class);
            List calendars = (List)calendarProcess.doQueryByNameAndDomain("Standard_Calendar", domain.getId(), 1, 1);
            CalendarVO calendar = calendars.isEmpty() ? null : (CalendarVO)calendars.get(0);
            String defaultPassword = "123456";
            HashMap<String, UserVO> userMapping = new HashMap<String, UserVO>();
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            for (Department department2 : wxDepts) {
                List wxUsers = QyApiService.getUsersByDepartment((String)access_token, (String)String.valueOf(department2.getId()), (String)"0", (String)"0");
                Iterator iterator2 = wxUsers.iterator();
                while (iterator2.hasNext()) {
                    JSONObject userInfo = new JSONObject();
                    User user = (User)iterator2.next();
                    if (userMapping.get(user.getUserid()) != null) {
                        if (user.getDepartment() != null && user.getDepartment().length != 1) continue;
                        ++USER_ADD_FAIL;
                        userInfo.put((Object)"NAME", (Object)user.getName());
                        userInfo.put((Object)"ERROR", (Object)"\u6570\u636e\u5e93\u5b58\u5728\u76f8\u540c\u8d26\u53f7");
                        userInfo.put((Object)"TIP", (Object)"");
                        errors.add((Object)userInfo);
                        continue;
                    }
                    UserVO userVO = userProcess.getUserByLoginno(user.getUserid(), domain.getId());
                    boolean USER_ADD_RESULT = false;
                    if (userVO == null) {
                        userVO = new UserVO();
                        userVO.setId(Sequence.getSequence());
                        userVO.setLoginno(user.getUserid());
                        userVO.setLoginpwd(defaultPassword);
                        userVO.setDomainid(domain.getId());
                        userVO.setEmail(user.getEmail());
                        userVO.setName(user.getName());
                        userVO.setTelephone(user.getMobile());
                        userVO.setDefaultDepartment(((DepartmentVO)deptMapping.get(department2.getId())).getId());
                        userVO.setCalendarType(calendar != null ? calendar.getId() : null);
                        userVO.setStatus(1);
                        if (!StringUtil.isBlank((String)user.getAvatar())) {
                            JSONObject json = new JSONObject();
                            json.put((Object)"url", (Object)user.getAvatar());
                            String Base64String = ImageUtil.transformImage2Base64String((String)user.getAvatar(), (String)userVO.getId());
                            json.put((Object)"data", (Object)(StringUtil.isBlank((String)Base64String) ? "" : Base64String));
                            if (!StringUtil.isBlank((String)Base64String)) {
                                json.put((Object)"isCompress", (Object)true);
                            } else {
                                json.put((Object)"isCompress", (Object)false);
                            }
                            userVO.setAvatar(json.toString());
                        }
                        ArrayList departments = new ArrayList();
                        for (int i = 0; i < user.getDepartment().length; ++i) {
                            departments.add(deptMapping.get(user.getDepartment()[i]));
                            if (roles != null && roles.size() > 0) {
                                for (Role role : roles) {
                                    UserDepartmentRoleSet set = new UserDepartmentRoleSet(userVO.getId(), ((DepartmentVO)deptMapping.get(user.getDepartment()[i])).getId(), role.getId());
                                    userVO.getUserDepartmentRoleSets().add(set);
                                }
                                continue;
                            }
                            UserDepartmentRoleSet set = new UserDepartmentRoleSet(userVO.getId(), ((DepartmentVO)deptMapping.get(user.getDepartment()[i])).getId(), null);
                            userVO.getUserDepartmentRoleSets().add(set);
                        }
                        userVO.setDepartments(departments);
                        if (!fes.isEmpty()) {
                            JSONObject extattr = JSONObject.fromObject((Object)user.getExtattr());
                            JSONArray attrs = extattr.getJSONArray("attrs");
                            block23: for (FieldExtendsVO fe : fes) {
                                String name = fe.getLabel();
                                for (JSONObject attr : attrs) {
                                    if (!name.equals(attr.getString("name"))) continue;
                                    String fieldName = fe.getName();
                                    fieldName = fieldName.replaceFirst("f", "F");
                                    Method method = UserVO.class.getMethod("set" + fieldName, String.class);
                                    method.invoke((Object)userVO, attr.get("value"));
                                    continue block23;
                                }
                            }
                        }
                        try {
                            userProcess.doCreate((AuthtimeValueObject)userVO);
                            USER_ADD_RESULT = true;
                        }
                        catch (Exception e) {
                            userInfo.put((Object)"NAME", (Object)userVO.getName());
                            userInfo.put((Object)"ERROR", (Object)"\u8bf7\u6821\u9a8c\u7528\u6237\u8d26\u53f7\u3001\u7535\u8bdd\u3001\u90ae\u7bb1\u7b49\u6570\u636e\u7684\u89c4\u8303\u6027");
                            userInfo.put((Object)"TIP", (Object)e.getMessage());
                            e.printStackTrace();
                        }
                    } else {
                        boolean needUpdate = WeixinService.isUpdateUserFromWeiXin(userVO, user, deptMapping, fes);
                        if (needUpdate) {
                            try {
                                WeixinService.updateUser(deptMapping, roles, user, userVO);
                                userProcess.doUpdate((AuthtimeValueObject)userVO);
                                USER_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                userInfo.put((Object)"NAME", (Object)userVO.getName());
                                userInfo.put((Object)"ERROR", (Object)"\u8bf7\u6821\u9a8c\u7528\u6237\u8d26\u53f7\u3001\u7535\u8bdd\u3001\u90ae\u7bb1\u7b49\u6570\u636e\u7684\u89c4\u8303\u6027");
                                userInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            USER_ADD_RESULT = true;
                        }
                    }
                    if (USER_ADD_RESULT) {
                        ++USER_ADD_SUCCESS;
                    } else {
                        ++USER_ADD_FAIL;
                    }
                    userMapping.put(user.getUserid(), userVO);
                    if (userInfo.isEmpty()) continue;
                    errors.add((Object)userInfo);
                }
            }
            result.put((Object)"USER_ADD_SUCCESS", (Object)USER_ADD_SUCCESS);
            result.put((Object)"DEPT_ADD_SUCCESS", (Object)DEPT_ADD_SUCCESS);
            result.put((Object)"USER_ADD_FAIL", (Object)USER_ADD_FAIL);
            result.put((Object)"DEPT_ADD_FAIL", (Object)DEPT_ADD_FAIL);
            result.put((Object)"ERRORS", (Object)errors);
        }
        catch (Exception e2) {
            OBPMValidateException e2;
            e2.printStackTrace();
            try {
                PersistenceUtils.rollbackTransaction();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (e2 instanceof WeixinHandleException) {
                e2 = new OBPMValidateException(e2.getLocalizedMessage(), (Throwable)e2);
            }
            throw e2;
        }
        return result;
    }

    private static void updateUser(Map<Integer, DepartmentVO> deptMapping, Collection<Role> roles, User user, UserVO userVO) {
        Collection userDepartmentRoleSets = userVO.getUserDepartmentRoleSets();
        Collection userDepartments = userVO.getDepartments();
        ArrayList<String> departmentIds = new ArrayList<String>();
        ArrayList<String> departmentIdsFromWeixin = new ArrayList<String>();
        int[] departments = user.getDepartment();
        for (int department : departments) {
            departmentIdsFromWeixin.add(deptMapping.get(department).getId());
        }
        Object object = userDepartments.iterator();
        while (object.hasNext()) {
            DepartmentVO departmentVO = (DepartmentVO)object.next();
            departmentIds.add(departmentVO.getId());
        }
        Iterator userDepartmentsTemp = userDepartments.iterator();
        while (userDepartmentsTemp.hasNext()) {
            DepartmentVO department = (DepartmentVO)userDepartmentsTemp.next();
            if (departmentIdsFromWeixin.contains(department.getId())) continue;
            userDepartmentsTemp.remove();
        }
        Iterator userDepartmentRoleSetsTemp = userDepartmentRoleSets.iterator();
        while (userDepartmentRoleSetsTemp.hasNext()) {
            UserDepartmentRoleSet userDepartmentRoleSet = (UserDepartmentRoleSet)userDepartmentRoleSetsTemp.next();
            if (departmentIdsFromWeixin.contains(userDepartmentRoleSet.getDepartmentId())) continue;
            userDepartmentRoleSetsTemp.remove();
        }
        for (String departmentId : departmentIdsFromWeixin) {
            if (departmentIds.contains(departmentId) || roles == null || roles.size() <= 0) continue;
            for (Role role : roles) {
                UserDepartmentRoleSet set = new UserDepartmentRoleSet(userVO.getId(), departmentId, role.getId());
                userDepartmentRoleSets.add(set);
            }
        }
        userVO.setDepartments(userDepartments);
        userVO.setUserDepartmentRoleSets(userDepartmentRoleSets);
    }

    public static UserVO updateUserFromWeixin(String userId) throws Exception {
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO userVO = (UserVO)userProcess.doView(userId);
        if (!WeixinService.validLicenseAuth()) {
            return userVO;
        }
        String domainId = userVO.getDomainid();
        String site_id = WeixinService.getSiteId(domainId);
        try {
            User user = null;
            if (site_id != null) {
                JSONObject wxUser = Weioa365WeixinService.getUser((String)userVO.getLoginno(), (String)site_id);
                if (wxUser != null) {
                    user = new User();
                    user.setAvatar(wxUser.getString("avatar"));
                    JSONArray dept = wxUser.getJSONArray("department");
                    int[] depts = new int[dept.size()];
                    for (int index = 0; index < dept.size(); ++index) {
                        int deptId;
                        depts[index] = deptId = Integer.valueOf(dept.getInt(index)).intValue();
                    }
                    user.setDepartment(depts);
                    user.setEmail(wxUser.getString("email"));
                    user.setEnable(wxUser.getInt("enable"));
                    user.setExtattr(wxUser.getString("extattr"));
                    user.setMobile(wxUser.getString("mobile"));
                    user.setName(wxUser.getString("name"));
                    user.setUserid(wxUser.getString("userid"));
                    user.setWeixinid(wxUser.getString("weixinid"));
                    user.setPosition(wxUser.getString("position"));
                }
            } else {
                String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
                if (StringUtils.isBlank((String)access_token)) {
                    return userVO;
                }
                user = QyApiService.getUser((String)access_token, (String)userVO.getLoginno());
            }
            if (user == null) {
                return userVO;
            }
            boolean needUpdate = WeixinService.isUpdateUserFromWeiXin(userVO, user);
            if (needUpdate) {
                userProcess.doUpdate((AuthtimeValueObject)userVO);
            }
        }
        catch (Exception e2) {
            OBPMValidateException e2;
            e2.printStackTrace();
            try {
                PersistenceUtils.rollbackTransaction();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (e2 instanceof WeixinHandleException) {
                e2 = new OBPMValidateException(e2.getLocalizedMessage(), (Throwable)e2);
            }
            throw e2;
        }
        return userVO;
    }

    public static void createOrUpdateUser2Weixin(UserVO userVO) throws Exception {
        if (!WeixinService.validLicenseAuth()) {
            return;
        }
        String domainId = userVO.getDomainid();
        String site_id = WeixinService.getSiteId(domainId);
        if (site_id != null) {
            Weioa365WeixinService.createOrUpdateUser2Weixin((String)userVO.getLoginno(), (String)domainId, (String)site_id);
            return;
        }
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
            List wxDepts = QyApiService.getDepartmentList((String)access_token);
            Department root = null;
            for (Department d : wxDepts) {
                if (d.getParentid() != 0) continue;
                root = d;
                break;
            }
            User wxUser = null;
            try {
                wxUser = QyApiService.getUser((String)access_token, (String)userVO.getLoginno());
            }
            catch (Exception d) {
                // empty catch block
            }
            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess)ProcessFactory.createProcess(FieldExtendsProcess.class);
            List fieldExtendses = fieldExtendsProcess.queryFieldExtendsByTable(domainId, "tableUser");
            if (wxUser != null) {
                boolean needUpdate = WeixinService.isUpdateUserToWeiXin(userVO, wxUser, root, fieldExtendses);
                if (needUpdate) {
                    try {
                        QyApiService.updateUser((String)access_token, (User)wxUser);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (userVO.getStatus() != 1) {
                    return;
                }
                if (StringUtil.isBlank((String)userVO.getTelephone()) && StringUtil.isBlank((String)userVO.getEmail())) {
                    return;
                }
                User u = WeixinService.createUser2WeiXin(userVO, new User(), root, fieldExtendses);
                try {
                    QyApiService.createUser((String)access_token, (User)u);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e2) {
            OBPMValidateException e2;
            e2.printStackTrace();
            try {
                PersistenceUtils.rollbackTransaction();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (e2 instanceof WeixinHandleException) {
                e2 = new OBPMValidateException(e2.getLocalizedMessage(), (Throwable)e2);
            }
            throw e2;
        }
    }

    public static JSONObject synch2Weixin(DomainVO domain) throws Exception {
        JSONObject result = new JSONObject();
        JSONArray errors = new JSONArray();
        int USER_ADD_SUCCESS = 0;
        int DEPT_ADD_SUCCESS = 0;
        int USER_ADD_FAIL = 0;
        int DEPT_ADD_FAIL = 0;
        if (!WeixinService.validLicenseAuth()) {
            return result;
        }
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domain.getId()));
            List wxDepts = QyApiService.getDepartmentList((String)access_token);
            HashMap<String, Department> deptMapping = new HashMap<String, Department>();
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            DepartmentVO topDeptVO = null;
            List departments = (List)deptProcess.doQueryByDomainAndValid(domain.getId(), 1);
            Department root = null;
            if (!departments.isEmpty()) {
                for (DepartmentVO departmentVO : departments) {
                    JSONObject deptInfo = new JSONObject();
                    if (departmentVO.getValid() == 0) {
                        ++DEPT_ADD_FAIL;
                        deptInfo.put((Object)"NAME", (Object)departmentVO.getName());
                        deptInfo.put((Object)"ERROR", (Object)"\u90e8\u95e8\u5931\u6548");
                        deptInfo.put((Object)"TIP", (Object)"");
                        errors.add((Object)deptInfo);
                        continue;
                    }
                    boolean DEPT_ADD_RESULT = false;
                    if (departmentVO.getLevel() == 0) {
                        Department dept;
                        topDeptVO = departmentVO;
                        if (wxDepts.isEmpty()) {
                            dept = new Department();
                            dept.setName(departmentVO.getName());
                            dept.setParentid(0);
                            try {
                                int wxdeptId = QyApiService.createDepartment((String)access_token, (Department)dept);
                                dept.setId(wxdeptId);
                                departmentVO.setWeixinDeptId(String.valueOf(wxdeptId));
                                deptProcess.doUpdate((AuthtimeValueObject)departmentVO);
                                DEPT_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                deptInfo.put((Object)"NAME", (Object)departmentVO.getName());
                                deptInfo.put((Object)"ERROR", (Object)"\u540c\u6b65\u90e8\u95e8\u5230\u5fae\u4fe1\u7aef\u5931\u8d25");
                                deptInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            dept = (Department)wxDepts.get(0);
                            dept.setName(departmentVO.getName());
                            try {
                                QyApiService.updateDepartment((String)access_token, (Department)dept);
                                departmentVO.setWeixinDeptId(String.valueOf(dept.getId()));
                                deptProcess.doUpdate((AuthtimeValueObject)departmentVO);
                                DEPT_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                deptInfo.put((Object)"NAME", (Object)departmentVO.getName());
                                deptInfo.put((Object)"ERROR", (Object)"\u540c\u6b65\u90e8\u95e8\u5230\u5fae\u4fe1\u7aef\u5931\u8d25");
                                deptInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        }
                        root = dept;
                        if (DEPT_ADD_RESULT) {
                            ++DEPT_ADD_SUCCESS;
                        } else {
                            ++DEPT_ADD_FAIL;
                        }
                        if (!deptInfo.isEmpty()) {
                            errors.add((Object)deptInfo);
                        }
                        deptMapping.put(departmentVO.getId(), dept);
                        continue;
                    }
                    boolean isSynch = false;
                    for (Department wxdept : wxDepts) {
                        if (!StringUtil.isBlank((String)departmentVO.getWeixinDeptId())) {
                            if (!String.valueOf(wxdept.getId()).equals(departmentVO.getWeixinDeptId())) continue;
                            if (!wxdept.getName().equals(departmentVO.getName())) {
                                wxdept.setName(departmentVO.getName());
                                try {
                                    QyApiService.updateDepartment((String)access_token, (Department)wxdept);
                                    DEPT_ADD_RESULT = true;
                                }
                                catch (Exception e) {
                                    deptInfo.put((Object)"NAME", (Object)departmentVO.getName());
                                    deptInfo.put((Object)"ERROR", (Object)"\u540c\u6b65\u90e8\u95e8\u5230\u5fae\u4fe1\u7aef\u5931\u8d25");
                                    deptInfo.put((Object)"TIP", (Object)e.getMessage());
                                    e.printStackTrace();
                                }
                            } else {
                                DEPT_ADD_RESULT = true;
                            }
                            deptMapping.put(departmentVO.getId(), wxdept);
                            isSynch = true;
                            break;
                        }
                        if (wxdept.getLevel() != departmentVO.getLevel() || !wxdept.getName().equals(departmentVO.getName()) || deptMapping.get(departmentVO.getSuperior().getId()) == null || ((Department)deptMapping.get(departmentVO.getSuperior().getId())).getId() != wxdept.getParentid()) continue;
                        departmentVO.setWeixinDeptId(String.valueOf(wxdept.getId()));
                        try {
                            deptProcess.doUpdate((AuthtimeValueObject)departmentVO);
                            DEPT_ADD_RESULT = true;
                        }
                        catch (Exception e) {
                            deptInfo.put((Object)"NAME", (Object)departmentVO.getName());
                            deptInfo.put((Object)"ERROR", (Object)"\u540c\u6b65\u90e8\u95e8\u5230\u5fae\u4fe1\u7aef\u5931\u8d25");
                            deptInfo.put((Object)"TIP", (Object)e.getMessage());
                            e.printStackTrace();
                        }
                        deptMapping.put(departmentVO.getId(), wxdept);
                        isSynch = true;
                        break;
                    }
                    if (!isSynch) {
                        Department dept = new Department();
                        dept.setName(departmentVO.getName());
                        if (departmentVO.getSuperior() == null) {
                            dept.setParentid(0);
                        } else {
                            Department wd = (Department)deptMapping.get(departmentVO.getSuperior().getId());
                            if (wd != null) {
                                dept.setParentid(wd.getId());
                            } else {
                                dept.setParentid(0);
                            }
                        }
                        try {
                            int wxdeptId = QyApiService.createDepartment((String)access_token, (Department)dept);
                            departmentVO.setWeixinDeptId(String.valueOf(wxdeptId));
                            dept.setId(wxdeptId);
                            deptProcess.doUpdate((AuthtimeValueObject)departmentVO);
                            DEPT_ADD_RESULT = true;
                        }
                        catch (Exception e) {
                            deptInfo.put((Object)"NAME", (Object)departmentVO.getName());
                            deptInfo.put((Object)"ERROR", (Object)"\u540c\u6b65\u90e8\u95e8\u5230\u5fae\u4fe1\u7aef\u5931\u8d25");
                            deptInfo.put((Object)"TIP", (Object)e.getMessage());
                            e.printStackTrace();
                        }
                        deptMapping.put(departmentVO.getId(), dept);
                    }
                    if (DEPT_ADD_RESULT) {
                        ++DEPT_ADD_SUCCESS;
                    } else {
                        ++DEPT_ADD_FAIL;
                    }
                    if (deptInfo.isEmpty()) continue;
                    errors.add((Object)deptInfo);
                }
            }
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            List users = (List)userProcess.queryByDomain(domain.getId());
            FieldExtendsProcess fieldExtendsProcess = (FieldExtendsProcess)ProcessFactory.createProcess(FieldExtendsProcess.class);
            List fieldExtendses = fieldExtendsProcess.queryFieldExtendsByTable(domain.getId(), "tableUser");
            if (!users.isEmpty()) {
                for (UserVO userVO : users) {
                    JSONObject userInfo = new JSONObject();
                    User wxUser = null;
                    try {
                        wxUser = QyApiService.getUser((String)access_token, (String)userVO.getLoginno());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    boolean USER_ADD_RESULT = false;
                    if (wxUser != null) {
                        boolean needUpdate = WeixinService.isUpdateUserToWeiXin(userVO, wxUser, root, fieldExtendses);
                        if (needUpdate) {
                            try {
                                QyApiService.updateUser((String)access_token, (User)wxUser);
                                USER_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                userInfo.put((Object)"NAME", (Object)wxUser.getName());
                                userInfo.put((Object)"ERROR", (Object)"\u8bf7\u6821\u9a8c\u7528\u6237\u8d26\u53f7\u3001\u7535\u8bdd\u3001\u90ae\u7bb1\u7b49\u6570\u636e\u7684\u89c4\u8303\u6027");
                                userInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            USER_ADD_RESULT = true;
                        }
                    } else {
                        boolean needCreate = true;
                        if (userVO.getStatus() != 1) {
                            userInfo.put((Object)"NAME", (Object)userVO.getName());
                            userInfo.put((Object)"ERROR", (Object)"\u7528\u6237\u72b6\u6001\u5931\u6548");
                            userInfo.put((Object)"TIP", (Object)"");
                            needCreate = false;
                        }
                        if (StringUtil.isBlank((String)userVO.getTelephone()) && StringUtil.isBlank((String)userVO.getEmail())) {
                            userInfo.put((Object)"NAME", (Object)userVO.getName());
                            userInfo.put((Object)"ERROR", (Object)"\u7528\u6237\u90ae\u7bb1\u548c\u624b\u673a\u90fd\u4e3a\u7a7a");
                            userInfo.put((Object)"TIP", (Object)"");
                            needCreate = false;
                        }
                        if (needCreate) {
                            User u = WeixinService.createUser2WeiXin(userVO, new User(), root, fieldExtendses);
                            try {
                                QyApiService.createUser((String)access_token, (User)u);
                                USER_ADD_RESULT = true;
                            }
                            catch (Exception e) {
                                userInfo.put((Object)"NAME", (Object)userVO.getName());
                                userInfo.put((Object)"ERROR", (Object)"\u8bf7\u6821\u9a8c\u7528\u6237\u8d26\u53f7\u3001\u7535\u8bdd\u3001\u90ae\u7bb1\u7b49\u6570\u636e\u7684\u89c4\u8303\u6027");
                                userInfo.put((Object)"TIP", (Object)e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }
                    if (USER_ADD_RESULT) {
                        ++USER_ADD_SUCCESS;
                    } else {
                        ++USER_ADD_FAIL;
                    }
                    if (userInfo.isEmpty()) continue;
                    errors.add((Object)userInfo);
                }
            }
            result.put((Object)"USER_ADD_SUCCESS", (Object)USER_ADD_SUCCESS);
            result.put((Object)"DEPT_ADD_SUCCESS", (Object)DEPT_ADD_SUCCESS);
            result.put((Object)"USER_ADD_FAIL", (Object)USER_ADD_FAIL);
            result.put((Object)"DEPT_ADD_FAIL", (Object)DEPT_ADD_FAIL);
            result.put((Object)"ERRORS", (Object)errors);
        }
        catch (Exception e2) {
            OBPMValidateException e2;
            e2.printStackTrace();
            if (e2 instanceof WeixinHandleException) {
                e2 = new OBPMValidateException(e2.getLocalizedMessage(), (Throwable)e2);
            }
            throw e2;
        }
        return result;
    }

    public static boolean createUser(String domainId, String name, String userid, String mobile, String email, Integer[] dept) throws Exception {
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
            User u = new User();
            u.setUserid(userid);
            u.setName(name);
            u.setMobile(mobile);
            u.setEmail(email);
            int[] depts = new int[dept.length];
            for (int i = 0; i < dept.length; ++i) {
                depts[i] = dept[i];
            }
            u.setDepartment(depts);
            QyApiService.createUser((String)access_token, (User)u);
            return true;
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static boolean updateUser(String domainId, String name, String userid, String mobile, String email, Integer[] dept) throws Exception {
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
            User u = new User();
            u.setUserid(userid);
            u.setName(name);
            u.setMobile(mobile);
            u.setEmail(email);
            int[] depts = new int[dept.length];
            for (int i = 0; i < dept.length; ++i) {
                depts[i] = dept[i];
            }
            u.setDepartment(depts);
            QyApiService.updateUser((String)access_token, (User)u);
            return true;
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static boolean deleteUser(String domainId, String userid) throws Exception {
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
            QyApiService.deleteUser((String)access_token, (String)userid);
            return true;
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static int createDepartment(String domainId, String name, Integer parentId) throws Exception {
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
            Department d = new Department();
            d.setName(name);
            d.setParentid(parentId.intValue());
            return QyApiService.createDepartment((String)access_token, (Department)d);
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void updateDepartment(String domainId, Integer id, String name, Integer parentId) throws Exception {
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
            Department d = new Department();
            d.setId(id.intValue());
            d.setName(name);
            d.setParentid(parentId.intValue());
            QyApiService.updateDepartment((String)access_token, (Department)d);
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void deleteDepartment(String domainId, String id) throws Exception {
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)WeixinSecretCache.get((String)domainId));
            QyApiService.deleteDepartment((String)access_token, (String)id);
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void clearDeptUsers(String corpID, String corpSecret, String deptid) throws Exception {
        try {
            String access_token = WeixinService.getAccessToken(corpID, corpSecret);
            List users = QyApiService.getUsersByDepartment((String)access_token, (String)deptid, (String)"1", (String)"0");
            if (!users.isEmpty()) {
                for (User user : users) {
                    QyApiService.deleteUser((String)access_token, (String)user.getUserid());
                }
            }
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static void clearDeptUsers(WeixinSecretCache.WeixinSecret weixinSecret, String deptid) throws Exception {
        try {
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)weixinSecret);
            List users = QyApiService.getUsersByDepartment((String)access_token, (String)deptid, (String)"1", (String)"0");
            if (!users.isEmpty()) {
                for (User user : users) {
                    QyApiService.deleteUser((String)access_token, (String)user.getUserid());
                }
            }
        }
        catch (Exception e) {
            throw new OBPMValidateException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String getAccessToken(String corpid, String corpsecret) throws Exception {
        WeixinSecretCache.WeixinSecret weixinSecret = new WeixinSecretCache.WeixinSecret(corpid, corpsecret, "0", "", "", "");
        return WeixinService.getAccessToken(weixinSecret);
    }

    public static String getAccessToken(WeixinSecretCache.WeixinSecret weixinSecret) throws Exception {
        if (!WeixinService.validLicenseAuth()) {
            return null;
        }
        return QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)weixinSecret);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void auth(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        if (!WeixinService.validLicenseAuth()) {
            return;
        }
        String code = request.getParameter("code");
        String domainId = request.getParameter("state");
        String applicationId = StringUtil.isBlank((String)request.getParameter("application")) ? request.getParameter("applicationId") : request.getParameter("application");
        String site_id = WeixinService.getSiteId(domainId);
        if (site_id != null) {
            WeixinService.authFromWeioa365(site_id, request, response, chain);
            return;
        } else {
            WeixinSecretCache.WeixinSecret info = WeixinSecretCache.get((String)domainId, (String)applicationId);
            if (info == null) {
                return;
            }
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)info);
            String userId = QyApiService.getUserId((String)access_token, (String)code, (String)info.getAgentId());
            if (StringUtil.isBlank((String)userId)) return;
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            UserVO user = userProcess.getUserByLoginno(userId, domainId);
            if (user == null && (user = userProcess.findByTelephone(userId, domainId)) == null) {
                user = userProcess.findByEmail(userId, domainId);
            }
            if (user != null && user.getStatus() == 1) {
                User u = QyApiService.getUser((String)access_token, (String)userId);
                if (!StringUtil.isBlank((String)u.getAvatar())) {
                    JSONObject json = new JSONObject();
                    json.put((Object)"url", (Object)u.getAvatar());
                    String Base64String = ImageUtil.transformImage2Base64String((String)u.getAvatar(), (String)user.getId());
                    json.put((Object)"data", (Object)(StringUtil.isBlank((String)Base64String) ? "" : Base64String));
                    if (!StringUtil.isBlank((String)Base64String)) {
                        json.put((Object)"isCompress", (Object)true);
                    } else {
                        json.put((Object)"isCompress", (Object)false);
                    }
                    user.setAvatar(json.toString());
                    userProcess.doUpdateWithCache((AuthtimeValueObject)user);
                }
                HttpSession session = request.getSession();
                WebUser webUser = new WebUser((IUser)user);
                DomainVO domain = (DomainVO)domainProcess.doView(domainId);
                webUser.setRecordLog(domain.getLog().booleanValue());
                webUser.setServerAddr(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/");
                webUser.setEquipment(1);
                WebUser.setWebUser((WebUser)webUser, (HttpServletRequest)request);
                String token = Security.getToken((String)user.getId());
                Cookie cookie = new Cookie("accessToken", token);
                cookie.setPath("/");
                response.addCookie(cookie);
                session.setAttribute("SKINTYPE", (Object)"phone");
                session.setAttribute("visit_from_weixin", (Object)"true");
                LogProcess logProcess = (LogProcess)ProcessFactory.createProcess(LogProcess.class);
                if (webUser == null || !webUser.isRecordLog()) return;
                String ip = LogHelper.getRequestIp((HttpServletRequest)request);
                LogVO log = LogVO.valueOf((IUser)webUser, (String)"\u767b\u5f55", (String)"\u767b\u5f55\u7cfb\u7edf", (String)ip);
                logProcess.doCreate((AuthtimeValueObject)log);
                return;
            } else {
                request.getRequestDispatcher("/login/weixinnouser.html").forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private static void authFromWeioa365(String site_id, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        String code = request.getParameter("code");
        String domainId = request.getParameter("state");
        String userId = Weioa365WeixinService.getUserId((String)code, (String)site_id);
        if (!StringUtil.isBlank((String)userId)) {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            UserVO user = userProcess.getUserByLoginno(userId, domainId);
            if (user == null || user.getStatus() == 1) {
                // empty if block
            }
            HttpSession session = request.getSession();
            WebUser webUser = new WebUser((IUser)user);
            DomainVO domain = (DomainVO)domainProcess.doView(domainId);
            webUser.setRecordLog(domain.getLog().booleanValue());
            webUser.setServerAddr(request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/");
            webUser.setEquipment(1);
            WebUser.setWebUser((WebUser)webUser, (HttpServletRequest)request);
            session.setAttribute("SKINTYPE", (Object)"phone");
            session.setAttribute("visit_from_weixin", (Object)"true");
            LogProcess logProcess = (LogProcess)ProcessFactory.createProcess(LogProcess.class);
            if (webUser != null && webUser.isRecordLog()) {
                String ip = LogHelper.getRequestIp((HttpServletRequest)request);
                LogVO log = LogVO.valueOf((IUser)webUser, (String)"\u767b\u5f55", (String)"\u767b\u5f55\u7cfb\u7edf", (String)ip);
                logProcess.doCreate((AuthtimeValueObject)log);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            request.getRequestDispatcher("/login/weixinnouser.html").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static boolean send(String title, String description, String touser, cn.myapps.runtime.dynaform.document.ejb.Document doc) throws Exception {
        if (!WeixinService.validLicenseAuth()) {
            return false;
        }
        String site_id = WeixinService.getSiteId(doc.getDomainid());
        if (!StringUtils.isBlank((String)site_id)) {
            Weioa365WeixinService.send((String)site_id, (String)doc.getDomainid(), (String)title, (String)description, (String)touser, (cn.myapps.runtime.dynaform.document.ejb.Document)doc);
            return true;
        }
        WeixinSecretCache.WeixinSecret secret = WeixinSecretCache.get((String)doc.getDomainid(), (String)doc.getApplicationid());
        if (secret == null) {
            return false;
        }
        String redirect_uri = URLEncoder.encode(secret.getServerHost() + "/mobile/index.html?application=" + doc.getApplicationid() + "#/open?linkType=00&actionContent=" + doc.getFormid() + "&docId=" + doc.getId(), "utf-8");
        StringBuilder url = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize?appid=");
        url.append(secret.getCorpID()).append("&response_type=code&scope=snsapi_base&state=").append(doc.getDomainid()).append("&redirect_uri=").append(redirect_uri).append("#wechat_redirect");
        String agentId = secret.getAgentId();
        NewsMessage message = new NewsMessage();
        message.setTouser(touser);
        message.setAgentid(agentId);
        New n = new New(title, description, url.toString());
        message.putNew(n);
        String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)secret);
        return MessageService.send((String)access_token, (Message)message);
    }

    public static boolean sendRichTextMessage(String touser, String title, String description, String url, String picUrl, String domainId, String applicationid) throws Exception {
        if (!WeixinService.validLicenseAuth()) {
            return false;
        }
        String agentId = "0";
        NewsMessage message = new NewsMessage();
        message.setTouser(touser);
        message.setAgentid(agentId);
        New n = new New(title, description, url.toString());
        if (!StringUtil.isBlank((String)picUrl)) {
            n.setPicurl(picUrl);
        }
        message.putNew(n);
        String site_id = WeixinService.getSiteId(domainId);
        if (!StringUtils.isBlank((String)site_id)) {
            if ("11de-f053-df18d577-aeb6-19a7865cfdb6".equals(applicationid)) {
                applicationid = "1";
            } else if ("11e6-429d-dd7a3284-86a2-074015f7cc96".equals(applicationid)) {
                applicationid = "6";
            } else if ("11e6-292e-6f72aed4-9a78-9b801f3f5251".equals(applicationid)) {
                applicationid = "11";
            }
            return Weioa365WeixinService.sendMessage((String)site_id, (String)domainId, (String)message.toJson(), (String)applicationid);
        }
        WeixinSecretCache.WeixinSecret secret = WeixinSecretCache.get((String)domainId, (String)applicationid);
        if (secret == null) {
            return false;
        }
        message.setAgentid(secret.getAgentId());
        String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)secret);
        return MessageService.send((String)access_token, (Message)message);
    }

    public static boolean sendTextMessage(String touser, String content, String domainId, String applicationid) throws Exception {
        if (!WeixinService.validLicenseAuth()) {
            return false;
        }
        String agentId = "0";
        TextMessage message = new TextMessage(touser, content);
        message.setAgentid(agentId);
        String site_id = WeixinService.getSiteId(domainId);
        if (!StringUtils.isBlank((String)site_id)) {
            if ("11de-f053-df18d577-aeb6-19a7865cfdb6".equals(applicationid)) {
                applicationid = "1";
            } else if ("11e6-429d-dd7a3284-86a2-074015f7cc96".equals(applicationid)) {
                applicationid = "6";
            } else if ("11e6-292e-6f72aed4-9a78-9b801f3f5251".equals(applicationid)) {
                applicationid = "11";
            }
            return Weioa365WeixinService.sendMessage((String)site_id, (String)domainId, (String)message.toJson(), (String)applicationid);
        }
        WeixinSecretCache.WeixinSecret secret = null;
        secret = "3".equals(applicationid) ? WeixinSecretCache.get((String)domainId, (String)"pm") : ("12".equals(applicationid) ? WeixinSecretCache.get((String)domainId, (String)"qm") : WeixinSecretCache.get((String)domainId, (String)applicationid));
        if (secret == null) {
            return false;
        }
        message.setAgentid(secret.getAgentId());
        String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)secret);
        return MessageService.send((String)access_token, (Message)message);
    }

    public static boolean sendMessage(String json, String domainId) throws Exception {
        if (!WeixinService.validLicenseAuth()) {
            return false;
        }
        String site_id = WeixinService.getSiteId(domainId);
        if (!StringUtils.isBlank((String)site_id)) {
            return Weioa365WeixinService.sendMessage((String)site_id, (String)domainId, (String)json, (String)"");
        }
        WeixinSecretCache.WeixinSecret secret = WeixinSecretCache.get((String)domainId);
        if (secret == null) {
            return false;
        }
        String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)secret);
        return MessageService.send((String)access_token, (String)json);
    }

    public static void validWeixinUrl(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        if (!WeixinService.validLicenseAuth()) {
            out.write("\u60a8\u7684License\u6ca1\u6709\u5bf9\u5fae\u4fe1\u4f01\u4e1a\u53f7\u529f\u80fd\u8fdb\u884c\u6388\u6743\uff0c\u76f8\u5173\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
            return;
        }
        String msg_signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        String domain = request.getParameter("domain");
        try {
            WeixinSecretCache.WeixinSecret wxSecret = WeixinSecretCache.get((String)domain);
            if (wxSecret == null) {
                out.write("\u60a8\u7684\u4f01\u4e1a\u57df\u8fd8\u6ca1\u6709\u7ed1\u5b9a\u5fae\u4fe1\u4f01\u4e1a\u53f7\uff01");
                return;
            }
            String token = wxSecret.getToken();
            String encodingAESKey = wxSecret.getEncodingAESKey();
            String corpId = wxSecret.getCorpID();
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(token, encodingAESKey, corpId);
            String result = wxcpt.VerifyURL(msg_signature, timestamp, nonce, echostr);
            out.write(result);
        }
        catch (Exception e) {
            out.write("\u89e3\u7801\u9636\u6bb5\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        out.flush();
        out.close();
    }

    public static void handelWeixinCallbackEvent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!WeixinService.validLicenseAuth()) {
            return;
        }
        String msg_signature = request.getParameter("msg_signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String postData = WeixinHttpsRequestUtil.getHttpPostDataAsString((HttpServletRequest)request);
        String domain = request.getParameter("domain");
        String eventXML = null;
        WeixinSecretCache.WeixinSecret wxSecret = null;
        try {
            wxSecret = WeixinSecretCache.get((String)domain);
            if (wxSecret == null) {
                return;
            }
            String token = wxSecret.getToken();
            String encodingAESKey = wxSecret.getEncodingAESKey();
            String corpId = wxSecret.getCorpID();
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(token, encodingAESKey, corpId);
            eventXML = wxcpt.DecryptMsg(msg_signature, timestamp, nonce, postData);
        }
        catch (Exception token) {
            // empty catch block
        }
        if (eventXML == null) {
            return;
        }
        try {
            Document doc = DocumentHelper.parseText(eventXML);
            Element root = doc.getRootElement();
            String msgType = root.elementText("MsgType");
            if (msgType.equals("event")) {
                EventCallbackService.handleEvent(eventXML, (String)domain);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        response.setStatus(200);
    }

    public static Map<String, String> getJsapiConfig(String url, String domainId) throws Exception {
        try {
            String site_id = WeixinService.getSiteId(domainId);
            if (!StringUtils.isBlank((String)site_id)) {
                return Weioa365WeixinService.getJsapiConfig((String)url, (String)site_id, (String)domainId);
            }
            WeixinSecretCache.WeixinSecret secret = WeixinSecretCache.get((String)domainId);
            if (secret == null) {
                return null;
            }
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)secret);
            String jsapi_ticket = QyApiService.getJsapiTicket((String)access_token, (String)secret.getCorpID());
            Map config = JsapiTicketSignUtil.sign((String)jsapi_ticket, (String)url);
            config.put("appId", secret.getCorpID());
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void downloadMedia(String domainId, String media_id, String fileName) throws Exception {
        try {
            String site_id = WeixinService.getSiteId(domainId);
            if (!StringUtils.isBlank((String)site_id)) {
                Weioa365WeixinService.downloadMedia((String)site_id, (String)domainId, (String)media_id, (String)fileName);
                return;
            }
            WeixinSecretCache.WeixinSecret secret = WeixinSecretCache.get((String)domainId);
            if (secret == null) {
                return;
            }
            String access_token = QyApiService.getAccessToken((WeixinSecretCache.WeixinSecret)secret);
            MediaService.downloadMedia(access_token, media_id, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String getCorpId(String site_id, String domainId) throws Exception {
        return Weioa365WeixinService.getCorpId((String)site_id, (String)domainId);
    }

    private static String getSiteId(String domainId) {
        try {
            DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
            DomainVO vo = (DomainVO)process.doView(domainId);
            if (vo != null && "cloud".equals(vo.getWeixinProxyType())) {
                return Environment.getMACAddress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void cleanWeixinSecretCache() throws Exception {
        WeixinSecretCache.clear();
        QyApiService.clearAccessToken();
    }

    private static boolean validLicenseAuth() {
        boolean falg = false;
        falg = true;
        if (!falg) {
            System.err.println("\u60a8\u7684License\u6ca1\u6709\u5bf9\u5fae\u4fe1\u4f01\u4e1a\u53f7\u529f\u80fd\u8fdb\u884c\u6388\u6743\uff0c\u76f8\u5173\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
        }
        return falg;
    }

    private static User createUser2WeiXin(UserVO userVO, User wxUser, Department root, List<FieldExtendsVO> fieldExtendses) {
        int[] depts;
        wxUser.setUserid(userVO.getLoginno());
        wxUser.setName(userVO.getName());
        wxUser.setMobile(userVO.getTelephone() != null && userVO.getTelephone().trim().length() == 11 ? userVO.getTelephone().trim() : null);
        wxUser.setEmail(userVO.getEmail() != null ? userVO.getEmail().trim() : "");
        Collection departments = userVO.getDepartments();
        if (!departments.isEmpty()) {
            depts = new int[departments.size()];
            int index = 0;
            for (DepartmentVO dept : departments) {
                String weixinDeptId = dept.getWeixinDeptId();
                if (StringUtil.isBlank((String)weixinDeptId)) continue;
                depts[index++] = Integer.parseInt(weixinDeptId);
            }
        } else {
            depts = new int[]{root.getId()};
        }
        wxUser.setDepartment(depts);
        JSONObject extattr = new JSONObject();
        JSONArray attrs = new JSONArray();
        for (int i = 0; i < fieldExtendses.size(); ++i) {
            FieldExtendsVO fevo = fieldExtendses.get(i);
            JSONObject attr = new JSONObject();
            if (fevo == null || !fevo.getEnabel().booleanValue()) continue;
            String value = fevo.getValue((AuthtimeValueObject)userVO);
            if (StringUtil.isBlank((String)value)) {
                attr.put((Object)"name", (Object)fevo.getLabel());
                attr.put((Object)"value", (Object)"");
            } else {
                attr.put((Object)"name", (Object)fevo.getLabel());
                attr.put((Object)"value", (Object)fevo.getValue((AuthtimeValueObject)userVO));
            }
            attrs.add((Object)attr);
        }
        extattr.put((Object)"attrs", (Object)attrs);
        wxUser.setExtattr(extattr.toString());
        return wxUser;
    }

    private static boolean isUpdateUserToWeiXin(UserVO userVO, User wxUser, Department root, List<FieldExtendsVO> fieldExtendses) {
        int[] depts;
        boolean isUpdateUser = false;
        if (userVO.getStatus() == 0 && wxUser.getEnable() == 1) {
            wxUser.setEnable(0);
            isUpdateUser = true;
        }
        if (!wxUser.getName().equals(userVO.getName()) || !StringUtil.isBlank((String)userVO.getTelephone()) && !userVO.getTelephone().trim().equals(wxUser.getMobile()) || !StringUtil.isBlank((String)userVO.getEmail()) && !userVO.getEmail().equals(wxUser.getEmail())) {
            wxUser.setName(userVO.getName());
            wxUser.setMobile(!StringUtil.isBlank((String)userVO.getTelephone()) ? userVO.getTelephone().trim() : wxUser.getMobile());
            wxUser.setEmail(!StringUtil.isBlank((String)userVO.getEmail()) ? userVO.getEmail().trim() : wxUser.getEmail());
            isUpdateUser = true;
        }
        JSONObject extattr = new JSONObject();
        JSONArray attrs = new JSONArray();
        for (int index = 0; index < fieldExtendses.size(); ++index) {
            FieldExtendsVO fevo = fieldExtendses.get(index);
            JSONObject attr = new JSONObject();
            if (fevo == null || !fevo.getEnabel().booleanValue()) continue;
            String value = fevo.getValue((AuthtimeValueObject)userVO);
            if (StringUtil.isBlank((String)value)) {
                attr.put((Object)"name", (Object)fevo.getLabel());
                attr.put((Object)"value", (Object)"");
            } else {
                attr.put((Object)"name", (Object)fevo.getLabel());
                attr.put((Object)"value", (Object)fevo.getValue((AuthtimeValueObject)userVO));
            }
            attrs.add((Object)attr);
        }
        extattr.put((Object)"attrs", (Object)attrs);
        JSONObject wxExtattr = JSONObject.fromObject((Object)wxUser.getExtattr());
        JSONArray wxAttrs = (JSONArray)wxExtattr.get("attrs");
        if (wxAttrs.isEmpty() && attrs.size() > 0) {
            wxUser.setExtattr(extattr.toString());
            isUpdateUser = true;
        } else {
            block1: for (int attrIndex = 0; attrIndex < attrs.size(); ++attrIndex) {
                JSONObject attr = attrs.getJSONObject(attrIndex);
                for (int wxAttrIndex = 0; wxAttrIndex < wxAttrs.size(); ++wxAttrIndex) {
                    JSONObject wxAttr = wxAttrs.getJSONObject(wxAttrIndex);
                    if (!wxAttr.get("name").equals(attr.get("name")) || wxAttr.get("value").equals(attr.get("value"))) continue;
                    wxUser.setExtattr(extattr.toString());
                    isUpdateUser = true;
                    break block1;
                }
            }
        }
        Collection departments = userVO.getDepartments();
        if (departments.size() > 0) {
            depts = new int[departments.size()];
            int index = 0;
            for (DepartmentVO dept : departments) {
                String weixinDeptId = dept.getWeixinDeptId();
                if (StringUtil.isBlank((String)weixinDeptId)) continue;
                depts[index++] = Integer.parseInt(weixinDeptId);
            }
        } else {
            depts = new int[]{root.getId()};
        }
        if (wxUser.getDepartment() != depts) {
            wxUser.setDepartment(depts);
            isUpdateUser = true;
        }
        return isUpdateUser;
    }

    private static boolean isUpdateUserFromWeiXin(UserVO userVO, User wxUser) {
        return WeixinService.isUpdateUserFromWeiXin(userVO, wxUser, null, null);
    }

    private static boolean isUpdateUserFromWeiXin(UserVO userVO, User wxUser, Map<Integer, DepartmentVO> deptMapping, List<FieldExtendsVO> fieldExtendMapping) {
        boolean isUpdateUser = false;
        if (!userVO.getName().equals(wxUser.getName()) || userVO.getTelephone() != null && !userVO.getTelephone().equals(wxUser.getMobile()) || userVO.getEmail() != null && !userVO.getEmail().equals(wxUser.getEmail()) || wxUser.getMobile() != null && !wxUser.getMobile().equals(userVO.getTelephone()) || wxUser.getEmail() != null && !wxUser.getEmail().equals(userVO.getEmail())) {
            userVO.setName(wxUser.getName());
            userVO.setTelephone(wxUser.getMobile());
            userVO.setEmail(wxUser.getEmail());
            isUpdateUser = true;
        }
        if (!(StringUtil.isBlank((String)userVO.getAvatarUri()) || StringUtil.isBlank((String)wxUser.getAvatar()) || userVO.getAvatarUri().equals(wxUser.getAvatar()) || StringUtil.isBlank((String)wxUser.getAvatar()))) {
            JSONObject json = new JSONObject();
            json.put((Object)"url", (Object)wxUser.getAvatar());
            String Base64String = ImageUtil.transformImage2Base64String((String)wxUser.getAvatar(), (String)userVO.getId());
            json.put((Object)"data", (Object)(StringUtil.isBlank((String)Base64String) ? "" : Base64String));
            if (!StringUtil.isBlank((String)Base64String)) {
                json.put((Object)"isCompress", (Object)true);
            } else {
                json.put((Object)"isCompress", (Object)false);
            }
            userVO.setAvatar(json.toString());
            isUpdateUser = true;
        }
        if (deptMapping != null && !deptMapping.isEmpty()) {
            for (int i = 0; i < wxUser.getDepartment().length; ++i) {
                boolean isExist = false;
                String deptId = deptMapping.get(wxUser.getDepartment()[i]).getId();
                DepartmentVO dept = null;
                for (DepartmentVO _dept : userVO.getDepartments()) {
                    dept = _dept;
                    if (!dept.getId().equals(deptId)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                UserDepartmentRoleSet userDepartmentSet = new UserDepartmentRoleSet(userVO.getId(), deptId, "");
                userVO.getUserDepartmentRoleSets().add(userDepartmentSet);
                userVO.getDepartments().add(dept);
                isUpdateUser = true;
            }
        }
        if (fieldExtendMapping != null && !fieldExtendMapping.isEmpty()) {
            try {
                JSONObject extattr = JSONObject.fromObject((Object)wxUser.getExtattr());
                JSONArray attrs = extattr.getJSONArray("attrs");
                block4: for (FieldExtendsVO fieldExtend : fieldExtendMapping) {
                    String name = fieldExtend.getLabel();
                    for (int index = 0; index < attrs.size(); ++index) {
                        JSONObject attr = attrs.getJSONObject(index);
                        if (!name.equals(attr.getString("name"))) continue;
                        String fieldName = fieldExtend.getName();
                        fieldName = fieldName.replaceFirst("f", "F");
                        Method gmethod = UserVO.class.getMethod("get" + fieldName, new Class[0]);
                        String v = (String)gmethod.invoke((Object)userVO, new Object[0]);
                        if (attr.get("value").equals(v)) continue;
                        Method method = UserVO.class.getMethod("set" + fieldName, String.class);
                        method.invoke((Object)userVO, attr.get("value"));
                        isUpdateUser = true;
                        continue block4;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isUpdateUser;
    }
}

