/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.tray.action;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.FileEncryptAndDecrypt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="TrayServiceAction")
@RequestMapping(value={"/api/tray/service"})
@Scope(value="prototype")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class TrayServiceController {
    protected static final String ACTION_RESULT_KEY = "status";
    protected static final int ACTION_RESULT_VALUE_SUCCESS = 1;
    protected static final int ACTION_RESULT_VALUE_FAULT = 0;
    protected static final String ACTION_MESSAGE_KEY = "message";
    protected static final String ACTION_DATA_KEY = "data";
    protected ParamsTable params;
    protected Map<String, Object> dataMap = new HashMap<String, Object>();
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpServletResponse response;
    @Autowired
    protected HttpSession session;

    @RequestMapping(value={"/download.action"})
    @ResponseBody
    public void doDownload() throws Exception {
        File file = null;
        HttpServletRequest request = this.request;
        HttpServletResponse response = this.response;
        try {
            ParamsTable params = this.getParams();
            String path = params.getParameterAsString("path");
            String name = params.getParameterAsString("name");
            if (!StringUtil.isBlank((String)path)) {
                String realPath = PropertyUtil.getPath() + File.separator + path + File.separator + name;
                file = new File(realPath);
                if (FileEncryptAndDecrypt.isEncrypt((String)realPath)) {
                    file = new File(FileEncryptAndDecrypt.encrypt((String)realPath));
                }
                if (!file.exists()) {
                    response.setStatus(404);
                    return;
                }
                this.setResponse(response, file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(500);
        }
    }

    private void setResponse(HttpServletResponse response, File file) throws IOException {
        ServletOutputStream os = null;
        BufferedInputStream reader = null;
        try {
            String encoding = "utf-8";
            HttpServletRequest request = this.request;
            String agent = request.getHeader("USER-AGENT");
            if (null != agent && -1 != agent.indexOf("Firefox")) {
                response.setContentType("application/x-download; charset=" + encoding + "");
                response.setHeader("Content-Disposition", "attachment;filename=\"" + MimeUtility.encodeText((String)file.getName(), (String)encoding, (String)"B") + "\"");
            } else {
                response.setContentType("application/x-download; charset=" + encoding + "");
                response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(file.getName(), encoding) + "\"");
            }
            os = response.getOutputStream();
            reader = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[4096];
            int i = -1;
            while ((i = reader.read(buffer)) != -1) {
                os.write(buffer, 0, i);
            }
            os.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (os != null) {
                reader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public ParamsTable getParams() {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)this.request);
            this.params.setSessionid(this.session.getId());
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public ParamsTable getParams(HttpServletRequest request) {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)request);
            this.params.setSessionid(request.getSession().getId());
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public Map<String, Object> addActionResult(boolean isSuccess, String message, Object data) {
        this.dataMap.put(ACTION_RESULT_KEY, isSuccess ? 1 : 0);
        this.dataMap.put(ACTION_MESSAGE_KEY, message);
        if (data != null) {
            this.dataMap.put(ACTION_DATA_KEY, data);
        }
        return this.dataMap;
    }
}

