/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.tray.action;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.support.tray.action.BreakpointServletFileUpload;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class BreakpointUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 4275252610690933584L;
    private static final int UPLOAD_ERROR_SERVER = -200;
    private static final int UPLOAD_SUCCESS = 200;
    private static final int UPLOAD_ERROR_NETWORK_DISCONNECT = 101;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("action");
        if ("queryUploadSize".equals(action)) {
            try {
                this.doQueryUploadSize(req, resp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.doUpload(req, resp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            int state = 0;
            try {
                long offset = 0L;
                long fileLength = 0L;
                String path = null;
                String fileName = null;
                DiskFileItemFactory fac = new DiskFileItemFactory();
                BreakpointServletFileUpload upload = new BreakpointServletFileUpload((FileItemFactory)fac);
                upload.setHeaderEncoding("utf-8");
                List fileList = null;
                try {
                    fileList = upload.parseRequest(request);
                    if (upload.isDisconnect()) {
                        state = 101;
                    }
                }
                catch (FileUploadException ex) {
                    state = -100;
                    throw ex;
                }
                for (FileItem item : fileList) {
                    if (!item.isFormField()) continue;
                    String fieldName = item.getFieldName();
                    if (fieldName.equalsIgnoreCase("path")) {
                        path = item.getString("UTF-8");
                    }
                    if (fieldName.equalsIgnoreCase("name")) {
                        fileName = URLDecoder.decode(item.getString("UTF-8"), "UTF-8");
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("offset")) {
                        offset = Long.valueOf(item.getString("UTF-8"));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("fileLength")) continue;
                    fileLength = Long.valueOf(item.getString("UTF-8"));
                }
                String realPath = PropertyUtil.getPath() + File.separator;
                String savePath = realPath + path;
                for (FileItem item : fileList) {
                    String name;
                    if (item.isFormField() || (name = item.getName()) == null || name.trim().equals("")) continue;
                    String tempPath = savePath + File.separator + fileName + ".tmp";
                    if (offset == 0L) {
                        File temp = new File(tempPath);
                        if (temp.exists()) {
                            temp.delete();
                        }
                        temp.createNewFile();
                        temp = null;
                    }
                    RandomAccessFile raf = null;
                    InputStream in = null;
                    try {
                        raf = new RandomAccessFile(tempPath, "rw");
                        if (offset > 0L) {
                            raf.setLength(offset);
                            raf.seek(offset);
                        }
                        byte[] b = new byte[1024];
                        in = item.getInputStream();
                        int nRead = 0;
                        while ((nRead = in.read(b)) > 0) {
                            raf.write(b, 0, nRead);
                        }
                        raf.close();
                        File temp = new File(tempPath);
                        File f = new File(savePath + File.separator + fileName);
                        if (!temp.exists()) continue;
                        if (f.exists()) {
                            f.delete();
                        }
                        temp.renameTo(new File(savePath + File.separator + fileName));
                        try {
                            int i = fileName.lastIndexOf(".");
                            String fullPath = savePath + File.separator + fileName;
                            String rootPath = PropertyUtil.getPath();
                            FileWriteUtil.writeKmConvertTask((String)rootPath, (String)UUID.randomUUID().toString(), (String)fullPath);
                            Thread.sleep(2000L);
                            String pdfFullPath = fullPath.substring(0, fullPath.lastIndexOf(File.separator)) + File.separator + "swf" + File.separator + fileName.substring(0, fileName.lastIndexOf(".")) + ".pdf";
                            File pdfFile = new File(pdfFullPath);
                            int count = 0;
                            do {
                                Thread.sleep(1000L);
                            } while ((!pdfFile.exists() || pdfFile.length() <= 0L) && ++count <= 30);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        state = 200;
                    }
                    catch (Exception ee) {
                        state = -200;
                        throw ee;
                    }
                    finally {
                        if (raf != null) {
                            try {
                                raf.close();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PrintWriter writer = this.getPrintWriter(request, response);
            writer.print(state);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createSWF(String fileType, String path, String uuid) {
        if ("doc".equals(fileType) || "docx".equals(fileType) || "xls".equals(fileType) || "xlsx".equals(fileType) || "pdf".equals(fileType) || "txt".equals(fileType) || "rtf".equals(fileType) || "et".equals(fileType) || "ppt".equals(fileType) || "pptx".equals(fileType) || "dps".equals(fileType) || "pot".equals(fileType) || "pps".equals(fileType) || "wps".equals(fileType)) {
            try {
                String rootPath = PropertyUtil.getPath();
                FileWriteUtil.writeKmConvertTask((String)rootPath, (String)uuid, (String)path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void doQueryUploadSize(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = request.getParameter("path");
        String name = request.getParameter("name");
        String realPath = this.getServletConfig().getServletContext().getRealPath("") + File.separator + path;
        String savePath = realPath;
        String tempPath = savePath + File.separator + name + ".tmp";
        File file = new File(tempPath);
        if (file.exists()) {
            response.getWriter().print(file.length());
        } else {
            response.getWriter().print(0);
        }
    }

    private PrintWriter getPrintWriter(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("utf-8");
        response.setContentType("text/html; charset=utf-8");
        return response.getWriter();
    }
}

