/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.sms.teemlink;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.support.sms.ISender;
import cn.myapps.support.sms.MessageManager;
import cn.myapps.support.sms.SMSMode;
import cn.myapps.support.sms.teemlink.TeemLinkSMSManager;
import cn.myapps.util.http.HttpRequestUtil;
import cn.myapps.webservice.client.TeemLinkSMS;
import java.net.URLEncoder;
import net.sf.json.JSONObject;

public final class TeemLinkSender
implements ISender {
    private MessageManager manager = MessageManager.getInstance();
    private TeemLinkSMS teemLinkService = TeemLinkSMSManager.getInstance().getService();

    @Override
    public int battchSendMessage(String[] recTels, String content) throws Exception {
        if (recTels == null || recTels.length <= 0) {
            throw new Exception("No Receiver!");
        }
        StringBuffer telephones = new StringBuffer();
        for (int i = 0; i < recTels.length; ++i) {
            if (StringUtil.isBlank((String)recTels[i])) continue;
            telephones.append(recTels[i]).append(",");
        }
        if (StringUtil.isBlank((String)telephones.toString())) {
            throw new Exception("No Receiver!");
        }
        return this.sendMessage(telephones.substring(0, telephones.length() - 1), content);
    }

    @Override
    public int battchSendMessage(String[] recTels, String content, String replyCode) throws Exception {
        if (recTels == null || recTels.length <= 0) {
            throw new Exception("No Receiver!");
        }
        StringBuffer telephones = new StringBuffer();
        for (int i = 0; i < recTels.length; ++i) {
            if (StringUtil.isBlank((String)recTels[i])) continue;
            telephones.append(recTels[i]).append(",");
        }
        if (StringUtil.isBlank((String)telephones.toString())) {
            throw new Exception("No Receiver!");
        }
        return this.sendMessage(telephones.substring(0, telephones.length() - 1), content, replyCode);
    }

    @Override
    public int sendMessage(String recTelephone, String content) throws Exception {
        if (this.manager.getValidator() == null) {
            throw new Exception("\u65e0\u6548\u7684\u9a8c\u8bc1\u5bf9\u8c61!");
        }
        DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
        DomainVO vo = (DomainVO)process.doView(this.manager.getValidator().getDomainid());
        content = content + "[" + vo.getName() + "]";
        String signature = (String)PropertyUtil.getProp((String)"myapp").get("sms.signature");
        String templateId = (String)PropertyUtil.getProp((String)"myapp").get("sms.templateId");
        String url = SMSMode.sms_url.replace("{account}", vo.getSmsMemberCode()).replace("{password}", vo.getSmsMemberPwd()).replace("{telephone}", recTelephone).replace("{content}", URLEncoder.encode(content, "UTF-8")).replace("{signatureId}", signature).replace("{templateId}", templateId);
        JSONObject jsonObject = HttpRequestUtil.get((String)url, null);
        int code = -1;
        if (jsonObject != null && jsonObject.get("msg").equals("\u77ed\u4fe1\u5df2\u53d1\u9001")) {
            code = 0;
        }
        return code;
    }

    @Override
    public int sendMessage(String recTelephone, String content, String replyCode) throws Exception {
        if (this.manager.getValidator() == null) {
            throw new Exception("\u65e0\u6548\u7684\u9a8c\u8bc1\u5bf9\u8c61!");
        }
        DomainProcess process = AuthTimeServiceManager.domainRuntimeService();
        DomainVO vo = (DomainVO)process.doView(this.manager.getValidator().getDomainid());
        String signature = (String)PropertyUtil.getProp((String)"myapp").get("sms.signature");
        String templateId = (String)PropertyUtil.getProp((String)"myapp").get("sms.templateId");
        String url = SMSMode.sms_url.replace("{account}", vo.getSmsMemberCode()).replace("{password}", vo.getSmsMemberPwd()).replace("{telephone}", recTelephone).replace("{content}", URLEncoder.encode(content, "UTF-8")).replace("{signatureId}", URLEncoder.encode(signature, "UTF-8")).replace("{templateId}", templateId);
        JSONObject jsonObject = HttpRequestUtil.get((String)url, null);
        int code = -1;
        if (jsonObject != null && jsonObject.get("msg").equals("\u77ed\u4fe1\u5df2\u53d1\u9001")) {
            code = 0;
        }
        return code;
    }
}

