/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.sms;

import cn.myapps.support.sms.IReceiver;
import cn.myapps.support.sms.ISender;
import cn.myapps.support.sms.IValidator;
import cn.myapps.support.sms.Validator;
import cn.myapps.support.sms.teemlink.TeemLinkReceiver;
import cn.myapps.support.sms.teemlink.TeemLinkSender;

public class MessageManager {
    private IValidator validator;
    private static MessageManager ins = null;

    private MessageManager(IValidator validator) {
        this.validator = validator;
    }

    public static MessageManager getInstance(IValidator validator) {
        if (ins == null || MessageManager.ins.validator != validator) {
            ins = new MessageManager(validator);
        }
        return ins;
    }

    public static MessageManager getInstance() {
        if (ins == null) {
            ins = new MessageManager(new Validator(null, null));
        }
        return ins;
    }

    public IReceiver getReceiver() throws Exception {
        if (this.validate()) {
            return new TeemLinkReceiver();
        }
        return null;
    }

    private boolean validate() throws Exception {
        return this.validator.validate();
    }

    public ISender getSender() throws Exception {
        if (this.validate()) {
            return new TeemLinkSender();
        }
        return null;
    }

    public IValidator getValidator() {
        return this.validator;
    }
}

