/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.support.lanxin.service.api.impl;

import cn.myapps.support.lanxin.LanxinHandleException;
import it.sauronsoftware.jave.AudioAttributes;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.EncodingAttributes;
import it.sauronsoftware.jave.InputFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class MediaService {
    private static final String get_media_url = "https://qyapi.weixin.qq.com/cgi-bin/media/get?access_token=ACCESS_TOKEN&media_id=MEDIA_ID";

    public static void downloadMedia(String access_token, String media_id, String fileName) throws LanxinHandleException {
        String url = get_media_url.replace("ACCESS_TOKEN", access_token).replace("MEDIA_ID", media_id);
        InputStream is = null;
        FileOutputStream fs = null;
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.connect();
            if (conn.getResponseCode() != 200) {
                throw new LanxinHandleException("\u83b7\u53d6\u4e34\u65f6\u7d20\u6750\u6587\u4ef6\u8fde\u63a5\u5931\u8d25\uff0c\u8fde\u63a5\u4ee3\u7801:" + conn.getResponseCode());
            }
            is = conn.getInputStream();
            fs = new FileOutputStream(fileName);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = is.read(buffer)) != -1) {
                fs.write(buffer, 0, read);
            }
            fs.close();
            is.close();
            if (fileName.toLowerCase().endsWith(".amr")) {
                MediaService.changeToMp3(fileName, fileName.replace(".amr", ".mp3"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LanxinHandleException("\u83b7\u53d6\u4e34\u65f6\u7d20\u6750\u6587\u4ef6 \u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void changeToMp3(String sourcePath, String targetPath) {
        File source = new File(sourcePath);
        File target = new File(targetPath);
        AudioAttributes audio = new AudioAttributes();
        Encoder encoder = new Encoder();
        audio.setCodec("libmp3lame");
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setFormat("mp3");
        attrs.setAudioAttributes(audio);
        try {
            encoder.encode(source, target, attrs);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InputFormatException inputFormatException) {
        }
        catch (EncoderException encoderException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        MediaService.downloadMedia("Q48GlIkfKrNeC4epiju2tUrJYzGEqsvF5ZCnY7ifKaUcZghUwSrAf__k7sK1uhbigOfBol6N14xEoaenhaWFew", "AadHZLeba_8-cW_dICOSQrDoh9m1Hz1lZP0OgWhsN2mI0cSxT6NC0cAj7sgyd67w", "d:/a.jpg");
    }
}

