/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.scheduler;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.task.Task;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.runtime.scheduler.engine.job.BpmPlatformWorkFlowEventJob;
import cn.myapps.runtime.scheduler.engine.job.IscriptTaskJob;
import cn.myapps.scheduler.Job;
import cn.myapps.scheduler.SchedulerLock;
import cn.myapps.scheduler.SchedulerUtil;
import java.io.File;
import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TriggerExecutor
extends Job {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        TriggerVO trigger = (TriggerVO)jobDataMap.get((Object)"triggervo");
        String applicationId = jobDataMap.getString("application");
        ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
        try {
            Application app = (Application)appService.findById(applicationId);
            if (app == null) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Date lastExecuteTime = new Date();
            TriggerProcess process = RunTimeServiceManager.triggerProcess((String)applicationId);
            if (trigger != null && !process.isCancel(trigger.getId())) {
                System.out.println("\u89e6\u53d1\u5668\u6267\u884c\u4efb\u52a1" + trigger.getId());
                cn.myapps.runtime.scheduler.engine.job.Job job = trigger.getJob();
                if (job instanceof BpmPlatformWorkFlowEventJob) {
                    BpmPlatformWorkFlowEventJob bpmPlatformWorkFlowEventJob = (BpmPlatformWorkFlowEventJob)job;
                    bpmPlatformWorkFlowEventJob.setDoc(trigger.getDoc());
                    bpmPlatformWorkFlowEventJob.execute();
                } else if (job instanceof IscriptTaskJob) {
                    String rootPath = PropertyUtil.getPath();
                    File file = new File(rootPath + File.separator + trigger.getDeadline() + ".log");
                    if (file.exists()) {
                        return;
                    }
                    file.createNewFile();
                    IscriptTaskJob iscriptTaskJob = (IscriptTaskJob)job;
                    iscriptTaskJob.setApplicationId(trigger.getApplicationId());
                    iscriptTaskJob.execute();
                    file.delete();
                } else {
                    job.execute();
                }
                if (!trigger.isLoop()) {
                    if (trigger.getJobType() != 4) {
                        process.doRemove(trigger.getId());
                    } else {
                        trigger.setState("stop");
                        trigger.setRunTimes(trigger.getRunTimes() + 1);
                        process.doUpdate((ValueObject)trigger);
                    }
                    String jobName = trigger.getId();
                    String jobGroupName = trigger.getApplicationId();
                    SchedulerUtil.cancelJob(jobName, jobGroupName);
                } else {
                    trigger.setState("waiting");
                    trigger.setRunTimes(trigger.getRunTimes() + 1);
                    TaskDesignTimeService tp = DesignTimeServiceManager.taskDesignTimeService();
                    IscriptTaskJob iscriptTaskJob = (IscriptTaskJob)job;
                    Task task = (Task)tp.findById(iscriptTaskJob.getTaskId());
                    if (task != null) {
                        long nextExecuteTime = task.getNextExecuteTime(lastExecuteTime);
                        trigger.setDeadline(nextExecuteTime);
                    }
                    process.doUpdate((ValueObject)trigger);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                String jobName = trigger.getId();
                String jobGroupName = trigger.getApplicationId();
                SchedulerUtil.cancelJob(jobName, jobGroupName);
                SchedulerLock.unLock(trigger);
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

