/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.scheduler;

import cn.myapps.common.model.ValueObject;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.scheduler.SchedulerUtil;
import cn.myapps.scheduler.TriggerAspect;
import cn.myapps.scheduler.TriggerExecutor;
import java.util.Date;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TriggerAspectImpl
implements TriggerAspect {
    private static final long INTERVAL = 60000L;

    @Override
    @After(value="execution(* cn.myapps.scheduler.SchedulerProcessBean.insertTrigger(..))")
    public void addTrigger(JoinPoint point) throws Exception {
        TriggerVO triggerVO = (TriggerVO)point.getArgs()[0];
        boolean isInsert = (Boolean)point.getArgs()[1];
        if (isInsert) {
            TriggerProcess process = RunTimeServiceManager.triggerProcess((String)triggerVO.getApplicationId());
            process.doCreate((ValueObject)triggerVO);
        }
        long nextExecutorTime = 60000L + new Date().getTime();
        if (triggerVO.getJobType() != 4 && triggerVO.getDeadline() < nextExecutorTime) {
            TriggerAspectImpl.addTriggerOnce(triggerVO, triggerVO.getApplicationId());
            return;
        }
    }

    @Override
    @After(value="execution(* cn.myapps.scheduler.SchedulerProcessBean.deleteTrigger(..))")
    public void cancelTrigger(JoinPoint point) throws Exception {
        TriggerVO triggerVO = (TriggerVO)point.getArgs()[0];
        boolean isDelete = (Boolean)point.getArgs()[1];
        String jobName = triggerVO.getId();
        String jobGroupName = triggerVO.getApplicationId();
        SchedulerUtil.cancelJob(jobName, jobGroupName);
        TriggerProcess process = RunTimeServiceManager.triggerProcess((String)triggerVO.getApplicationId());
        if (isDelete) {
            process.doRemove(triggerVO.getId());
        } else {
            triggerVO.setState("stop");
            process.doUpdate((ValueObject)triggerVO);
        }
    }

    @Override
    @After(value="execution(* cn.myapps.scheduler.SchedulerProcessBean.updateTrigger(..))")
    public void updateTrigger(JoinPoint point) throws Exception {
        TriggerVO triggerVO = (TriggerVO)point.getArgs()[0];
        TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess((String)triggerVO.getApplicationId());
        TriggerVO trigger = (TriggerVO)triggerProcess.selectByToken(triggerVO.getToken());
        if (trigger != null) {
            triggerVO.setId(trigger.getId());
            triggerVO.setRunTimes(trigger.getRunTimes());
            triggerProcess.doUpdate((ValueObject)triggerVO);
        }
    }

    public static void addTriggerOnce(TriggerVO triggerVO, String application) throws Exception {
        try {
            String jobName = triggerVO.getId();
            String jobGroupName = triggerVO.getApplicationId();
            String triggerName = triggerVO.getId();
            String triggerGroupName = triggerVO.getApplicationId();
            String cron = "0/3 * * * * ?";
            Date startTime = new Date(triggerVO.getDeadline());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("triggervo", triggerVO);
            map.put("application", triggerVO.getApplicationId());
            SchedulerUtil.triggerJobOnce(jobName, jobGroupName, triggerName, triggerGroupName, TriggerExecutor.class, map, startTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

