/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.scheduler;

import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.scheduler.Job;
import java.util.Date;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public class SchedulerUtil {
    private static SchedulerFactoryBean getFactory() {
        SchedulerFactoryBean factory = (SchedulerFactoryBean)SpringApplicationContextUtil.getBean(SchedulerFactoryBean.class);
        return factory;
    }

    public static void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String cron, Map<?, ?> dataMap) {
        SchedulerUtil.addJobWithContextDataMap(jobName, jobGroupName, triggerName, triggerGroupName, jobClass, cron, dataMap);
    }

    public static void addJobWithContextDataMap(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String cron, Map<?, ?> dataMap) {
        try {
            JobDataMap newJobDataMap = new JobDataMap(dataMap);
            Scheduler sched = SchedulerUtil.getFactory().getScheduler();
            JobDetail jobDetail = null;
            jobDetail = dataMap == null ? JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).usingJobData(newJobDataMap).storeDurably(true).build() : JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).usingJobData(newJobDataMap).storeDurably(true).build();
            if (!sched.checkExists(JobKey.jobKey((String)jobName, (String)jobGroupName))) {
                TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
                triggerBuilder.withIdentity(triggerName, triggerGroupName);
                triggerBuilder.startNow();
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
                CronTrigger trigger = (CronTrigger)triggerBuilder.usingJobData(newJobDataMap).build();
                sched.scheduleJob(jobDetail, (Trigger)trigger);
            } else {
                sched.addJob(jobDetail, true);
            }
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void triggerJobOnce(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, Map<?, ?> dataMap, Date startTime) {
        try {
            Scheduler sched = SchedulerUtil.getFactory().getScheduler();
            JobDataMap newJobDataMap = new JobDataMap(dataMap);
            JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).usingJobData(newJobDataMap).build();
            SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(1).withRepeatCount(1);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).startAt(startTime).withSchedule((ScheduleBuilder)builder).usingJobData(newJobDataMap).build();
            sched.scheduleJob(jobDetail, trigger);
            if (!sched.isShutdown()) {
                sched.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void cancelJob(String jobName, String jobGroupName) {
        Scheduler sched = SchedulerUtil.getFactory().getScheduler();
        try {
            sched.pauseJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
            sched.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroupName));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public static void destroy() {
        try {
            SchedulerUtil.getFactory().destroy();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

