/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.scheduler;

import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.ICacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.IMyElement;
import cn.myapps.common.util.cache.MyCacheManager;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import java.util.Date;

public class SchedulerLock {
    public static void lock(TriggerVO vo) throws Exception {
        if (vo != null && !StringUtil.isBlank((String)vo.getToken())) {
            String cacheName;
            ICacheProvider provider = MyCacheManager.getProviderInstance((String)"cn.myapps.util.cache.RedisProvider");
            IMyCache cache = provider.getCache(cacheName = "SCHEDULERSPACE$" + vo.getId());
            if (cache == null) {
                cache = provider.createCache(cacheName, 50000, false, false, 120L, 120L);
            }
            cache.put((Object)vo.getToken(), (Object)(new Date().getTime() + 300000L));
            System.out.println("vo = [" + vo + "]");
        }
    }

    public static void unLock(TriggerVO vo) {
        if (vo != null && !StringUtil.isBlank((String)vo.getToken())) {
            String cacheName;
            ICacheProvider provider = MyCacheManager.getProviderInstance((String)"cn.myapps.util.cache.RedisProvider");
            IMyCache cache = provider.getCache(cacheName = "SCHEDULERSPACE$" + vo.getId());
            if (cache == null) {
                return;
            }
            cache.remove((Object)vo.getToken());
        }
    }

    public static boolean isLock(TriggerVO vo) {
        if (vo != null && !StringUtil.isBlank((String)vo.getToken())) {
            String cacheName;
            ICacheProvider provider = MyCacheManager.getProviderInstance((String)"cn.myapps.util.cache.RedisProvider");
            IMyCache cache = provider.getCache(cacheName = "SCHEDULERSPACE$" + vo.getId());
            if (cache == null) {
                return false;
            }
            IMyElement cachedElement = cache.get((Object)vo.getToken());
            if (cachedElement != null) {
                long value = (Long)cachedElement.getValue();
                return value > new Date().getTime();
            }
            return false;
        }
        return false;
    }
}

