/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.scheduler;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.task.Task;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.scheduler.SchedulerLock;
import cn.myapps.scheduler.SchedulerUtil;
import cn.myapps.scheduler.TriggerExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SchedulerListenerJob {
    private static final long INTERVAL = 60000L;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        System.err.println("SchedulerListenerJob_Start-->" + new Date());
        try {
            for (String application : this.getTaskApplications()) {
                TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess((String)application);
                Collection list = triggerProcess.getStandbyTrigger(60000L);
                for (TriggerVO trigger : list) {
                    if (SchedulerLock.isLock(trigger)) {
                        System.out.println("isLock = [" + SchedulerLock.isLock(trigger) + "]");
                        continue;
                    }
                    if ("stop".equals(trigger.getState())) continue;
                    String jobName = trigger.getId();
                    String jobGroupName = trigger.getApplicationId();
                    String triggerName = trigger.getId();
                    String triggerGroupName = trigger.getApplicationId();
                    Date startTime = new Date(trigger.getDeadline());
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("triggervo", trigger);
                    map.put("application", trigger.getApplicationId());
                    System.out.println("jobName = [" + jobName + "]" + startTime);
                    SchedulerUtil.triggerJobOnce(jobName, jobGroupName, triggerName, triggerGroupName, TriggerExecutor.class, map, startTime);
                    SchedulerLock.lock(trigger);
                }
            }
            System.err.println("SchedulerListenerJob_end-->" + new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getTaskApplications() {
        ArrayList<String> applicationids = new ArrayList<String>();
        try {
            ApplicationDesignTimeService service = DesignTimeServiceManager.applicationDesignTimeService();
            List apps = service.list("", "");
            HashMap<String, Application> appMap = new HashMap<String, Application>();
            for (Application application : apps) {
                if (application.getType() == 2) continue;
                appMap.put(application.getId(), application);
            }
            TaskDesignTimeService taskDesignTimeService = DesignTimeServiceManager.taskDesignTimeService();
            DataPackage data = taskDesignTimeService.queryByNameOrDescript("", "", 1, Integer.MAX_VALUE);
            List taskList = (List)data.datas;
            for (Task task : taskList) {
                Application application;
                Boolean isRight;
                if (applicationids.contains(task.getApplicationid()) || !(isRight = Boolean.valueOf((application = (Application)appMap.get(task.getApplicationid())).testDB())).booleanValue()) continue;
                applicationids.add(task.getApplicationid());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return applicationids;
    }
}

