/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.scheduler;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.runtime.notice.PersonalMessageMode;
import cn.myapps.scheduler.Job;
import cn.myapps.support.sms.ISender;
import cn.myapps.support.sms.MessageManager;
import cn.myapps.support.sms.Validator;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.mail.EmailUtil;
import java.util.Collection;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NotificationSendPasswordMessageJob
extends Job {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        PropertyUtil.reload((String)"passwordLegal");
        String loginPasswordNotice = PropertyUtil.get((String)"ao.login.password.update.notice");
        String loginNoticeMethod = PropertyUtil.get((String)"ao.login.notice.method");
        String loginNoticeAuthor = PropertyUtil.get((String)"ao.login.notice.author");
        String loginNoticeContent = PropertyUtil.get((String)"ao.login.notice.content");
        String loginPasswordMaxage = PropertyUtil.get((String)"ao.login.password.maxage");
        long now = new Date().getTime();
        long passwordAgeNotice = Long.parseLong(loginPasswordNotice) * 24L * 3600L * 1000L;
        long passwordAge = Long.parseLong(loginPasswordMaxage) * 24L * 3600L * 1000L;
        String[] method = loginNoticeMethod.split(",");
        String content = loginNoticeContent;
        try {
            UserProcess userProcess = (UserProcess)ProcessFactory.createProcess(UserProcess.class);
            DomainProcess domainProcess = (DomainProcess)ProcessFactory.createProcess(DomainProcess.class);
            Collection domains = domainProcess.queryDomainsByStatus(1);
            for (DomainVO domain : domains) {
                long userCount = userProcess.countByDomain(domain.getId());
                int userPageSize = 2000;
                int maxUserPageIndex = (int)(userCount / (long)userPageSize + (long)(userCount % (long)userPageSize > 0L ? 1 : 0));
                for (int index = 1; index <= maxUserPageIndex; ++index) {
                    int page = index;
                    Collection users = userProcess.queryByDomain(domain.getId(), page, userPageSize);
                    for (UserVO user : users) {
                        if (user.getStatus() != 1 || !loginNoticeAuthor.equals("0")) continue;
                        long lastPassTime = user.getLastModifyTime().getTime();
                        if (lastPassTime + passwordAge < now) {
                            userProcess.updateUserLockFlag(user.getLoginno(), 0);
                        }
                        if (lastPassTime + passwordAgeNotice >= now) continue;
                        for (int i = 0; method.length > i; ++i) {
                            WebUser tuser = new WebUser((IUser)user);
                            if (method[i].equals("1")) {
                                MessageManager manager = MessageManager.getInstance(new Validator(user.getDomainid(), ""));
                                ISender sender = manager.getSender();
                                sender.sendMessage(user.getTelephone(), content);
                            }
                            if (method[i].equals("2")) {
                                PersonalMessageMode personMessageMode = new PersonalMessageMode();
                                personMessageMode.sendMessageToUser(user.getId(), user.getId(), "\u5bc6\u7801\u8fc7\u671f\u901a\u77e5", content);
                            }
                            if (!method[i].equals("3")) continue;
                            EmailUtil eu = new EmailUtil("", (IUser)tuser);
                            eu.sendEmailBySystemUserForTranspond(user.getEmail(), "\u5bc6\u7801\u8fc7\u671f\u901a\u77e5", content);
                        }
                    }
                    PersistenceUtils.closeSessionAndConnection();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

