/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.scheduler;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.task.Task;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.runtime.scheduler.engine.job.IscriptTaskJob;
import cn.myapps.runtime.scheduler.engine.job.Job;
import cn.myapps.util.sequence.Sequence;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitRuntimeScheduler {
    private static final Logger logger = LoggerFactory.getLogger(InitRuntimeScheduler.class);
    private static final long INTERVAL = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String application) {
        try {
            TaskDesignTimeService taskDesignTimeService = DesignTimeServiceManager.taskDesignTimeService();
            TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess((String)application);
            triggerProcess.updateStandbyState2WaitingState();
            DataPackage data = taskDesignTimeService.queryByNameOrDescript(application, "", 1, Integer.MAX_VALUE);
            Collection iscriptTriggers = triggerProcess.getTriggerByJobType(4, 600000000000L);
            HashMap<String, Object> triggerMap = new HashMap<String, Object>();
            for (Object trigger : iscriptTriggers) {
                if (!application.equals(trigger.getApplicationId())) continue;
                triggerMap.put(trigger.getTaskId(), trigger);
            }
            TriggerVO newTrigger = null;
            for (Task task : data.getDatas()) {
                if (triggerMap.get(task.getId()) != null) {
                    TriggerVO triggerVO = (TriggerVO)triggerMap.get(task.getId());
                    Calendar calendar = Calendar.getInstance();
                    IscriptTaskJob job = new IscriptTaskJob(task.getId(), !StringUtil.isBlank((String)task.getApplicationid()) ? task.getApplicationid() : triggerVO.getApplicationId());
                    if (task.getPeriod() == 0 || task.getPeriod() == 0 || task.getPeriod() == 8192) {
                        job.setLoop(false);
                    } else {
                        job.setLoop(true);
                    }
                    newTrigger = new TriggerVO((Job)job, calendar.getTimeInMillis());
                    triggerVO.setJobData(newTrigger.getJobData());
                    triggerVO.setDeadline(triggerVO.getDeadline());
                    triggerVO.setLastModifyDate(task.getModifyTime());
                    triggerProcess.doUpdate((ValueObject)triggerVO);
                    triggerMap.remove(task.getId());
                    continue;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(task.getRunningTime());
                IscriptTaskJob job = new IscriptTaskJob(task.getId(), task.getApplicationid());
                if (task.getPeriod() == 0 || task.getPeriod() == 0 || task.getPeriod() == 8192) {
                    job.setLoop(false);
                } else {
                    job.setLoop(true);
                }
                TriggerVO trigger = new TriggerVO((Job)job, calendar.getTimeInMillis());
                trigger.setId(Sequence.getSequence());
                trigger.setApplicationId(task.getApplicationid());
                trigger.setLastModifyDate(task.getModifyTime());
                trigger.setRunTimes(0);
                trigger.setTaskId(task.getId());
                if (task.getStartupType() != 1) {
                    trigger.setState("stop");
                }
                triggerProcess.doCreate((ValueObject)trigger);
                triggerMap.remove(task.getId());
            }
            for (TriggerVO trigger : triggerMap.values()) {
                triggerProcess.doRemove(trigger.getId());
            }
            Collection list = triggerProcess.getStandbyTrigger(60000L);
            for (TriggerVO triggerVO : list) {
                if (triggerVO.getJobType() == 4 || !application.equals(triggerVO.getApplicationId())) continue;
                triggerVO.setState("waiting");
                triggerProcess.doUpdate((ValueObject)triggerVO);
            }
        }
        catch (Exception e) {
            logger.error("\u5f00\u59cb\u5b9a\u65f6\u4efb\u52a1\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

