/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.workflow.flowMonitor.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/api/runtime/monitors/workflows/nav/"})
public class NavigationController
extends AbstractRuntimeController {
    @GetMapping(value={"/flow_trees"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getflowTrees() throws Exception {
        try {
            BillDefiDesignTimeService billDefiService = DesignTimeServiceManager.billDefiDesignTimeService();
            WebUser user = this.getSuperUser();
            String superUserId = user != null ? user.getId() : null;
            return this.success("success", billDefiService.getFlowTree(superUserId));
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/application_trees"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getApplicationTrees() throws Exception {
        try {
            WebUser user = this.getSuperUser();
            String superUserId = user != null ? user.getId() : null;
            SuperUserDesignTimeService superUserService = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO superUser = superUserService.doView(superUserId);
            Collection applications = superUser.getApplicationList();
            JSONArray appArray = new JSONArray();
            for (Application application : applications) {
                JSONObject appJson = new JSONObject();
                appJson.put((Object)"id", (Object)application.getId());
                appJson.put((Object)"name", (Object)application.getName());
                appJson.put((Object)"type", (Object)"application");
                appArray.add((Object)appJson);
            }
            return this.success("success", appArray);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/domain_list"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getDomainList() throws Exception {
        try {
            DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
            Collection collection = dp.getAllDomain();
            JSONArray jsonArray = new JSONArray();
            for (DomainVO domain : collection) {
                JSONObject domainJson = new JSONObject();
                domainJson.put((Object)"id", (Object)domain.getId());
                domainJson.put((Object)"name", (Object)domain.getName());
                domainJson.put((Object)"type", (Object)"domain");
                jsonArray.add((Object)domainJson);
            }
            return this.success("success", jsonArray);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    private WebUser getSuperUser() {
        WebUser user = AuthTimeServiceManager.getAdminUser((HttpServletRequest)this.request);
        return user;
    }
}

