/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.workflow.flowMonitor.controller;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.workflow.flowMonitor.service.IFlowStatisticsService;
import cn.myapps.runtime.workflow.flowMonitor.utils.ResponseUtils;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/api/runtime/{applicationId}/monitors/workflows/statistics"})
public class FlowStatisticsController {
    @Autowired
    private IFlowStatisticsService flowStatisticsService;

    @GetMapping(value={"/instances"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> currentView(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) throws Exception {
        try {
            List datas = this.flowStatisticsService.currentView(applicationId, domainId, startTime, endTime);
            if (datas.isEmpty()) {
                JSONObject jsonObject = new JSONObject();
                return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)jsonObject));
            }
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)datas));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/photo"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> flowInstancePhoto(@RequestParam String instanceId) throws Exception {
        try {
            String base = this.flowStatisticsService.photoToBase64(instanceId);
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)base));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/instance_distributions"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> flowDistribution(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) throws Exception {
        try {
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)this.flowStatisticsService.flowDistribution(applicationId, domainId, startTime, endTime)));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/instance_times"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> flowTimes(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) throws Exception {
        try {
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)this.flowStatisticsService.flowTimes(applicationId, domainId, startTime, endTime)));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/node_times"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> NodeTimes(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam String flowName) throws Exception {
        try {
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)this.flowStatisticsService.NodeTimes(applicationId, domainId, flowName)));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/complete_types"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> completeStatus(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) throws Exception {
        try {
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)this.flowStatisticsService.completeStatus(applicationId, domainId, startTime, endTime)));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/back_instances"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> flowBack(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam(required=false) String startTime, @RequestParam(required=false) String endTime) throws Exception {
        try {
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)this.flowStatisticsService.flowBack(applicationId, domainId, startTime, endTime)));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/back_nodes"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<?> nodeBack(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam String flowName) throws Exception {
        try {
            return ResponseEntity.ok((Object)ResponseUtils.setResource((int)0, (String)"ok", (Object)this.flowStatisticsService.nodeBack(applicationId, domainId, flowName)));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

