/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.workflow.flowMonitor.controller;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.workflow.flowMonitor.service.IFlowMonitorService;
import cn.myapps.runtime.workflow.service.WorkflowRunTimeService;
import cn.myapps.runtime.workflow.storage.runtime.intervention.ejb.FlowInterventionVO;
import java.util.List;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/api/runtime/{applicationId}/monitors/workflows"})
public class FlowMonitorController
extends AbstractRuntimeController {
    @Autowired
    private IFlowMonitorService flowMonitorServiceImpl;
    @Autowired
    private WorkflowRunTimeService workflowService;

    @GetMapping(value={"/instances"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> doList(@PathVariable String applicationId, @RequestParam String domainId, @RequestParam String _currpage, @RequestParam String _pagelines, @RequestParam(required=false, defaultValue="") String _orderby, @RequestParam(required=false, defaultValue="") String _flowName, @RequestParam String _status, @RequestParam String _flowIndex, @RequestParam(required=false, defaultValue="") String _initiator, @RequestParam(required=false, defaultValue="") String _firstProcessTimeBegin, @RequestParam(required=false, defaultValue="") String _firstProcessTimeEnd, @RequestParam(required=false, defaultValue="") String _summary, @RequestParam(required=false, defaultValue="") String _initiatorDeptId) throws Exception {
        try {
            JSONObject json = new JSONObject();
            json.put((Object)"domainId", (Object)domainId);
            json.put((Object)"_currpage", (Object)_currpage);
            json.put((Object)"_pagelines", (Object)_pagelines);
            json.put((Object)"_orderby", (Object)_orderby);
            json.put((Object)"_flowName", (Object)_flowName);
            json.put((Object)"_status", (Object)_status);
            json.put((Object)"_initiatorId", (Object)_initiator);
            json.put((Object)"_firstProcessTimeBegin", (Object)_firstProcessTimeBegin);
            json.put((Object)"_firstProcessTimeEnd", (Object)_firstProcessTimeEnd);
            json.put((Object)"_summary", (Object)_summary);
            json.put((Object)"_flowIndex", (Object)_flowIndex);
            json.put((Object)"_initiatorDeptId", (Object)_initiatorDeptId);
            return ResponseEntity.ok((Object)this.flowMonitorServiceImpl.getFlowList(applicationId, json));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)new Resource(500, "server innernal error"), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/instances/{instanceId}/historys"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getHistorys(@PathVariable String applicationId, @PathVariable String instanceId) throws Exception {
        try {
            List his = this.workflowService.getHistorys(applicationId, instanceId);
            List cur = this.workflowService.getCurrents(applicationId, instanceId);
            his.addAll(cur);
            return this.success("success", his);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/instances/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getInstanceInfo(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        try {
            FlowInterventionVO flowInterventionVO = this.flowMonitorServiceImpl.getInstance(applicationId, id);
            return this.success("success", flowInterventionVO);
        }
        catch (Exception e) {
            return this.error(500, e.getMessage(), null);
        }
    }
}

