/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.workflow.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.MyProfileHelper;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.common.utils.Pager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.engine.StateMachineHelper;
import cn.myapps.runtime.workflow.service.WorkflowRunTimeService;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryVO;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u5de5\u4f5c\u6d41\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/{applicationId}", "/api/authtime/{applicationId}"}, produces={"application/json;charset=UTF-8"})
public class WorkflowController
extends AbstractRuntimeController {
    @Autowired
    private WorkflowRunTimeService workflowService;

    @GetMapping(value={"/workflows/{instanceId}/states"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value=" \u83b7\u53d6\u6d41\u7a0b\u72b6\u6001", notes=" \u83b7\u53d6\u6d41\u7a0b\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="path", dataType="string")})
    public Resource queryWorkflow(@PathVariable String applicationId, @PathVariable String instanceId) throws Exception {
        JSONObject result = this.workflowService.queryWorkflow(applicationId, instanceId);
        return this.success("ok", result);
    }

    @GetMapping(value={"/documents/{docId}/workflows/flowhistorys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u5386\u53f2", notes="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource getHistorys(@PathVariable String applicationId, @PathVariable String docId, @RequestParam String content) throws Exception {
        List<FlowHistoryVO> result = new ArrayList();
        List flowhiss = this.workflowService.getHistorys(applicationId, docId);
        if (!StringUtil.isBlank((String)content)) {
            content = content.toLowerCase();
            for (FlowHistoryVO his : flowhiss) {
                if (!his.getStartNodeName().toLowerCase().contains(content) && !his.getTargetNodeName().toLowerCase().contains(content) && !his.getAuditorName().toLowerCase().contains(content) && !his.getAgentAuditorName().toLowerCase().contains(content) && !his.getAttitude().toLowerCase().contains(content)) continue;
                result.add(his);
            }
        } else {
            result = flowhiss;
        }
        return this.success("ok", result);
    }

    @GetMapping(value={"/documents/{docId}/workflows/{instanceId}/flowchart"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u56fe", notes="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="path", dataType="string")})
    public Resource getWorkflowChart(@PathVariable String applicationId, @PathVariable String docId, @PathVariable String instanceId) throws Exception {
        JSONObject result = this.workflowService.getWorkflowChart(applicationId, docId, instanceId);
        return this.success("ok", result);
    }

    @PostMapping(value={"/documents/{docid}/workflows/initiate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b", notes="\u53d1\u8d77\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource initiate(@PathVariable String applicationId, @PathVariable String docid, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        String flowId = (String)parse.read("$.flowId", new Predicate[0]);
        String nextId = (String)parse.read("$.nextId", new Predicate[0]);
        String actId = (String)parse.read("$.actId", new Predicate[0]);
        String result = this.workflowService.initiate(this.getParams(), (IUser)this.getUser(), doc, flowId, actId, nextId, applicationId);
        return this.success("ok", result);
    }

    @GetMapping(value={"/documents/{docId}/workflows/remind-historys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u50ac\u529e\u5386\u53f2", notes="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u50ac\u529e\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource getRemindHistorys(@PathVariable String applicationId, @PathVariable String docId) throws Exception {
        List result = this.workflowService.getRemindHistorys(applicationId, docId);
        return this.success("ok", result);
    }

    @PostMapping(value={"/documents/{docId}/panels/submission"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u63d0\u4ea4\u9762\u677f", notes="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u63d0\u4ea4\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource submissionPanels(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        JSONObject result = this.workflowService.submissionPanels(applicationId, doc, params, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PostMapping(value={"/documents/{docid}/panels/initiate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u53d1\u8d77\u9762\u677f", notes="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u53d1\u8d77\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource initiatePanels(@PathVariable String applicationId, @PathVariable String docid, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        JSONArray result = this.workflowService.initiatePanels(applicationId, doc, (IUser)this.getUser(), this.getParams());
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docId}/workflows/submit"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b", notes="\u63d0\u4ea4\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource submitWorkflow(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Document doc = null;
        try {
            NodeRT nodert;
            String subFlowApprover;
            String circulatorInfoStr;
            JSONObject json;
            String attitude;
            doc = this.prepareDocument(content, applicationId, "$.document", params);
            String flowId = (String)parse.read("$.flowId", new Predicate[0]);
            String currentNodeId = (String)parse.read("$.currentNodeId", new Predicate[0]);
            List nextNodeIds = (List)parse.read("$.nextNodeIds", new Predicate[0]);
            String isMoreCurrentNode = parse.read("$.isMoreCurrentNode", new Predicate[0]) == null ? null : parse.read("$.isMoreCurrentNode", new Predicate[0]).toString();
            String signature = (String)parse.read("$.signatureJson", new Predicate[0]);
            if (nextNodeIds == null || nextNodeIds.isEmpty()) {
                return this.error(4001, "\u8bf7\u9009\u62e9\u5ba1\u6279\u8282\u70b9!", null);
            }
            if (!StringUtil.isBlank((String)signature)) {
                params.setParameter("_signature", (Object)signature);
            }
            if (!StringUtil.isBlank((String)(attitude = (String)parse.read("$.attitude", new Predicate[0])))) {
                params.setParameter("attitude", (Object)attitude);
            }
            List fileList = (List)parse.read("$.fileList", new Predicate[0]);
            if (!StringUtil.isBlank((String)attitude)) {
                params.setParameter("fileList", (Object)fileList);
            }
            if (!StringUtil.isBlank((String)isMoreCurrentNode)) {
                if (isMoreCurrentNode.equals("true")) {
                    params.setParameter("isMoreCurrentNode", (Object)true);
                } else {
                    params.setParameter("isMoreCurrentNode", (Object)false);
                }
            }
            params.setParameter("_flowid", (Object)flowId);
            List submitTo = (List)parse.read("$.submitTo", new Predicate[0]);
            if (submitTo != null && !submitTo.isEmpty()) {
                ArrayList<JSONObject> submitToList = new ArrayList<JSONObject>();
                for (Map map : submitTo) {
                    json = new JSONObject();
                    json.put("nodeid", (Object)((String)map.get("nodeid")).toString());
                    json.put("isToPerson", (Object)"true");
                    String userIdStr = (String)map.get("userids");
                    String newUserIdStr = userIdStr.replaceAll(";", "','");
                    String userIds = "['" + newUserIdStr + "']";
                    json.put("userids", (Object)userIds);
                    submitToList.add(json);
                }
                params.setParameter("submitTo", (Object)((Object)submitToList).toString());
            }
            if (!StringUtil.isBlank((String)(circulatorInfoStr = (String)parse.read("$.circulatorInfo", new Predicate[0])))) {
                ArrayList<String> circulatorInfo = new ArrayList<String>();
                String[] userIds = circulatorInfoStr.split(";");
                json = new JSONObject();
                json.put("circulator", (Object)userIds);
                circulatorInfo.add(json.toString());
                params.setParameter("_circulatorInfo", (Object)((Object)circulatorInfo).toString());
            }
            String string = subFlowApprover = parse.read("subFlowApprover", new Predicate[0]) == null ? null : parse.read("subFlowApprover", new Predicate[0]).toString();
            if (!StringUtil.isBlank(subFlowApprover)) {
                params.setParameter("_subFlowApproverInfo", (Object)subFlowApprover);
            }
            if (doc.getState() == null) {
                throw new SaasBadException("\u65e0\u6548\u6587\u6863\u6570\u636e,doc.getState\u5ba1\u6279\u6570\u636e\u4e0d\u5e94\u8be5\u4e3a\u7a7a");
            }
            if (!(doc.getState().isTemp() || (nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)this.getUser(), (String)currentNodeId)) != null && nodert.getNodeid().equals(currentNodeId))) {
                return this.error(4001, "\u5ba1\u6279\u4eba\u5df2\u7ecf\u6ca1\u6709\u5ba1\u6279\u6743\u9650\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4", null);
            }
            String[] nextNodeIdsArray = nextNodeIds.toArray(new String[0]);
            WebUser webUser = this.getUser();
            Collection subDocuments = doc.getFrontSubDocuments();
            Collection<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)webUser);
            if (errors.isEmpty()) {
                DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
                if (subDocuments != null) {
                    ArrayList copySubDocuments = new ArrayList();
                    copySubDocuments.addAll(doc.getSubDocuments());
                    for (Document document : copySubDocuments) {
                        if (document.isDelete()) {
                            dProcess.doRemove(document.getId());
                            doc.removeSubDocument(document.getId());
                            continue;
                        }
                        if (!document.isEdit()) continue;
                        Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)this.getUser());
                        if (!subErrors.isEmpty()) {
                            return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                        }
                        document.setVersions(-1);
                        dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
                    }
                    doc = doc.getForm().recalculateDocument(doc, params, (IUser)this.getUser());
                }
                String result = this.workflowService.submitWorkflow(params, doc, applicationId, (IUser)webUser, currentNodeId, attitude, nextNodeIdsArray);
                return this.success("ok", result);
            }
            return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
        }
        catch (Exception e) {
            String message = "";
            if (e instanceof OBPMValidateException) {
                message = ((OBPMValidateException)((Object)e)).getValidateMessage();
            } else if (e.getMessage().toLowerCase().indexOf("data too long for column") > -1) {
                int index = e.getMessage().indexOf("ITEM_");
                int off = e.getMessage().lastIndexOf("'");
                String fieldName = e.getMessage().substring(index, off);
                message = new StringBuffer().append(fieldName).append("\u5b57\u6bb5\u8fc7\u957f\uff01").toString();
            } else {
                message = e.getMessage();
            }
            ArrayList<ErrorMessage> errmsgs = new ArrayList<ErrorMessage>();
            ErrorMessage msg = new ErrorMessage();
            msg.setErrcode(40001);
            msg.setErrmsg(message);
            msg.setField("");
            errmsgs.add(msg);
            e.printStackTrace();
            return this.error(4001, "\u6d41\u7a0b\u6821\u9a8c\u4e0d\u901a\u8fc7", errmsgs);
        }
    }

    @PostMapping(value={"/documents/{docId}/panels/back"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u56de\u9000\u9762\u677f", notes="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u56de\u9000\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource backPanels(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        JSONObject result = this.workflowService.backPanels(applicationId, doc, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PostMapping(value={"/documents/{docId}/panels/jump"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u56de\u9000\u9762\u677f", notes="\u83b7\u53d6\u6587\u6863\u7684\u6d41\u7a0b\u56de\u9000\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource jumpPanels(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String content) throws Exception {
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        JSONObject result = this.workflowService.jumpPanels(applicationId, doc, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/back"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u56de\u9000\u6d41\u7a0b", notes="\u56de\u9000\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource backWorkflow(@PathVariable String applicationId, @PathVariable String docid, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        String currentNodeId = (String)parse.read("$.currentNodeId", new Predicate[0]);
        String flowId = (String)parse.read("$.flowId", new Predicate[0]);
        String attitude = (String)parse.read("$.attitude", new Predicate[0]);
        if (!StringUtil.isBlank((String)attitude)) {
            params.setParameter("attitude", (Object)attitude);
        }
        List nextNodeIds = (List)parse.read("$.nextNodeIds", new Predicate[0]);
        String[] nextNodeIdsArray = nextNodeIds.toArray(new String[0]);
        String signature = (String)parse.read("$.signatureJson", new Predicate[0]);
        if (!StringUtil.isBlank((String)signature)) {
            params.setParameter("_signature", (Object)signature);
        }
        params.setParameter("_flowid", (Object)flowId);
        Collection subDocuments = doc.getFrontSubDocuments();
        if (subDocuments != null) {
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            ArrayList copySubDocuments = new ArrayList();
            copySubDocuments.addAll(doc.getSubDocuments());
            for (Document document : copySubDocuments) {
                if (document.isDelete()) {
                    dProcess.doRemove(document.getId());
                    doc.removeSubDocument(document.getId());
                    continue;
                }
                if (!document.isEdit()) continue;
                Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)this.getUser());
                if (!subErrors.isEmpty()) {
                    return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                }
                document.setVersions(-1);
                dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
            }
        }
        String result = this.workflowService.backWorkflow((IUser)this.getUser(), applicationId, doc, params, currentNodeId, nextNodeIdsArray, attitude);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/jump"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u56de\u9000\u6d41\u7a0b\u5386\u53f2\u8282\u70b9\u6307\u5b9a\u5386\u53f2\u7528\u6237", notes="\u56de\u9000\u6d41\u7a0b\u5386\u53f2\u8282\u70b9\u6307\u5b9a\u5386\u53f2\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource jumpWorkflow(@PathVariable String applicationId, @PathVariable String docid, @RequestBody String content) throws Exception {
        List jumpTo;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        String currentNodeId = (String)parse.read("$.currentNodeId", new Predicate[0]);
        String flowId = (String)parse.read("$.flowId", new Predicate[0]);
        String attitude = (String)parse.read("$.attitude", new Predicate[0]);
        if (!StringUtil.isBlank((String)attitude)) {
            params.setParameter("attitude", (Object)attitude);
        }
        List nextNodeIds = (List)parse.read("$.nextNodeIds", new Predicate[0]);
        String[] nextNodeIdsArray = nextNodeIds.toArray(new String[0]);
        String signature = (String)parse.read("$.signatureJson", new Predicate[0]);
        if (!StringUtil.isBlank((String)signature)) {
            params.setParameter("_signature", (Object)signature);
        }
        if ((jumpTo = (List)parse.read("$.jumpToPerson", new Predicate[0])) != null && !jumpTo.isEmpty()) {
            ArrayList<JSONObject> jumpToList = new ArrayList<JSONObject>();
            for (Map map : jumpTo) {
                String newUserIdStr;
                JSONObject json = new JSONObject();
                json.put("nodeid", (Object)((String)map.get("nodeid")).toString());
                json.put("isToPerson", (Object)"true");
                String userIdStr = (String)map.get("userids");
                String userIds = newUserIdStr = userIdStr.replaceAll(";", "','");
                json.put("userids", (Object)userIds);
                jumpToList.add(json);
            }
            params.setParameter("jumpToPerson", (Object)((Object)jumpToList).toString());
        }
        params.setParameter("_flowid", (Object)flowId);
        Collection subDocuments = doc.getFrontSubDocuments();
        if (subDocuments != null) {
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            ArrayList copySubDocuments = new ArrayList();
            copySubDocuments.addAll(doc.getSubDocuments());
            for (Document document : copySubDocuments) {
                if (document.isDelete()) {
                    dProcess.doRemove(document.getId());
                    doc.removeSubDocument(document.getId());
                    continue;
                }
                if (!document.isEdit()) continue;
                Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)this.getUser());
                if (!subErrors.isEmpty()) {
                    return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                }
                document.setVersions(-1);
                dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
            }
        }
        String result = this.workflowService.backWorkflow((IUser)this.getUser(), applicationId, doc, params, currentNodeId, nextNodeIdsArray, attitude);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/retracement"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u64a4\u56de\u6d41\u7a0b", notes="\u64a4\u56de\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource retracementWorkflow(@PathVariable String applicationId, @PathVariable String docid) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        IDocument doc = (IDocument)dProcess.doView(docid);
        String result = this.workflowService.retracementWorkflow(this.getParams(), (IUser)this.getUser(), doc, applicationId);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/suspend"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6302\u8d77\u6d41\u7a0b", notes="\u6302\u8d77\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource suspendWorkflow(@PathVariable String applicationId, @PathVariable String docid) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        IDocument doc = (IDocument)dProcess.doView(docid);
        String result = this.workflowService.suspendWorkflow(this.getParams(), (IUser)this.getUser(), applicationId, doc);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/recovery"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6062\u590d\u6d41\u7a0b", notes="\u6062\u590d\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string")})
    public Resource recoveryWorkflow(@PathVariable String applicationId, @PathVariable String docid) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        IDocument doc = (IDocument)dProcess.doView(docid);
        String result = this.workflowService.recoveryWorkflow(this.getParams(), (IUser)this.getUser(), applicationId, doc);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/termination"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u7ec8\u6b62\u6d41\u7a0b", notes="\u7ec8\u6b62\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="attitude", value="\u610f\u89c1", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="signature", value="\u7b7e\u540d", required=false, paramType="query", dataType="string")})
    public Resource terminateWorkflow(@PathVariable String applicationId, @PathVariable String docid, @RequestParam(required=false) String attitude, @RequestParam(required=false) String signature) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)dProcess.doView(docid);
        String result = this.workflowService.terminateWorkflow(this.getParams(), (IUser)this.getUser(), applicationId, attitude, signature, doc);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/remind"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u50ac\u529e", notes="\u6d41\u7a0b\u50ac\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource reminderWorkflow(@PathVariable String applicationId, @PathVariable String docid, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String reminderContent = (String)parse.read("$.attitude", new Predicate[0]);
        List nodertIds = (List)parse.read("$.nodertIds", new Predicate[0]);
        String[] nodertIdsArray = nodertIds.toArray(new String[0]);
        if (nodertIdsArray.length == 0) {
            return this.error(4001, "\u8bf7\u9009\u62e9\u50ac\u529e\u8282\u70b9!", null);
        }
        String signature = (String)parse.read("$.signatureJson", new Predicate[0]);
        String result = this.workflowService.reminderWorkflow((IUser)this.getUser(), applicationId, docid, nodertIdsArray, reminderContent, signature);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/freeflows/submit"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u81ea\u7531\u6d41\u7a0b\u63d0\u4ea4", notes="\u81ea\u7531\u6d41\u7a0b\u63d0\u4ea4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource submitFreeFlows(@PathVariable String docid, @PathVariable String applicationId, @RequestBody String content) throws Exception {
        String signature;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        String nextUserId = (String)parse.read("$.nextUserId", new Predicate[0]);
        if (StringUtil.isBlank((String)nextUserId)) {
            return this.error(4001, "{*[cn.myapps.runtime.workflow.choose_specify_auditor]*}", new ArrayList<ErrorMessage>());
        }
        String attitude = (String)parse.read("$.attitude", new Predicate[0]);
        if (!StringUtil.isBlank((String)attitude)) {
            params.setParameter("attitude", (Object)attitude);
        }
        if (!StringUtil.isBlank((String)(signature = (String)parse.read("$.signatureJson", new Predicate[0])))) {
            params.setParameter("_signature", (Object)signature);
        }
        WebUser webUser = this.getUser();
        Collection subDocuments = doc.getFrontSubDocuments();
        Collection<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)webUser);
        if (errors.isEmpty()) {
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            if (subDocuments != null) {
                ArrayList copySubDocuments = new ArrayList();
                copySubDocuments.addAll(doc.getSubDocuments());
                for (Document document : copySubDocuments) {
                    if (document.isDelete()) {
                        dProcess.doRemove(document.getId());
                        doc.removeSubDocument(document.getId());
                        continue;
                    }
                    if (!document.isEdit()) continue;
                    Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)this.getUser());
                    if (!subErrors.isEmpty()) {
                        return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                    }
                    document.setVersions(-1);
                    dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
                }
                doc = doc.getForm().recalculateDocument(doc, params, (IUser)this.getUser());
            }
            String result = this.workflowService.submitFreeFlows(doc, (IUser)webUser, params, applicationId, attitude, nextUserId);
            return this.success("ok", result);
        }
        return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
    }

    @PutMapping(value={"/documents/{docid}/freeflows/back"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u81ea\u7531\u6d41\u7a0b\u56de\u9000", notes="\u81ea\u7531\u6d41\u7a0b\u56de\u9000")
    @ApiImplicitParams(value={@ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource backFreeFlows(@PathVariable String docid, @PathVariable String applicationId, @RequestBody String content) throws Exception {
        String signature;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        String nextUserId = (String)parse.read("$.nextUserId", new Predicate[0]);
        String attitude = (String)parse.read("$.attitude", new Predicate[0]);
        if (!StringUtil.isBlank((String)attitude)) {
            params.setParameter("attitude", (Object)attitude);
        }
        if (!StringUtil.isBlank((String)(signature = (String)parse.read("$.signatureJson", new Predicate[0])))) {
            params.setParameter("_signature", (Object)signature);
        }
        WebUser webUser = this.getUser();
        Collection subDocuments = doc.getFrontSubDocuments();
        Collection<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, (IUser)webUser);
        if (errors.isEmpty()) {
            DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            if (subDocuments != null) {
                ArrayList copySubDocuments = new ArrayList();
                copySubDocuments.addAll(doc.getSubDocuments());
                for (Document document : copySubDocuments) {
                    if (document.isDelete()) {
                        dProcess.doRemove(document.getId());
                        doc.removeSubDocument(document.getId());
                        continue;
                    }
                    if (!document.isEdit()) continue;
                    Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, (IUser)this.getUser());
                    if (!subErrors.isEmpty()) {
                        return this.error(4001, "\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors);
                    }
                    document.setVersions(-1);
                    dProcess.doCreateOrUpdate((IDocument)document, (IUser)this.getUser());
                }
            }
            String result = this.workflowService.backFreeFlows(doc, (IUser)this.getUser(), params, applicationId, attitude, nextUserId);
            return this.success("ok", result);
        }
        return this.error(4001, "\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors);
    }

    @PostMapping(value={"/documents/{docid}/freeflows/initiate"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u81ea\u7531\u6d41\u7a0b\u53d1\u8d77", notes="\u81ea\u7531\u6d41\u7a0b\u53d1\u8d77")
    @ApiImplicitParams(value={@ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource initiateFreeFlows(@PathVariable String docid, @PathVariable String applicationId, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        String nextUserId = (String)parse.read("$.nextUserId", new Predicate[0]);
        String attitude = (String)parse.read("$.attitude", new Predicate[0]);
        Map items = (Map)parse.read("$.document.items", new Predicate[0]);
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docid, (IUser)this.getUser());
        if (doc == null) {
            doc = (Document)dProcess.doView(docid);
        }
        for (Map.Entry entry : items.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Item item = doc.findItem(key);
            if (item == null) {
                throw new Exception(key + " \u503c\u4e0d\u5b58\u5728");
            }
            item.setValue(value);
        }
        String result = this.workflowService.initiateFreeFlows(doc, (IUser)this.getUser(), this.getParams(), applicationId, attitude, nextUserId);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/freeflows/complete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u81ea\u7531\u6d41\u7a0b\u7ed3\u675f", notes="\u81ea\u7531\u6d41\u7a0b\u7ed3\u675f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource completeFreeFlows(@PathVariable String docid, @PathVariable String applicationId, @RequestBody String content) throws Exception {
        String signature;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        Document doc = this.prepareDocument(content, applicationId, "$.document", params);
        String attitude = (String)parse.read("$.attitude", new Predicate[0]);
        if (!StringUtil.isBlank((String)attitude)) {
            params.setParameter("attitude", (Object)attitude);
        }
        if (!StringUtil.isBlank((String)(signature = (String)parse.read("$.signatureJson", new Predicate[0])))) {
            params.setParameter("_signature", (Object)signature);
        }
        String result = this.workflowService.completeFreeFlows(doc, (IUser)this.getUser(), params, applicationId, attitude);
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docid}/workflows/approvers"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba", notes="\u66f4\u65b0\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="docid", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource updateApprovers(@PathVariable String docid, @PathVariable String applicationId, @RequestBody String content) throws Exception {
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)content, (Configuration)configuration);
        ParamsTable params = this.getParams();
        List auditorList = (List)parse.read("$.auditorList", new Predicate[0]);
        params.setParameter("auditorList", (Object)auditorList);
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Document doc = (Document)dProcess.doView(docid);
        String result = this.workflowService.updateApprovers(params, (IUser)this.getUser(), applicationId, doc);
        return this.success("ok", result);
    }

    @GetMapping(value={"/workflows/{instanceId}/hisActorsFreeFlow"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u81ea\u7531\u6d41\u7a0b\u6a21\u5f0f\u56de\u9000\u83b7\u53d6\u5386\u53f2\u5904\u7406\u4eba", notes="\u81ea\u7531\u6d41\u7a0b\u6a21\u5f0f\u56de\u9000\u83b7\u53d6\u5386\u53f2\u5904\u7406\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string")})
    public Resource getHisActorsFreeFlow(@PathVariable String applicationId, @PathVariable String instanceId) throws Exception {
        String _userId = this.getUser().getId();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        FlowHistoryServiceImpl hisProcess = new FlowHistoryServiceImpl(applicationId);
        FlowRuntimeServiceImpl runtimeService = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = runtimeService.findFlowStateRT(instanceId);
        Collection list = hisProcess.getFlowHistorysByDocId(instance.getDocid());
        HashMap<String, UserVO> userMap = new HashMap<String, UserVO>();
        for (FlowHistoryVO his : list) {
            String userId = his.getAuditorId();
            if (_userId.equals(userId) || userMap.containsKey(userId)) continue;
            UserVO userVO = (UserVO)userProcess.doView(userId);
            userMap.put(userId, userVO);
        }
        ArrayList<UserNode> userList = new ArrayList<UserNode>();
        for (String key : userMap.keySet()) {
            WebUser webUser = new WebUser((IUser)userMap.get(key));
            UserNode u = MyProfileHelper.buildProfile((WebUser)webUser);
            userList.add(u);
        }
        return this.success("ok", userList);
    }

    @GetMapping(value={"/documents/{docId}/workflows/{flowId}/selectApprovers"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6307\u5b9a\u5ba1\u6279\u4eba\u7528\u6237\u9009\u62e9\u6846\u5217\u8868", notes="\u83b7\u53d6\u6d41\u7a0b\u6307\u5b9a\u5ba1\u6279\u4eba\u7528\u6237\u9009\u62e9\u6846\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="selectId", value="\u9009\u62e9id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="pageNum", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="string", defaultValue="1")})
    public Resource doSelectByFlow(@PathVariable String applicationId, @PathVariable String docId, @PathVariable String flowId, @RequestParam String nodeId, @RequestParam String type, @RequestParam(required=false) String selectId, @RequestParam(required=false, defaultValue="10") String pageSize, @RequestParam(required=false, defaultValue="1") String pageNum) throws Exception {
        List users = StateMachineHelper.getPrincipalList((String)docId, (WebUser)this.getUser(), (String)nodeId, (HttpServletRequest)this.request, (String)flowId, (int)Integer.valueOf(type), (String)selectId);
        List<UserNode> result = new ArrayList<UserNode>();
        for (UserVO userVO : users) {
            if (userVO.getStatus() != 1) continue;
            UserNode u = MyProfileHelper.buildProfileUser((UserVO)userVO);
            result.add(u);
        }
        result = this.sort(result);
        int newPageSzie = Integer.valueOf(pageSize);
        int newPageNum = Integer.valueOf(pageNum);
        Pager pager = Pager.create(result, (int)newPageSzie);
        List datas = pager.getPagedList(newPageNum);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datas", datas);
        map.put("pageCount", pager.getPageCount());
        map.put("linesPerPage", newPageSzie);
        map.put("rowCount", result.size());
        map.put("pageNum", newPageNum);
        return this.success("ok", map);
    }

    @GetMapping(value={"/workflows/defi"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="pageNum", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="string", defaultValue="1")})
    public Resource getFlowDefs(@PathVariable String applicationId, @RequestParam String type, @RequestParam(required=false, defaultValue="10") String pageSize, @RequestParam(required=false, defaultValue="1") String pageNum) throws Exception {
        BillDefiDesignTimeService billDefiService = DesignTimeServiceManager.billDefiDesignTimeService();
        int newPageSzie = Integer.valueOf(pageSize);
        int newPageNum = Integer.valueOf(pageNum);
        DataPackage dpks = billDefiService.query(applicationId, "", newPageNum, newPageSzie);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (BillDefiVO def : dpks.datas) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)def.getId());
            obj.put("name", (Object)def.getName());
            obj.put("subject", (Object)def.getSubject());
            list.add(obj);
        }
        map.put("datas", list);
        map.put("pageCount", Integer.valueOf(dpks.getPageCount()));
        map.put("linesPerPage", Integer.valueOf(dpks.linesPerPage));
        map.put("rowCount", Integer.valueOf(dpks.rowCount));
        map.put("pageNum", Integer.valueOf(newPageNum));
        return this.success("ok", map);
    }

    @GetMapping(value={"/documents/{docId}/workflows/{flowId}/selectCirculators"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6307\u5b9a\u6284\u9001\u4eba\u7528\u6237\u9009\u62e9\u6846\u5217\u8868", notes="\u83b7\u53d6\u6d41\u7a0b\u6307\u5b9a\u6284\u9001\u4eba\u7528\u6237\u9009\u62e9\u6846\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0bid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="selectId", value="\u9009\u62e9id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="pageNum", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="string", defaultValue="1")})
    public Resource doSelectCirculatorByFlow(@PathVariable String applicationId, @PathVariable String docId, @PathVariable String flowId, @RequestParam String nodeId, @RequestParam String type, @RequestParam(required=false) String selectId, @RequestParam(required=false, defaultValue="10") String pageSize, @RequestParam(required=false, defaultValue="1") String pageNum) throws Exception {
        Collection users = StateMachineHelper.getCirculatorList((String)docId, (IUser)this.getUser(), (String)nodeId, (HttpServletRequest)this.request, (String)flowId, (int)Integer.valueOf(type), (String)selectId);
        List<UserNode> result = new ArrayList<UserNode>();
        for (UserVO userVO : users) {
            if (userVO.getStatus() != 1) continue;
            UserNode u = MyProfileHelper.buildProfileUser((UserVO)userVO);
            result.add(u);
        }
        result = this.sort(result);
        int newPageSzie = Integer.valueOf(pageSize);
        int newPageNum = Integer.valueOf(pageNum);
        Pager pager = Pager.create(result, (int)newPageSzie);
        List datas = pager.getPagedList(newPageNum);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datas", datas);
        map.put("pageCount", pager.getPageCount());
        map.put("linesPerPage", newPageSzie);
        map.put("rowCount", result.size());
        map.put("pageNum", newPageNum);
        return this.success("ok", map);
    }

    @PutMapping(value={"/workflows/{instanceId}/supplement"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6dfb\u52a0/\u8865\u7b7e\u610f\u89c1", notes="\u6dfb\u52a0/\u8865\u7b7e\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="comments", value="\u8865\u7b7e\u610f\u89c1", required=true, paramType="query", dataType="string")})
    public Resource doFlowSupplement(@PathVariable String applicationId, @PathVariable String instanceId, @RequestParam String comments) throws Exception {
        String result = this.workflowService.doFlowSupplement(applicationId, instanceId, comments, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PutMapping(value={"/workflows/{instanceId}/assist"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u534f\u529e", notes="\u6d41\u7a0b\u534f\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="attitude", value="\u534f\u529e\u610f\u89c1", required=true, paramType="query", dataType="string")})
    public Resource doFlowAssist(@PathVariable String applicationId, @PathVariable String instanceId, @RequestParam String attitude) throws Exception {
        String result = this.workflowService.doFlowAssist(applicationId, instanceId, attitude, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docId}/workflows/assist/addition"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u534f\u529e\u52a0\u7b7e", notes="\u6d41\u7a0b\u534f\u529e\u52a0\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="userIds", value="\u8bf7\u6c42\u5305\u4f53(\u7528\u6237id\u96c6\u5408)", required=true, paramType="body", dataType="string")})
    public Resource addCoAuditor(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String userIds) throws Exception {
        List idList = (List)JsonPath.parse((String)userIds).json();
        String result = this.workflowService.addCoAuditor(applicationId, docId, idList, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @PutMapping(value={"/documents/{docId}/workflows/approver/addition"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u534f\u529e\u52a0\u7b7e", notes="\u6d41\u7a0b\u534f\u529e\u52a0\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="userIds", value="\u8bf7\u6c42\u5305\u4f53(\u7528\u6237id\u96c6\u5408)", required=true, paramType="body", dataType="string")})
    public Resource addAuditor(@PathVariable String applicationId, @PathVariable String docId, @RequestBody String userIds) throws Exception {
        List idList = (List)JsonPath.parse((String)userIds).json();
        String result = this.workflowService.addAuditor(applicationId, docId, idList, (IUser)this.getUser());
        return this.success("ok", result);
    }

    private Collection<ErrorMessage> validateDocument(ParamsTable params, Document doc, String applicationId, IUser webUser) throws Exception {
        Collection errors;
        ArrayList<ErrorMessage> errmsgs = new ArrayList<ErrorMessage>();
        doc.setDomainid(this.getDomain());
        String _flowType = params.getParameterAsString("_flowType");
        boolean isWithoutValidate = params.getParameterAsBoolean("isWithoutValidate");
        if (isWithoutValidate) {
            return null;
        }
        if ("retracement".equals(_flowType)) {
            _flowType = "85";
        }
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        if ((_flowType != null && _flowType.equals("85") || proxy.isDocSaveUser(doc, params, webUser)) && (errors = proxy.doValidate(doc, params, webUser)) != null && errors.size() > 0) {
            for (ValidateMessage err : errors) {
                ErrorMessage msg = new ErrorMessage();
                msg.setErrcode(40001);
                msg.setErrmsg(err.getErrmessage());
                msg.setField(err.getFieldname());
                errmsgs.add(msg);
            }
        }
        return errmsgs;
    }

    private List<UserNode> sort(List<UserNode> list) {
        Collections.sort(list, new Comparator<UserNode>(){

            @Override
            public int compare(UserNode o1, UserNode o2) {
                if (o1.getOrderByNo() > o2.getOrderByNo()) {
                    return 1;
                }
                if (o1.getOrderByNo() == o2.getOrderByNo()) {
                    return 0;
                }
                return -1;
            }
        });
        return list;
    }
}

