/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.widget.controller;

import cn.myapps.authtime.user.model.UserDefined;
import cn.myapps.authtime.user.service.UserDefinedProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.checkin.CheckinVO;
import cn.myapps.common.model.widget.PageWidget;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.widget.service.PageWidgetDesignTimeService;
import cn.myapps.runtime.checkin.CheckinProcess;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.WorkVO;
import cn.myapps.runtime.dynaform.work.ejb.WorkProcessBean;
import cn.myapps.runtime.widget.service.PageWidgetRunTimeService;
import cn.myapps.runtime.workflow.storage.runtime.ejb.Circulator;
import cn.myapps.runtime.workflow.storage.runtime.ejb.CirculatorProcessBean;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.PathNotFoundException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"widgets\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class PageWidgetController
extends AbstractRuntimeController {
    @Autowired
    PageWidgetRunTimeService pageWidgetRunTimeService;

    @GetMapping(value={"/widgets/{widgetId}"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9aWidget\u5185\u5bb9", notes="\u83b7\u53d6\u6307\u5b9aWidget\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="widgetId", value="\u5c0f\u5de5\u5177id", required=true, paramType="path", dataType="string")})
    public Resource doDisplayWidget(@PathVariable String widgetId) throws Exception {
        Object result = this.pageWidgetRunTimeService.displayWidget(this.getParams(), widgetId, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/homepage/config"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u9996\u9875Widget\u914d\u7f6e", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u9996\u9875Widget\u914d\u7f6e")
    public Resource doGetUserPageWidgetSetting() throws Exception {
        boolean isMobile = this.getParams().getParameterAsBoolean("isMobile");
        JSONObject userPageWidgetSetting = this.pageWidgetRunTimeService.getUserPageWidgetSetting((IUser)this.getUser(), isMobile);
        return this.success("ok", userPageWidgetSetting);
    }

    @GetMapping(value={"/{applicationId}/homepage/phoneConfig"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u7aef(\u5fae\u4fe1)\u9996\u9875Widget\u914d\u7f6e", notes="\u83b7\u53d6\u624b\u673a\u7aef(\u5fae\u4fe1)\u9996\u9875Widget\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u5e94\u7528id", required=true, paramType="path", dataType="string")})
    public Resource doGetPhoneConfig(@PathVariable String applicationId) throws Exception {
        ApplicationDesignTimeService applicationService = DesignTimeServiceManager.applicationDesignTimeService();
        Application application = (Application)applicationService.findById(applicationId);
        String systemWidgetSettingString = application.getSystemWidgetSetting();
        JSONObject systemWidgetSetting = new JSONObject();
        if (StringUtils.isNotEmpty((String)systemWidgetSettingString)) {
            systemWidgetSetting = JSONObject.parseObject((String)systemWidgetSettingString);
        } else {
            systemWidgetSetting.put("Banner", (Object)true);
            systemWidgetSetting.put("menuIcon", (Object)true);
            systemWidgetSetting.put("system_workflow", (Object)true);
        }
        return this.success("ok", systemWidgetSetting);
    }

    @PostMapping(value={"/homepage/config"})
    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u9996\u9875Widget\u914d\u7f6e", notes="\u4fdd\u5b58\u7528\u6237\u9996\u9875Widget\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource doSaveUserPageWidgetSetting(@RequestBody(required=false) String content) throws Exception {
        String templateElement = null;
        try {
            if (StringUtil.isBlank((String)content)) {
                templateElement = "";
            } else {
                JSONObject templateJSON = JSONObject.parseObject((String)content);
                templateElement = templateJSON.toJSONString();
                ApplicationDesignTimeService appService = DesignTimeServiceManager.applicationDesignTimeService();
                List apps = appService.getListByWebUser((IUser)this.getUser());
                PageWidgetDesignTimeService process = DesignTimeServiceManager.pageWidgetDesignTimeService();
                for (Application application : apps) {
                    Collection pageWidgets = process.doQueryWidgetsByApplicationId(application.getId());
                    for (PageWidget pageWidget : pageWidgets) {
                        if (!pageWidget.isPublished() || pageWidget.isSetup()) continue;
                        pageWidget.setSetup(true);
                        process.update((Object)pageWidget);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PathNotFoundException();
        }
        WebUser user = this.getUser();
        UserDefinedProcess process = (UserDefinedProcess)ProcessFactory.createProcess(UserDefinedProcess.class);
        UserDefined vo = process.doFindMyCustomUserDefined((IUser)user);
        if (vo != null) {
            vo.setTemplateElement(templateElement);
            process.doUpdate((AuthtimeValueObject)vo);
        } else {
            UserDefined po = new UserDefined();
            po.setCreator(user.getName());
            po.setUserId(user.getId());
            po.setTemplateElement(templateElement);
            process.doCreate((AuthtimeValueObject)po);
        }
        return this.success("ok", null);
    }

    @GetMapping(value={"/widget/myPending"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u5f85\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)", notes="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u5f85\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="\u73b0\u5728\u7684\u9875\u6570", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u7684\u6761\u6570", required=false, paramType="query", dataType="string", defaultValue="5")})
    public Resource queryPendingByUser(@RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="5") int linesPerPage) throws Exception {
        WebUser user = this.getUser();
        List applicationIds = user.getApplicationIds();
        DataPackage workDataPage = new DataPackage();
        ArrayList listWork = new ArrayList();
        int allSum = 0;
        boolean isFlowAgent = true;
        if (applicationIds != null) {
            for (String applicationId : applicationIds) {
                WorkProcessBean wp = new WorkProcessBean(applicationId);
                DataPackage<WorkVO> tmp_works = wp.getPendingList("", "", "", isFlowAgent, applicationId, user.getDomainid(), "", pageNo, linesPerPage, (IUser)user);
                listWork.addAll(tmp_works.getDatas());
                allSum += tmp_works.getRowCount();
            }
        }
        if (allSum != 0) {
            workDataPage.setRowCount(allSum);
            workDataPage.setLinesPerPage(linesPerPage);
            workDataPage.setPageNo(pageNo);
            int beginIndex = (pageNo - 1) * linesPerPage;
            int endIndex = pageNo * linesPerPage;
            if (beginIndex >= listWork.size()) {
                workDataPage.setDatas(null);
                workDataPage.setRowCount(0);
            } else if (endIndex >= listWork.size()) {
                endIndex = listWork.size();
            }
            workDataPage.setDatas(listWork.subList(beginIndex, endIndex));
        }
        return this.success("ok", workDataPage);
    }

    @GetMapping(value={"/widget/myProcessing"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u7ecf\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)", notes="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u7ecf\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="\u73b0\u5728\u7684\u9875\u6570", required=false, paramType="query", dataType="int", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u7684\u6761\u6570", required=false, paramType="query", dataType="int", defaultValue="5")})
    public Resource queryProcessingByUser(@RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="5") int linesPerPage) throws Exception {
        WebUser user = this.getUser();
        List applicationIds = user.getApplicationIds();
        DataPackage workDataPage = new DataPackage();
        ArrayList listWork = new ArrayList();
        int allSum = 0;
        if (applicationIds != null) {
            for (String applicationId : applicationIds) {
                WorkProcessBean wp = new WorkProcessBean(applicationId);
                DataPackage<WorkVO> tmp_works = wp.getProcessedRunningList("", "", "", applicationId, user.getDomainid(), false, "pending", "", pageNo, linesPerPage, (IUser)user);
                listWork.addAll(tmp_works.getDatas());
                allSum += tmp_works.getRowCount();
            }
        }
        if (allSum != 0) {
            workDataPage.setRowCount(allSum);
            workDataPage.setLinesPerPage(linesPerPage);
            workDataPage.setPageNo(pageNo);
            int beginIndex = (pageNo - 1) * linesPerPage;
            int endIndex = pageNo * linesPerPage;
            if (beginIndex >= listWork.size()) {
                workDataPage.setDatas(null);
                workDataPage.setRowCount(0);
            } else if (endIndex >= listWork.size()) {
                endIndex = listWork.size();
            }
            workDataPage.setDatas(listWork.subList(beginIndex, endIndex));
        }
        return this.success("ok", workDataPage);
    }

    @GetMapping(value={"/widget/myCopy"})
    @ApiOperation(value="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u6284\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)", notes="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u6284\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", value="\u73b0\u5728\u7684\u9875\u6570", required=false, paramType="query", dataType="int", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u7684\u6761\u6570", required=false, paramType="query", dataType="int", defaultValue="5")})
    public Resource listCirculatorByUser(@RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="5") int linesPerPage) throws Exception {
        WebUser user = this.getUser();
        List applicationIds = user.getApplicationIds();
        DataPackage workDataPage = new DataPackage();
        ArrayList listCirculators = new ArrayList();
        long allSum = 0L;
        ParamsTable params = this.getParams();
        boolean isRead = params.getParameterAsBoolean("isread");
        if (isRead) {
            params.setParameter("_isRead", (Object)1);
        } else {
            params.setParameter("_isRead", (Object)0);
        }
        if (applicationIds != null) {
            for (String applicationId : applicationIds) {
                CirculatorProcessBean cprocess = new CirculatorProcessBean(applicationId);
                DataPackage result = cprocess.getWorksByUser(params, (IUser)this.getUser());
                allSum += cprocess.countByCopy(params, (IUser)user);
                listCirculators.addAll(result.getDatas());
            }
        }
        if (allSum != 0L) {
            MyCompartor2 mc = new MyCompartor2();
            Collections.sort(listCirculators, mc);
            workDataPage.setRowCount(new Long(allSum).intValue());
            workDataPage.setLinesPerPage(linesPerPage);
            workDataPage.setPageNo(pageNo);
            int beginIndex = (pageNo - 1) * linesPerPage;
            int endIndex = pageNo * linesPerPage;
            if (beginIndex >= listCirculators.size()) {
                workDataPage.setDatas(null);
                workDataPage.setRowCount(0);
            } else if (endIndex >= listCirculators.size()) {
                endIndex = listCirculators.size();
            }
            workDataPage.setDatas(listCirculators.subList(beginIndex, endIndex));
        }
        return this.success("ok", workDataPage);
    }

    @PostMapping(value={"/{applicationId}/widgets/{widgetId}/checkin"})
    @ApiOperation(value="\u7b7e\u5230", notes="\u7b7e\u5230")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="widgetId", value="widetId", required=true, paramType="path", dataType="string")})
    public Resource createCheckin(@PathVariable String applicationId, @PathVariable String widgetId) throws Exception {
        CheckinProcess service = RunTimeServiceManager.checkinProcess((String)applicationId);
        WebUser user = this.getUser();
        CheckinVO checkin = new CheckinVO();
        checkin.setUserId(user.getId());
        checkin.setUserName(user.getName());
        checkin.setCheckinTime(new Date());
        checkin.setDomainid(user.getDomainid());
        checkin.setApplicationid(applicationId);
        checkin.setWidgetId(widgetId);
        service.doCreate(checkin);
        return this.success("ok", checkin);
    }

    @GetMapping(value={"/{applicationId}/widgets/{widgetId}/checkin"})
    @ApiOperation(value="\u662f\u5426\u7b7e\u5230", notes="\u662f\u5426\u7b7e\u5230")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="widgetId", value="widetId", required=true, paramType="path", dataType="string")})
    public Resource isCheckin(@PathVariable String applicationId, @PathVariable String widgetId) throws Exception {
        CheckinProcess service = RunTimeServiceManager.checkinProcess((String)applicationId);
        boolean result = service.isCheckin(widgetId, this.getUser().getId());
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/widgets/{widgetId}/checkins"})
    @ApiOperation(value="\u7b7e\u5230\u7edf\u8ba1", notes="\u7b7e\u5230\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="widgetId", value="widetId", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="countType", value="\u7edf\u8ba1\u7c7b\u578b", required=false, paramType="query", dataType="string", defaultValue="none")})
    public Resource getCheckins(@PathVariable String applicationId, @PathVariable String widgetId, @RequestParam(required=false, defaultValue="none") String countType) throws Exception {
        CheckinProcess service = RunTimeServiceManager.checkinProcess((String)applicationId);
        long result = service.countCheckinByType(widgetId, countType, this.getUser().getId());
        return this.success("ok", result);
    }

    private class MyCompartor2
    implements Comparator {
        private MyCompartor2() {
        }

        public int compare(Object o1, Object o2) {
            Circulator c1 = (Circulator)o1;
            Circulator c2 = (Circulator)o2;
            return c2.getCcTime().compareTo(c1.getCcTime());
        }
    }
}

