/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.usersetup.controller;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.user.UserUtil;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.workflow.storage.runtime.proxy.ejb.WorkflowProxyProcessBean;
import cn.myapps.runtime.workflow.storage.runtime.proxy.ejb.WorkflowProxyVO;
import cn.myapps.support.weixin.WeixinServiceProxy;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.utils.RSAUtils;
import com.bcxin.saas.core.utils.encrypt.PasswordUtils;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u4e2a\u4eba\u8bbe\u7f6e\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class UserSetupController
extends AbstractRuntimeController {
    @PostMapping(value={"/usersetups/password"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u5bc6\u7801", notes="\u66f4\u65b0\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonStr", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource setUserPassword(@RequestBody String jsonStr) throws Exception {
        int passwordArrayLength;
        WebUser user = this.getUser();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String oldPassword = jsonObject.getString("oldPassword");
        try {
            oldPassword = RSAUtils.decrypt((String)oldPassword);
        }
        catch (Exception e) {
            String oldPasswordLp = oldPassword.substring(0, oldPassword.length() - 2);
            String oldPasswordRp = oldPassword.substring(oldPassword.length() - 2, oldPassword.length());
            oldPassword = Security.decodeBASE64((String)(oldPasswordRp + oldPasswordLp));
        }
        String newpassword = jsonObject.getString("newpassword");
        try {
            newpassword = RSAUtils.decrypt((String)newpassword);
        }
        catch (Exception e) {
            String newpasswordLp = newpassword.substring(0, newpassword.length() - 2);
            String newpasswordRp = newpassword.substring(newpassword.length() - 2, newpassword.length());
            newpassword = Security.decodeBASE64((String)(newpasswordRp + newpasswordLp));
        }
        String confirmPassword = jsonObject.getString("confirmPassword");
        try {
            confirmPassword = RSAUtils.decrypt((String)confirmPassword);
        }
        catch (Exception e) {
            String confirmPasswordLp = confirmPassword.substring(0, confirmPassword.length() - 2);
            String confirmPasswordRp = confirmPassword.substring(confirmPassword.length() - 2, confirmPassword.length());
            confirmPassword = Security.decodeBASE64((String)(confirmPasswordRp + confirmPasswordLp));
        }
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO userVO = (UserVO)userProcess.doView(user.getId());
        PropertyUtil.reload((String)"passwordLegal");
        String passwordArrayLengthString = PropertyUtil.get((String)"ao.login.password.update.before.maxtimes");
        int n = passwordArrayLength = StringUtil.isNumber((String)passwordArrayLengthString) ? StringUtil.parseInt((String)passwordArrayLengthString) : 0;
        if (passwordArrayLength != 0) {
            Pattern p;
            Matcher matcher;
            boolean result;
            String legal;
            UserVO po = (UserVO)userProcess.doView(userVO.getId());
            String oldPasswordArray = "";
            oldPasswordArray = po.getPasswordArray();
            String[] pwda = null;
            int oldpasswordArrayLength = 0;
            if (oldPasswordArray != null) {
                pwda = oldPasswordArray.split(",");
                oldpasswordArrayLength = oldPasswordArray.split(",").length;
            }
            String passwordArray = null;
            if (!StringUtil.isBlank((String)newpassword) && !newpassword.trim().equals("888888qqqq")) {
                if (!newpassword.trim().equals(confirmPassword)) {
                    return this.error(4001, "{*[cn.myapps.core.personalsettings.basic.lable.ComfirmAndPasswordNotSame]*}", null);
                }
                String password = po.getLoginpwd();
                boolean oldPasswordFlag = false;
                if (PasswordUtils.initVerify((String)oldPassword.trim(), (String)password)) {
                    oldPasswordFlag = true;
                }
                if (oldPassword.trim().equals(this.decrypt(password))) {
                    oldPasswordFlag = true;
                }
                if (PasswordUtils.validatePassword((String)oldPassword.trim(), (String)password)) {
                    oldPasswordFlag = true;
                }
                if (!oldPasswordFlag && !oldPassword.trim().equals(this.decrypt(password))) {
                    return this.error(4001, "{*[cn.myapps.core.personalsettings.basic.lable.originalPasswordError]*}", null);
                }
            }
            if (!(PasswordUtils.initVerify((String)newpassword.trim(), (String)po.getLoginpwd()) && PasswordUtils.validatePassword((String)newpassword.trim(), (String)po.getLoginpwd()) && newpassword.trim().equals(this.decrypt(po.getLoginpwd())) || newpassword.trim().equals("888888qqqq"))) {
                if (oldPasswordArray != null) {
                    for (int i = 0; i < oldpasswordArrayLength; ++i) {
                        if (!newpassword.equals(this.decrypt(pwda[i]))) continue;
                        return this.error(4001, "{*[ModifyPasswordNotSame]*}\uff1a" + passwordArrayLengthString, null);
                    }
                    passwordArray = oldPasswordArray + "," + this.encrypt(newpassword);
                } else {
                    passwordArray = po.getLoginpwd() + "," + this.encrypt(newpassword);
                }
                userVO.setLastModifyTime(new Date());
            } else {
                passwordArray = po.getPasswordArray();
                userVO.setLastModifyTime(po.getLastModifyTime());
            }
            if (oldpasswordArrayLength + 1 > passwordArrayLength) {
                int i1 = passwordArray.split(",").length;
                String passwordArraytmp = "";
                for (int i = i1 - passwordArrayLength - 1; i < i1; ++i) {
                    passwordArraytmp = passwordArraytmp + "," + passwordArray.split(",")[i];
                }
                passwordArray = passwordArraytmp.substring(1);
            }
            String passwordLength = PropertyUtil.get((String)"ao.login.password.length");
            if (!StringUtil.isBlank((String)newpassword) && passwordLength != null && !passwordLength.trim().equals("")) {
                int length = Integer.parseInt(passwordLength);
                if (newpassword.length() < length) {
                    return this.error(4001, "{*[PasswordLengthCanNotLow]*}" + length, null);
                }
            }
            if (((legal = PropertyUtil.get((String)"ao.login.password.legal")).equals("1") || legal == "1") && !(result = (matcher = (p = Pattern.compile("^(?=.*\\d)(?=.*[a-z]).{8,}$")).matcher(newpassword)).matches())) {
                return this.error(4001, "\u5bc6\u7801\u5fc5\u987b\u7531\u82f1\u6587,\u7279\u6b8a\u5b57\u7b26\u548c\u6570\u5b57\u6784\u6210", null);
            }
            userVO.setPasswordArray(passwordArray);
        }
        String encodePwd = Security.encodeToBASE64((String)newpassword);
        String lp = encodePwd.substring(0, 2);
        String rp = encodePwd.substring(2, encodePwd.length());
        userVO.setLoginpwd(rp + lp);
        userProcess.doPersonalUpdate((AuthtimeValueObject)userVO);
        if (!"none".equals(userVO.getDomain().getWeixinProxyType())) {
            final UserVO _user = userVO;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WeixinServiceProxy.createOrUpdateUser2Weixin((UserVO)_user);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            PersistenceUtils.closeSessionAndConnection();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        UserUtil.synUser((UserVO)userVO, (boolean)true);
        user.setLoginpwd(userVO.getLoginpwd());
        WebUser.setWebUser((WebUser)user, (HttpServletRequest)this.request);
        return this.success("ok", "");
    }

    @PostMapping(value={"/usersetups/detail"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u4e2a\u4eba\u4fe1\u606f", notes="\u66f4\u65b0\u4e2a\u4eba\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonStr", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource setUserDetail(@RequestBody String jsonStr) throws Exception {
        WebUser user = this.getUser();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String name = jsonObject.getString("name");
        String email = jsonObject.getString("email");
        String telephone = jsonObject.getString("telephone");
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO userVO = (UserVO)userProcess.doView(user.getId());
        userVO.setName(name);
        userVO.setEmail(email);
        userVO.setTelephone(telephone);
        userProcess.doPersonalUpdate((AuthtimeValueObject)userVO);
        if (!"none".equals(userVO.getDomain().getWeixinProxyType())) {
            final UserVO _user = userVO;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        WeixinServiceProxy.createOrUpdateUser2Weixin((UserVO)_user);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            PersistenceUtils.closeSessionAndConnection();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }).start();
        }
        user.setName(name);
        user.setEmail(email);
        user.setTelephone(telephone);
        WebUser.setWebUser((WebUser)user, (HttpServletRequest)this.request);
        return this.success("ok", "");
    }

    @GetMapping(value={"/{applicationId}/usersetups/proxys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4ee3\u7406\u5217\u8868", notes="\u83b7\u53d6\u4ee3\u7406\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="flowName", value="\u6d41\u7a0b\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u663e\u793a\u6761\u6570", required=false, paramType="query", dataType="string")})
    public Resource getUserProxys(@PathVariable String applicationId, @RequestParam(required=false) String flowName, @RequestParam(required=false) String linesPerPage, @RequestParam(required=false) String pageNo) throws Exception {
        ParamsTable params = this.getParams();
        params.setParameter("application", (Object)applicationId);
        params.setParameter("_flowName", (Object)flowName);
        if (!StringUtil.isBlank((String)linesPerPage)) {
            int newPageSize = Integer.parseInt(linesPerPage);
            params.setParameter("_pagelines", (Object)newPageSize);
        }
        if (!StringUtil.isBlank((String)pageNo)) {
            int newPageNum = Integer.parseInt(pageNo);
            params.setParameter("_currpage", (Object)newPageNum);
        }
        WorkflowProxyProcessBean workflowProcess = new WorkflowProxyProcessBean(applicationId);
        DataPackage result = workflowProcess.doQuery(params, (IUser)this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/usersetups/proxys/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4ee3\u7406", notes="\u83b7\u53d6\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u4ee3\u7406id", required=true, paramType="path", dataType="string")})
    public Resource getUserProxy(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        WorkflowProxyProcessBean workflowProcess = new WorkflowProxyProcessBean(applicationId);
        WorkflowProxyVO result = (WorkflowProxyVO)workflowProcess.doView(id);
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/usersetups/proxys/flows"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5217\u8868", notes="\u83b7\u53d6\u6d41\u7a0b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string")})
    public Resource getUserProxyFlowName(@PathVariable String applicationId) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        BillDefiDesignTimeService bp = DesignTimeServiceManager.billDefiDesignTimeService();
        ParamsTable params = this.getParams();
        String subject = params.getParameterAsString("subject");
        if (StringUtil.isBlank((String)subject)) {
            subject = "";
        }
        Collection flows = bp.getBillDefiByApplication(applicationId);
        for (BillDefiVO bv : flows) {
            if (!bv.getSubject().contains(subject)) continue;
            map.put(bv.getId(), bv.getSubject());
        }
        return this.success("ok", map);
    }

    @PostMapping(value={"/{applicationId}/usersetups/proxys/save"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4fdd\u5b58\u4ee3\u7406", notes="\u4fdd\u5b58\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u4ee3\u7406id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource saveUserProxy(@PathVariable String applicationId, @RequestParam(required=false) String id, @RequestBody String content) throws Exception {
        WorkflowProxyProcessBean workflowProcess = new WorkflowProxyProcessBean(applicationId);
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        String flowName = jsonObject.getString("flowName");
        String flowId = jsonObject.getString("flowId");
        String description = jsonObject.getString("description");
        String state = jsonObject.getString("state");
        String agents = jsonObject.getString("agents");
        String agentsName = jsonObject.getString("agentsName");
        String owner = jsonObject.getString("owner");
        Date startProxyTime = jsonObject.getDate("startProxyTime");
        Date endProxyTime = jsonObject.getDate("endProxyTime");
        int proxyMode = jsonObject.getIntValue("proxyMode");
        if (!StringUtil.isBlank((String)flowId)) {
            String[] flowIdArr = flowId.split(";");
            String[] flowNameArr = flowName.split(";");
            for (int i = 0; i < flowNameArr.length; ++i) {
                WorkflowProxyVO vo = !StringUtil.isBlank((String)id) ? (WorkflowProxyVO)workflowProcess.doView(id) : new WorkflowProxyVO();
                if (!StringUtil.isBlank((String)description)) {
                    vo.setDescription(description);
                }
                if (!StringUtil.isBlank((String)state)) {
                    vo.setState(state);
                }
                if (!StringUtil.isBlank((String)agents)) {
                    vo.setAgents(agents);
                }
                if (!StringUtil.isBlank((String)agentsName)) {
                    vo.setAgentsName(agentsName);
                }
                if (!StringUtil.isBlank((String)owner)) {
                    vo.setOwner(owner);
                }
                if (startProxyTime != null && !startProxyTime.equals("")) {
                    vo.setStartProxyTime(startProxyTime);
                }
                if (endProxyTime != null && !endProxyTime.equals("")) {
                    vo.setEndProxyTime(endProxyTime);
                }
                vo.setProxyMode(proxyMode);
                vo.setApplicationid(applicationId);
                vo.setDomainid(this.getUser().getDomainid());
                if (vo.getOwner() == null || vo.getOwner().trim().length() <= 0) {
                    vo.setOwner(this.getUser().getId());
                }
                vo.setFlowName(flowNameArr[i]);
                vo.setFlowId(flowIdArr[i]);
                if (vo.getId() == null || vo.getId().trim().length() <= 0) {
                    if (!workflowProcess.onlyCheckOnFlow(vo)) {
                        return this.error(40014, "\u8be5\u6d41\u7a0b\u7684\u4ee3\u7406\u914d\u7f6e\u4fe1\u606f\u5df2\u5b58\u5728:" + flowNameArr[i], null);
                    }
                    workflowProcess.doCreate((ValueObject)vo);
                    continue;
                }
                workflowProcess.doUpdate((ValueObject)vo);
            }
        } else {
            WorkflowProxyVO vo = !StringUtil.isBlank((String)id) ? (WorkflowProxyVO)workflowProcess.doView(id) : new WorkflowProxyVO();
            if (!StringUtil.isBlank((String)description)) {
                vo.setDescription(description);
            }
            if (!StringUtil.isBlank((String)state)) {
                vo.setState(state);
            }
            if (!StringUtil.isBlank((String)agents)) {
                vo.setAgents(agents);
            }
            if (!StringUtil.isBlank((String)agentsName)) {
                vo.setAgentsName(agentsName);
            }
            if (!StringUtil.isBlank((String)owner)) {
                vo.setOwner(owner);
            }
            if (startProxyTime != null && !startProxyTime.equals("")) {
                vo.setStartProxyTime(startProxyTime);
            }
            if (endProxyTime != null && !endProxyTime.equals("")) {
                vo.setEndProxyTime(endProxyTime);
            }
            vo.setProxyMode(proxyMode);
            vo.setApplicationid(applicationId);
            vo.setDomainid(this.getUser().getDomainid());
            if (vo.getOwner() == null || vo.getOwner().trim().length() <= 0) {
                vo.setOwner(this.getUser().getId());
            }
            vo.setFlowName("\u6240\u6709\u6d41\u7a0b");
            vo.setFlowId("");
            if (vo.getId() == null || vo.getId().trim().length() <= 0) {
                if (!workflowProcess.onlyCheckOnFlow(vo)) {
                    return this.error(40014, "\u8be5\u6d41\u7a0b\u7684\u4ee3\u7406\u914d\u7f6e\u4fe1\u606f\u5df2\u5b58\u5728", null);
                }
                workflowProcess.doCreate((ValueObject)vo);
            } else {
                workflowProcess.doUpdate((ValueObject)vo);
            }
        }
        return this.success("ok", "");
    }

    @DeleteMapping(value={"/{applicationId}/usersetups/proxys"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u4ee3\u7406", notes="\u5220\u9664\u4ee3\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="jsonStr", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource deleteUserProxy(@PathVariable String applicationId, @RequestBody String jsonStr) throws Exception {
        List ids = (List)JsonPath.parse((String)jsonStr).json();
        String[] pks = new String[]{};
        pks = ids.toArray(pks);
        WorkflowProxyProcessBean workflowProcess = new WorkflowProxyProcessBean(applicationId);
        workflowProcess.doRemove(pks);
        return this.success("ok", "");
    }

    @GetMapping(value={"/usersetups/domains"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u4f01\u4e1a\u57df", notes="\u83b7\u53d6\u7528\u6237\u6240\u5c5e\u4f01\u4e1a\u57df")
    public Resource getDomains() throws Exception {
        WebUser webUser = this.getUser();
        String loginNo = webUser.getLoginno();
        String loginPwd = Security.decryptPassword((String)webUser.getLoginpwd());
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        DataPackage users = userProcess.queryDataByParamsTable("All", "", loginNo, "", "", "", "", Integer.valueOf(1), "", null, null, 1, Integer.MAX_VALUE);
        ArrayList<DomainVO> result = new ArrayList<DomainVO>();
        for (UserVO user : users.datas) {
            DomainVO domain;
            if (!StringUtils.hasLength((String)loginPwd) || !loginPwd.equals(Security.decryptPassword((String)user.getLoginpwd())) || (domain = user.getDomain()) == null || domain.getStatus() != 1) continue;
            result.add(user.getDomain());
        }
        return this.success("ok", result);
    }

    @PutMapping(value={"/usersetups/domains/switch"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5207\u6362\u4f01\u4e1a\u57df", notes="\u5207\u6362\u4f01\u4e1a\u57df")
    public Resource switchDomain(@RequestParam String domain, HttpServletResponse response) throws Exception {
        WebUser webUser = this.getUser();
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO user = userProcess.getUserByLoginnoAndDoaminName(webUser.getLoginno(), domain);
        String token = Security.getToken((String)user.getId());
        Cookie cookie = new Cookie("accessToken", token);
        Cookie isFromLogin = new Cookie("isFromLogin", "1");
        cookie.setPath("/");
        cookie.setMaxAge(7200);
        isFromLogin.setPath("/");
        response.addCookie(cookie);
        response.addCookie(isFromLogin);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("accessToken", (Object)token);
        return this.success("ok", jsonObject);
    }

    private String encrypt(String s) throws Exception {
        return Security.encryptPassword((String)s);
    }

    private String decrypt(String s) {
        String pwd = Security.decryptPassword((String)s);
        return Security.decryptPassword((String)s);
    }
}

