/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.user.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.authtime.user.service.UserRunTimeService;
import cn.myapps.authtime.usergroup.model.UserGroupVO;
import cn.myapps.authtime.usergroup.service.UserGroupProcess;
import cn.myapps.authtime.usergroup.service.UserGroupSetProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.base.web.listener.OnlineUsers;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.dynaform.view.tree.Node;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import com.bcxin.saas.domains.dtos.PageResultDto;
import com.bcxin.saas.domains.dtos.PageSearchDto;
import com.bcxin.saas.domains.readers.EmployeeDbReader;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u7528\u6237\u9009\u62e9\u6846\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime"}, produces={"application/json;charset=UTF-8"})
public class UserSelectboxController
extends AbstractRuntimeController {
    @Autowired
    private UserRunTimeService userService;
    @Autowired
    private EmployeeDbReader employeeDbReader;

    @GetMapping(value={"/{applicationId}/users/selectbox/department"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4ee5\u90e8\u95e8\u4e3a\u6811\u5f62\u7ed3\u6784\u7684\u7528\u6237\u96c6\u5408", notes="\u83b7\u53d6\u4ee5\u90e8\u95e8\u4e3a\u6811\u5f62\u7ed3\u6784\u7684\u7528\u6237\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="deptId", value="\u90e8\u95e8id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="pageNum", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="string", defaultValue="1")})
    public Resource getUserListAsDeptTree(@PathVariable String applicationId, @RequestParam(required=false, name="deptId") String deptId, @RequestParam(required=false, defaultValue="10") String pageSize, @RequestParam(required=false, defaultValue="1") String pageNum) throws Exception {
        if (pageSize == null || "".equals(pageSize) || "null".equals(pageSize)) {
            pageSize = "10";
        }
        if (pageNum == null || "".equals(pageNum) || "null".equals(pageNum)) {
            pageNum = "1";
        }
        int newPageSize = Integer.parseInt(pageSize);
        int newPageNum = Integer.parseInt(pageNum);
        PageSearchDto searchDto = new PageSearchDto();
        searchDto.setDomainId(this.getUser().getDomainid());
        searchDto.setDeptId(deptId);
        searchDto.setPageNum(newPageNum);
        searchDto.setPageSize(newPageSize);
        PageResultDto result = this.employeeDbReader.getEmployeeByDepartId(searchDto);
        return this.success("ok", result);
    }

    @GetMapping(value={"/{applicationId}/users/selectbox/role"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4ee5\u89d2\u8272\u4e3a\u6811\u5f62\u7ed3\u6784\u7684\u7528\u6237\u96c6\u5408(\u5206\u9875)", notes="\u83b7\u53d6\u4ee5\u89d2\u8272\u4e3a\u6811\u5f62\u7ed3\u6784\u7684\u7528\u6237\u96c6\u5408(\u5206\u9875)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="pageNum", value="\u5f53\u524d\u9875", required=false, paramType="query", dataType="string", defaultValue="1")})
    public Resource getUserListAsRoleTree(@PathVariable String applicationId, @RequestParam(required=false) String roleId, @RequestParam(required=false, defaultValue="10") String pageSize, @RequestParam(required=false, defaultValue="1") String pageNum) throws Exception {
        if (pageSize == null || "".equals(pageSize) || "null".equals(pageSize)) {
            pageSize = "10";
        }
        if (pageNum == null || "".equals(pageNum) || "null".equals(pageNum)) {
            pageNum = "1";
        }
        int newPageSize = Integer.parseInt(pageSize);
        int newPageNum = Integer.parseInt(pageNum);
        ParamsTable params = this.getParams();
        String flowId = params.getParameterAsString("flowId");
        String nodeId = params.getParameterAsString("nodeId");
        String docId = params.getParameterAsString("docId");
        int type = params.getParameterAsInteger("type");
        if (!StringUtil.isBlank((String)roleId)) {
            PageSearchDto searchDto = new PageSearchDto();
            searchDto.setDomainId(this.getUser().getDomainid());
            searchDto.setRoleId(roleId);
            searchDto.setPageNum(newPageNum);
            searchDto.setPageSize(newPageSize);
            PageResultDto result = this.employeeDbReader.getEmployees(searchDto);
            return this.success("ok", result);
        }
        Map result = this.userService.getUserListAsRoleTree((IUser)this.getUser(), roleId, flowId, nodeId, applicationId, docId, Integer.valueOf(newPageSize), Integer.valueOf(newPageNum), type, this.request);
        return this.success("ok", result);
    }

    @GetMapping(value={"/users/selectbox/contacts"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4ee5\u901a\u8baf\u5f55\u4e3a\u6811\u5f62\u7ed3\u6784\u7684\u7528\u6237\u96c6\u5408", notes="\u83b7\u53d6\u4ee5\u901a\u8baf\u5f55\u4e3a\u6811\u5f62\u7ed3\u6784\u7684\u7528\u6237\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="contactsId", value="\u901a\u8baf\u5f55\u5206\u7ec4id", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="userName", value="\u7528\u6237\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNum", value="\u6bcf\u9875\u6570", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="isFromMail", value="\u662f\u5426\u90ae\u4ef6\u8c03\u7528", required=false, paramType="query", dataType="string")})
    public Resource getUserListAsContactsTree(@RequestParam(required=false) String contactsId, @RequestParam(required=false) String userName, @RequestParam(required=false, defaultValue="1") String pageNum, @RequestParam(required=false, defaultValue="10") String pageSize, @RequestParam(required=false) boolean isFromMail) throws Exception {
        if (pageSize == null || "".equals(pageSize) || "null".equals(pageSize)) {
            pageSize = "10";
        }
        if (pageNum == null || "".equals(pageNum) || "null".equals(pageNum)) {
            pageNum = "1";
        }
        int newPageSize = Integer.parseInt(pageSize);
        int newPageNum = Integer.parseInt(pageNum);
        PageSearchDto searchDto = new PageSearchDto();
        searchDto.setDomainId(this.getUser().getDomainid());
        searchDto.setContanctsId(contactsId);
        searchDto.setUserName(userName);
        searchDto.setFromMail(isFromMail);
        searchDto.setPageNum(newPageNum);
        searchDto.setPageSize(newPageSize);
        PageResultDto result = this.employeeDbReader.getEmployeeByDomainId(searchDto);
        return this.success("ok", result);
    }

    @PutMapping(value={"/updateOnlineUsers"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u5728\u7ebf\u7528\u6237", notes="\u66f4\u65b0\u5728\u7ebf\u7528\u6237")
    public void updateOnlineUsers() {
        try {
            WebUser user = AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request);
            OnlineUsers.add((String)Sequence.getTimeSequence(), (WebUser)user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @DeleteMapping(value={"/removeOnlineUser"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u79fb\u9664\u5728\u7ebf\u7528\u6237", notes="\u79fb\u9664\u5728\u7ebf\u7528\u6237")
    public void removeOnlineUser(HttpServletRequest request) {
        try {
            String userId = WebUser.getWebUserId((HttpServletRequest)request);
            if (StringUtils.hasLength((String)userId)) {
                OnlineUsers.removeByUserId((String)userId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @GetMapping(value={"/users/selectbox/onlines"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u96c6\u5408", notes="\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", value="\u6bcf\u9875\u6570", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10")})
    public Resource getOnlineUserList(@RequestParam(required=false, defaultValue="1") String pageNum, @RequestParam(required=false, defaultValue="10") String pageSize) throws Exception {
        Map result = this.userService.getOnlineUserList(pageNum, pageSize, this.getUser());
        return this.success("ok", result);
    }

    @GetMapping(value={"/users/selectbox/dimissions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u79bb\u804c\u7528\u6237\u96c6\u5408", notes="\u83b7\u53d6\u79bb\u804c\u7528\u6237\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", value="\u6bcf\u9875\u6570", required=true, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=true, paramType="query", dataType="string", defaultValue="50"), @ApiImplicitParam(name="domainId", value="\u4f01\u4e1a\u57dfid", required=true, paramType="query", dataType="string")})
    public Resource getDismissionUserList(@RequestParam(required=true) String domainId, @RequestParam(required=true) int pageNum, @RequestParam(required=true) int pageSize) {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            DataPackage dataPackage = userProcess.doQueryByDoaminaAndStatusAndPermissionType(domainId, "public", 0, pageNum, pageSize);
            Collection datas = dataPackage.getDatas();
            ArrayList<UserNode> userNodes = new ArrayList<UserNode>();
            for (UserVO userVO : datas) {
                UserNode u = new UserNode();
                u.setId(userVO.getId());
                u.setName(userVO.getName());
                userNodes.add(u);
            }
            return this.success("ok", userNodes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @GetMapping(value={"/users/selectbox/search"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u7528\u6237", notes="\u6a21\u7cca\u67e5\u8be2\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyWord", value="\u5173\u952e\u5b57", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNum", value="\u6bcf\u9875\u6570", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u636e\u6570", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="isFromMail", value="\u662f\u5426\u90ae\u4ef6\u8c03\u7528", required=false, paramType="query", dataType="string")})
    public Resource getUsersBySearch(@RequestParam(required=false) String keyWord, @RequestParam(required=false, defaultValue="10") String pageSize, @RequestParam(required=false, defaultValue="1") String pageNum, @RequestParam(required=false) boolean isFromMail) throws Exception {
        int pageNo = StringUtil.isBlank((String)pageNum) ? 1 : Integer.valueOf(pageNum);
        int pageCount = StringUtil.isBlank((String)pageSize) ? 10 : Integer.valueOf(pageSize);
        PageSearchDto searchDto = new PageSearchDto();
        searchDto.setDomainId(this.getUser().getDomainid());
        searchDto.setPageNum(pageNo);
        searchDto.setPageSize(pageCount);
        searchDto.setFromMail(isFromMail);
        searchDto.setKeyWord(keyWord);
        PageResultDto result = this.employeeDbReader.getEmployeeByDomainId(searchDto);
        return this.success("ok", result);
    }

    @GetMapping(value={"/users/selectbox/dept-tree"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u6811", notes="\u83b7\u53d6\u90e8\u95e8\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentId", value="\u7236\u7ea7id", required=false, paramType="query", dataType="string")})
    public List<Node> getDepartTree(@RequestParam(required=false) String parentId) throws Exception {
        List result = this.userService.getDepartTree(parentId, this.getUser().getDomainid());
        return result;
    }

    @GetMapping(value={"/users/selectbox/contacts/group"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u901a\u8baf\u5f55\u5206\u7ec4", notes="\u83b7\u53d6\u901a\u8baf\u5f55\u5206\u7ec4")
    public Resource getContactsGroup() throws Exception {
        DataPackage result = this.userService.getContactsGroup((IUser)this.getUser());
        return this.success("ok", result);
    }

    @PostMapping(value={"/users/contacts/groups"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u65b0\u5efa\u901a\u8baf\u5f55\u5206\u7ec4", notes="\u65b0\u5efa\u901a\u8baf\u5f55\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u5206\u7ec4\u540d\u79f0", required=true, paramType="query", dataType="string")})
    public Resource newContactsGroup(@RequestParam String name) throws Exception {
        WebUser user = this.getUser();
        UserGroupProcess process = (UserGroupProcess)ProcessFactory.createProcess(UserGroupProcess.class);
        if (!process.isExistGroup(name, user.getId())) {
            UserGroupVO userGroupVO = new UserGroupVO();
            userGroupVO.setName(name);
            userGroupVO.setOwnerId(user.getId());
            userGroupVO.setDomainid(user.getDomainid());
            process.doCreate((AuthtimeValueObject)userGroupVO);
            return this.success("ok", userGroupVO);
        }
        return this.error(4001, "\u8be5\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728", null);
    }

    @PostMapping(value={"/users/contacts/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4fdd\u5b58\u901a\u8baf\u5f55\u5206\u7ec4", notes="\u4fdd\u5b58\u901a\u8baf\u5f55\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="name", value="\u5206\u7ec4\u540d\u79f0", required=true, paramType="query", dataType="string")})
    public Resource saveContactsGroup(@PathVariable String groupId, @RequestParam String name) throws Exception {
        WebUser user = this.getUser();
        UserGroupProcess process = (UserGroupProcess)ProcessFactory.createProcess(UserGroupProcess.class);
        UserGroupVO userGroupVO = (UserGroupVO)process.doView(groupId);
        if (process.isExistGroup(name, user.getId()) && !name.equals(userGroupVO.getName())) {
            return this.error(4001, "\u8be5\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728", null);
        }
        userGroupVO.setName(name);
        userGroupVO.setOwnerId(user.getId());
        userGroupVO.setDomainid(user.getDomainid());
        process.doUpdate((AuthtimeValueObject)userGroupVO);
        return this.success("ok", userGroupVO);
    }

    @DeleteMapping(value={"/users/contacts/groups/{groupId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u901a\u8baf\u5f55\u5206\u7ec4", notes="\u5220\u9664\u901a\u8baf\u5f55\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id", required=true, paramType="path", dataType="string")})
    public Resource removeContactsGroup(@PathVariable String groupId) throws Exception {
        UserGroupProcess process = (UserGroupProcess)ProcessFactory.createProcess(UserGroupProcess.class);
        process.doRemove(groupId);
        return this.success("ok", "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/users/contacts/groups/{groupId}/users"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237\u81f3\u901a\u8baf\u5f55\u5206\u7ec4", notes="\u6dfb\u52a0\u7528\u6237\u81f3\u901a\u8baf\u5f55\u5206\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="userIds", value="\u7528\u6237id\u96c6\u5408", required=true, paramType="body", dataType="string")})
    public Resource addUserToContactsGroup(@PathVariable String groupId, @RequestBody String userIds) throws Exception {
        List ids = (List)JsonPath.parse((String)userIds).json();
        String[] idArray = new String[]{};
        idArray = ids.toArray(idArray);
        UserGroupSetProcess userGroupSetProcess = (UserGroupSetProcess)ProcessFactory.createProcess(UserGroupSetProcess.class);
        userGroupSetProcess.addUserToGroup(idArray, groupId);
        return this.success("ok", "\u6dfb\u52a0\u6210\u529f");
    }

    @DeleteMapping(value={"/users/contacts/groups/{groupId}/users"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u79fb\u9664\u901a\u8baf\u5f55\u5206\u7ec4\u7528\u6237", notes="\u79fb\u9664\u901a\u8baf\u5f55\u5206\u7ec4\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u5206\u7ec4id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="userIds", value="\u7528\u6237id\u96c6\u5408", required=true, paramType="body", dataType="string")})
    public Resource removeUserFromContactsGroup(@PathVariable String groupId, @RequestBody String userIds) throws Exception {
        List ids = (List)JsonPath.parse((String)userIds).json();
        String[] idArray = new String[]{};
        idArray = ids.toArray(idArray);
        UserGroupSetProcess userGroupSetProcess = (UserGroupSetProcess)ProcessFactory.createProcess(UserGroupSetProcess.class);
        userGroupSetProcess.deleteByUser(idArray, groupId);
        return this.success("ok", "\u79fb\u9664\u6210\u529f");
    }
}

