/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.user.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.MyProfileHelper;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.util.json.JsonTmpUtil;
import cn.myapps.util.sequence.Sequence;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.saas.core.utils.encrypt.PasswordUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u7528\u6237\u9009\u62e9\u6846\u6267\u884c\u6a21\u5757"})
@Component
@RequestMapping(path={"/api/runtime/users"}, produces={"application/json;charset=UTF-8"})
public class UserController
extends AbstractRuntimeController {
    private final DistributedCacheProvider distributedCacheProvider;

    public UserController(DistributedCacheProvider distributedCacheProvider) {
        this.distributedCacheProvider = distributedCacheProvider;
    }

    @GetMapping(value={"/myprofile"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f", notes="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f")
    public Resource getLoginUser() throws Exception {
        WebUser webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request);
        if (webUser == null) {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(webUser.getId());
            webUser = new WebUser((IUser)user);
            WebUser.setWebUser((WebUser)webUser, (HttpServletRequest)this.request);
        }
        UserNode u = MyProfileHelper.buildProfile((WebUser)webUser);
        return this.success("ok", u);
    }

    @GetMapping(value={"/profile"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7528\u6237id", required=true, paramType="query", dataType="string")})
    public Resource getSelectUser(@RequestParam(required=false) String id) throws Exception {
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO serVO = (UserVO)userProcess.doView(id);
        WebUser webUser = new WebUser((IUser)serVO);
        UserNode u = MyProfileHelper.buildProfile((WebUser)webUser);
        return this.success("ok", u);
    }

    @GetMapping(value={"/{id}/avatar"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5934\u50cf", notes="\u83b7\u53d6\u7528\u6237\u5934\u50cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7528\u6237id", required=true, paramType="path", dataType="string")})
    public Resource getSelectUserAvatar(@PathVariable String id) throws Exception {
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO serVO = (UserVO)userProcess.doView(id);
        if (serVO != null) {
            return this.success("ok", serVO.getAvatarUri());
        }
        return this.error(500, "\u7528\u6237\u4e0d\u5b58\u5728\uff01", null);
    }

    @PostMapping(value={"/skin"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u65b0\u76ae\u80a4", notes="\u66f4\u65b0\u76ae\u80a4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonStr", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource setUserSkin(@RequestBody String jsonStr) throws Exception {
        WebUser user = this.getUser();
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonStr);
        String skin = jsonObject.getString("skin");
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO userVO = (UserVO)userProcess.doView(user.getId());
        userVO.setUserSkin(skin);
        userProcess.doPersonalUpdate((AuthtimeValueObject)userVO);
        return this.success("ok", null);
    }

    @PutMapping(value={"/unlock"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u524d\u53f0\u89e3\u9501", notes="\u524d\u53f0\u89e3\u9501")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pwd", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource validatePassword(@RequestBody String pwd) throws Exception {
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO userVO = (UserVO)userProcess.doView(this.getUser().getId());
        if (PasswordUtils.isMatched((String)userVO.getLoginpwd(), (String)pwd)) {
            return this.success("ok", true);
        }
        return this.success("ok", false);
    }

    @GetMapping(value={"/signs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7b7e\u7ae0\u5217\u8868", notes="\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7b7e\u7ae0\u5217\u8868")
    public Resource getLoginUserSigns() throws Exception {
        String signs;
        WebUser webUser = this.getUser();
        JSONArray r = null;
        if (webUser != null && !StringUtil.isBlank((String)(signs = webUser.getSigns()))) {
            r = JsonTmpUtil.fromObject((Object)signs);
        }
        return this.success("ok", r);
    }

    @GetMapping(value={"/signs/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7b7e\u7ae0", notes="\u6839\u636eid\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7b7e\u7ae0")
    public Resource getLoginUserSign(@PathVariable String id, @RequestParam String password) throws Exception {
        JSONArray signs;
        WebUser user = this.getUser();
        JSONArray jSONArray = signs = StringUtil.isBlank((String)user.getSigns()) ? new JSONArray() : JsonTmpUtil.fromObject((Object)user.getSigns());
        if (signs.isEmpty()) {
            return this.error(40001, "\u60a8\u8fd8\u6ca1\u6709\u8bbe\u7f6e\u5370\u7ae0\uff0c\u8bf7\u4f7f\u7528\u201c\u5370\u7ae0\u7ba1\u7406\u201d\u529f\u80fd\u4e0a\u4f20\u5e76\u8bbe\u7f6e\u5370\u7ae0\uff01", null);
        }
        JSONObject data = null;
        for (int i = 0; i < signs.size(); ++i) {
            JSONObject sign = signs.getJSONObject(i);
            if (!sign.getString("id").equals(id)) continue;
            if (password.equals(Security.decryptPassword((String)sign.getString("password")))) {
                data = sign;
                break;
            }
            return this.error(40001, "\u64cd\u4f5c\u5931\u8d25\uff0c\u5370\u7ae0\u5bc6\u7801\u9519\u8bef\uff01", null);
        }
        if (data == null) {
            return this.error(40001, "\u64cd\u4f5c\u5931\u8d25\uff0c\u5370\u7ae0\u4e0d\u5b58\u5728\uff01", null);
        }
        return this.success("ok", data);
    }

    @PostMapping(value={"/signs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u65b0\u5efa\u7b7e\u7ae0", notes="\u65b0\u5efa\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonStr", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource saveLoginUserSign(@RequestBody String jsonStr) throws Exception {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonStr);
        WebUser webUser = this.getUser();
        String signs = webUser.getSigns();
        JSONArray result = new JSONArray();
        if (!StringUtil.isBlank((String)signs)) {
            result = JsonTmpUtil.fromObject((Object)signs);
        }
        String password = (String)jsonObject.get("password");
        password = Security.encryptPassword((String)password);
        jsonObject.put((Object)"password", (Object)password);
        result.add((Object)jsonObject);
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO user = (UserVO)userProcess.doView(webUser.getId());
        user.setSigns(result.toString());
        userProcess.doUpdate((AuthtimeValueObject)user);
        return this.success("ok", "\u65b0\u5efa\u6210\u529f");
    }

    @DeleteMapping(value={"/signs/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u767b\u5f55\u7528\u6237\u7b7e\u7ae0", notes="\u5220\u9664\u767b\u5f55\u7528\u6237\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7b7e\u7ae0id", required=true, paramType="path", dataType="string")})
    public Resource deleteLoginUserSign(@PathVariable String id) throws Exception {
        WebUser webUser = this.getUser();
        String signs = webUser.getSigns();
        JSONArray jsonArray = new JSONArray();
        JSONArray result = new JSONArray();
        if (!StringUtil.isBlank((String)signs)) {
            jsonArray = JsonTmpUtil.fromObject((Object)signs);
        }
        result.addAll((Collection)jsonArray);
        for (Object object : jsonArray) {
            JSONObject jsonObj = (JSONObject)object;
            if (!id.equals(jsonObj.get("id"))) continue;
            result.remove((Object)jsonObj);
        }
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO user = (UserVO)userProcess.doView(webUser.getId());
        user.setSigns(result.toString());
        userProcess.doUpdate((AuthtimeValueObject)user);
        return this.success("ok", "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/signs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u767b\u5f55\u7528\u6237\u7b7e\u7ae0", notes="\u6279\u91cf\u5220\u9664\u767b\u5f55\u7528\u6237\u7b7e\u7ae0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="jsonStr", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Resource deleteLoginUserSigns(@RequestBody String jsonStr) throws Exception {
        JSONArray newSignsArr = JsonTmpUtil.fromObject((Object)jsonStr);
        WebUser webUser = this.getUser();
        String signs = webUser.getSigns();
        JSONArray oldSignsArr = new JSONArray();
        if (!StringUtil.isBlank((String)signs)) {
            oldSignsArr = JsonTmpUtil.fromObject((Object)signs);
        }
        JSONArray result = new JSONArray();
        result.addAll((Collection)oldSignsArr);
        for (Object object : newSignsArr) {
            String id = (String)object;
            for (Object oldObject : oldSignsArr) {
                JSONObject jsonObj = (JSONObject)oldObject;
                if (!id.equals(jsonObj.get("id"))) continue;
                result.remove(oldObject);
            }
        }
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO user = (UserVO)userProcess.doView(webUser.getId());
        user.setSigns(result.toString());
        userProcess.doUpdate((AuthtimeValueObject)user);
        return this.success("ok", "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{userId}/commonOpinions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5e38\u7528\u610f\u89c1\u914d\u7f6e", notes="\u83b7\u53d6\u5e38\u7528\u610f\u89c1\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="path", dataType="string")})
    public Resource getCommonOpinions(@PathVariable String userId) throws Exception {
        JSONArray opinionJson = new JSONArray();
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        UserVO userSetup = (UserVO)process.doView(userId);
        String commonOpinion = null;
        if (userSetup == null) {
            throw new SaasNofoundException(String.format("\u6307\u5b9a\u7684\u7528\u6237(%s)\u65e0\u6548", userId));
        }
        if (StringUtil.isBlank((String)userSetup.getCommonOpinion()) || userSetup.getCommonOpinion().equals("[]")) {
            JSONObject opinion = new JSONObject();
            opinion.put((Object)"id", (Object)Sequence.getUUID());
            opinion.put((Object)"content", (Object)"\u540c\u610f");
            opinionJson.add((Object)opinion);
            opinion.put((Object)"id", (Object)Sequence.getUUID());
            opinion.put((Object)"content", (Object)"\u6279\u51c6");
            opinionJson.add((Object)opinion);
            opinion.put((Object)"id", (Object)Sequence.getUUID());
            opinion.put((Object)"content", (Object)"OK");
            opinionJson.add((Object)opinion);
            userSetup.setCommonOpinion(opinionJson.toString());
            process.doUpdate((AuthtimeValueObject)userSetup);
        }
        commonOpinion = userSetup.getCommonOpinion();
        opinionJson = JsonTmpUtil.fromObject((Object)commonOpinion);
        return this.success("ok", opinionJson);
    }

    @PostMapping(value={"/{userId}/commonOpinions"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6dfb\u52a0\u5e38\u7528\u610f\u89c1", notes="\u6dfb\u52a0\u5e38\u7528\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="opinion", value="\u610f\u89c1", required=false, paramType="query", dataType="string")})
    public Resource addCommonOpinion(@PathVariable String userId, @RequestParam(required=false) String opinion) throws Exception {
        UserVO userSetup = null;
        JSONArray opinionArray = new JSONArray();
        JSONObject opinionJson = new JSONObject();
        opinionJson.put((Object)"id", (Object)Sequence.getUUID());
        opinionJson.put((Object)"content", (Object)opinion);
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        userSetup = (UserVO)process.doView(userId);
        if (!StringUtil.isBlank((String)opinion)) {
            if (userSetup != null) {
                String commonOpinion = userSetup.getCommonOpinion();
                if (!StringUtil.isBlank((String)commonOpinion)) {
                    opinionArray = JsonTmpUtil.fromObject((Object)commonOpinion);
                }
                opinionArray.add((Object)opinionJson);
                userSetup.setCommonOpinion(opinionArray.toString());
                process.doUpdate((AuthtimeValueObject)userSetup);
            } else {
                opinionArray.add((Object)opinionJson);
                userSetup = new UserVO();
                userSetup.setCommonOpinion(opinionArray.toString());
                userSetup.setId(userId);
                process.doCreate((AuthtimeValueObject)userSetup);
            }
        }
        return this.success("ok", opinionJson);
    }

    @DeleteMapping(value={"/{userId}/commonOpinions/{opId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u5e38\u7528\u610f\u89c1", notes="\u5220\u9664\u5e38\u7528\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="opId", value="\u610f\u89c1", required=false, paramType="path", dataType="string")})
    public Resource deleteCommonOpinion(@PathVariable String userId, @PathVariable String opId) throws Exception {
        UserVO userSetup = null;
        JSONArray opinionArray = null;
        JSONObject opinionJson = null;
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        userSetup = (UserVO)process.doView(userId);
        if (userSetup != null && !StringUtil.isBlank((String)opId)) {
            opinionArray = JsonTmpUtil.fromObject((Object)userSetup.getCommonOpinion());
            for (int i = 0; i < opinionArray.size(); ++i) {
                opinionJson = opinionArray.getJSONObject(i);
                if (!opId.equals(opinionJson.getString("id"))) continue;
                opinionArray.remove(i);
                break;
            }
            userSetup.setCommonOpinion(opinionArray.toString());
            process.doUpdate((AuthtimeValueObject)userSetup);
        }
        return this.success("ok", opinionJson);
    }

    @PutMapping(value={"/{userId}/commonOpinions/{opId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u4fee\u6539\u5e38\u7528\u610f\u89c1", notes="\u4fee\u6539\u5e38\u7528\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="opId", value="\u610f\u89c1id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="opinion", value="\u610f\u89c1", required=false, paramType="path", dataType="string")})
    public Resource updateCommonOpinion(@PathVariable String userId, @PathVariable String opId, @RequestParam(required=false) String opinion) throws Exception {
        UserVO userSetup = null;
        JSONArray opinionArray = null;
        JSONObject opinionJson = null;
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        userSetup = (UserVO)process.doView(userId);
        if (userSetup != null && !StringUtil.isBlank((String)opId)) {
            try {
                opinionArray = JsonTmpUtil.fromObject((Object)userSetup.getCommonOpinion());
                for (int i = 0; i < opinionArray.size(); ++i) {
                    opinionJson = opinionArray.getJSONObject(i);
                    if (!opId.equals(opinionJson.getString("id"))) continue;
                    opinionArray.remove(i);
                    opinionJson.clear();
                    opinionJson.put((Object)"id", (Object)opId);
                    opinionJson.put((Object)"content", (Object)opinion);
                    opinionArray.add((Object)opinionJson);
                    break;
                }
                userSetup.setCommonOpinion(opinionArray.toString());
                process.doUpdate((AuthtimeValueObject)userSetup);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.success("ok", opinionJson);
    }

    @GetMapping(value={"/department/{departmentid}/users"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u90e8\u95e8\u62ff\u7528\u6237", notes="\u6839\u636e\u90e8\u95e8\u62ff\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="departmentid", value="\u90e8\u95e8ids", required=true, paramType="path", dataType="string")})
    public Collection<UserVO> getDepartmentUsers(@PathVariable String departmentid) throws Exception {
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        return process.queryByDepartment(departmentid);
    }

    @GetMapping(value={"/domain/{domainid}/users"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6839\u636e\u4f01\u4e1a\u57df\u62ff\u7528\u6237", notes="\u6839\u636e\u4f01\u4e1a\u57df\u62ff\u7528\u6237")
    @ApiImplicitParams(value={@ApiImplicitParam(name="domainid", value="\u4f01\u4e1a\u57dfid", required=true, paramType="path", dataType="string")})
    public Collection<UserVO> getDomaintUsers(@PathVariable String domainid) throws Exception {
        UserProcess process = AuthTimeServiceManager.userRuntimeService();
        return process.queryByDomain(domainid);
    }
}

