/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.system.monitor.util;

import cn.myapps.runtime.system.monitor.model.SystemMonitor;
import cn.myapps.runtime.system.monitor.util.SystemMonitorUtil;
import cn.myapps.scheduler.Job;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.util.Date;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SystemMonitorWriteTxtJob
extends Job {
    public static int executeTime = 30000;
    ThreadMXBean threadMXBean = ManagementFactory.getPlatformMXBean(ThreadMXBean.class);
    OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    MemoryMXBean memBean = ManagementFactory.getPlatformMXBean(MemoryMXBean.class);

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            String contextPath = System.getProperty("java.io.tmpdir");
            int mb = 0x100000;
            SystemMonitor monitor1 = new SystemMonitor();
            double processCpuLoad = this.osBean.getProcessCpuLoad();
            processCpuLoad *= 100.0;
            if (processCpuLoad < 0.0) {
                processCpuLoad = 0.0;
            }
            int threadNum = this.threadMXBean.getThreadCount();
            MemoryUsage heap = this.memBean.getHeapMemoryUsage();
            MemoryUsage nonHeap = this.memBean.getNonHeapMemoryUsage();
            long heapSizeUsed = heap.getUsed() / (long)mb;
            long nonHeapSizeUsed = nonHeap.getUsed() / (long)mb;
            DecimalFormat df = new DecimalFormat("0.00");
            long freePhysicalMemorySize = this.osBean.getFreePhysicalMemorySize();
            long totalPhysicalMemorySize = this.osBean.getTotalPhysicalMemorySize();
            String physicalMemorySizeUse = df.format((float)(totalPhysicalMemorySize - freePhysicalMemorySize) / (float)mb);
            Date date = new Date();
            monitor1.setCpuLoad(processCpuLoad);
            monitor1.setThreadNum(threadNum);
            monitor1.setHeapSizeUsed(heapSizeUsed);
            monitor1.setNonHeapSizeUsed(nonHeapSizeUsed);
            monitor1.setTime(date.getTime());
            monitor1.setTotalMemorySize(Double.valueOf(physicalMemorySizeUse));
            SystemMonitorUtil.writeFile(monitor1, contextPath + File.separator + "systemMonitor.txt");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

