/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.system.monitor.controller;

import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.system.monitor.util.SystemMonitorUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="prototype")
@RequestMapping(value={"/api"})
public class SystemMonitorController {
    @Autowired
    public HttpServletRequest request;
    ThreadMXBean threadMXBean = ManagementFactory.getPlatformMXBean(ThreadMXBean.class);
    OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    MemoryMXBean memBean = ManagementFactory.getPlatformMXBean(MemoryMXBean.class);

    @ResponseBody
    @GetMapping(value={"/system/monitor/time"}, produces={"application/json;charset=UTF-8"})
    public Object getProcessCpuLoad() throws Exception {
        int mb = 0x100000;
        int threadNum = this.threadMXBean.getThreadCount();
        HashMap<String, Number> hashMap = new HashMap<String, Number>();
        DecimalFormat df = new DecimalFormat("0.00");
        double processCpuLoad = this.osBean.getProcessCpuLoad();
        if ((processCpuLoad *= 100.0) < 0.0) {
            processCpuLoad = 0.0;
        }
        long freePhysicalMemorySize = this.osBean.getFreePhysicalMemorySize();
        long totalPhysicalMemorySize = this.osBean.getTotalPhysicalMemorySize();
        String physicalMemorySizeUse = df.format((float)(totalPhysicalMemorySize - freePhysicalMemorySize) / (float)mb);
        hashMap.put("cpuLoad", processCpuLoad);
        hashMap.put("memorySizeUse", Double.valueOf(physicalMemorySizeUse));
        hashMap.put("totalMemorySize", totalPhysicalMemorySize / (long)mb);
        hashMap.put("threadNum", threadNum);
        MemoryUsage heap = this.memBean.getHeapMemoryUsage();
        MemoryUsage nonHeap = this.memBean.getNonHeapMemoryUsage();
        long heapSizeUsed = heap.getUsed() / (long)mb;
        long nonHeapSizeUsed = nonHeap.getUsed() / (long)mb;
        hashMap.put("heapSizeUsed", heapSizeUsed);
        hashMap.put("nonHeapSizeUsed", nonHeapSizeUsed);
        return hashMap;
    }

    @ResponseBody
    @GetMapping(value={"/systemMonitor"}, produces={"application/json;charset=UTF-8"})
    public Object getSystemMonitor() throws Exception {
        String contextPath = System.getProperty("java.io.tmpdir");
        String filePath = contextPath + File.separator + "systemMonitor.txt";
        List<String> lists = SystemMonitorUtil.readFile(filePath);
        StringBuffer stbr = new StringBuffer();
        int beginIndex = 0;
        int endIndex = lists.size() - 1;
        String minuteTime = this.request.getParameter("time");
        if (!StringUtil.isBlank((String)minuteTime)) {
            ArrayList<String> litstTemp = new ArrayList<String>();
            int count = Integer.valueOf(minuteTime) * 2;
            if (lists.size() > count) {
                beginIndex = lists.size() - 1 - count;
            }
            System.out.println(minuteTime);
            litstTemp.addAll(lists.subList(beginIndex, endIndex));
            stbr.append("[");
            for (String string : litstTemp) {
                stbr.append(string).append(",");
            }
            stbr.setLength(stbr.length() - 1);
            stbr.append("]");
            return stbr.toString();
        }
        if (lists.size() > 100) {
            beginIndex = endIndex - 100 - 1;
            ArrayList<String> litstTemp = new ArrayList<String>();
            litstTemp.addAll(lists.subList(beginIndex, endIndex));
            stbr.append("[");
            for (String string : litstTemp) {
                stbr.append(string).append(",");
            }
            stbr.setLength(stbr.length() - 1);
            stbr.append("]");
            return stbr.toString();
        }
        stbr.append("[");
        for (String string : lists) {
            stbr.append(string).append(",");
        }
        stbr.setLength(stbr.length() - 1);
        stbr.append("]");
        return stbr.toString();
    }
}

