/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.security;

import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest = null;

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.orgRequest = request;
    }

    public String getParameter(String name) {
        String value = super.getParameter(this.xssEncode(name));
        if (value != null) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public Enumeration<String> getParameterNames() {
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        String[] arrayOfString1 = super.getParameterValues(name);
        if (arrayOfString1 == null) {
            return null;
        }
        int i = arrayOfString1.length;
        String[] arrayOfString2 = new String[i];
        for (int j = 0; j < i; ++j) {
            arrayOfString2[j] = this.xssEncode(arrayOfString1[j]);
        }
        return arrayOfString2;
    }

    public Map<String, String[]> getParameterMap() {
        Map paramMap = super.getParameterMap();
        HashMap<String, String[]> warpParameterMap = new HashMap<String, String[]>();
        for (Map.Entry entry : paramMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] instanceof String)) continue;
                values[i] = this.xssEncode(values[i]);
            }
            warpParameterMap.put((String)entry.getKey(), values);
        }
        return warpParameterMap;
    }

    public String getHeader(String name) {
        String value = super.getHeader(this.xssEncode(name));
        if (value != null) {
            value = this.xssEncode(value);
        }
        return value;
    }

    public String escape(String s) {
        String[] ignoreEscapeURL = new String[]{};
        String _ignoreEscapeURL = PropertyUtil.get((String)"SecurityFilter.firewall.interceptor.keyword.ignoreEscapeURL");
        if (!StringUtil.isBlank((String)_ignoreEscapeURL)) {
            ignoreEscapeURL = _ignoreEscapeURL.split("\\|");
        }
        String currentUri = this.orgRequest.getRequestURI();
        for (int index = 0; index < ignoreEscapeURL.length; ++index) {
            String ignoreEscapeURLItem = ignoreEscapeURL[index];
            if (StringUtils.isBlank((String)ignoreEscapeURLItem) || !currentUri.trim().toLowerCase().contains(ignoreEscapeURLItem.trim().toLowerCase())) continue;
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block11: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block11;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block11;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block11;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block11;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block11;
                }
                case '%': {
                    sb.append('\uff05');
                    continue block11;
                }
                case '(': {
                    sb.append('\uff08');
                    continue block11;
                }
                case ')': {
                    sb.append('\uff09');
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        String result = this.stripXSS(s);
        if (null != result) {
            result = this.escape(result);
        }
        return result;
    }

    private String stripXSS(String value) {
        if (value != null) {
            value = value.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<iframe>(.*?)</iframe>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</iframe>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<iframe(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
        }
        return value;
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getOrgRequest();
        }
        return req;
    }
}

