/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.security;

import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;

public class Firewall {
    private boolean startFirewall = false;
    private boolean stopCSRF = false;
    private boolean validKeyword = false;
    private boolean strongMode = false;
    private String[] excludeChars = new String[0];
    private Set<Pattern> excludePatterns = new HashSet<Pattern>();
    private String[] excludeHostAddress = null;
    private String[] ignoreURL = new String[0];
    private static Firewall instance = null;
    private Pattern cp = Pattern.compile("\\s*");
    private static Policy policy = null;

    private Firewall(boolean startFirewall, boolean validKeyword, String[] excludeChars, Set<Pattern> excludePatterns, boolean stopCSRF, String[] excludeHostAddress, String[] ignoreURL, boolean strongMode) {
        this.startFirewall = startFirewall;
        this.validKeyword = validKeyword;
        this.excludeChars = excludeChars;
        this.excludePatterns = excludePatterns;
        this.stopCSRF = stopCSRF;
        this.excludeHostAddress = excludeHostAddress;
        this.ignoreURL = ignoreURL;
        this.strongMode = strongMode;
    }

    public static Firewall getInstance() {
        if (instance == null) {
            Firewall.init();
        }
        return instance;
    }

    private static synchronized void init() {
        boolean startFirewall = false;
        boolean validKeyword = false;
        boolean stopCSRF = false;
        boolean strongMode = false;
        String[] excludeChars = new String[]{};
        HashSet<Pattern> excludePatterns = new HashSet<Pattern>();
        String[] excludeHostAddress = null;
        String[] ignoreURL = new String[]{};
        String _startFirewall = PropertyUtil.get((String)"SecurityFilter.firewall.startFirewall");
        String _validKeyword = PropertyUtil.get((String)"SecurityFilter.firewall.interceptor.keyword");
        String _stopCSRF = PropertyUtil.get((String)"SecurityFilter.firewall.interceptor.CSRF");
        String _excludeChars = PropertyUtil.get((String)"SecurityFilter.firewall.interceptor.keyword.excludeChars");
        String _excludePatterns = PropertyUtil.get((String)"SecurityFilter.firewall.interceptor.keyword.excludePatterns");
        String _excludeHostAddress = PropertyUtil.get((String)"SecurityFilter.firewall.interceptor.CSRF.excludeHostAddress");
        String _ignoreURL = PropertyUtil.get((String)"SecurityFilter.firewall.interceptor.keyword.ignoreURL");
        String _strongMode = PropertyUtil.get((String)"SecurityFilter.firewall.strongMode");
        if (!StringUtil.isBlank((String)_startFirewall)) {
            startFirewall = Boolean.parseBoolean(_startFirewall);
        }
        if (!StringUtil.isBlank((String)_strongMode) && (strongMode = Boolean.parseBoolean(_strongMode))) {
            _excludeChars = _excludeChars + "|alert|'| and ";
        }
        if (!StringUtil.isBlank((String)_validKeyword)) {
            validKeyword = Boolean.parseBoolean(_validKeyword);
        }
        if (!StringUtil.isBlank((String)_stopCSRF)) {
            stopCSRF = Boolean.parseBoolean(_stopCSRF);
        }
        if (!StringUtil.isBlank((String)_excludeChars)) {
            excludeChars = _excludeChars.split("\\|");
        }
        if (!StringUtil.isBlank((String)_ignoreURL)) {
            ignoreURL = _ignoreURL.split("\\|");
        }
        if (!StringUtil.isBlank((String)_excludePatterns)) {
            String[] regexs;
            for (String regex : regexs = _excludePatterns.split("\\|")) {
                excludePatterns.add(Pattern.compile(StringEscapeUtils.unescapeJava((String)regex)));
            }
        }
        if (!StringUtil.isBlank((String)_excludeHostAddress)) {
            excludeHostAddress = _excludeHostAddress.split("\\|");
        }
        if (policy == null) {
            try {
                InputStream is = Firewall.class.getClassLoader().getResourceAsStream("antisamy.xml");
                policy = Policy.getInstance((InputStream)is);
            }
            catch (PolicyException e) {
                e.printStackTrace();
            }
        }
        instance = new Firewall(startFirewall, validKeyword, excludeChars, excludePatterns, stopCSRF, excludeHostAddress, ignoreURL, strongMode);
    }

    public boolean excute(HttpServletRequest hreq, HttpServletResponse resp) throws Exception {
        String queryStr;
        if (!this.startFirewall) {
            return true;
        }
        String uri = hreq.getRequestURI().toLowerCase();
        if (uri.contains("viewsource.jsp")) {
            resp.setStatus(403);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write("\u975e\u6cd5\u64cd\u4f5c\uff0cviewsource.jsp\u9519\u8bef\uff01");
            resp.getWriter().flush();
            resp.getWriter().close();
            return false;
        }
        String string = queryStr = hreq.getQueryString() != null ? hreq.getQueryString().toLowerCase() : "";
        if (queryStr.indexOf("password=") == 0 || queryStr.indexOf("&password=") > 0) {
            resp.setStatus(403);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write("\u975e\u6cd5\u64cd\u4f5c\uff0c\u5bc6\u7801\u4e0d\u80fd\u901a\u8fc7get\u8bf7\u6c42\u4f20\u8f93\uff01");
            resp.getWriter().flush();
            resp.getWriter().close();
            return false;
        }
        String password = hreq.getParameter("password");
        if (password != null && password.trim().length() <= 6) {
            resp.setStatus(403);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write("\u975e\u6cd5\u64cd\u4f5c\uff0c\u5bc6\u7801\u5fc5\u987b\u901a\u8fc7\u52a0\u5bc6\u65b9\u5f0f\u4f20\u8f93\uff01");
            resp.getWriter().flush();
            resp.getWriter().close();
            return false;
        }
        String requestMethod = hreq.getMethod().toUpperCase();
        if (!(requestMethod.equals("GET") || requestMethod.equals("POST") || requestMethod.equals("PUT") || requestMethod.equals("DELETE") || requestMethod.equals("PATCH"))) {
            resp.setStatus(403);
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write("\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u5408\u6cd5\u7684\u8bf7\u6c42\u65b9\u5f0f\uff01requestMethod");
            resp.getWriter().flush();
            resp.getWriter().close();
            return false;
        }
        if (this.stopCSRF) {
            String referer = hreq.getHeader("REFERER");
            boolean flag = true;
            if (referer != null) {
                String hostAddress = hreq.getScheme() + "://" + hreq.getServerName() + ":" + hreq.getServerPort();
                if (referer.startsWith(hostAddress.trim())) {
                    flag = false;
                } else if (this.excludeHostAddress != null) {
                    for (String address : this.excludeHostAddress) {
                        if (address != null && !referer.startsWith(address.trim())) continue;
                        flag = false;
                        break;
                    }
                }
            } else if (uri.contains("login.jsp") || uri.contains("/phone/main.jsp") || uri.contains("/pm/wap/index.jsp") || uri.contains("/qm/wap/center.jsp") || uri.contains("/wap/pendlist.jsp") || uri.contains("/attendance/sign.jsp") || uri.contains("/attendance/wap/record.jsp") || uri.contains("/contacts/index.jsp") || uri.contains("/km/wap/index.jsp") || uri.contains("/runtime/app/") || !uri.contains(".jsp") && !uri.contains(".action")) {
                flag = false;
            }
            if (flag) {
                resp.setStatus(403);
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("text/html; charset=UTF-8");
                resp.getWriter().write("\u975e\u6cd5\u64cd\u4f5c\uff0c\u51fa\u4e8e\u5b89\u5168\u8003\u8651\u7cfb\u7edf\u4e0d\u5141\u8bb8\u8de8\u57df\u8bf7\u6c42\uff01(security.properties\u4e2d\u7684\u9632\u706b\u5899\u914d\u7f6e\u6587\u4ef6)");
                resp.getWriter().flush();
                resp.getWriter().close();
                return false;
            }
        }
        if (this.validKeyword) {
            if (this.isIgnoreUri(uri)) {
                return true;
            }
            Map params = hreq.getParameterMap();
            StringBuffer queryString = new StringBuffer();
            for (String key : params.keySet()) {
                String[] values = (String[])params.get(key);
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    queryString.append(key + "=" + value + "&");
                }
            }
            if (queryString.length() > 1) {
                queryString.setLength(queryString.length() - 1);
            }
            if (!this.checkParametersLegal(uri + "?" + queryString.toString())) {
                resp.setStatus(403);
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("text/html; charset=UTF-8");
                resp.getWriter().write("\u4f60\u63d0\u4ea4\u6216\u6253\u5f00\u7684\u94fe\u63a5\u91cc\u53ef\u80fd\u5b58\u5728\u975e\u6cd5\u5b57\u7b26,\u8bf7\u4e0d\u8981\u5728\u53c2\u6570\u4e2d\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u5c1d\u8bd5\u6ce8\u5165\u653b\u51fb\uff01");
                resp.getWriter().flush();
                resp.getWriter().close();
                return false;
            }
        }
        return true;
    }

    public boolean isIgnoreUri(String uri) {
        if (StringUtils.isBlank((String)uri)) {
            return false;
        }
        for (int i = 0; i < this.ignoreURL.length; ++i) {
            if (StringUtil.isBlank((String)this.ignoreURL[i]) || !uri.contains(this.ignoreURL[i].toLowerCase().trim()) && !uri.contains("import")) continue;
            return true;
        }
        return false;
    }

    private boolean checkParametersLegal(String queryString) {
        if (StringUtil.isBlank((String)queryString)) {
            return true;
        }
        queryString = queryString.toLowerCase().trim();
        Matcher m = this.cp.matcher(queryString);
        String _queryString = m.replaceAll("");
        try {
            _queryString = URLDecoder.decode(_queryString, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        AntiSamy as = new AntiSamy();
        try {
            CleanResults cleanResults = as.scan(_queryString, policy);
            List errorMessages = cleanResults.getErrorMessages();
            if (!errorMessages.isEmpty()) {
                return false;
            }
        }
        catch (Exception cleanResults) {
            // empty catch block
        }
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(_queryString).find()) continue;
            return false;
        }
        try {
            queryString = URLDecoder.decode(queryString, "utf-8");
        }
        catch (UnsupportedEncodingException cleanResults) {
            // empty catch block
        }
        for (int i = 0; i < this.excludeChars.length; ++i) {
            String excludeChar = this.excludeChars[i];
            if (StringUtil.isBlank((String)excludeChar) || !queryString.contains(excludeChar)) continue;
            return false;
        }
        return true;
    }

    private String getServerHost(HttpServletRequest request) {
        StringBuilder host = new StringBuilder();
        host.append(request.getScheme()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80) {
            host.append(":").append(request.getServerPort());
        }
        return host.toString();
    }

    public boolean isStartFirewall() {
        return this.startFirewall;
    }

    public boolean isStopCSRF() {
        return this.stopCSRF;
    }

    public boolean isStrongMode() {
        return this.strongMode;
    }
}

