/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.workflow.service;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.dao.workflow.definition.FileSystemBillDefiDAO;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.rest.workflow.service.WorkflowQueryService;
import cn.myapps.runtime.workflow.element.AutoNode;
import cn.myapps.runtime.workflow.element.CompleteNode;
import cn.myapps.runtime.workflow.element.EndNode;
import cn.myapps.runtime.workflow.element.FlowDiagram;
import cn.myapps.runtime.workflow.element.ManualNode;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.runtime.workflow.element.StartNode;
import cn.myapps.runtime.workflow.element.SubFlow;
import cn.myapps.runtime.workflow.element.SuspendNode;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.engine.StateMachineUtil;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.TaskInfoProcess;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class WorkflowQueryServiceImpl
implements WorkflowQueryService {
    @Override
    public JSONObject queryWorkflow(String applicationId, String instanceId) throws Exception {
        String stateLabelInfo;
        FlowRuntimeServiceImpl flowStateRTProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT flowInstance = flowStateRTProcess.findFlowStateRT(instanceId);
        if (flowInstance == null) {
            return new JSONObject();
        }
        IDocument doc = flowInstance.getDocument();
        JSONArray result = new JSONArray();
        if (!StringUtil.isBlank((String)doc.getStateid()) && !StringUtil.isBlank((String)doc.getStateLabel()) && (result = JSON.parseArray((String)(stateLabelInfo = doc.getStateLabelInfo()))).size() > 0) {
            JSONObject node;
            JSONObject stateLabelInfoJSON = result.getJSONObject(0);
            JSONArray nodes = stateLabelInfoJSON.getJSONArray("nodes");
            if (nodes.size() > 0 && !(node = nodes.getJSONObject(0)).containsKey((Object)"auditors")) {
                return new JSONObject();
            }
            return stateLabelInfoJSON;
        }
        return new JSONObject();
    }

    @Override
    public JSONObject submissionPanels(String applicationId, IDocument doc, WebUser user, String flowId, String instanceId, ParamsTable params) throws Exception {
        BillDefiDesignTimeService billDefiService;
        BillDefiVO flowVO;
        Node firstNode;
        FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(applicationId);
        if (StringUtil.isBlank((String)instanceId) && !StringUtil.isBlank((String)flowId) && (firstNode = StateMachine.getFirstNode((IDocument)doc, (BillDefiVO)(flowVO = (billDefiService = DesignTimeServiceManager.billDefiDesignTimeService()).doView(flowId)), (IUser)user, (ParamsTable)params)) != null) {
            FlowStateRT state = stateProcess.createTransientFlowStateRT(doc, flowId, (IUser)user);
            ArrayList<NodeRT> noderts = new ArrayList<NodeRT>();
            NodeRT nodert = new NodeRT(state, firstNode, "1");
            noderts.add(nodert);
            state.setNoderts(noderts);
            doc.setState(state);
            doc.setInitiator(user.getId());
        }
        if (doc != null) {
            FlowStateRT instance = stateProcess.getCurrFlowStateRT(doc, (IUser)user, instanceId);
            flowVO = instance.getFlowVO();
            NodeRT nodert = null;
            String currNodeId = null;
            FlowDiagram fd = null;
            if (flowVO != null) {
                fd = flowVO.toFlowDiagram();
                if (instance.isTemp()) {
                    nodert = (NodeRT)((List)instance.getNoderts()).get(0);
                    currNodeId = nodert.getNodeid();
                }
                if (currNodeId == null && nodert == null) {
                    doc.setState(instance);
                    nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, (String)currNodeId);
                    if (nodert != null) {
                        currNodeId = nodert.getNodeid();
                    }
                }
            }
            Node currnode = null;
            if (currNodeId != null) {
                currnode = (Node)fd.getElementByID(currNodeId);
            }
            boolean issplit = false;
            int nextNodeCheckedStatus = 0;
            boolean isAppentCirculator = false;
            if (currnode instanceof ManualNode) {
                issplit = ((ManualNode)currnode).issplit;
                nextNodeCheckedStatus = ((ManualNode)currnode).nextNodeCheckedStatus;
            } else if (currnode instanceof AutoNode) {
                issplit = ((AutoNode)currnode).issplit;
            }
            JSONObject json = new JSONObject();
            json.put("currentNodeId", (Object)currNodeId);
            json.put("isSplit", (Object)issplit);
            json.put("splitToken", (Object)currNodeId);
            json.put("flowId", (Object)flowVO.getId());
            if (currnode instanceof ManualNode && ((ManualNode)currnode).isCarbonCopy && ((ManualNode)currnode).isSelectCirculator && !isAppentCirculator) {
                json.put("isAppentCirculator", (Object)true);
            }
            if (currnode instanceof ManualNode && ((ManualNode)currnode).isToPerson) {
                json.put("isToPerson", (Object)true);
            }
            Collection nextNodeList = fd.getNextNodeList(currnode.id, doc, params, (IUser)user);
            JSONArray nextNodeListjson = new JSONArray();
            for (Node node : nextNodeList) {
                JSONObject nodejson = new JSONObject();
                nodejson.put("id", (Object)node.id);
                nodejson.put("name", (Object)node.name);
                if (node instanceof AutoNode) {
                    nodejson.put("type", (Object)"AutoNode");
                } else if (node instanceof ManualNode) {
                    nodejson.put("type", (Object)"ManualNode");
                } else if (node instanceof CompleteNode) {
                    nodejson.put("type", (Object)"CompleteNode");
                } else if (node instanceof EndNode) {
                    nodejson.put("type", (Object)"EndNode");
                } else if (node instanceof StartNode) {
                    nodejson.put("type", (Object)"StartNode");
                } else if (node instanceof SubFlow) {
                    nodejson.put("type", (Object)"SubFlow");
                } else if (node instanceof SuspendNode) {
                    nodejson.put("type", (Object)"SuspendNode");
                }
                switch (nextNodeCheckedStatus) {
                    case 0: {
                        nodejson.put("checked", (Object)true);
                        nodejson.put("locked", (Object)false);
                        break;
                    }
                    case 1: {
                        nodejson.put("checked", (Object)false);
                        nodejson.put("locked", (Object)false);
                        break;
                    }
                    case 2: {
                        nodejson.put("checked", (Object)true);
                        nodejson.put("locked", (Object)true);
                        break;
                    }
                }
                nextNodeListjson.add((Object)nodejson);
            }
            json.put("nextNodes", (Object)nextNodeListjson);
            return json;
        }
        return null;
    }

    @Override
    public JSONObject backPanels(String applicationId, String instanceid, WebUser user) throws Exception {
        FlowRuntimeServiceImpl flowStateRTProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = flowStateRTProcess.findFlowStateRT(instanceid);
        if (instance != null) {
            IDocument doc = instance.getDocument();
            doc.setApplicationid(applicationId);
            BillDefiVO flowVO = instance.getFlowVO();
            NodeRT nodert = null;
            String currNodeId = null;
            FlowDiagram fd = null;
            if (flowVO != null) {
                fd = flowVO.toFlowDiagram();
                if (currNodeId == null && nodert == null && (nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                    currNodeId = nodert.getNodeid();
                }
            }
            Node currnode = null;
            if (currNodeId != null) {
                currnode = (Node)fd.getElementByID(currNodeId);
            }
            JSONObject json = new JSONObject();
            json.put("currentNodeId", currNodeId);
            json.put("splitToken", (Object)currNodeId);
            json.put("flowId", (Object)flowVO.getId());
            Collection backNodeList = null;
            if (((ManualNode)currnode).backType == 1 && ((ManualNode)currnode).cBack) {
                backNodeList = StateMachine.getBackToNodeList((BillDefiVO)flowVO, (NodeRT)nodert, (IUser)user, (int)0);
            } else if (((ManualNode)currnode).backType == 0 && ((ManualNode)currnode).cBack) {
                backNodeList = StateMachine.getBackToNodeList((IDocument)doc, (BillDefiVO)flowVO, (NodeRT)nodert, (IUser)user, (int)0);
            } else if (((ManualNode)currnode).retracementScript == null) {
                backNodeList = StateMachine.getBackToNodeList((IDocument)doc, (BillDefiVO)flowVO, (NodeRT)nodert, (IUser)user, (int)0);
            }
            JSONArray nodeListjson = new JSONArray();
            for (Node node : backNodeList) {
                JSONObject nodejson = new JSONObject();
                nodejson.put("id", (Object)node.id);
                nodejson.put("name", (Object)node.name);
                nodejson.put("type", (Object)node.getClass().getSimpleName());
                nodeListjson.add((Object)nodejson);
            }
            json.put("backNodes", (Object)nodeListjson);
            return json;
        }
        return null;
    }

    @Override
    public JSONObject taskInfo(String instanceid, WebUser user, String applicationid) throws Exception {
        String userName = user.getName();
        TaskInfoProcess process = RunTimeServiceManager.taskInfoProcess((String)applicationid);
        Collection collection = process.queryTask(instanceid, userName);
        JSONArray nextNodeListjson = new JSONArray();
        for (NodeRT nodeRT : collection) {
            JSONObject nodejson = new JSONObject();
            nodejson.put("NodeRTId", (Object)nodeRT.getId());
            nodejson.put("NodeRTName", (Object)nodeRT.getName());
            nodejson.put("flowStateRTId", (Object)nodeRT.getFlowstatertid());
            nodejson.put("Deadline", (Object)nodeRT.getDeadline());
            nodejson.put("position", (Object)nodeRT.getPosition());
            nodejson.put("reminderTime", (Object)nodeRT.getReminderTimes());
            nodejson.put("StateLabel", (Object)nodeRT.getStatelabel());
            nodejson.put("FlowOption", (Object)nodeRT.getFlowoption());
            nodejson.put("SplitToken", (Object)nodeRT.getSplitToken());
            nextNodeListjson.add((Object)nodejson);
        }
        JSONObject json = new JSONObject();
        json.put("NodeRTInfo", (Object)nextNodeListjson);
        return json;
    }

    @Override
    public JSONObject taskNum(String instanceid, WebUser user, String applicationid) throws Exception {
        String userName = user.getName();
        TaskInfoProcess process = RunTimeServiceManager.taskInfoProcess((String)applicationid);
        int num = process.queryTaskNum(instanceid, userName);
        JSONObject numJsonObject = new JSONObject();
        numJsonObject.put("number", (Object)num);
        return numJsonObject;
    }

    @Override
    public JSONObject getNodeRT(String instanceid, String nodeRTId, String applicationId) throws Exception {
        FlowRuntimeServiceImpl process = new FlowRuntimeServiceImpl(applicationId);
        Collection collection = process.queryActorRTByNoderRTAndFlowInstanceId(nodeRTId, instanceid);
        JSONObject numJsonObject = new JSONObject();
        numJsonObject.put("actor", (Object)collection);
        return numJsonObject;
    }

    @Override
    public JSONObject getAllActor(WebUser user, ParamsTable params, String applicationId, String nodeId, String flowId, String instanceId) throws Exception {
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        Node nodeCh = null;
        try {
            FlowRuntimeServiceImpl flowStateRTProcess = new FlowRuntimeServiceImpl(applicationId);
            FlowStateRT flowInstance = flowStateRTProcess.findFlowStateRT(instanceId);
            IDocument doc = flowInstance.getDocument();
            doc.setState(flowInstance);
            FileSystemBillDefiDAO billDefiDAO = new FileSystemBillDefiDAO(BillDefiVO.class);
            BillDefiVO billDefiVO = (BillDefiVO)billDefiDAO.findById(flowId);
            Collection collectionNode = billDefiVO.getAllExecuteableNodes();
            for (Node node : collectionNode) {
                String id = node.id;
                if (!id.equals(nodeId)) continue;
                nodeCh = node;
                break;
            }
            Collection collection = StateMachineUtil.getPrincipalList((IDocument)doc, (ParamsTable)params, nodeCh, (String)user.getDomainid(), (String)applicationId, (IUser)user);
            for (IUser baseUser : collection) {
                JSONObject userJson = new JSONObject();
                userJson.put("id", (Object)baseUser.getId());
                userJson.put("name", (Object)baseUser.getName());
                userJson.put("userCode", (Object)baseUser.getLoginno());
                jsonArray.add((Object)userJson);
            }
            result.put("actor", (Object)jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public List<NodeRT> remindPanels(String applicationId, WebUser user, String instanceId) throws Exception {
        FlowRuntimeServiceImpl flowStateRTProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = flowStateRTProcess.findFlowStateRT(instanceId);
        ArrayList<NodeRT> list = new ArrayList<NodeRT>();
        if (instance.isTemp() || instance.isTerminated()) {
            return list;
        }
        Collection noderts = flowStateRTProcess.doQueryNodeRT(instanceId);
        BillDefiVO flowVO = instance.getFlowVO();
        FlowDiagram fd = flowVO.toFlowDiagram();
        for (NodeRT nodeRT : noderts) {
            Node node;
            if (nodeRT.getActorIdList().contains(user.getId()) || !((node = fd.getNodeByID(nodeRT.getNodeid())) instanceof ManualNode) || !((ManualNode)node).isAllowUrge2Approval(instance.getDocument(), new ParamsTable(), (IUser)user)) continue;
            list.add(nodeRT);
        }
        return list;
    }
}

