/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.workflow.service;

import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.document.model.PureDocument;
import cn.myapps.runtime.rest.workflow.service.WorkflowExecuteService;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.runtime.scheduler.engine.RegularScheduler;
import cn.myapps.runtime.scheduler.engine.job.Job;
import cn.myapps.runtime.scheduler.engine.job.JobFactory;
import cn.myapps.runtime.scheduler.engine.job.ManualNodeTimingApprovalJob;
import cn.myapps.runtime.workflow.element.FlowDiagram;
import cn.myapps.runtime.workflow.element.ManualNode;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.runtime.workflow.element.OGraphics;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.engine.instruction.InstructionExecutor;
import cn.myapps.runtime.workflow.storage.runtime.ejb.ActorHIS;
import cn.myapps.runtime.workflow.storage.runtime.ejb.ActorRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.CoActorRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.RelationHIS;
import cn.myapps.runtime.workflow.utility.Sequence;
import cn.myapps.util.ProcessFactory;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class WorkflowExecuteServiceImpl
implements WorkflowExecuteService {
    @Override
    public void start(IDocument doc, WebUser user, ParamsTable params, String flowId) throws Exception {
        BillDefiDesignTimeService flowProcss = DesignTimeServiceManager.billDefiDesignTimeService();
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)doc.getApplicationid());
        BillDefiVO flowVO = flowProcss.doView(flowId);
        Node firstNode = StateMachine.getFirstNode((IDocument)doc, (BillDefiVO)flowVO, (IUser)user, (ParamsTable)params);
        if (firstNode != null) {
            Node startNode = StateMachine.getStartNodeByFirstNode((BillDefiVO)flowVO, (Node)firstNode);
            if (startNode != null) {
                params.setParameter("_flowid", (Object)flowId);
                proxy.doStartFlowOrUpdate(doc, params, (IUser)user);
            }
        } else {
            throw new OBPMValidateException("workflowCode\u9519\u8bef\uff01");
        }
    }

    @Override
    public void submit(IDocument doc, WebUser user, ParamsTable params, String currNodeId, String[] nextNodeIds, String flowType, String comment) throws Exception {
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)doc.getApplicationid());
        proxy.doFlow(doc, params, currNodeId, nextNodeIds, flowType, comment, (IUser)user);
    }

    @Override
    public void back(IDocument doc, WebUser user, ParamsTable params, String currNodeId, String[] nextNodeIds, String flowType, String comment, String flowId, String applicationId) throws Exception {
        params.setParameter("_flowid", (Object)flowId);
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        proxy.doFlow(doc, params, currNodeId, nextNodeIds, flowType, comment, (IUser)user);
    }

    @Override
    public void retract(IDocument doc, WebUser user, ParamsTable params, String applicationId) throws Exception {
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        BillDefiVO flowVO = doc.getState().getFlowVO();
        FlowDiagram fd = flowVO.toFlowDiagram();
        Node currNode = null;
        if (doc.getState().isComplete()) {
            FlowHistoryServiceImpl procss = new FlowHistoryServiceImpl(applicationId);
            RelationHIS his = procss.getCompleteRelationHIS(doc.getId(), doc.getState().getId());
            currNode = (Node)fd.getElementByID(his.getEndnodeid());
        } else if (doc.getState().getNoderts() != null && doc.getState().getNoderts().size() > 0) {
            NodeRT nodert = (NodeRT)doc.getState().getNoderts().iterator().next();
            currNode = (Node)fd.getElementByID(nodert.getNodeid());
        }
        Node nextNode = StateMachine.getBackNodeByHis((IDocument)doc, (BillDefiVO)flowVO, (String)currNode.id, (IUser)user, (int)256);
        if (nextNode != null) {
            ArrayList<Node> fromNode = new ArrayList<Node>();
            if (((ManualNode)nextNode).issplit) {
                Collection noderts = doc.getState().getNoderts();
                Collection nextNodeList = fd.getNextNodeList(nextNode.id, doc, params, (IUser)user);
                if (!nextNodeList.isEmpty() && !noderts.isEmpty()) {
                    block0: for (Node node : nextNodeList) {
                        for (NodeRT rt : noderts) {
                            if (!node.id.equals(rt.getNodeid())) continue;
                            fromNode.add(node);
                            continue block0;
                        }
                    }
                }
            } else {
                fromNode.add(currNode);
            }
            for (Node node : fromNode) {
                String submitTo = "[{\"nodeid\":'" + nextNode.id + "',\"isToPerson\":'true',\"userids\":\"['" + user.getId() + "']\"},]";
                params.setParameter("submitTo", (Object)submitTo);
                String[] nextids = new String[]{nextNode.id};
                proxy.doFlow(doc, params, node.id, nextids, "85", "", (IUser)user);
            }
        }
    }

    @Override
    public void recovery(IDocument doc, WebUser user, ParamsTable params, String applicationId) throws Exception {
        String nodertId;
        NodeRT nodeRT;
        Date actionTime = new Date();
        FlowRuntimeServiceImpl nodeRTProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowHistoryServiceImpl relationHISProcess = new FlowHistoryServiceImpl(applicationId);
        FlowStateRT instance1 = doc.getState();
        BillDefiVO flowVO1 = instance1.getFlowVO();
        NodeRT nodeRT1 = null;
        String currNodeId = null;
        FlowDiagram fd1 = null;
        if (flowVO1 != null) {
            fd1 = flowVO1.toFlowDiagram();
            if (instance1.isTemp()) {
                nodeRT1 = (NodeRT)((List)instance1.getNoderts()).get(0);
                currNodeId = nodeRT1.getNodeid();
            }
            if (currNodeId == null && nodeRT1 == null && (nodeRT1 = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                currNodeId = nodeRT1.getNodeid();
            }
        }
        if ((nodeRT = nodeRTProcess.doViewNodeRT(nodertId = nodeRT1.getId())) != null) {
            String currnodeid;
            BillDefiVO flowVO = doc.getState().getFlowVO();
            Node currnode = null;
            FlowDiagram fd = null;
            if (flowVO != null) {
                fd = flowVO.toFlowDiagram();
            }
            if ((currnodeid = nodeRT.getNodeid()) != null) {
                currnode = (Node)fd.getElementByID(currnodeid);
            }
            nodeRT.setState(0);
            Date lastProcessTime = new Date();
            long time = lastProcessTime.getTime() - nodeRT.getLastProcessTime().getTime();
            if (((ManualNode)currnode).isLimited && nodeRT.getDeadline() != null && nodeRT.getDeadline() != null) {
                Date deadline = new Date(nodeRT.getDeadline().getTime() + time);
                nodeRT.setDeadline(deadline);
            }
            Collection actorRTs = nodeRT.getActorrts();
            Map strategyMap = ((ManualNode)currnode).getNotificationStrategyMap();
            if (strategyMap.containsKey("overdue")) {
                for (ActorRT actorRT : actorRTs) {
                    if (actorRT.getDeadline() == null) continue;
                    Date deadline = new Date(actorRT.getDeadline().getTime() + time);
                    actorRT.setDeadline(deadline);
                }
            }
            nodeRT.setActorrts(actorRTs);
            nodeRT.setLastProcessTime(lastProcessTime);
            nodeRTProcess.doUpdateNodeRT(nodeRT);
            FlowStateRT instance = doc.getState(currNodeId);
            RelationHIS rhis = new RelationHIS();
            rhis.setId(Sequence.getSequence());
            rhis.setFlowStateId(instance.getId());
            rhis.setFlowid(instance.getFlowid());
            rhis.setFlowname(instance.getFlowVO().getSubject());
            rhis.setDocid(instance.getDocid());
            rhis.setStartnodeid(currnode.id);
            rhis.setStartnodename(currnode.name);
            rhis.setEndnodeid(currnode.id);
            rhis.setEndnodename(currnode.name);
            rhis.setIspassed(false);
            rhis.setActiontime(actionTime);
            rhis.setAttitude("");
            rhis.setAuditor(user.getId());
            ActorHIS actorHIS = null;
            if (!StringUtil.isBlank((String)user.getProxyUserId())) {
                UserVO uservo = (UserVO)ProcessFactory.createProcess(UserProcess.class).doView(user.getProxyUserId());
                actorHIS = new ActorHIS((IUser)uservo);
                actorHIS.setAgentid(user.getId());
                actorHIS.setAgentname(user.getName());
            } else {
                actorHIS = new ActorHIS((IUser)user);
            }
            actorHIS.setAttitude("");
            actorHIS.setSignature("");
            actorHIS.setProcesstime(actionTime);
            rhis.getActorhiss().add(actorHIS);
            rhis.setFlowOperation("89");
            rhis.setReminderCount(0);
            relationHISProcess.doCreateRelationHIS(rhis);
            if (((ManualNode)currnode).isLimited && nodeRT.getDeadline() != null) {
                Job job = JobFactory.createJob(ManualNodeTimingApprovalJob.class, (Object[])new Object[]{instance.getDocid(), instance.getId(), nodeRT.getId(), instance.getApplicationid(), null});
                TriggerVO trigger = new TriggerVO(job, nodeRT.getDeadline().getTime());
                RegularScheduler.addTrigger((TriggerVO)trigger, (String)applicationId);
            }
        }
    }

    @Override
    public void terminate(IDocument doc, WebUser user, ParamsTable params, String applicationId) throws Exception {
        String label;
        FlowStateRT instance = doc.getState();
        FlowDiagram fd = instance.getFlowVO().toFlowDiagram();
        BillDefiVO flowVO = instance.getFlowVO();
        NodeRT nodeRT = null;
        String currNodeId = null;
        if (flowVO != null) {
            fd = flowVO.toFlowDiagram();
            if (instance.isTemp()) {
                nodeRT = (NodeRT)((List)instance.getNoderts()).get(0);
                currNodeId = nodeRT.getNodeid();
            }
            if (currNodeId == null && nodeRT == null && (nodeRT = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                currNodeId = nodeRT.getNodeid();
            }
        }
        boolean update = false;
        Node currNode = (Node)fd.getElementByID(currNodeId);
        Node endNode = new Node(fd){

            public void showTips(Graphics g) {
            }

            public void paint(OGraphics g) {
            }
        };
        endNode.name = label = "\u7ec8\u6b62";
        endNode.statelabel = label;
        endNode.id = "terminate_id";
        FlowRuntimeServiceImpl nodeRTProcess = new FlowRuntimeServiceImpl(doc.getApplicationid());
        if (!instance.isComplete() && !instance.isTerminated() && instance.getNoderts() != null && instance.getNoderts().size() > 0) {
            for (NodeRT nodert : instance.getNoderts()) {
                nodeRTProcess.doRemoveNodeRT(nodert.getId());
            }
            instance.getNoderts().clear();
            update = true;
        }
        if (update) {
            NodeRT nodert;
            Date actionTime = new Date();
            nodert = new NodeRT(instance, endNode, "8");
            instance.getNoderts().add(nodert);
            StateMachine.updateFlowState((FlowStateRT)instance, (IUser)user);
            StateMachine.updatePreviousRelationHIS((FlowStateRT)instance, (Node)currNode, (IUser)user, (Date)actionTime);
            StateMachine.createOrUpdateRelationHIS((FlowStateRT)instance, (Node)currNode, (Node)endNode, (IUser)user, (Date)actionTime, (String)"", (String)"", (String)"8", (ParamsTable)params, (String)"", (NodeRT)nodeRT);
            InstructionExecutor.getInstance().execute();
            DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
            doc.setAuditdate(actionTime);
            doc.setAuditorList("");
            doc.setAuditorNames("");
            doc.setStateLabelInfo(null);
            doc.setAuditorList(null);
            doc.setAudituser(user.getId());
            doc.setLastFlowOperation("8");
            doc.setLastmodified(actionTime);
            doc.setLastmodifier(user.getId());
            doc.setStateLabel(label);
            proxy.doCreateOrUpdate(doc, (IUser)user);
        }
    }

    @Override
    public void suspend(IDocument doc, WebUser user, ParamsTable params, String applicationId) throws Exception {
        Date actionTime = new Date();
        FlowRuntimeServiceImpl nodeRTProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowHistoryServiceImpl relationHISProcess = new FlowHistoryServiceImpl(applicationId);
        FlowStateRT instance = doc.getState();
        BillDefiVO flowVO = instance.getFlowVO();
        NodeRT nodeRT = null;
        String currNodeId = null;
        FlowDiagram fd = null;
        if (flowVO != null) {
            fd = flowVO.toFlowDiagram();
            if (instance.isTemp()) {
                nodeRT = (NodeRT)((List)instance.getNoderts()).get(0);
                currNodeId = nodeRT.getNodeid();
            }
            if (currNodeId == null && nodeRT == null && (nodeRT = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                currNodeId = nodeRT.getNodeid();
            }
        }
        if (nodeRT != null) {
            String currnodeid;
            nodeRT.setState(NodeRT.FLOWSTATE_HANDUP);
            nodeRT.setLastProcessTime(new Date());
            nodeRT.setActorrts(nodeRT.getActorrts());
            nodeRTProcess.doUpdateNodeRT(nodeRT);
            flowVO = doc.getState().getFlowVO();
            Node currnode = null;
            fd = null;
            if (flowVO != null) {
                fd = flowVO.toFlowDiagram();
            }
            if ((currnodeid = nodeRT.getNodeid()) != null) {
                currnode = (Node)fd.getElementByID(currnodeid);
            }
            RelationHIS rhis = new RelationHIS();
            rhis.setId(Sequence.getSequence());
            rhis.setFlowStateId(instance.getId());
            rhis.setFlowid(instance.getFlowid());
            rhis.setFlowname(instance.getFlowVO().getSubject());
            rhis.setDocid(instance.getDocid());
            rhis.setStartnodeid(currnode.id);
            rhis.setStartnodename(currnode.name);
            rhis.setEndnodeid(currnode.id);
            rhis.setEndnodename(currnode.name);
            rhis.setIspassed(false);
            rhis.setActiontime(actionTime);
            rhis.setAuditor(user.getId());
            ActorHIS actorHIS = null;
            if (!StringUtil.isBlank((String)user.getProxyUserId())) {
                UserVO uservo = (UserVO)ProcessFactory.createProcess(UserProcess.class).doView(user.getProxyUserId());
                actorHIS = new ActorHIS((IUser)uservo);
                actorHIS.setAgentid(user.getId());
                actorHIS.setAgentname(user.getName());
            } else {
                actorHIS = new ActorHIS((IUser)user);
            }
            actorHIS.setProcesstime(actionTime);
            rhis.getActorhiss().add(actorHIS);
            rhis.setFlowOperation("88");
            rhis.setReminderCount(0);
            relationHISProcess.doCreateRelationHIS(rhis);
            if (((ManualNode)currnode).isLimited && nodeRT.getDeadline() != null) {
                String token = TriggerVO.generateManualNodeTimingApprovalJobToken((String)doc.getId(), (String)doc.getStateid(), (String)nodeRT.getId());
                RegularScheduler.cancelTrigger((String)token, (String)applicationId);
            }
        }
    }

    @Override
    public void startFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment, String nextUserId) throws Exception {
        FlowRuntimeServiceImpl fsProcess = new FlowRuntimeServiceImpl(applicationId);
        fsProcess.doStartFreeWorkflow(doc, nextUserId, comment, params, (IUser)user);
    }

    @Override
    public void submitFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment, String nextUserId) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        FlowRuntimeServiceImpl fsProcess = new FlowRuntimeServiceImpl(applicationId);
        dProcess.doStartFlowOrUpdate(doc, params, (IUser)user);
        fsProcess.doProcessFreeWorkflow(doc.getState(), nextUserId, comment, params, (IUser)user);
    }

    @Override
    public void backFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment, String nextUserId) throws Exception {
        FlowRuntimeServiceImpl fsProcess = new FlowRuntimeServiceImpl(applicationId);
        fsProcess.doBackOffFreeWorkflow(doc.getState(), nextUserId, comment, params, (IUser)user);
    }

    @Override
    public void completeFree(IDocument doc, WebUser user, ParamsTable params, String applicationId, String comment) throws Exception {
        FlowRuntimeServiceImpl fsProcess = new FlowRuntimeServiceImpl(applicationId);
        fsProcess.doCompleteFreeWorkflow(doc.getState(), comment, params, (IUser)user);
    }

    @Override
    public IDocument updateAuditor(ParamsTable params, WebUser user, String applicationId, String instanceId, List<String> userIds) throws Exception {
        FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = stateProcess.findFlowStateRT(instanceId);
        IDocument doc = instance.getDocument();
        BillDefiVO flowVO = instance.getFlowVO();
        NodeRT nodeRT = null;
        String currNodeId = null;
        FlowDiagram flowDiagram = null;
        if (flowVO != null) {
            flowDiagram = flowVO.toFlowDiagram();
            if (instance.isTemp()) {
                nodeRT = (NodeRT)((List)instance.getNoderts()).get(0);
                currNodeId = nodeRT.getNodeid();
            }
            if (currNodeId == null && nodeRT == null && (nodeRT = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                currNodeId = nodeRT.getNodeid();
            }
        }
        JSONObject json = (JSONObject)JSONObject.parse((String)doc.getAuditorList());
        for (Map.Entry entry : json.entrySet()) {
            JSONArray value = (JSONArray)entry.getValue();
            if (value == null) continue;
            for (String id : userIds) {
                if (value.contains((Object)id)) continue;
                value.add((Object)id);
            }
        }
        params.setParameter("_currid", (Object)currNodeId);
        doc.setAuditorList(json.toString());
        DocumentProcess docProcess = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
        if (instance.getDocument() != null) {
            docProcess.doChangeAuditor(instance.getDocument(), params, (IUser)user);
        }
        return doc;
    }

    @Override
    public String doFlowAssist(String applicationId, String instanceId, String attitude, WebUser user) throws Exception {
        FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = stateProcess.findFlowStateRT(instanceId);
        String nodeRTId = "";
        Collection cNodeRTs = instance.getNoderts();
        for (NodeRT nodeRT2 : cNodeRTs) {
            Collection coActors = nodeRT2.getCoActors();
            for (CoActorRT coActorRT : coActors) {
                if (!user.getId().equals(coActorRT.getUserId())) continue;
                nodeRTId = nodeRT2.getId();
                stateProcess.doEvaluate(instanceId, nodeRTId, attitude, (IUser)user);
                return "\u534f\u529e\u6210\u529f";
            }
        }
        return "\u534f\u529e\u5931\u8d25";
    }

    @Override
    public String addCoAuditor(String applicationId, String docId, List<String> userIds, WebUser user) throws Exception {
        JSONObject json;
        ArrayList<String> userIdList;
        DocumentProcess dProcess = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
        IDocument doc = (IDocument)dProcess.doView(docId);
        FlowStateRT instance = doc.getState();
        BillDefiVO flowVO = instance.getFlowVO();
        NodeRT nodeRT = null;
        String currNodeId = null;
        if (flowVO != null) {
            if (instance.isTemp()) {
                nodeRT = (NodeRT)((List)instance.getNoderts()).get(0);
                currNodeId = nodeRT.getNodeid();
            }
            if (currNodeId == null && nodeRT == null && (nodeRT = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                currNodeId = nodeRT.getNodeid();
            }
        }
        if ((userIdList = (ArrayList<String>)(json = (JSONObject)JSONObject.parse((String)doc.getCoAuditorList())).get(currNodeId)) != null) {
            for (String id : userIds) {
                if (userIdList.contains(id)) continue;
                userIdList.add(id);
            }
        } else {
            userIdList = new ArrayList<String>();
            for (String id : userIds) {
                if (userIdList.contains(id)) continue;
                userIdList.add(id);
            }
        }
        json.put(currNodeId, userIdList);
        doc.setCoAuditorList(json.toString());
        ParamsTable params = new ParamsTable();
        params.setParameter("_currid", (Object)currNodeId);
        dProcess.doChangeCoAuditor(doc, params, (IUser)user);
        return "\u534f\u529e\u52a0\u7b7e\u6210\u529f";
    }

    @Override
    public PureDocument reminderWorkflow(WebUser user, String applicationid, String instanceId, String[] nodertIds, String reminderContent) throws Exception {
        FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(applicationid);
        DocumentProcess dProcess = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationid);
        FlowStateRT instance = stateProcess.findFlowStateRT(instanceId);
        ParamsTable params = new ParamsTable();
        PureDocument doc = (PureDocument)dProcess.doView(instance.getDocid());
        dProcess.doPlatformFlowReminder(doc, nodertIds, reminderContent, params, user);
        MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)user);
        return doc;
    }

    @Override
    public IDocument updateApprovers(ParamsTable params, WebUser user, String applicationId, String instanceId, List<String> userIds) throws Exception {
        FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = stateProcess.findFlowStateRT(instanceId);
        IDocument doc = instance.getDocument();
        BillDefiVO flowVO = instance.getFlowVO();
        NodeRT nodeRT = null;
        String currNodeId = null;
        FlowDiagram flowDiagram = null;
        if (flowVO != null) {
            flowDiagram = flowVO.toFlowDiagram();
            if (instance.isTemp()) {
                nodeRT = (NodeRT)((List)instance.getNoderts()).get(0);
                currNodeId = nodeRT.getNodeid();
            }
            if (currNodeId == null && nodeRT == null && (nodeRT = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                currNodeId = nodeRT.getNodeid();
            }
        }
        JSONObject json = (JSONObject)JSONObject.parse((String)doc.getAuditorList());
        for (Map.Entry entry : json.entrySet()) {
            JSONArray value = (JSONArray)entry.getValue();
            value.clear();
            if (value == null) continue;
            for (String id : userIds) {
                value.add((Object)id);
            }
        }
        params.setParameter("_currid", (Object)currNodeId);
        doc.setAuditorList(json.toString());
        DocumentProcess docProcess = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
        if (instance.getDocument() != null) {
            docProcess.doChangeAuditor(instance.getDocument(), params, (IUser)user);
        }
        return doc;
    }

    @Override
    public String doFlowSupplement(String applicationId, String instanceId, String comments, WebUser user) throws Exception {
        FlowRuntimeServiceImpl flowStateRTProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = flowStateRTProcess.findFlowStateRT(instanceId);
        FlowHistoryServiceImpl relationHISProcess = new FlowHistoryServiceImpl(applicationId);
        RelationHIS rhis = new RelationHIS();
        rhis.setId(Sequence.getSequence());
        rhis.setFlowStateId(instanceId);
        rhis.setFlowid(instance.getFlowid());
        rhis.setFlowname(instance.getFlowVO().getSubject());
        rhis.setDocid(instance.getDocid());
        rhis.setStartnodeid("");
        rhis.setStartnodename("\u6dfb\u52a0/\u8865\u7b7e\u610f\u89c1");
        rhis.setEndnodeid("");
        rhis.setEndnodename("\u6dfb\u52a0/\u8865\u7b7e\u610f\u89c1");
        rhis.setIspassed(false);
        rhis.setActiontime(new Date());
        rhis.setAttitude(comments);
        rhis.setAuditor(user.getId());
        ActorHIS actorHIS = null;
        if (!StringUtil.isBlank((String)user.getProxyUserId())) {
            UserVO uservo = (UserVO)ProcessFactory.createProcess(UserProcess.class).doView(user.getProxyUserId());
            actorHIS = new ActorHIS((IUser)new WebUser((IUser)uservo));
            actorHIS.setAgentid(user.getId());
            actorHIS.setAgentname(user.getName());
        } else {
            actorHIS = new ActorHIS((IUser)user);
        }
        actorHIS.setProcesstime(new Date());
        actorHIS.setAttitude(comments);
        actorHIS.setSignature("");
        rhis.getActorhiss().add(actorHIS);
        rhis.setFlowOperation("\u6dfb\u52a0/\u8865\u7b7e\u610f\u89c1");
        rhis.setReminderCount(0);
        relationHISProcess.doCreateRelationHIS(rhis);
        return "\u8865\u7b7e\u6210\u529f";
    }

    @Override
    public void deleteFlow(String docId, String applicationId) throws Exception {
        FlowRuntimeServiceImpl flowProcess = new FlowRuntimeServiceImpl(applicationId);
        flowProcess.doDeleteFlow(docId);
    }
}

