/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.workflow.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.document.model.PureDocument;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.workflow.service.WorkflowQueryService;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import cn.myapps.util.json.JsonTmpUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6d41\u7a0b\u67e5\u8be2\u6a21\u5757"})
@Controller
@RequestMapping(path={"/api/rest/bpm/query"}, produces={"application/json;charset=UTF-8"})
public class WorkflowQueryController
extends AbstractRESTController {
    @Autowired
    @Qualifier(value="workflowQueryServiceImpl")
    WorkflowQueryService service;

    @ApiOperation(value="\u6d41\u7a0b\u72b6\u6001", notes="\u6d41\u7a0b\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/states"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource startqueryWorkflow(@RequestParam String applicationId, @RequestParam String instanceId, @RequestParam String accessToken) throws Exception {
        com.alibaba.fastjson.JSONObject result = this.service.queryWorkflow(applicationId, instanceId);
        return this.success("success", JsonTmpUtil.fromObject((Object)result));
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u63d0\u4ea4\u9762\u677f", notes="\u83b7\u53d6\u6d41\u7a0b\u63d0\u4ea4\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @PostMapping(value={"/submission"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource submissionPanels(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String instanceId, @RequestParam String flowId, @RequestParam String userCode, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        com.alibaba.fastjson.JSONObject result = this.service.submissionPanels(applicationId, (IDocument)doc, user, flowId, instanceId, this.getParams());
        result.put("instanceId", (Object)instanceId);
        return this.success("success", result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56de\u9000\u9762\u677f", notes="\u83b7\u53d6\u6d41\u7a0b\u56de\u9000\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @PostMapping(value={"/back"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource backPanels(@RequestParam String applicationId, @RequestParam String instanceId, @RequestParam String accessToken, @RequestParam String userCode) throws Exception {
        com.alibaba.fastjson.JSONObject result = this.service.backPanels(applicationId, instanceId, this.getUser());
        result.put("instanceId", (Object)instanceId);
        return this.success("success", result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u50ac\u529e\u9762\u677f", notes="\u83b7\u53d6\u6d41\u7a0b\u50ac\u529e\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/remindpanel"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource remindPanel(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String instanceId, @RequestParam String userCode) throws Exception {
        WebUser user = this.getUser();
        List<NodeRT> nodeRTS = this.service.remindPanels(applicationId, user, instanceId);
        JSONArray result = new JSONArray();
        for (NodeRT nodert : nodeRTS) {
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)nodert.getNodeid());
            object.put((Object)"name", (Object)nodert.getName());
            result.add((Object)object);
        }
        return this.success("success", result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4fe1\u606f", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/taskInfo"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource taskInformation(@RequestParam String accessToken, @RequestParam String userCode, @RequestParam String instanceId, @RequestParam String applicationId) throws Exception {
        com.alibaba.fastjson.JSONObject result = this.service.taskInfo(instanceId, this.getUser(), applicationId);
        return this.success("success", result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u6570\u91cf", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/taskNum"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource taskNum(@RequestParam String accessToken, @RequestParam String userCode, @RequestParam String instanceId, @RequestParam String applicationId) throws Exception {
        com.alibaba.fastjson.JSONObject result = this.service.taskNum(instanceId, this.getUser(), applicationId);
        return this.success("success", result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f8b\u8282\u70b9\u5ba1\u6279\u4eba", notes="\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f8b\u8282\u70b9\u5ba1\u6279\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nodeRTId", value="\u8282\u70b9\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/nowActor"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getActorRT(@RequestParam String accessToken, @RequestParam String instanceId, @RequestParam String nodeRTId, @RequestParam String applicationId) throws Exception {
        com.alibaba.fastjson.JSONObject result = this.service.getNodeRT(instanceId, nodeRTId, applicationId);
        return this.success("success", result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u5019\u9009\u5ba1\u6279\u4eba", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u5019\u9009\u5ba1\u6279\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0b\u6a21\u677fId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/allActor"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getActorbyNode(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String nodeId, @RequestParam String flowId, @RequestParam String instanceId, @RequestParam String userCode) throws Exception {
        com.alibaba.fastjson.JSONObject result = new com.alibaba.fastjson.JSONObject();
        WebUser user = this.getUser();
        ParamsTable params = this.getParams();
        result = this.service.getAllActor(user, params, applicationId, nodeId, flowId, instanceId);
        return this.success("success", result);
    }
}

