/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.workflow.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.runtime.dynaform.document.ejb.WorkVO;
import cn.myapps.runtime.dynaform.work.ejb.WorkProcessBean;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.workflow.service.WorkflowHistoryService;
import cn.myapps.runtime.workflow.service.WorkflowRunTimeService;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryVO;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6d41\u7a0b\u5386\u53f2\u6a21\u5757"})
@Controller
@RequestMapping(path={"/api/rest/bpm"})
public class WorkflowHistoryController
extends AbstractRESTController {
    @Autowired
    @Qualifier(value="workflowHistoryServiceImpl")
    WorkflowHistoryService service;
    @Autowired
    private WorkflowRunTimeService workflowService;

    @ApiOperation(value="\u6d41\u7a0b\u5386\u53f2", notes="\u6d41\u7a0b\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/history/flowHistory"}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource getHistorys(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String id, @RequestParam String userCode) throws Exception {
        List<FlowHistoryVO> result = this.service.getHistorys(applicationId, id);
        return this.success("success", result);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56fe", notes="\u83b7\u53d6\u6d41\u7a0b\u56fe")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/history/flowPhoto"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<byte[]> getFlowPhoto(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String instanceId) throws Exception {
        FlowRuntimeServiceImpl process = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT flowState = process.findFlowStateRT(instanceId);
        HttpHeaders headers = new HttpHeaders();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(flowState.getAuditdate());
        String dateTime = String.valueOf(calendar.get(1) + String.valueOf(calendar.get(2) + 1));
        File file = this.service.getFlowPhoto(applicationId, instanceId, dateTime);
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentDispositionFormData("attachment", instanceId + ".jpg");
        if (!(file != null && file.exists() || flowState == null)) {
            throw new Exception("\u8be5\u6d41\u7a0b\u4e3a\u81ea\u7531\u6d41\u7a0b\uff0c\u6ca1\u6709\u6d41\u7a0b\u56fe\u3002");
        }
        if (file == null || !file.exists()) {
            throw new Exception("\u627e\u4e0d\u5230\u6587\u4ef6\uff01");
        }
        return new ResponseEntity((Object)WorkflowHistoryController.File2byte(file), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public static byte[] File2byte(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    @GetMapping(value={"/myPending"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u5f85\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)", notes="rest\u63a5\u53e3\u83b7\u53d6\u6211\u7684\u5f85\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u8d26\u53f7", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u73b0\u5728\u7684\u9875\u6570", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u7684\u6761\u6570", required=false, paramType="query", dataType="string", defaultValue="5")})
    public Resource queryPendingByUser(@RequestParam String userCode, @RequestParam String accessToken, @RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="5") int linesPerPage) throws Exception {
        WebUser user = this.getUser();
        List applicationIds = user.getApplicationIds();
        DataPackage workDataPage = new DataPackage();
        ArrayList listWork = new ArrayList();
        int allSum = 0;
        boolean isFlowAgent = true;
        if (applicationIds != null) {
            for (String applicationId : applicationIds) {
                WorkProcessBean wp = new WorkProcessBean(applicationId);
                DataPackage<WorkVO> tmp_works = wp.getPendingList("", "", "", isFlowAgent, applicationId, user.getDomainid(), "", pageNo, linesPerPage, (IUser)user);
                listWork.addAll(tmp_works.getDatas());
                allSum += tmp_works.getRowCount();
            }
        }
        if (allSum != 0) {
            workDataPage.setRowCount(allSum);
            workDataPage.setLinesPerPage(linesPerPage);
            workDataPage.setPageNo(pageNo);
            int beginIndex = (pageNo - 1) * linesPerPage;
            int endIndex = pageNo * linesPerPage;
            if (beginIndex >= listWork.size()) {
                workDataPage.setDatas(null);
                workDataPage.setRowCount(0);
            } else if (endIndex >= listWork.size()) {
                endIndex = listWork.size();
            }
            workDataPage.setDatas(listWork.subList(beginIndex, endIndex));
        }
        return this.success("ok", workDataPage);
    }

    @GetMapping(value={"/myProcessing"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u524d\u53f0widget\u663e\u793a-\u6211\u7684\u7ecf\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)", notes="rest\u63a5\u53e3\u83b7\u53d6\u6211\u7684\u7ecf\u529e(\u5305\u542b\u591a\u4e2a\u8f6f\u4ef6)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u8d26\u53f7", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="pageNo", value="\u73b0\u5728\u7684\u9875\u6570", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="linesPerPage", value="\u6bcf\u9875\u7684\u6761\u6570", required=false, paramType="query", dataType="string", defaultValue="5")})
    public Resource queryProcessingByUser(@RequestParam String userCode, @RequestParam String accessToken, @RequestParam(required=false, defaultValue="1") int pageNo, @RequestParam(required=false, defaultValue="5") int linesPerPage) throws Exception {
        WebUser user = this.getUser();
        List applicationIds = user.getApplicationIds();
        DataPackage workDataPage = new DataPackage();
        ArrayList listWork = new ArrayList();
        int allSum = 0;
        if (applicationIds != null) {
            for (String applicationId : applicationIds) {
                WorkProcessBean wp = new WorkProcessBean(applicationId);
                DataPackage<WorkVO> tmp_works = wp.getProcessedRunningList("", "", "", applicationId, user.getDomainid(), false, "", "", pageNo, linesPerPage, (IUser)user);
                listWork.addAll(tmp_works.getDatas());
                allSum += tmp_works.getRowCount();
            }
        }
        if (allSum != 0) {
            workDataPage.setRowCount(allSum);
            workDataPage.setLinesPerPage(linesPerPage);
            workDataPage.setPageNo(pageNo);
            int beginIndex = (pageNo - 1) * linesPerPage;
            int endIndex = pageNo * linesPerPage;
            if (beginIndex >= listWork.size()) {
                workDataPage.setDatas(null);
                workDataPage.setRowCount(0);
            } else if (endIndex >= listWork.size()) {
                endIndex = listWork.size();
            }
            workDataPage.setDatas(listWork.subList(beginIndex, endIndex));
        }
        return this.success("ok", workDataPage);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u50ac\u529e\u5386\u53f2", notes="\u83b7\u53d6\u6d41\u7a0b\u50ac\u529e\u5386\u53f2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string")})
    @GetMapping(value={"/history/remindhis"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource remindHis(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String instanceId, @RequestParam String userCode) throws Exception {
        WebUser user = this.getUser();
        FlowRuntimeServiceImpl flowStateRTProcess = new FlowRuntimeServiceImpl(applicationId);
        FlowStateRT instance = flowStateRTProcess.findFlowStateRT(instanceId);
        List result = this.workflowService.getRemindHistorys(applicationId, instance.getDocid());
        return this.success("ok", result);
    }
}

