/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.workflow.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.document.model.PureDocument;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.workflow.service.WorkflowExecuteService;
import cn.myapps.util.json.JsonTmpUtil;
import com.jayway.jsonpath.JsonPath;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u6d41\u7a0b\u6267\u884c\u6a21\u5757"})
@Controller
@RequestMapping(path={"/api/rest/bpm/runtime"}, produces={"application/json;charset=UTF-8"})
public class WorkflowExecuteController
extends AbstractRESTController {
    @Autowired
    @Qualifier(value="workflowExecuteServiceImpl")
    WorkflowExecuteService service;

    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b", notes="\u542f\u52a8\u548c\u521d\u59cb\u5316\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    @PostMapping(value={"/start"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource start(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String flowId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        this.service.start((IDocument)doc, user, this.getParams(), flowId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/submission"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b", notes="\u63d0\u4ea4\u548c\u5ba1\u6279\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="flowType", value="\u6d41\u7a0b\u7c7b\u578b(FlowType)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="currNodeId", value="\u5f53\u524d\u8282\u70b9\u7684\u8282\u70b9\u5b9a\u4e49\u5bf9\u8c61Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nextNodeIds", value="\u4e0b\u4e00\u8282\u70b9\u7684\u8282\u70b9\u5b9a\u4e49\u5bf9\u8c61\u7684\u96c6\u5408(\u6570\u7ec4)", required=true, paramType="query", dataType="string", allowMultiple=true), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource submit(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String flowType, @RequestParam String currNodeId, @RequestParam String instanceId, @RequestParam(required=false) String comment, @RequestParam String[] nextNodeIds, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.submit((IDocument)doc, user, this.getParams(), currNodeId, nextNodeIds, flowType, comment);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/back"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u9a73\u56de", notes="\u9a73\u56de\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="flowType", value="\u6d41\u7a0b\u7c7b\u578b", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="currNodeId", value="\u5f53\u524d\u8282\u70b9\u7684\u8282\u70b9\u5b9a\u4e49\u5bf9\u8c61Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="comment", value="\u5ba1\u6279\u610f\u89c1", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nextNodeIds", value="\u4e0b\u4e00\u8282\u70b9\u7684\u8282\u70b9\u5b9a\u4e49\u5bf9\u8c61\u7684\u96c6\u5408(\u6570\u7ec4)", required=true, paramType="query", dataType="string", allowMultiple=true), @ApiImplicitParam(name="flowId", value="\u6d41\u7a0b\u5b9a\u4e49Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource back(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String flowType, @RequestParam String currNodeId, @RequestParam String instanceId, @RequestParam(required=false) String comment, @RequestParam String[] nextNodeIds, @RequestParam String flowId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.back((IDocument)doc, user, this.getParams(), currNodeId, nextNodeIds, flowType, comment, flowId, applicationId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/remind"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u50ac\u529e\u6d41\u7a0b", notes="\u50ac\u529e\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="reminderContent", value="\u50ac\u529e\u610f\u89c1", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="query", dataType="string")})
    public Resource reminderWorkflow(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestParam String reminderContent, @RequestBody String[] content) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.service.reminderWorkflow(user, applicationId, instanceId, content, reminderContent);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/retracement"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u56de\u64a4\u6d41\u7a0b", notes="\u6d41\u7a0b\u56de\u64a4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource retreat(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.retract((IDocument)doc, this.getUser(), this.getParams(), applicationId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/recovery"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6062\u590d\u6d41\u7a0b", notes="\u6062\u590d\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="query", dataType="string")})
    public Resource recovery(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.recovery((IDocument)doc, this.getUser(), this.getParams(), applicationId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/termination"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u7ec8\u6b62\u6d41\u7a0b", notes="\u7ec8\u6b62\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801(\u7528\u6237\u8d26\u53f7)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource terminate(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.terminate((IDocument)doc, this.getUser(), this.getParams(), applicationId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/suspend"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6302\u8d77\u6d41\u7a0b", notes="\u6302\u8d77\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource suspend(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.suspend((IDocument)doc, this.getUser(), this.getParams(), applicationId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/startFree"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5f00\u542f\u81ea\u7531\u6d41\u7a0b", notes="\u5f00\u542f\u81ea\u7531\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801(\u7528\u6237\u8d26\u53f7)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="comment", value="\u5ba1\u6279\u610f\u89c1", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nextUserCode", value="\u4e0b\u4e2a\u5ba1\u6279\u4eba\u7684UserCode", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u7684\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource startFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam(required=false) String comment, @RequestParam String nextUserCode, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        String nextUserId = userProcess.findUserIdByAccount(nextUserCode);
        this.service.startFree((IDocument)doc, this.getUser(), this.getParams(), applicationId, comment, nextUserId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/submissionFree"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u63d0\u4ea4\u81ea\u7531\u6d41\u7a0b", notes="\u63d0\u4ea4\u81ea\u7531\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801(\u7528\u6237\u8d26\u53f7)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="comment", value="\u5ba1\u6279\u610f\u89c1", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nextUserCode", value="\u4e0b\u4e2a\u5ba1\u6279\u4eba\u7684UserCode", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="parentId", value="\u7236id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u5b9e\u4f8bid", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u7684\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource submitFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam(required=false) String comment, @RequestParam String nextUserCode, @RequestParam(required=false) String parentId, @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setParent(parentId);
        doc.setState(instanceId);
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        String nextUserId = userProcess.findUserIdByAccount(nextUserCode);
        this.service.submitFree((IDocument)doc, this.getUser(), this.getParams(), applicationId, comment, nextUserId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/backFree"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u56de\u9000\u81ea\u7531\u6d41\u7a0b", notes="\u56de\u9000\u81ea\u7531\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801(\u7528\u6237\u8d26\u53f7)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="comment", value="\u5ba1\u6279\u610f\u89c1", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="nextUserId", value="\u4e0b\u4e2a\u5ba1\u6279\u4eba\u7684Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u7684\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource backFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam(required=false) String comment, @RequestParam String nextUserId, @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.backFree((IDocument)doc, this.getUser(), this.getParams(), applicationId, comment, nextUserId);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/assist/addition"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u534f\u529e\u52a0\u7b7e", notes="\u6d41\u7a0b\u534f\u529e\u52a0\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userIds", value="\u8bf7\u6c42\u5305\u4f53(\u7528\u6237id\u96c6\u5408)", required=true, paramType="body", dataType="string")})
    public Resource addCoAuditor(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestBody String userIds) throws Exception {
        WebUser user = this.getUser();
        List idList = (List)JsonPath.parse((String)userIds).json();
        String info = this.service.addCoAuditor(applicationId, instanceId, idList, user);
        return this.success("success", info);
    }

    @PostMapping(value={"/assist"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6d41\u7a0b\u534f\u529e", notes="\u6d41\u7a0b\u534f\u529e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="comment", value="\u5ba1\u6279\u610f\u89c1", required=true, paramType="query", dataType="string")})
    public Resource doFlowAssist(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestParam String comment) throws Exception {
        WebUser user = this.getUser();
        String info = this.service.doFlowAssist(applicationId, instanceId, comment, user);
        return this.success("success", info);
    }

    @PostMapping(value={"/completeFree"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u7ed3\u675f\u81ea\u7531\u6d41\u7a0b", notes="\u7ed3\u675f\u81ea\u7531\u6d41\u7a0b(\u5f52\u6863)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801(\u7528\u6237\u8d26\u53f7)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="comment", value="\u5ba1\u6279\u610f\u89c1", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u7684\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource completeFree(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam(required=false) String comment, @RequestParam String instanceId, @RequestBody String postBody) throws Exception {
        WebUser user = this.getUser();
        PureDocument doc = this.parseDocument(postBody, applicationId, user);
        doc.setState(instanceId);
        this.service.completeFree((IDocument)doc, this.getUser(), this.getParams(), applicationId, comment);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/auditor"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u66f4\u6539\u5ba1\u6279\u4eba", notes="\u66f4\u6539\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801(\u7528\u6237\u8d26\u53f7)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="auditorList", value="\u5ba1\u6279\u4eba\u5217\u8868", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u8bf7\u6c42\u5305\u4f53\u7684\u5185\u5bb9", required=true, paramType="body", dataType="string")})
    public Resource updateAuditor(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestBody String userIds) throws Exception {
        WebUser user = this.getUser();
        List auditorList = (List)JsonPath.parse((String)userIds).json();
        IDocument doc = this.service.updateAuditor(this.getParams(), this.getUser(), applicationId, instanceId, auditorList);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/approvers"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u7f16\u8f91\u5f53\u524d\u8282\u70b9\u5ba1\u6279\u4eba", notes="\u7f16\u8f91\u5f53\u524d\u8282\u70b9\u5ba1\u6279\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801(\u7528\u6237\u8d26\u53f7)", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="postBody", value="\u5ba1\u6279\u4eba\u5217\u8868", required=true, paramType="body", dataType="string")})
    public Resource updateApprovers(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestBody String userIds) throws Exception {
        WebUser user = this.getUser();
        List auditorList = (List)JsonPath.parse((String)userIds).json();
        IDocument doc = this.service.updateApprovers(this.getParams(), this.getUser(), applicationId, instanceId, auditorList);
        return this.success("success", JsonTmpUtil.fromObject((Object)doc.getStateLabelInfo()));
    }

    @PostMapping(value={"/supplement"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6dfb\u52a0/\u8865\u7b7e\u610f\u89c1", notes="\u6dfb\u52a0/\u8865\u7b7e\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="instanceId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8865\u7b7e\u610f\u89c1", required=true, paramType="query", dataType="string")})
    public Resource supplement(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String userCode, @RequestParam String instanceId, @RequestParam String content) throws Exception {
        WebUser user = this.getUser();
        String result = this.service.doFlowSupplement(applicationId, instanceId, content, user);
        return this.success("success", result);
    }

    @GetMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b", notes="\u5220\u9664\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessToken", value="\u8bbf\u95ee\u4ee4\u724c", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="applicationId", value="\u5e94\u7528Id", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="docId", value="\u6587\u6863Id", required=true, paramType="query", dataType="string")})
    public Resource deleteFlow(@RequestParam String accessToken, @RequestParam String applicationId, @RequestParam String docId) throws Exception {
        this.service.deleteFlow(docId, applicationId);
        return this.success("success", "\u5220\u9664\u6210\u529f");
    }
}

