/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.user.controller;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.user.model.User;
import cn.myapps.runtime.rest.user.service.UserService;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="bpmUserController")
@RequestMapping(path={"/rest/bpm/user"})
public class UserController
extends AbstractRESTController {
    @Autowired
    @Qualifier(value="bpmUserService")
    UserService service;

    @PostMapping(value={"/save"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource save(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        User user = this.parseUser(postBody);
        String response = this.service.add(user);
        return this.success("created", response);
    }

    @PostMapping(value={"/find"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource find(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String account = (String)parse.read("$.account", new Predicate[0]);
        User user = this.service.find(account);
        JSONObject userJSON = new JSONObject();
        userJSON.put("UserInfo", (Object)user);
        return this.success("ok", userJSON);
    }

    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource update(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        JSONObject jsonObject = JSONObject.parseObject((String)postBody);
        String response = this.service.update(jsonObject);
        return this.success("ok", response);
    }

    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource delete(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String account = (String)parse.read("$.account", new Predicate[0]);
        String response = this.service.delete(account);
        return this.success("ok", response);
    }
}

