/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.security.service;

import cn.myapps.runtime.rest.security.service.AccessTokenService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.springframework.stereotype.Service;

@Service
public class JwtAccessTokenServiceImpl
implements AccessTokenService {
    private final int TTLMillis = 3600000;

    @Override
    public Boolean checkAccessToken(String accessToken, String secretKey) throws ExpiredJwtException, Exception {
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)secretKey)).parseClaimsJws(accessToken).getBody();
        String secret = claims.getSubject();
        System.out.println("secret->" + secret);
        return true;
    }

    @Override
    public String generateAccessToken(String secret, String secretKey) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)secretKey);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setHeaderParam("typ", (Object)"JWT").setIssuedAt(now).setSubject(secret).signWith(signatureAlgorithm, (Key)signingKey);
        long expMillis = nowMillis + 3600000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp).setNotBefore(now);
        return builder.compact();
    }

    public static void main(String[] args) {
        String token = new JwtAccessTokenServiceImpl().generateAccessToken("12345", "teemlink_obpm");
        System.out.println(token);
    }
}

