/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.security;

import cn.myapps.common.util.Security;
import cn.myapps.runtime.rest.security.service.AccessTokenService;
import cn.myapps.runtime.rest.security.service.JwtAccessTokenServiceImpl;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RestSecurityHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RestSecurityHandlerInterceptor.class);
    @Autowired
    @Qualifier(value="jwtAccessTokenService")
    private AccessTokenService accessTokenService = new JwtAccessTokenServiceImpl();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String login = request.getContextPath() + "/api/runtime/login.*";
        String dingdingLogin = request.getContextPath() + "/api/runtime/dingding/authlogin";
        String syncDataForm = request.getContextPath() + "/api/runtime/synchronization.*";
        String syncOperation = request.getContextPath() + "/runtime/sync/.*";
        String uri = request.getRequestURI();
        if (uri.matches("^" + login) || uri.matches("^" + dingdingLogin) || uri.matches("^" + syncDataForm) || uri.matches("^" + syncOperation) || uri.indexOf("/showjrxml/") >= 0 || uri.indexOf("/getCustomColumnsInfos") >= 0 || uri.indexOf("/accessToken") >= 0 || uri.contains("/components/do-refresh") && "put".equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        try {
            if (uri.indexOf("/rest/") > -1 && this.accessTokenService.checkAccessToken(request.getParameter("accessToken"), "teemlink_obpm").booleanValue()) {
                return true;
            }
            String userId = Security.getUserIdFromToken((HttpServletRequest)request);
            if (userId == null) {
                userId = Security.getDebugUserIdFromToken((HttpServletRequest)request);
                if (userId == null) {
                    return false;
                }
                String token = Security.getToken((String)userId);
                if (Security.getDebugUserExpiresAtFromToken((HttpServletRequest)request) - System.currentTimeMillis() < 3600000L) {
                    Cookie cookie = new Cookie("debugToken", token);
                    cookie.setPath("/");
                    response.addCookie(cookie);
                }
            } else {
                String token = Security.getToken((String)userId);
                if (Security.getUserExpiresAtFromToken((HttpServletRequest)request) - System.currentTimeMillis() < 3600000L) {
                    Cookie cookie = new Cookie("accessToken", token);
                    cookie.setPath("/");
                    response.addCookie(cookie);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return super.preHandle(request, response, handler);
    }

    private void writeErrorJsonMsg(HttpServletResponse response, String msg) throws Exception {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"errcode", (Object)500);
        jsonObject.put((Object)"errmsg", (Object)msg);
        response.getWriter().write(jsonObject.toString());
    }
}

