/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.department.controller;

import cn.myapps.common.controller.Resource;
import cn.myapps.runtime.rest.common.controller.AbstractRESTController;
import cn.myapps.runtime.rest.department.model.Department;
import cn.myapps.runtime.rest.department.service.DepartmentService;
import com.alibaba.fastjson.JSONObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller(value="bpmDepartmentController")
@RequestMapping(path={"/rest/bpm/department"})
public class DepartmentController
extends AbstractRESTController {
    @Autowired
    @Qualifier(value="bpmDepartmentService")
    DepartmentService service;

    @PostMapping(value={"/save"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource save(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        Department dept = this.parseDepartment(postBody);
        String response = this.service.add(dept);
        return this.success("created", response);
    }

    @PostMapping(value={"/find"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource find(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String id = (String)parse.read("$.id", new Predicate[0]);
        Department dept = this.service.find(id);
        JSONObject deptJSON = new JSONObject();
        deptJSON.put("DepartmentInfo", (Object)dept);
        return this.success("ok", deptJSON);
    }

    @PostMapping(value={"/update"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource update(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        JSONObject jsonObject = JSONObject.parseObject((String)postBody);
        String response = this.service.update(jsonObject);
        return this.success("ok", response);
    }

    @PostMapping(value={"/delete"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource delete(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String account = (String)parse.read("$.id", new Predicate[0]);
        String response = this.service.delete(account);
        return this.success("ok", response);
    }

    @PostMapping(value={"/get"})
    @ResponseStatus(value=HttpStatus.OK)
    public Resource get(@RequestParam String accessToken, @RequestBody String postBody) throws Exception {
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String id = (String)parse.read("$.id", new Predicate[0]);
        Collection<Department> dept = this.service.get(id);
        JSONObject deptJSON = new JSONObject();
        deptJSON.put("DepartmentList", dept);
        return this.success("ok", deptJSON);
    }
}

