/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.rest.common.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.SequenceGenerator;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.document.model.PureDocument;
import cn.myapps.runtime.rest.department.model.Department;
import cn.myapps.runtime.rest.user.model.User;
import cn.myapps.runtime.workflow.WorkflowException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestController
public abstract class AbstractRESTController {
    protected static Configuration configuration = Configuration.defaultConfiguration();
    @Autowired
    protected HttpServletRequest request;
    private ParamsTable params;
    private Resource resourceValue;

    public User parseUser(String postBody) {
        if (StringUtils.isBlank((String)postBody)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String userName = (String)parse.read("$.username", new Predicate[0]);
        String account = (String)parse.read("$.account", new Predicate[0]);
        String gender = (String)parse.read("$.gender", new Predicate[0]);
        String mobileNumber = (String)parse.read("$.mobilenumber", new Predicate[0]);
        String email = (String)parse.read("$.email", new Predicate[0]);
        String certificateTypeId = (String)parse.read("$.certificatetypeid", new Predicate[0]);
        String certificateNumber = (String)parse.read("$.certificatenumber", new Predicate[0]);
        String departmentId = (String)parse.read("$.departmentid", new Predicate[0]);
        String order = (String)parse.read("$.order", new Predicate[0]);
        String isTop = (String)parse.read("$.istop", new Predicate[0]);
        String isLeader = (String)parse.read("$.isleader", new Predicate[0]);
        String entryDate = (String)parse.read("$.entrydate", new Predicate[0]);
        LinkedHashMap extend = (LinkedHashMap)parse.read("$.extend", new Predicate[0]);
        String extendStr = extend.toString();
        User user = new User();
        user.setUserName(userName);
        user.setAccount(account);
        user.setGender(gender);
        user.setMobileNumber(mobileNumber);
        user.setEmail(email);
        user.setCertificateTypeId(certificateTypeId);
        user.setCertificateNumber(certificateNumber);
        user.setDepartmentId(departmentId);
        user.setOrder(order);
        user.setIsTop(isTop);
        user.setIsLeader(isLeader);
        user.setEntryDate(entryDate);
        user.setExtend(extendStr);
        return user;
    }

    public Department parseDepartment(String postBody) throws Exception {
        if (StringUtils.isBlank((String)postBody)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String name = (String)parse.read("$.name", new Predicate[0]);
        String parentId = (String)parse.read("$.parentid", new Predicate[0]);
        String order = (String)parse.read("$.order", new Predicate[0]);
        String description = (String)parse.read("$.description", new Predicate[0]);
        String isVirtual = (String)parse.read("$.isvirtual", new Predicate[0]);
        String master = (String)parse.read("$.master", new Predicate[0]);
        String leader = (String)parse.read("$.leader", new Predicate[0]);
        String extend = (String)parse.read("$.extend", new Predicate[0]);
        Department dept = new Department();
        dept.setID(SequenceGenerator.getSequence());
        dept.setName(name);
        dept.setParentId(parentId);
        dept.setOrder(order);
        dept.setDescription(description);
        dept.setIsVirtual(isVirtual);
        dept.setMaster(master);
        dept.setLeader(leader);
        dept.setExtend(extend);
        return dept;
    }

    public PureDocument parseDocument(String postBody, String applicationId, WebUser user) throws Exception {
        Map items;
        String summary;
        if (StringUtils.isBlank((String)postBody)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u5305\u4f53\u5185\u5bb9\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        DocumentContext parse = JsonPath.parse((String)postBody, (Configuration)configuration);
        String id = (String)parse.read("$.id", new Predicate[0]);
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u5305\u4f53id\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        PureDocument doc = (PureDocument)docProcess.doView(id);
        if (doc == null) {
            doc = new PureDocument();
            doc.setId(id);
            doc.setAuthor((IUser)user);
            DepartmentVO defaultDept = (DepartmentVO)AuthTimeServiceManager.departmentRuntimeService().doView(user.getDefaultDepartment());
            if (!StringUtil.isBlank((String)user.getDefaultDepartment())) {
                doc.setAuthorDeptIndex(defaultDept.getIndexCode());
            }
            doc.setDomainid(user.getDomainid());
            doc.setCreated(new Date());
            doc.setIstmp((Object)true);
            doc.setLastmodifier(user.getId());
            doc.setApplicationid(applicationId);
        }
        if (!StringUtils.isBlank((String)(summary = (String)parse.read("$.summary", new Predicate[0])))) {
            doc.setSummary(summary);
        }
        if ((items = (Map)parse.read("$.items", new Predicate[0])) != null) {
            for (Map.Entry entry : items.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Item item = new Item();
                item.setName(key);
                item.setValue(value);
                doc.addItem(item);
            }
        }
        return doc;
    }

    public WebUser getUser() {
        WebUser webUser = null;
        String userId = this.request.getParameter("userCode");
        if (!StringUtils.isBlank((String)userId)) {
            try {
                UserProcess up = AuthTimeServiceManager.userRuntimeService();
                UserVO userVO = up.login(userId);
                if (userVO != null) {
                    webUser = new WebUser((IUser)userVO);
                    WebUser.setWebUser((WebUser)webUser, (HttpServletRequest)this.request);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return webUser;
    }

    public ParamsTable getParams() {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)this.request);
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public ParamsTable getParams(HttpServletRequest request) {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)request);
            String sessionId = request.getSession().getId();
            this.params.setSessionid(sessionId);
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    protected Resource success(String errmsg, Object data) {
        return new Resource(0, errmsg, data, null);
    }

    protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, null, errors);
    }

    public Resource getResourceValue() {
        return this.resourceValue;
    }

    public void setResourceValue(Resource resourceValue) {
        this.resourceValue = resourceValue;
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Resource resourceNotFound(ResourceNotFoundException e) {
        return this.error(404, "Not Found", null);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource error(RuntimeException e) {
        e.printStackTrace();
        return this.error(500, "Server Error:" + e.getMessage(), null);
    }

    @ExceptionHandler(value={OBPMValidateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource serverError(OBPMValidateException e) {
        e.printStackTrace();
        return this.error(500, "Server Error:" + e.getMessage(), null);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
        return this.error(40035, "\u4e0d\u5408\u6cd5\u7684\u53c2\u6570", null);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource requestbodyError(PathNotFoundException e) {
        e.printStackTrace();
        return this.error(406, "\u8bf7\u6c42\u5305\u4f53\u53c2\u6570\u51fa\u9519", null);
    }

    @ExceptionHandler(value={WorkflowException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource WorkflowException(WorkflowException e) {
        return this.error(50001, e.getMessage(), null);
    }

    static {
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
    }
}

