/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.report.service;

import cn.myapps.common.CommonDAO;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.dao.report.FileSystemReportDAO;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.CommonException;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.view.Column;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.report.engine.ReportEngine;
import cn.myapps.runtime.common.service.AbstractRunTimeProcessBean;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.Tab;
import cn.myapps.runtime.dynaform.form.ejb.TabField;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.report.model.DRDataSource;
import cn.myapps.runtime.report.service.ReportService;
import cn.myapps.runtime.report.service.RuntimeOpenQueryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
extends AbstractRunTimeProcessBean<Report>
implements ReportService {
    private static final long serialVersionUID = 712365638612148766L;
    @Autowired
    private RuntimeOpenQueryService runtimeOpenQueryService;
    private DataSourceDesignTimeService dataSourceService;

    public ReportServiceImpl() {
        try {
            this.dataSourceService = DesignTimeServiceManager.dataSourceDesignTimeService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getQueryString(String js, AbstractView view, ParamsTable params, IUser user) throws Exception {
        StringBuffer label = new StringBuffer();
        label.append("VIEW(").append(view.getId()).append(")." + view.getName()).append(".FilterScript");
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)view.getApplicationid());
        runner.initBSFManager(null, params, user, new ArrayList());
        Object result = runner.run((RunnableMeta)view, label.toString(), js);
        if (result != null && result instanceof String) {
            return (String)result;
        }
        return null;
    }

    protected CommonDAO<Report> getDao() {
        return new FileSystemReportDAO(Report.class);
    }

    public String getPathSuffix() {
        return "report";
    }

    public String getFileSuffix() {
        return "report";
    }

    @Override
    public String getQueryString(ParamsTable params, IUser user, Document sDoc, List<Object> sqlParamList, Report report) throws Exception {
        String sql = "";
        StringBuffer label = new StringBuffer();
        label.append("VIEW(").append(report.getId()).append(")." + report.getName()).append(".SqlFilterScript");
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)report.getApplicationid());
        runner.initBSFManager((IDocument)sDoc, params, user, new ArrayList());
        JavaScriptFactory.clear();
        Object object = runner.run((RunnableMeta)report, label.toString(), report.getDataSourceSqlScript());
        if (object != null && object instanceof String) {
            sql = (String)object;
        } else if (object != null && object instanceof Map) {
            HashMap sqlMap = (HashMap)object;
            sql = (String)sqlMap.get("sql");
            if (sqlMap.get("sqlParamList") instanceof List) {
                sqlParamList.addAll((List)sqlMap.get("sqlParamList"));
            }
        }
        return sql;
    }

    @Override
    public String generateDynamicReportByViewDataSource(Report report, Collection<Document> data, ParamsTable params, IUser user) throws Exception {
        Report viewDataSourceReport = this.getViewDataSourceReport(report, data, params, user);
        ReportEngine engine = ReportEngine.getInstance();
        String path = engine.exportHtml(viewDataSourceReport, params, user);
        return path;
    }

    @Override
    public String generateExcelByViewDataSource(Report report, Collection<Document> data, ParamsTable params, IUser user) throws Exception {
        Report viewDataSourceReport = this.getViewDataSourceReport(report, data, params, user);
        ReportEngine engine = ReportEngine.getInstance();
        String path = engine.exportExcel(viewDataSourceReport, params, user);
        return path;
    }

    @Override
    public String generatePdfByViewDataSource(Report report, Collection<Document> data, ParamsTable params, IUser user) throws Exception {
        Report viewDataSourceReport = this.getViewDataSourceReport(report, data, params, user);
        ReportEngine engine = ReportEngine.getInstance();
        String path = engine.exportPdf(viewDataSourceReport, params, user);
        return path;
    }

    @Override
    public String generateExcelByProcedure(Report report, IUser user, ParamsTable params) throws Exception {
        ReportEngine engine = ReportEngine.getInstance();
        String applicationId = report.getApplicationid();
        String procedureScript = report.getProcedureScript();
        String dataSourceName = report.getDataSourceName();
        DataSource dataSource = this.dataSourceService.getDataSourceByName(dataSourceName, applicationId);
        Document searchDocument = null;
        String searchFormId = report.getDataSourceSearchForm();
        if (!StringUtils.isBlank((String)searchFormId)) {
            FormDesignTimeService fs = DesignTimeServiceManager.formDesignTimeService();
            Form searchForm = fs.doView(searchFormId);
            searchDocument = searchForm.createDocument(params, user);
        }
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
        runner.initBSFManager((IDocument)searchDocument, params, user, new ArrayList());
        JavaScriptFactory.clear();
        Object object = runner.run((RunnableMeta)report, "Report[" + report.getName() + "]-" + report.getId(), procedureScript);
        if (object instanceof String) {
            procedureScript = (String)object;
        }
        this.runtimeOpenQueryService.generateDynamicReportDataSourceByProcedure(report, procedureScript, dataSource.getDriverClass(), dataSource.getUrl(), dataSource.getUsername(), dataSource.getPassword());
        String path = engine.exportExcel(report, params, user);
        return path;
    }

    @Override
    public List<QueryColumnInfo> getCustomColumnsInfos(String customDataIscript, Report report, ParamsTable params, IUser user, String applicationId) throws Exception {
        if (report == null) {
            report = new Report();
            report.setId("TEMP_REPORT_ID");
            report.setName("TEMP_REPORT_NAME");
            report.setApplicationid(applicationId);
        }
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)report.getApplicationid());
        runner.initBSFManager(null, params, user, new ArrayList());
        JavaScriptFactory.clear();
        Object object = runner.run((RunnableMeta)report, "Report[" + report.getName() + "]-" + report.getId(), customDataIscript);
        ArrayList<QueryColumnInfo> columnInfos = new ArrayList<QueryColumnInfo>();
        if (object instanceof DRDataSource) {
            DRDataSource drDataSource = (DRDataSource)object;
            List<Map<String, Object>> values = drDataSource.getValues();
            Iterator<Map<String, Object>> iterator = values.iterator();
            if (iterator.hasNext()) {
                Map<String, Object> m = iterator.next();
                for (String key : m.keySet()) {
                    QueryColumnInfo columnInfo = new QueryColumnInfo();
                    String columnName = key;
                    String className = m.get(key).getClass().getName();
                    columnInfo.setColumnClassName(className);
                    columnInfo.setColumnTypeName(className);
                    columnInfo.setColumnLabel(columnName);
                    columnInfo.setColumnName(columnName);
                    columnInfos.add(columnInfo);
                }
            }
        } else {
            throw new Exception("Report[" + report.getName() + "]\u811a\u672c\u8fd0\u7b97\u7ed3\u679c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8fd4\u56deDRDataSource\u7c7b\u578b\uff01");
        }
        return columnInfos;
    }

    @Override
    public String generateDynamicReportByCustomDataSource(Report report, ParamsTable params, IUser user) throws Exception {
        ReportEngine engine = ReportEngine.getInstance();
        String customScript = report.getDataSourceCustomScript();
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)report.getApplicationid());
        runner.initBSFManager(null, params, user, new ArrayList());
        JavaScriptFactory.clear();
        Object object = runner.run((RunnableMeta)report, "Report[" + report.getName() + "]-" + report.getId(), customScript);
        if (object instanceof DRDataSource) {
            DRDataSource drDataSource = (DRDataSource)object;
            DRDataSource dataSource = new DRDataSource(drDataSource.getColumns());
            List<Map<String, Object>> values = drDataSource.getValues();
            for (Map<String, Object> value : values) {
                dataSource.add(value.values().toArray());
            }
            report.setDrDataSource((Object)dataSource);
            List<QueryColumnInfo> columnInfos = this.getCustomColumnsInfos(customScript, report, params, user, report.getApplicationid());
            if (columnInfos.size() > 0) {
                ArrayList<TextColumnBuilder> colms = new ArrayList<TextColumnBuilder>();
                for (QueryColumnInfo queryColumnInfo : columnInfos) {
                    String columnClassName = queryColumnInfo.getColumnClassName();
                    colms.add(DynamicReports.col.column(queryColumnInfo.getColumnLabel(), queryColumnInfo.getColumnName(), DataTypes.detectType((String)columnClassName)));
                }
                report.setReportColumnInfos(colms);
            } else {
                report.setReportColumnInfos(null);
            }
        } else {
            throw new Exception("Report[" + report.getName() + "]\u811a\u672c\u8fd0\u7b97\u7ed3\u679c\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8fd4\u56deDRDataSource\u7c7b\u578b\uff01");
        }
        String path = engine.exportHtml(report, params, user);
        return path;
    }

    @Override
    public String generateDynamicReportByFormDataSource(Report report, ParamsTable params, IUser user, String docid) throws Exception {
        Report formDataSourceReport = this.getFormData(report, params, user, docid);
        ReportEngine engine = ReportEngine.getInstance();
        String path = engine.exportHtml(formDataSourceReport, params, user);
        return path;
    }

    @Override
    public String generatePdfByFormDataSource(Report report, ParamsTable params, IUser user, String docid) throws Exception {
        Report formDataSourceReport = this.getFormData(report, params, user, docid);
        ReportEngine engine = ReportEngine.getInstance();
        String path = engine.exportPdf(formDataSourceReport, params, user);
        return path;
    }

    public Report getFormData(Report report, ParamsTable params, IUser user, String docid) throws Exception {
        FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
        Form form = formService.doView(report.getFormId());
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)report.getApplicationid());
        Document doc = (Document)dProcess.doView(docid);
        if (doc == null) {
            doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docid, (IUser)user);
        } else {
            doc.setSubDocuments(doc.getChilds());
            doc = form.recalculateDocument(doc, params, user);
        }
        if (doc == null) {
            doc = new Document();
        }
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)form.getApplicationid());
        Collection fields = form.getFields();
        LinkedList<String> nameList = new LinkedList<String>();
        LinkedList<String> data = new LinkedList<String>();
        for (FormField formField : fields) {
            if (formField instanceof TabField) {
                Collection tabs = ((TabField)formField).getTabs();
                if (tabs == null || tabs.size() <= 0) continue;
                for (Tab tab : tabs) {
                    Form tabForm = formService.doView(tab.getFormId());
                    tabForm.inited();
                    Collection tabFields = tabForm.getFields();
                    for (FormField field : tabFields) {
                        nameList.add(field.getName());
                        data.add(field.getText(doc, runner, user));
                    }
                }
                continue;
            }
            nameList.add(formField.getName());
            data.add(formField.getText(doc, runner, user));
        }
        DRDataSource drDataSource = new DRDataSource(nameList.toArray(new String[fields.size()]));
        drDataSource.add(data.toArray());
        report.setDrDataSource((Object)drDataSource);
        List<QueryColumnInfo> columnInfos = this.getFormColumnsInfos(report.getFormId());
        if (columnInfos.size() > 0) {
            ArrayList<TextColumnBuilder> colms = new ArrayList<TextColumnBuilder>();
            for (QueryColumnInfo queryColumnInfo : columnInfos) {
                String columnClassName = queryColumnInfo.getColumnClassName();
                colms.add(DynamicReports.col.column(queryColumnInfo.getColumnLabel(), queryColumnInfo.getColumnName(), DataTypes.detectType((String)columnClassName)));
            }
            report.setReportColumnInfos(colms);
        } else {
            report.setReportColumnInfos(null);
        }
        return report;
    }

    @Override
    public List<QueryColumnInfo> getViewColumnsInfos(String viewId) throws Exception {
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(viewId);
        ArrayList<QueryColumnInfo> columnInfos = new ArrayList<QueryColumnInfo>();
        List columns = view.getColumns();
        for (Column column : columns) {
            if (!column.getType().equals("COLUMN_TYPE_FIELD")) continue;
            QueryColumnInfo columnInfo = new QueryColumnInfo();
            if (column.getType().equals("COLUMN_TYPE_FIELD")) {
                columnInfo.setColumnName(column.getFormField().getName());
                columnInfo.setColumnLabel(column.getFormField().getName());
                columnInfo.setColumnTypeName(column.getFormField().getFieldtype());
            } else {
                columnInfo.setColumnName(column.getName());
                columnInfo.setColumnLabel(column.getName());
                columnInfo.setColumnTypeName("COLUMN_TYPE_SCRIPT");
            }
            System.out.println(columnInfo.getColumnTypeName());
            columnInfo.setColumnClassName("java.lang.String");
            columnInfos.add(columnInfo);
        }
        return columnInfos;
    }

    @Override
    public List<QueryColumnInfo> getQueryColumnInfos(String sql, String dataSourceName, String applicationId, IUser user, Report report, ParamsTable params) throws Exception {
        List<QueryColumnInfo> resultQueryColumnInfos = null;
        DataSource dataSource = this.dataSourceService.getDataSourceByName(dataSourceName, applicationId);
        if (dataSource == null) {
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a!");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        System.out.println("dataSourceFileName:" + dataSource.getUri());
        System.out.println("dataSourceName:" + dataSourceName);
        System.out.println("url:" + dataSource.getUrl());
        if (report == null) {
            report = new Report();
            report.setId("TEMP_REPORT_ID");
            report.setName("TEMP_REPORT_NAME");
            report.setApplicationid(applicationId);
        }
        report.setDataSourceSqlScript(sql);
        ArrayList<Object> sqlParamList = new ArrayList<Object>();
        String finalSql = this.getQueryString(params, user, null, sqlParamList, report);
        if (StringUtils.isBlank((String)finalSql)) {
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6700\u7ec8\u7684\u67e5\u8be2sql\u4e3a\u7a7a!");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        resultQueryColumnInfos = this.runtimeOpenQueryService.getQueryColumnInfos(finalSql, dataSource.getDriverClass(), dataSource.getUrl(), dataSource.getUsername(), dataSource.getPassword());
        return resultQueryColumnInfos;
    }

    @Override
    public List<QueryColumnInfo> getFormColumnsInfos(String formId) throws Exception {
        FormDesignTimeService fProcess = DesignTimeServiceManager.formDesignTimeService();
        Form form = fProcess.doView(formId);
        form.inited();
        Collection fields = form.getFields();
        ArrayList<QueryColumnInfo> queryColumnInfos = new ArrayList<QueryColumnInfo>();
        for (FormField field : fields) {
            if (field instanceof TabField) {
                Collection tabs = ((TabField)field).getTabs();
                if (tabs == null || tabs.size() <= 0) continue;
                for (Tab tab : tabs) {
                    if (!tab.getType().equals("form")) continue;
                    Form tabForm = fProcess.doView(tab.getFormId());
                    tabForm.inited();
                    Collection tabFields = tabForm.getFields();
                    for (FormField formField : tabFields) {
                        QueryColumnInfo queryColumnInfo = new QueryColumnInfo();
                        queryColumnInfo.setColumnName(formField.getName());
                        queryColumnInfo.setColumnLabel(formField.getName());
                        queryColumnInfo.setColumnTypeName(formField.getFieldtype());
                        queryColumnInfo.setColumnClassName("java.lang.String");
                        queryColumnInfos.add(queryColumnInfo);
                    }
                }
                continue;
            }
            QueryColumnInfo queryColumnInfo = new QueryColumnInfo();
            queryColumnInfo.setColumnName(field.getName());
            queryColumnInfo.setColumnLabel(field.getName());
            queryColumnInfo.setColumnTypeName(field.getFieldtype());
            queryColumnInfo.setColumnClassName("java.lang.String");
            queryColumnInfos.add(queryColumnInfo);
        }
        return queryColumnInfos;
    }

    @Override
    public String generateDynamicReportByProcedure(Report report, IUser user, ParamsTable params) throws Exception {
        ReportEngine engine = ReportEngine.getInstance();
        String applicationId = report.getApplicationid();
        String procedureScript = report.getProcedureScript();
        String dataSourceName = report.getDataSourceName();
        DataSource dataSource = this.dataSourceService.getDataSourceByName(dataSourceName, applicationId);
        Document searchDocument = null;
        String searchFormId = report.getDataSourceSearchForm();
        if (!StringUtils.isBlank((String)searchFormId)) {
            FormDesignTimeService fs = DesignTimeServiceManager.formDesignTimeService();
            Form searchForm = fs.doView(searchFormId);
            searchDocument = searchForm.createDocument(params, user);
        }
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
        runner.initBSFManager((IDocument)searchDocument, params, user, new ArrayList());
        JavaScriptFactory.clear();
        Object object = runner.run((RunnableMeta)report, "Report[" + report.getName() + "]-" + report.getId(), procedureScript);
        if (object instanceof String) {
            procedureScript = (String)object;
        }
        this.runtimeOpenQueryService.generateDynamicReportDataSourceByProcedure(report, procedureScript, dataSource.getDriverClass(), dataSource.getUrl(), dataSource.getUsername(), dataSource.getPassword());
        String path = engine.exportHtml(report, params, user);
        if (StringUtil.isBlank((String)path)) {
            return "\u4ea7\u751f\u62a5\u8868\u5931\u8d25!";
        }
        return path;
    }

    @Override
    public String generateDynamicReportByReportId(String reportId, IUser user, ParamsTable params) throws Exception {
        Report sqlDataSourceReport;
        ReportEngine engine = ReportEngine.getInstance();
        String path = engine.exportHtml(sqlDataSourceReport = this.getSqlDataSourceReport(reportId, user, params), params, user);
        if (StringUtil.isBlank((String)path)) {
            return "\u4ea7\u751f\u62a5\u8868\u5931\u8d25!";
        }
        return path;
    }

    @Override
    public String generateExcelByReportId(String reportId, IUser user, ParamsTable params) throws Exception {
        ReportEngine engine = ReportEngine.getInstance();
        Report sqlDataSourceReport = this.getSqlDataSourceReport(reportId, user, params);
        String path = engine.exportExcel(sqlDataSourceReport, params, user);
        return path;
    }

    @Override
    public String generatePdfByReportId(String reportId, IUser user, ParamsTable params) throws Exception {
        ReportEngine engine = ReportEngine.getInstance();
        Report sqlDataSourceReport = this.getSqlDataSourceReport(reportId, user, params);
        String path = engine.exportPdf(sqlDataSourceReport, params, user);
        return path;
    }

    private Report getSqlDataSourceReport(String reportId, IUser user, ParamsTable params) throws Exception {
        Report report = (Report)this.doView(reportId);
        String applicationId = report.getApplicationid();
        String dataSourceName = report.getDataSourceName();
        DataSource dataSource = this.dataSourceService.getDataSourceByName(dataSourceName, applicationId);
        System.out.println("dataSourceFileName:" + dataSource.getUri());
        System.out.println("dataSourceName:" + dataSourceName);
        System.out.println("url:" + dataSource.getUrl());
        Document searchDocument = null;
        String searchFormId = report.getDataSourceSearchForm();
        if (!StringUtils.isBlank((String)searchFormId)) {
            FormDesignTimeService fs = DesignTimeServiceManager.formDesignTimeService();
            Form searchForm = fs.doView(searchFormId);
            searchDocument = searchForm.createDocument(params, user);
        }
        ArrayList<Object> sqlParamList = new ArrayList<Object>();
        String finalSql = this.getQueryString(params, user, searchDocument, sqlParamList, report);
        this.runtimeOpenQueryService.generateDynamicReportDataSource(report, finalSql, dataSource.getDriverClass(), dataSource.getUrl(), dataSource.getUsername(), dataSource.getPassword());
        return report;
    }

    private Report getViewDataSourceReport(Report report, Collection<Document> data, ParamsTable params, IUser user) throws Exception {
        String viewId = report.getViewId();
        ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
        AbstractView view = vProcess.doView(viewId);
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)view.getApplicationid());
        LinkedList items = new LinkedList();
        HashMap itemsData = new HashMap();
        LinkedList<String> columnNameList = new LinkedList<String>();
        List viewColumns = view.getColumns();
        for (Object column : viewColumns) {
            String name = column.getFieldName();
            columnNameList.add(name);
        }
        DRDataSource drDataSource = new DRDataSource(columnNameList.toArray(new String[viewColumns.size()]));
        for (Document doc : data) {
            LinkedList list = new LinkedList();
            List columns = view.getColumns();
            for (Column column : columns) {
                try {
                    String columnValue;
                    runner.initBSFManager((IDocument)doc, params, user, new ArrayList());
                    FormField field = column.getFormField();
                    Map map = field.toAttributes(doc, runner, user, 6);
                    String value = column.getText(doc, runner, user);
                    if (column.getType().equals("COLUMN_TYPE_SCRIPT") || column.getShowType() != "00" && (field.getClass().getSimpleName().equals("TreeDepartmentField") || field.getClass().getSimpleName().equals("DepartmentField") || field.getClass().getSimpleName().equals("UserField"))) {
                        map.remove("value");
                        map.put("value", value);
                    }
                    map.put("buttonType", StringUtil.isBlank((String)column.getButtonType()) ? "" : column.getButtonType());
                    map.put("templateFromId", StringUtil.isBlank((String)column.getTemplateForm()) ? "" : column.getTemplateForm());
                    if (!StringUtil.isBlank((String)column.getDecimalsNum())) {
                        String columnName;
                        switch (columnName = column.getFieldName()) {
                            case "$StateLabel": {
                                try {
                                    String stateLabel;
                                    String json = value.substring(1, value.length() - 1);
                                    JSONObject stateLabelJson = JSONObject.fromObject((Object)json);
                                    value = stateLabel = stateLabelJson.getJSONArray("nodes").getJSONObject(0).getString("stateLabel");
                                    map.put("value", value);
                                }
                                catch (Exception json) {}
                                break;
                            }
                            case "$PrevAuditNode": {
                                String prevAuditNode;
                                value = value.substring(1, value.length() - 1);
                                JSONObject prevAuditNodeJson = JSONObject.fromObject((Object)value);
                                value = prevAuditNode = prevAuditNodeJson.getString("prevAuditNode");
                                map.put("value", value);
                                break;
                            }
                            case "$PrevAuditUser": {
                                String prevAuditUser;
                                value = value.substring(1, value.length() - 1);
                                JSONObject prevAuditUserJson = JSONObject.fromObject((Object)value);
                                value = prevAuditUser = prevAuditUserJson.getString("prevAuditUser");
                                map.put("value", value);
                            }
                        }
                    }
                    if ((columnValue = (String)map.get("value")) == null || columnValue.equals("")) {
                        Item item = doc.findItem(field.getName());
                        if (item != null) {
                            columnValue = item.getTextvalue();
                        }
                        map.put("value", columnValue);
                    }
                    list.add(map.get("value"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            drDataSource.add(list.toArray());
        }
        report.setDrDataSource((Object)drDataSource);
        List<QueryColumnInfo> columnInfos = this.getViewColumnsInfos(viewId);
        if (columnInfos.size() > 0) {
            ArrayList<TextColumnBuilder> colms = new ArrayList<TextColumnBuilder>();
            for (QueryColumnInfo queryColumnInfo : columnInfos) {
                String columnClassName = queryColumnInfo.getColumnClassName();
                colms.add(DynamicReports.col.column(queryColumnInfo.getColumnLabel(), queryColumnInfo.getColumnName(), DataTypes.detectType((String)columnClassName)));
            }
            report.setReportColumnInfos(colms);
        } else {
            report.setReportColumnInfos(null);
        }
        return report;
    }

    public List<Report> list(String parentId, String pathSuffix, String fileSuffix, String name) throws Exception {
        return null;
    }
}

