/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.report.model;

import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;

public class JRBeanCollectionDataSource
extends JRAbstractBeanDataSource {
    private Collection<?> data;
    private Iterator<?> iterator;
    private Object currentBean;

    public JRBeanCollectionDataSource(Collection<?> beanCollection) {
        this(beanCollection, true);
    }

    public JRBeanCollectionDataSource(Collection<?> beanCollection, boolean isUseFieldDescription) {
        super(isUseFieldDescription);
        this.data = beanCollection;
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }

    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null) {
            hasNext = this.iterator.hasNext();
            if (hasNext) {
                this.currentBean = this.iterator.next();
            } else {
                this.moveFirst();
            }
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.getFieldValue(this.currentBean, field);
    }

    public void moveFirst() {
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }

    public Collection<?> getData() {
        return this.data;
    }

    public int getRecordCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public JRBeanCollectionDataSource cloneDataSource() {
        return new JRBeanCollectionDataSource(this.data);
    }
}

