/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.report.dao;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.CommonException;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.report.dao.RuntimeOpenQueryDao;
import cn.myapps.runtime.report.model.DRDataSource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import org.springframework.stereotype.Component;

@Component
public class RuntimeOpenQueryDaoJdbcImpl
implements RuntimeOpenQueryDao {
    @Override
    public List<QueryColumnInfo> getQueryColumnInfos(String sql, String dbDriver, String dbUrl, String dbUser, String dbPass) throws CommonException {
        if (StringUtil.isBlank((String)dbDriver) || StringUtil.isBlank((String)dbUrl) || StringUtil.isBlank((String)dbUser)) {
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6570\u636e\u6e90\u8fde\u63a5\u4fe1\u606f\u4e0d\u5168\uff01");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        ArrayList<QueryColumnInfo> resultColumnList = new ArrayList<QueryColumnInfo>();
        Connection conn = null;
        try {
            conn = PersistenceUtils.getDruidDataSource((String)"RuntimeOpenQueryDaoJdbcImpl", (String)dbUser, (String)dbPass, (String)dbDriver, (String)dbUrl, (String)"100", (String)"3000").getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6267\u884csql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        try {
            ResultSetMetaData data = rs.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                int typeValue;
                String columnName = data.getColumnName(i);
                String columnTypeName = data.getColumnTypeName(i);
                String columnClassName = data.getColumnClassName(i);
                String columnLabel = data.getColumnLabel(i);
                if (columnClassName.equals("java.sql.Timestamp") || columnClassName.equals("java.sql.Date")) {
                    columnClassName = "java.util.Date";
                }
                if ((typeValue = data.getColumnType(i)) == 2005 || typeValue == 2004 || typeValue == -4 || typeValue == 2000 || typeValue == 2009) continue;
                QueryColumnInfo queryColumnInfo = new QueryColumnInfo();
                queryColumnInfo.setColumnName(columnName);
                queryColumnInfo.setColumnTypeName(columnTypeName);
                queryColumnInfo.setColumnClassName(columnClassName);
                queryColumnInfo.setColumnLabel(columnLabel);
                resultColumnList.add(queryColumnInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u89e3\u6790\u5217\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        try {
            stmt.close();
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        return resultColumnList;
    }

    @Override
    public List<QueryColumnInfo> getProcedureColumnsInfos(String procedureScript, String dbDriver, String dbUrl, String dbUser, String dbPass) throws Exception {
        if (StringUtil.isBlank((String)dbDriver) || StringUtil.isBlank((String)dbUrl) || StringUtil.isBlank((String)dbUser)) {
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6570\u636e\u6e90\u8fde\u63a5\u4fe1\u606f\u4e0d\u5168\uff01");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        ArrayList<QueryColumnInfo> resultColumnList = new ArrayList<QueryColumnInfo>();
        Connection conn = null;
        try {
            conn = PersistenceUtils.getDruidDataSource((String)"RuntimeOpenQueryDaoJdbcImpl", (String)dbUser, (String)dbPass, (String)dbDriver, (String)dbUrl, (String)"100", (String)"3000").getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        Statement statement = null;
        ResultSet rs = null;
        Map<Integer, Object> map = null;
        try {
            String proce = "net.sourceforge.jtds.jdbc.Driver".equals(dbDriver) ? this.parseProcedureInSqlServer(procedureScript) : this.parseProcedure(procedureScript);
            statement = conn.prepareCall(proce);
            if (proce.indexOf(40) > -1 && proce.indexOf(41) > -1) {
                if ("oracle.jdbc.driver.OracleDriver".equals(dbDriver)) {
                    map = this.parseParametersInOracle((CallableStatement)statement, procedureScript, new ParamsTable(), 1, Integer.MAX_VALUE, null);
                } else {
                    this.parseParameters((CallableStatement)statement, procedureScript, new ParamsTable(), 1, Integer.MAX_VALUE, null);
                }
            }
            boolean re = statement.execute();
            if ("oracle.jdbc.driver.OracleDriver".equals(dbDriver)) {
                if (map != null && map.size() > 0) {
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        if (!"package".equals(entry.getValue())) continue;
                        rs = (ResultSet)statement.getObject((Integer)entry.getKey());
                    }
                }
            } else {
                rs = statement.getResultSet();
            }
            ResultSetMetaData data = rs.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                int typeValue;
                String columnName = data.getColumnName(i);
                String columnTypeName = data.getColumnTypeName(i);
                String columnClassName = data.getColumnClassName(i);
                String columnLabel = data.getColumnLabel(i);
                if (columnClassName.equals("java.sql.Timestamp") || columnClassName.equals("java.sql.Date")) {
                    columnClassName = "java.util.Date";
                }
                if ((typeValue = data.getColumnType(i)) == 2005 || typeValue == 2004 || typeValue == -4 || typeValue == 2000 || typeValue == 2009) continue;
                QueryColumnInfo queryColumnInfo = new QueryColumnInfo();
                queryColumnInfo.setColumnName(columnName);
                queryColumnInfo.setColumnTypeName(columnTypeName);
                queryColumnInfo.setColumnClassName(columnClassName);
                queryColumnInfo.setColumnLabel(columnLabel);
                resultColumnList.add(queryColumnInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6267\u884csql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        finally {
            statement.close();
            rs.close();
            conn.close();
        }
        return resultColumnList;
    }

    @Override
    public void generateDynamicReportDataSource(Report report, String sql, String dbDriver, String dbUrl, String dbUser, String dbPass) throws CommonException {
        if (StringUtil.isBlank((String)dbDriver) || StringUtil.isBlank((String)dbUrl) || StringUtil.isBlank((String)dbUser)) {
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6570\u636e\u6e90\u8fde\u63a5\u4fe1\u606f\u4e0d\u5168\uff01");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        Connection conn = null;
        try {
            conn = PersistenceUtils.getDruidDataSource((String)"RuntimeOpenQueryDaoJdbcImpl", (String)dbUser, (String)dbPass, (String)dbDriver, (String)dbUrl, (String)"100", (String)"3000").getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6267\u884csql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        try {
            ArrayList<Object> columnDatas;
            int typeValue;
            ArrayList<QueryColumnInfo> columnList = new ArrayList<QueryColumnInfo>();
            ArrayList<String> columnNameList = new ArrayList<String>();
            ResultSetMetaData metaDatas = rs.getMetaData();
            int colCount = metaDatas.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                String columnName = metaDatas.getColumnName(i);
                String columnTypeName = metaDatas.getColumnTypeName(i);
                String columnClassName = metaDatas.getColumnClassName(i);
                String columnLabel = metaDatas.getColumnLabel(i);
                typeValue = metaDatas.getColumnType(i);
                if (typeValue == 2005 || typeValue == 2004 || typeValue == -4 || typeValue == 2000 || typeValue == 2009) continue;
                QueryColumnInfo queryColumnInfo = new QueryColumnInfo();
                for (QueryColumnInfo qc : columnList) {
                    if (!qc.getColumnName().equals(columnName)) continue;
                    columnName = columnName + "1";
                }
                queryColumnInfo.setColumnName(columnName);
                queryColumnInfo.setColumnTypeName(columnTypeName);
                queryColumnInfo.setColumnClassName(columnClassName);
                queryColumnInfo.setColumnLabel(columnLabel);
                columnList.add(queryColumnInfo);
                columnNameList.add(columnName);
            }
            String[] columns = new String[columnNameList.size()];
            columnNameList.toArray(columns);
            DRDataSource drDataSource = new DRDataSource(columns);
            boolean hasResultDatas = false;
            while (rs.next()) {
                columnDatas = new ArrayList<Object>();
                for (int i = 1; i <= colCount; ++i) {
                    typeValue = metaDatas.getColumnType(i);
                    if (typeValue == 2005 || typeValue == 2004 || typeValue == -4 || typeValue == 2000 || typeValue == 2009) continue;
                    columnDatas.add(rs.getObject(i));
                }
                drDataSource.add(columnDatas.toArray());
                hasResultDatas = true;
            }
            if (hasResultDatas) {
                report.setDrDataSource((Object)drDataSource);
            } else {
                columnDatas = new ArrayList();
                drDataSource.add(columnDatas.toArray());
                report.setDrDataSource((Object)drDataSource);
            }
            if (columnList.size() > 0) {
                ArrayList<TextColumnBuilder> colms = new ArrayList<TextColumnBuilder>();
                for (QueryColumnInfo queryColumnInfo : columnList) {
                    String columnClassName = queryColumnInfo.getColumnClassName();
                    if (columnClassName.equals("java.sql.Timestamp") || columnClassName.equals("java.sql.Date")) {
                        columnClassName = "java.util.Date";
                    } else if (columnClassName.equals("[B")) {
                        columnClassName = "java.lang.String";
                    }
                    colms.add(DynamicReports.col.column(queryColumnInfo.getColumnLabel(), queryColumnInfo.getColumnName(), DataTypes.detectType((String)columnClassName)));
                }
                report.setReportColumnInfos(colms);
            } else {
                report.setReportColumnInfos(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u521b\u5efaDRDataSource\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        try {
            stmt.close();
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
    }

    @Override
    public void generateDynamicReportDataSourceByProcedure(Report report, String procedureScript, String dbDriver, String dbUrl, String dbUser, String dbPass) throws Exception {
        if (StringUtil.isBlank((String)dbDriver) || StringUtil.isBlank((String)dbUrl) || StringUtil.isBlank((String)dbUser)) {
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6570\u636e\u6e90\u8fde\u63a5\u4fe1\u606f\u4e0d\u5168\uff01");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        Connection conn = null;
        try {
            conn = PersistenceUtils.getDruidDataSource((String)"RuntimeOpenQueryDaoJdbcImpl", (String)dbUser, (String)dbPass, (String)dbDriver, (String)dbUrl, (String)"100", (String)"3000").getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
        CallableStatement stmt = null;
        ResultSet rs = null;
        Map<Integer, Object> map = null;
        try {
            ArrayList<Object> columnDatas;
            int typeValue;
            String proce = "net.sourceforge.jtds.jdbc.Driver".equals(dbDriver) ? this.parseProcedureInSqlServer(procedureScript) : this.parseProcedure(procedureScript);
            stmt = conn.prepareCall(proce);
            if (proce.indexOf(40) > -1 && proce.indexOf(41) > -1) {
                if ("oracle.jdbc.driver.OracleDriver".equals(dbDriver)) {
                    map = this.parseParametersInOracle(stmt, procedureScript, new ParamsTable(), 1, Integer.MAX_VALUE, null);
                } else {
                    this.parseParameters(stmt, procedureScript, new ParamsTable(), 1, Integer.MAX_VALUE, null);
                }
            }
            boolean re = stmt.execute();
            if ("oracle.jdbc.driver.OracleDriver".equals(dbDriver)) {
                if (map != null && map.size() > 0) {
                    Set set = map.entrySet();
                    for (Map.Entry entry : set) {
                        if (!"package".equals(entry.getValue())) continue;
                        rs = (ResultSet)stmt.getObject((Integer)entry.getKey());
                    }
                }
            } else {
                rs = stmt.getResultSet();
            }
            ArrayList<QueryColumnInfo> columnList = new ArrayList<QueryColumnInfo>();
            ArrayList<String> columnNameList = new ArrayList<String>();
            ResultSetMetaData metaDatas = rs.getMetaData();
            int colCount = metaDatas.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                String columnName = metaDatas.getColumnName(i);
                String columnTypeName = metaDatas.getColumnTypeName(i);
                String columnClassName = metaDatas.getColumnClassName(i);
                String columnLabel = metaDatas.getColumnLabel(i);
                typeValue = metaDatas.getColumnType(i);
                if (typeValue == 2005 || typeValue == 2004 || typeValue == -4 || typeValue == 2000 || typeValue == 2009) continue;
                QueryColumnInfo queryColumnInfo = new QueryColumnInfo();
                queryColumnInfo.setColumnName(columnName);
                queryColumnInfo.setColumnTypeName(columnTypeName);
                queryColumnInfo.setColumnClassName(columnClassName);
                queryColumnInfo.setColumnLabel(columnLabel);
                columnList.add(queryColumnInfo);
                columnNameList.add(columnName);
            }
            String[] columns = new String[columnNameList.size()];
            columnNameList.toArray(columns);
            DRDataSource drDataSource = new DRDataSource(columns);
            boolean hasResultDatas = false;
            while (rs.next()) {
                columnDatas = new ArrayList<Object>();
                for (int i = 1; i <= colCount; ++i) {
                    typeValue = metaDatas.getColumnType(i);
                    if (typeValue == 2005 || typeValue == 2004 || typeValue == -4 || typeValue == 2000 || typeValue == 2009) continue;
                    columnDatas.add(rs.getObject(i));
                }
                drDataSource.add(columnDatas.toArray());
                hasResultDatas = true;
            }
            if (hasResultDatas) {
                report.setDrDataSource((Object)drDataSource);
            } else {
                columnDatas = new ArrayList();
                drDataSource.add(columnDatas.toArray());
                report.setDrDataSource((Object)drDataSource);
            }
            if (columnList.size() > 0) {
                ArrayList<TextColumnBuilder> colms = new ArrayList<TextColumnBuilder>();
                for (QueryColumnInfo queryColumnInfo : columnList) {
                    String columnClassName = queryColumnInfo.getColumnClassName();
                    if (columnClassName.equals("java.sql.Timestamp") || columnClassName.equals("java.sql.Date")) {
                        columnClassName = "java.util.Date";
                    } else if (columnClassName.equals("[B")) {
                        columnClassName = "java.lang.String";
                    }
                    colms.add(DynamicReports.col.column(queryColumnInfo.getColumnLabel(), queryColumnInfo.getColumnName(), DataTypes.detectType((String)columnClassName)));
                }
                report.setReportColumnInfos(colms);
            } else {
                report.setReportColumnInfos(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonException irptException = new CommonException();
            StringBuffer exceptionMsgSB = new StringBuffer();
            exceptionMsgSB.append("\u6267\u884csql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38\uff01");
            exceptionMsgSB.append(e.getClass().getName());
            exceptionMsgSB.append(StringUtil.isBlank((String)e.getMessage()) ? e.getMessage() : "");
            irptException.setExceptionMsg(exceptionMsgSB.toString());
            throw irptException;
        }
    }

    protected String parseProcedure(String procedure) throws Exception {
        StringBuffer p = new StringBuffer();
        if (!procedure.trim().startsWith("{")) {
            if (!procedure.trim().startsWith("call ")) {
                throw new OBPMValidateException("missing 'call' at the beginning of [" + procedure + "]");
            }
            p.append('{');
        } else if (!procedure.trim().startsWith("call", 1)) {
            throw new OBPMValidateException("missing 'call' at the beginning of [" + procedure + "]");
        }
        int index1 = procedure.indexOf(40);
        int index2 = procedure.lastIndexOf(41);
        if (index1 < 0 && index2 > -1) {
            throw new OBPMValidateException("missing '(' on [" + procedure + "]");
        }
        if (index1 > -1 && index2 < 0) {
            throw new OBPMValidateException("missing ')' on [" + procedure + "]");
        }
        if (index1 > -1 && index2 > -1) {
            p.append(procedure.substring(procedure.indexOf(123) + 1, index1).trim());
            p.append('(');
            String[] parametersAsArray = procedure.substring(index1 + 1, index2).split(",");
            for (int i = 0; i < parametersAsArray.length; ++i) {
                p.append('?');
                if (i >= parametersAsArray.length - 1) continue;
                p.append(',');
            }
            p.append(')');
        } else {
            p.append(procedure.substring(procedure.indexOf(123) + 1).trim());
        }
        if (!procedure.trim().endsWith("}")) {
            p.append('}');
        }
        return p.toString();
    }

    protected void parseParameters(CallableStatement statement, String procedure, ParamsTable params, int page, int lines, String domainid) throws Exception {
        int index2;
        int index1 = procedure.indexOf("(");
        String parameters = procedure.substring(index1 + 1, index2 = procedure.lastIndexOf(")"));
        String[] paramsAsArray = parameters.split(",");
        if (paramsAsArray != null && paramsAsArray.length > 0) {
            for (int i = 0; i < paramsAsArray.length; ++i) {
                String[] p = paramsAsArray[i].split(":");
                if (p == null || p.length != 2) continue;
                String type = p[0].trim();
                String value = p[1].trim();
                if ("String".equalsIgnoreCase(type)) {
                    if ("#curDomain".equals(value)) {
                        statement.setString(i + 1, domainid);
                        continue;
                    }
                    if ("#sortCol".equals(value)) {
                        statement.setString(i + 1, params.getParameterAsString("_sortCol"));
                        continue;
                    }
                    if ("#sortStatus".equals(value)) {
                        statement.setString(i + 1, params.getParameterAsString("_sortStatus"));
                        continue;
                    }
                    if ("#orderby".equals(value)) {
                        statement.setString(i + 1, params.getParameterAsString("_orderby"));
                        continue;
                    }
                    statement.setString(i + 1, value);
                    continue;
                }
                if ("int".equalsIgnoreCase(type)) {
                    if ("#curPage".equals(value)) {
                        statement.setInt(i + 1, page);
                        continue;
                    }
                    if ("#lines".equals(value)) {
                        statement.setInt(i + 1, lines);
                        continue;
                    }
                    statement.setInt(i + 1, (int)Integer.valueOf(value));
                    continue;
                }
                if ("Date".equalsIgnoreCase(type) || "java.sql.Date".equalsIgnoreCase(type)) {
                    statement.setDate(i + 1, Date.valueOf(value));
                    continue;
                }
                if ("Time".equalsIgnoreCase(type) || "java.sql.Time".equalsIgnoreCase(type)) {
                    statement.setTime(i + 1, Time.valueOf(value));
                    continue;
                }
                if ("Timestamp".equalsIgnoreCase(type) || "java.sql.Timestamp".equalsIgnoreCase(type)) {
                    statement.setTimestamp(i + 1, Timestamp.valueOf(value));
                    continue;
                }
                if ("double".equalsIgnoreCase(type)) {
                    statement.setDouble(i + 1, (double)Double.valueOf(value));
                    continue;
                }
                if ("float".equalsIgnoreCase(type)) {
                    statement.setFloat(i + 1, Float.valueOf(value).floatValue());
                    continue;
                }
                if ("long".equalsIgnoreCase(type)) {
                    statement.setLong(i + 1, (long)Long.valueOf(value));
                    continue;
                }
                throw new OBPMValidateException("not support type [" + type + "]");
            }
        }
    }

    protected String parseProcedureInSqlServer(String procedure) throws Exception {
        StringBuffer p = new StringBuffer();
        if (!procedure.trim().startsWith("exec ")) {
            throw new OBPMValidateException("missing 'exec' at the beginning of [" + procedure + "]");
        }
        int index1 = procedure.indexOf(40);
        int index2 = procedure.lastIndexOf(41);
        if (index1 < 0 && index2 > -1) {
            throw new OBPMValidateException("missing '(' on [" + procedure + "]");
        }
        if (index1 > -1 && index2 < 0) {
            throw new OBPMValidateException("missing ')' on [" + procedure + "]");
        }
        if (index1 > -1 && index2 > -1) {
            p.append(procedure.substring(procedure.indexOf(123) + 1, index1).trim());
            p.append('(');
            String[] parametersAsArray = procedure.substring(index1 + 1, index2).split(",");
            for (int i = 0; i < parametersAsArray.length; ++i) {
                p.append('?');
                if (i >= parametersAsArray.length - 1) continue;
                p.append(',');
            }
            p.append(')');
        } else {
            p.append(procedure.substring(procedure.indexOf(123) + 1).trim());
        }
        return p.toString();
    }

    private Map<Integer, Object> parseParametersInOracle(CallableStatement statement, String procedure, ParamsTable params, int page, int lines, String domainid) throws Exception {
        int index2;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        int index1 = procedure.indexOf("(");
        String parameters = procedure.substring(index1 + 1, index2 = procedure.lastIndexOf(")"));
        String[] paramsAsArray = parameters.split(",");
        if (paramsAsArray != null && paramsAsArray.length > 0) {
            for (int i = 0; i < paramsAsArray.length; ++i) {
                String[] p = paramsAsArray[i].split(":");
                if (p != null && p.length == 2) {
                    String type = p[0].trim();
                    String value = p[1].trim();
                    if ("String".equalsIgnoreCase(type)) {
                        if ("#curDomain".equals(value)) {
                            statement.setString(i + 1, domainid);
                            continue;
                        }
                        if ("#sortCol".equals(value)) {
                            statement.setString(i + 1, params.getParameterAsString("_sortCol"));
                            continue;
                        }
                        if ("#sortStatus".equals(value)) {
                            statement.setString(i + 1, params.getParameterAsString("_sortStatus"));
                            continue;
                        }
                        if ("#orderby".equals(value)) {
                            statement.setString(i + 1, params.getParameterAsString("_orderby"));
                            continue;
                        }
                        statement.setString(i + 1, value);
                        continue;
                    }
                    if ("int".equalsIgnoreCase(type)) {
                        if ("#curPage".equals(value)) {
                            statement.setInt(i + 1, page);
                            continue;
                        }
                        if ("#lines".equals(value)) {
                            statement.setInt(i + 1, lines);
                            continue;
                        }
                        statement.setInt(i + 1, (int)Integer.valueOf(value));
                        continue;
                    }
                    if ("Date".equalsIgnoreCase(type) || "java.sql.Date".equalsIgnoreCase(type)) {
                        statement.setDate(i + 1, Date.valueOf(value));
                        continue;
                    }
                    if ("Time".equalsIgnoreCase(type) || "java.sql.Time".equalsIgnoreCase(type)) {
                        statement.setTime(i + 1, Time.valueOf(value));
                        continue;
                    }
                    if ("Timestamp".equalsIgnoreCase(type) || "java.sql.Timestamp".equalsIgnoreCase(type)) {
                        statement.setTimestamp(i + 1, Timestamp.valueOf(value));
                        continue;
                    }
                    if ("double".equalsIgnoreCase(type)) {
                        statement.setDouble(i + 1, (double)Double.valueOf(value));
                        continue;
                    }
                    if ("float".equalsIgnoreCase(type)) {
                        statement.setFloat(i + 1, Float.valueOf(value).floatValue());
                        continue;
                    }
                    if ("long".equalsIgnoreCase(type)) {
                        statement.setLong(i + 1, (long)Long.valueOf(value));
                        continue;
                    }
                    if ("out".equalsIgnoreCase(type)) {
                        if (!"package".equalsIgnoreCase(value)) continue;
                        statement.registerOutParameter(i + 1, -10);
                        map.put(i + 1, "package");
                        continue;
                    }
                    throw new OBPMValidateException("not support type [" + type + "]");
                }
                if (p == null) continue;
                throw new OBPMValidateException("parameter [" + paramsAsArray[i] + "] format is not correct");
            }
        }
        return map;
    }
}

