/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.report.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.Environment;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.CommonException;
import cn.myapps.common.model.report.QueryColumnInfo;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.report.ReportGroup;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.report.service.ReportGroupDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.report.engine.ReportEngine;
import cn.myapps.runtime.activity.service.ActivityRunTimeServiceImpl;
import cn.myapps.runtime.common.controller.AbstractRuntimeController;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.dynaform.form.ejb.ValueStoreField;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.report.service.ReportService;
import cn.myapps.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.utils.SqlUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Api(tags={"\u62a5\u8868\u6a21\u5757"})
@Controller
@RequestMapping(value={"/api/runtime/report"})
public class ReportController
extends AbstractRuntimeController {
    @Autowired
    private ReportService process;
    @Autowired
    private ReportGroupDesignTimeService reportGroupDesignTimeService;

    @RequestMapping(value={"/show/{id}"})
    @ResponseBody
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u62a5\u8868id", required=true, paramType="path", dataType="string")})
    public String showReport(@PathVariable String id) throws Exception {
        Environment env = Environment.getInstance();
        if (!StringUtil.isBlank((String)id)) {
            Report report = this.process.doView(id);
            ReportEngine engine = ReportEngine.getInstance();
            String path = engine.exportHtml(report, this.getParams(), (IUser)this.getUser());
            path = env.getContext(path);
            return "<script>window.location='" + path + "';</script>";
        }
        return "\u8bf7\u6307\u5b9a\u62a5\u8868!";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ResponseBody
    @RequestMapping(value={"/showjrxml/{id}"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u62a5\u8868\u663e\u793a", notes="\u62a5\u8868\u663e\u793a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u62a5\u8868id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=false, paramType="body", dataType="string")})
    public String showJrxmlReport(@PathVariable String id, @RequestBody(required=false) String content, String docid) throws Exception {
        try {
            String domainId;
            if (StringUtil.isBlank((String)id)) {
                return "msg:\u8bf7\u6307\u5b9a\u62a5\u8868!";
            }
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            if (!StringUtil.isBlank((String)content)) {
                JSONObject jsonObject = JSONObject.parseObject((String)content);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    params.setParameter(key, value);
                }
            }
            if (!StringUtil.isBlank((String)(domainId = params.getParameterAsString("domainId")))) {
                user.setDomainid(domainId);
            }
            String htmlPath = "";
            ReportEngine engine = ReportEngine.getInstance();
            Report report = this.process.doView(id);
            String subReportId = report.getSubReportId();
            if (StringUtil.isBlank((String)subReportId)) return htmlPath;
            if (subReportId.indexOf(",") != -1) {
                String[] subReportIds = subReportId.split(",");
                int i = 0;
                while (i < subReportIds.length) {
                    Report subReport = this.process.doView(subReportIds[i]);
                    this.getReportPath(subReport, (IUser)user, params, docid, "html");
                    ++i;
                }
                htmlPath = this.getReportPath(report, (IUser)user, params, docid, "html");
                return htmlPath;
            }
            Report subReport = this.process.doView(subReportId);
            this.getReportPath(subReport, (IUser)user, params, docid, "html");
            return htmlPath;
        }
        catch (CommonException irte) {
            irte.printStackTrace();
            return "msg:\u5df2\u77e5\u7cfb\u7edf\u5f02\u5e38\uff01" + irte.getExceptionMsg();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "msg:\u672a\u77e5\u7cfb\u7edf\u5f02\u5e38\uff01ExceptionName:" + e.getClass().getName() + ",ExceptionMsg:" + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getReportPath(Report report, IUser user, ParamsTable params, String docid, String type) throws Exception {
        String path = "";
        ReportEngine engine = ReportEngine.getInstance();
        String id = report.getId();
        String parentId = params.getParameterAsString("parentid");
        try {
            if (report.getDataSourceType().equals("DATASOURCE_TYPE_SQL") && report.getIsPrint() == 0) {
                if (report.getTemplateType().equals("JRXML")) {
                    if (type.equals("html")) {
                        path = this.process.generateDynamicReportByReportId(id, user, params);
                    } else if (type.equals("excel")) {
                        path = this.process.generateExcelByReportId(id, user, params);
                    } else if (type.equals("pdf")) {
                        path = this.process.generatePdfByReportId(id, user, params);
                    }
                } else {
                    report.setDataSourceType("");
                    if (type.equals("html")) {
                        path = engine.exportHtml(report, params, user);
                    } else if (type.equals("excel")) {
                        path = engine.exportExcel(report, params, user);
                    } else if (type.equals("pdf")) {
                        path = engine.exportPdf(report, params, user);
                    }
                }
            } else if (report.getDataSourceType().equals("DATASOURCE_TYPE_VIEW") && report.getIsPrint() == 0) {
                String viewId = report.getViewId();
                ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
                AbstractView view = vProcess.doView(viewId);
                Document searchDocument = null;
                DataPackage dataPackage = null;
                Collection data = null;
                if (view.getSearchForm() != null) {
                    searchDocument = view.getSearchForm().createDocument(params, user);
                    for (Map.Entry entry : searchDocument.getItemMap().entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        params.setParameter(key, value);
                    }
                } else {
                    searchDocument = new Document();
                }
                params.setParameter("parentid", (Object)parentId);
                params.setParameter("refreshparent", (Object)true);
                params.setParameter("isedit", (Object)false);
                params.setParameter("lines", (Object)Integer.MAX_VALUE);
                params.setParameter("_viewid", (Object)viewId);
                if ("TreeView".equalsIgnoreCase(view.getSimpleClassName()) || "MapView".equalsIgnoreCase(view.getSimpleClassName())) {
                    params.setParameter("lines", (Object)Integer.MAX_VALUE);
                }
                dataPackage = view.getViewTypeImpl().getViewDatas(params, user, searchDocument);
                data = dataPackage.getDatas();
                if (type.equals("html")) {
                    path = this.process.generateDynamicReportByViewDataSource(report, data, params, user);
                } else if (type.equals("excel")) {
                    path = this.process.generateExcelByViewDataSource(report, data, params, user);
                } else if (type.equals("pdf")) {
                    path = this.process.generatePdfByViewDataSource(report, data, params, user);
                }
            } else if (report.getDataSourceType().equals("DATASOURCE_TYPE_CUSTOM") && report.getIsPrint() == 0) {
                if (type.equals("html")) {
                    path = this.process.generateDynamicReportByCustomDataSource(report, params, user);
                }
            } else if (report.getDataSourceType().equals("DATASOURCE_TYPE_PROCEDURE") && report.getIsPrint() == 0) {
                if (type.equals("html")) {
                    path = this.process.generateDynamicReportByProcedure(report, user, params);
                } else if (type.equals("excel")) {
                    path = this.process.generateExcelByProcedure(report, user, params);
                } else if (type.equals("pdf")) {
                    path = this.process.generateExcelByProcedure(report, user, params);
                }
            } else if (report.getIsPrint() == 1) {
                path = this.process.generateDynamicReportByFormDataSource(report, params, user, docid);
            }
        }
        finally {
            String jrxmlFileRealPath = Environment.getInstance().getRealPath(report.getJrxmlFilePath());
            String jasperFileRealPath = jrxmlFileRealPath.replace(".jrxml", ".jasper");
            try {
                JasperCompileManager.compileReportToFile((String)jrxmlFileRealPath, (String)jasperFileRealPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    @ResponseBody
    @RequestMapping(value={"/exportexcel/{id}"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u62a5\u8868\u5bfc\u51faexcel", notes="\u62a5\u8868\u5bfc\u51faexcel")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u62a5\u8868id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=false, paramType="body", dataType="string")})
    public void exportExcel(HttpServletResponse response, @PathVariable String id, @RequestBody(required=false) String content) throws Exception {
        try {
            content = SqlUtil.encode((String)content);
            if (!StringUtil.isBlank((String)id)) {
                WebUser user = this.getUser();
                ParamsTable params = this.getParams();
                String path = "";
                ReportEngine engine = ReportEngine.getInstance();
                Report report = this.process.doView(id);
                if (!StringUtil.isBlank((String)report.getSubReportId())) {
                    Report subReport = this.process.doView(report.getSubReportId());
                    this.getReportPath(subReport, (IUser)user, params, null, "excel");
                }
                path = this.getReportPath(report, (IUser)user, params, null, "excel");
                String agent = this.request.getHeader("USER-AGENT");
                String fileNameExcel = report.getName() + ".xls";
                String encoding = Environment.getInstance().getEncoding();
                if (null != agent && -1 != agent.indexOf("Firefox")) {
                    response.setContentType("application/x-download; charset=" + encoding + "");
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileNameExcel.getBytes("UTF-8"), "iso-8859-1"));
                } else {
                    response.setContentType("application/x-download; charset=" + encoding + "");
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileNameExcel.getBytes("UTF-8"), "iso-8859-1"));
                }
                Environment env = Environment.getInstance();
                String realPath = env.getRealPath(path);
                File file = new File(realPath);
                new ActivityRunTimeServiceImpl().doFileDownload(file, (OutputStream)response.getOutputStream());
            }
        }
        catch (CommonException irte) {
            irte.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ResponseBody
    @RequestMapping(value={"/exportpdf/{id}"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u62a5\u8868\u5bfc\u51fapdf", notes="\u62a5\u8868\u5bfc\u51fapdf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u62a5\u8868id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=false, paramType="body", dataType="string")})
    public void exportPdf(HttpServletResponse response, @PathVariable String id, @RequestBody(required=false) String content, String docid) throws Exception {
        try {
            content = SqlUtil.encode((String)content);
            if (!StringUtil.isBlank((String)id)) {
                WebUser user = this.getUser();
                ParamsTable params = this.getParams();
                String parentId = params.getParameterAsString("parentid");
                String path = "";
                ReportEngine engine = ReportEngine.getInstance();
                Report report = this.process.doView(id);
                if (!StringUtil.isBlank((String)report.getSubReportId())) {
                    Report subReport = this.process.doView(report.getSubReportId());
                    this.getReportPath(subReport, (IUser)user, params, docid, "pdf");
                }
                path = this.getReportPath(report, (IUser)user, params, docid, "pdf");
                String agent = this.request.getHeader("USER-AGENT");
                String fileNameExcel = report.getName() + ".pdf";
                String encoding = Environment.getInstance().getEncoding();
                if (null != agent && -1 != agent.indexOf("Firefox")) {
                    response.setContentType("application/x-download; charset=" + encoding + "");
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileNameExcel.getBytes("UTF-8"), "iso-8859-1"));
                } else {
                    response.setContentType("application/x-download; charset=" + encoding + "");
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileNameExcel.getBytes("UTF-8"), "iso-8859-1"));
                }
                Environment env = Environment.getInstance();
                String realPath = env.getRealPath(path);
                File file = new File(realPath);
                new ActivityRunTimeServiceImpl().doFileDownload(file, (OutputStream)response.getOutputStream());
            }
        }
        catch (CommonException irte) {
            irte.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(path={"/{id}/searchformtemplate/{applicationId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u67e5\u8be2\u8868\u5355\u6a21\u677f", notes="\u83b7\u53d6\u67e5\u8be2\u8868\u5355\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", value="\u8f6f\u4ef6id", required=true, paramType="path", dataType="string"), @ApiImplicitParam(name="id", value="\u62a5\u8868id", required=true, paramType="path", dataType="string")})
    public Resource getSearchFormTemplate(@PathVariable String applicationId, @PathVariable String id) throws Exception {
        WebUser user = this.getUser();
        ParamsTable params = this.getParams();
        Form searchForm = null;
        Report report = this.process.doView(id);
        if (report.getDataSourceType().equals("DATASOURCE_TYPE_VIEW")) {
            ViewDesignTimeService vProcess = DesignTimeServiceManager.viewDesignTimeService();
            AbstractView view = vProcess.doView(report.getViewId());
            searchForm = view.getSearchForm();
        } else {
            FormDesignTimeService fs = DesignTimeServiceManager.formDesignTimeService();
            searchForm = fs.doView(report.getDataSourceSearchForm());
        }
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
        Document searchDocument = null;
        searchDocument = searchForm != null ? searchForm.createDocument(params, (IUser)this.getUser()) : new Document();
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder buffer = new StringBuilder();
        StringBuilder template = new StringBuilder();
        Form form = searchDocument.getForm();
        String formId = form == null ? "" : form.getId();
        ArrayList<Map> data = new ArrayList<Map>();
        if (form != null) {
            template.append(form.getHtmlTemplate(searchDocument, runner, (IUser)user));
            buffer.append(template.toString());
            buffer.append("<input type=\"hidden\" id=\"dy_refreshObj\" formid=\"" + formId + "\"");
            buffer.append(" docid=\"" + searchDocument.getId() + "\" userid=\"" + user.getId() + "\"");
            buffer.append(" mapVal=\"");
            for (Object obj : form.getAllFields()) {
                if (!(obj instanceof ValueStoreField)) continue;
                FormField field = (FormField)obj;
                buffer.append(field.getName() + ";");
            }
            if (buffer.lastIndexOf(";") != -1) {
                buffer.deleteCharAt(buffer.lastIndexOf(";"));
            }
            Collection fields = form.getFields();
            for (FormField formField : fields) {
                Map value = formField.toAttributes(searchDocument, runner, (IUser)this.getUser(), 2);
                data.add(value);
            }
            buffer.append("\" />");
        }
        map.put("fields", data);
        map.put("document", searchDocument);
        map.put("template", buffer.toString());
        if (form != null && form.getStyle() != null) {
            map.put("style", form.getStyle());
        }
        return this.success("ok", map);
    }

    @GetMapping(value={"/getReportsInGroup"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u62a5\u8868\u518c\u4e0b\u7684\u62a5\u8868", notes="\u83b7\u53d6\u5f53\u524d\u62a5\u8868\u518c\u4e0b\u7684\u62a5\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="reportGroupId", value="\u62a5\u8868\u518cid", required=true, paramType="path", dataType="string")})
    public Resource getReportsInGroup(String reportGroupId, String reportIds) {
        JSONObject json = new JSONObject();
        try {
            String[] ids;
            if (!StringUtil.isBlank((String)reportGroupId)) {
                ReportGroup reportGroup = this.reportGroupDesignTimeService.doView(reportGroupId);
                ids = reportGroup.getReportIds().split(";");
            } else {
                ids = reportIds.split(";");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (String id : ids) {
                Report report = (Report)this.process.findById(id);
                map.put(report.getId(), report.getName());
            }
            json.put("data", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success("ok", json);
    }

    @PostMapping(value={"/getCustomColumnsInfos"})
    @ResponseBody
    public List<QueryColumnInfo> getCustomColumnsInfos(@RequestBody String scriptString, String applicationId) throws Exception {
        WebUser user = this.getUser();
        ParamsTable params = this.getParams();
        List<QueryColumnInfo> customColumnsInfos = this.process.getCustomColumnsInfos(scriptString, null, params, (IUser)user, applicationId);
        return customColumnsInfos;
    }
}

