/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.onlinetakephoto;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.Environment;
import cn.myapps.common.util.DefaultProperty;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.sequence.Sequence;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnLineTakePhotoServlet
extends HttpServlet {
    private static final long serialVersionUID = -138681845395518146L;
    private static final Logger Log = LoggerFactory.getLogger(OnLineTakePhotoServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = request.getParameter("type");
        if (!StringUtil.isBlank((String)type) && type.equals("android")) {
            this.doAndroidUploadFile(request, response);
        } else {
            this.processRequest(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = request.getParameter("type");
        if (!StringUtil.isBlank((String)type) && type.equals("android")) {
            this.doAndroidUploadFile(request, response);
        } else {
            this.processRequest(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAndroidUploadFile(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            String fileName = request.getParameter("fileName");
            response.setContentType("text/html");
            try {
                List items = upload.parseRequest(request);
                for (FileItem item : items) {
                    if (item.isFormField()) continue;
                    response.setContentType("text/xml");
                    response.getWriter().write(this.common(item.get(), ""));
                }
            }
            catch (Exception e) {
                response.getWriter().write("");
            }
        }
        catch (Exception e) {
            response.getWriter().write("");
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String common(byte[] data, String filePath) throws Exception {
        String path = "";
        if (StringUtil.isBlank((String)filePath)) {
            path = Environment.getInstance().getRealPath(DefaultProperty.getProperty((String)"ONLINE_TAKE_PHONO_PATH"));
            File upDir = new File(path);
            if (!upDir.exists() && !upDir.mkdir()) {
                Log.warn("Failed to create folder (" + filePath + ")");
                throw new IOException("Failed to create folder (" + filePath + ")");
            }
            String saveName = Sequence.getSequence();
            String fileName = saveName + ".jpg";
            filePath = DefaultProperty.getProperty((String)"ONLINE_TAKE_PHONO_PATH") + "//" + fileName;
            path = path + "//" + fileName;
        } else {
            path = Environment.getInstance().getRealPath(filePath);
        }
        File f = new File(path);
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(f));
        dos.write(data);
        dos.flush();
        dos.close();
        return filePath;
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String filePath = request.getParameter("filePath");
        String bitmap_data = request.getParameter("bitmap_data");
        int width = Integer.parseInt(request.getParameter("width"));
        int height = Integer.parseInt(request.getParameter("height"));
        BufferedImage img = new BufferedImage(width, height, 1);
        try {
            int w = width;
            int h = height;
            int[] pixels = new int[w * h];
            String[] m_tempPics = bitmap_data.split(",");
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    Long pic_argb = Long.parseLong(m_tempPics[x * h + y]);
                    int a = (int)(pic_argb >> 24 & 0xFFL);
                    int r = (int)(pic_argb >> 16 & 0xFFL);
                    int g = (int)(pic_argb >> 8 & 0xFFL);
                    int b = (int)(pic_argb & 0xFFL);
                    pixels[y * w + x] = new Color(r, g, b, a).getRGB();
                }
            }
            img.setRGB(0, 0, w, h, pixels, 0, w);
            img.flush();
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "jpg", bao);
            byte[] data = bao.toByteArray();
            if (!StringUtil.isBlank((String)filePath)) {
                if (filePath.indexOf(DefaultProperty.getProperty((String)"ONLINE_TAKE_PHONO_PATH")) == -1) {
                    filePath = "";
                }
            } else {
                filePath = "";
            }
            response.setContentType("text/xml");
            response.getWriter().write(this.common(data, filePath));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            response.setContentType("text/xml");
            response.getWriter().write("\u4fdd\u5b58\u5931\u8d25");
            throw new IOException(ex.getMessage());
        }
    }
}

