/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.notice;

import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.util.SequenceException;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.conf.NoticeApi;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.notice.Notice;
import cn.myapps.runtime.notice.Notification;
import cn.myapps.runtime.workflow.notification.ejb.SendMode;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.sequence.Sequence;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import net.sf.json.JSONObject;

public class PersonalMessageMode
implements SendMode {
    private String getLinkParamsByDocument(IDocument document) {
        JSONObject handleUrl = new JSONObject();
        handleUrl.put((Object)"_docid", (Object)document.getId());
        handleUrl.put((Object)"_formid", (Object)document.getFormid());
        handleUrl.put((Object)"application", (Object)document.getApplicationid());
        handleUrl.put((Object)"mode", (Object)"personalMessageMode");
        return handleUrl.toString();
    }

    private String getContentsByCondition(IDocument document, String subject, int subjectType, String summary, IUser user) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class='notice_type' type='" + subjectType + "'></span>");
        if (user != null) {
            sb.append("<span class='notice_actor'>" + user.getName() + "</span>");
        } else {
            sb.append("<span class='notice_actor'></span>");
        }
        sb.append("<span class='notice_flow'>\u5ba1\u6279\u5355</span>");
        try {
            String formname = document.getFormname();
            sb.append("<span class='notice_summary'>" + formname + "-" + summary + "</span>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public boolean send(String subject, int subjectType, String summary, IUser responsible, IDocument document, IUser webUser) {
        try {
            Notice notice = new Notice();
            notice.setId(Sequence.getSequence());
            notice.setSubjectType(subjectType);
            notice.setCreateTime(new Date());
            notice.setDomainid(document.getDomainid());
            String linkParams = this.getLinkParamsByDocument(document);
            notice.setLinkParams(linkParams);
            String warpSummary = this.getContentsByCondition(document, subject, subjectType, summary, webUser);
            String module = document.getFormname();
            notice.setModule(module);
            notice.setRead(false);
            notice.setSummary(warpSummary);
            notice.setToUserId(responsible.getId());
            JSONObject content = new JSONObject();
            content.put((Object)"content", (Object)summary);
            content.put((Object)"event", (Object)subject);
            content.put((Object)"type", (Object)subjectType);
            notice.setContent(content.toString());
            NoticeApi noticeApi = (NoticeApi)SpringApplicationContextUtil.getBean(NoticeApi.class);
            noticeApi.createNotice(notice);
            Notification notification = new Notification();
            notification.setSender(webUser.getName());
            notification.setSenderId(webUser.getId());
            notification.setReceiverId(responsible.getId());
            notification.setMessageId(notice.getId());
            notification.setMessageType(notice.getSubjectType());
            notification.setModule(module);
            notification.setLinkParams(notice.getLinkParams());
            notification.setDomainid(webUser.getDomainid());
            notification.setSummary(summary);
            notification.setCreateTime(notice.getCreateTime());
            noticeApi.createNotification(notification);
        }
        catch (SequenceException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void sendMessageToUser(String userId, String receiverid, String title, String content) throws Exception {
        NoticeApi noticeApi = (NoticeApi)SpringApplicationContextUtil.getBean(NoticeApi.class);
        noticeApi.createMessage(receiverid, title, content, userId);
    }

    public void sendMessageToDeptUser(String departmentid, String title, String content, String userId) throws Exception {
        UserProcess us = (UserProcess)ProcessFactory.createProcess(UserProcess.class);
        UserVO user = (UserVO)us.doView(userId);
        HashSet<String> receiverId = new HashSet<String>();
        HashSet<String> receiverDeptId = new HashSet<String>();
        Collection _users = us.queryByDepartment(departmentid);
        NoticeApi noticeApi = (NoticeApi)SpringApplicationContextUtil.getBean(NoticeApi.class);
        receiverDeptId.add(departmentid);
        for (UserVO u : _users) {
            receiverId.add(u.getId());
        }
        String _receiverId = "";
        String _receiverDeptId = "";
        if (!receiverId.isEmpty()) {
            _receiverId = receiverId.toString().substring(1, receiverId.toString().length() - 1);
            _receiverDeptId = receiverDeptId.toString().substring(1, receiverDeptId.toString().length() - 1);
        } else {
            _receiverId = "";
            _receiverDeptId = "";
        }
        noticeApi.createMessage(_receiverId, title, content, userId);
    }

    public void sendMessageToRoleUser(String roleId, String title, String content, String userId) throws Exception {
        UserProcess us = (UserProcess)ProcessFactory.createProcess(UserProcess.class);
        UserVO user = (UserVO)us.doView(userId);
        HashSet<String> receiverId = new HashSet<String>();
        HashSet receiverDeptId = new HashSet();
        Collection _users = us.queryByRole(roleId);
        NoticeApi noticeApi = (NoticeApi)SpringApplicationContextUtil.getBean(NoticeApi.class);
        for (UserVO u : _users) {
            receiverId.add(u.getId());
        }
        String _receiverId = "";
        _receiverId = !receiverId.isEmpty() ? receiverId.toString().substring(1, receiverId.toString().length() - 1) : "";
        noticeApi.createMessage(_receiverId, title, content, userId);
    }
}

