/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.notice;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.workflow.notification.ejb.SendMode;
import cn.myapps.util.mail.EmailSender;

public class EmailMode
implements SendMode {
    private String htmlDecodeEncoder(String content) {
        if (StringUtil.isBlank((String)content)) {
            return content;
        }
        content = content.replaceAll("&quot;", "\"");
        content = content.replaceAll("&amp;", "&");
        content = content.replaceAll("&lt;", "<");
        content = content.replaceAll("&gt;", ">");
        return content;
    }

    public boolean send(String subject, int subjectType, String summary, IUser responsible, IDocument document, IUser webUser) {
        if (!StringUtil.isBlank((String)responsible.getEmail())) {
            String replyContent = null;
            String body = summary;
            if (!StringUtil.isBlank(replyContent)) {
                body = body + replyContent;
            }
            body = this.htmlDecodeEncoder(body);
            EmailSender sender = EmailSender.getInstance();
            try {
                DomainVO domain = (DomainVO)AuthTimeServiceManager.domainRuntimeService().doView(webUser.getDomainid());
                String from = domain.getSendAddress();
                String host = domain.getSendHost();
                String user = domain.getSendAccount();
                String password = domain.getSendPassword();
                String bcc = domain.getCcAddress();
                sender.addEmail(from, responsible.getEmail(), subject, body, host, user, password, bcc, true, webUser);
                sender.sendEmail();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

