/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.mobile.user.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.mobile.common.controller.BaseController;
import cn.myapps.runtime.mobile.user.model.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="UserController")
@RequestMapping(value={"/runtime/app/users"})
@Scope(value="prototype")
@Api(tags={"\u7528\u6237\u6a21\u5757"})
public class UserController
extends BaseController {
    @RequestMapping(value={"/getUser.action"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u8054\u7cfb\u4eba\u8d44\u6599", notes="\u83b7\u53d6\u8054\u7cfb\u4eba\u8d44\u6599")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="ids", value="\u8054\u7cfb\u4eba\u4e3b\u952e", required=true, paramType="query", dataType="string")})
    public Map<String, Object> getUserData() {
        if (this.getUserId() == null) {
            return this.addActionResult(false, "access_token invalid", null);
        }
        try {
            ArrayList<User> list = new ArrayList<User>();
            ParamsTable params = this.getParams();
            String ids = params.getParameterAsString("ids");
            String[] id = ids.split(",");
            for (int i = 0; i < id.length; ++i) {
                UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
                UserVO user = (UserVO)userProcess.doView(id[i]);
                UserVO me = (UserVO)userProcess.doView(this.getUserId());
                User u = new User();
                u.setId(user.getId());
                u.setName(user.getName());
                u.setLoginNo(user.getLoginno());
                u.setEmail(user.getEmail());
                u.setMobile(user.getTelephone());
                u.setMobile2(user.getTelephone2());
                if (StringUtil.isBlank((String)user.getAvatarUri())) {
                    u.setAvatar("");
                } else {
                    u.setAvatar(user.getAvatarUri() + "?accessToken=" + this.getAccess_token());
                }
                u.setDomain(user.getDomain().getName());
                DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
                DepartmentVO dept = (DepartmentVO)deptProcess.doView(user.getDefaultDepartment());
                if (dept != null) {
                    u.setDept(dept.getName());
                } else {
                    u.setDept("");
                }
                if (me.getFavoriteContacts() != null && me.getFavoriteContacts().indexOf(user.getId()) >= 0) {
                    u.setFavoriteContact(true);
                } else {
                    u.setFavoriteContact(false);
                }
                list.add(u);
            }
            return this.addActionResult(true, "ok", list);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/queryUser.action"})
    @ResponseBody
    @ApiOperation(value="", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string")})
    public Map<String, Object> queryUser() {
        if (this.getUserId() == null) {
            return this.addActionResult(false, "access_token invalid", null);
        }
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(this.getUserId());
            User u = new User();
            u.setId(user.getId());
            u.setName(user.getName());
            u.setLoginNo(user.getLoginno());
            u.setEmail(user.getEmail());
            u.setMobile(user.getTelephone());
            u.setMobile2(user.getTelephone2());
            if (StringUtil.isBlank((String)user.getAvatarUri())) {
                u.setAvatar("");
            } else {
                u.setAvatar(user.getAvatarUri() + "?accessToken=" + this.getAccess_token());
            }
            u.setDomain(user.getDomain().getName());
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            DepartmentVO dept = (DepartmentVO)deptProcess.doView(user.getDefaultDepartment());
            if (dept != null) {
                u.setDept(dept.getName());
            } else {
                u.setDept("");
            }
            return this.addActionResult(true, "ok", u);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/save.action"})
    @ResponseBody
    @ApiOperation(value="\u66f4\u65b0\u7528\u6237\u8d44\u6599", notes="\u66f4\u65b0\u7528\u6237\u8d44\u6599")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Map<String, Object> doSave() {
        if (this.getUserId() == null) {
            return this.addActionResult(false, "access_token invalid", null);
        }
        try {
            ParamsTable params = this.getParams();
            String name = params.getParameterAsString("name");
            String loginno = params.getParameterAsString("loginno");
            String password = params.getParameterAsString("password");
            String oldPassword = params.getParameterAsString("oldPassword");
            String email = params.getParameterAsString("email");
            String mobile = params.getParameterAsString("mobile");
            String mobile2 = params.getParameterAsString("mobile2");
            String avatar = params.getParameterAsString("avatar");
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(this.getUserId());
            if (avatar != null && !"".equals(avatar)) {
                user.setAvatar(avatar);
            }
            if (name != null && !"".equals(name)) {
                user.setName(name);
            }
            if (loginno != null && !"".equals(loginno)) {
                user.setLoginno(loginno);
            }
            if (password != null && !"".equals(password)) {
                if (oldPassword == null || "".equals(oldPassword)) return this.addActionResult(false, "\u539f\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", null);
                if (!oldPassword.equals(Security.decryptPassword((String)user.getLoginpwd()))) return this.addActionResult(false, "\u539f\u5bc6\u7801\u9519\u8bef", null);
                if ((password = Security.encodeToBASE64((String)password)).length() > 2) {
                    String lp = password.substring(0, 2);
                    String rp = password.substring(2, password.length());
                    password = rp + lp;
                    user.setLoginpwd(password);
                }
            }
            if (email != null && !"".equals(email)) {
                user.setEmail(email);
            }
            if (mobile != null && !"".equals(mobile)) {
                user.setTelephone(mobile);
            }
            if (mobile2 != null && !"".equals(mobile2)) {
                user.setTelephone2(mobile2);
            }
            userProcess.doUpdate((AuthtimeValueObject)user);
            return this.addActionResult(true, "\u4fdd\u5b58\u6210\u529f", null);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }
}

