/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.mobile.security.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.mobile.common.controller.BaseController;
import cn.myapps.util.WebCookies;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="LoginController")
@RequestMapping(value={"/runtime/app/security"})
@Scope(value="prototype")
@Api(tags={"\u767b\u5f55\u6a21\u5757"})
public class LoginController
extends BaseController {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    private WebCookies webCookies;

    public WebCookies getWebCookies() {
        return this.webCookies;
    }

    public void setWebCookies(WebCookies webCookies) {
        this.webCookies = webCookies;
    }

    @RequestMapping(value={"/login.action"})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55", notes="\u7528\u6237\u767b\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="\u4f01\u4e1a\u57df\u540d\u79f0", value="domainName", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="\u8d26\u53f7", value="username", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="\u5bc6\u7801", value="password", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="\u9a8c\u8bc1\u7801", value="checkcode", required=true, paramType="query", dataType="string")})
    public Map<String, Object> login() throws Exception {
        Map<String, Object> jsonResult = null;
        ParamsTable params = this.getParams();
        String domainName = params.getParameterAsString("domainName");
        String username = params.getParameterAsString("username");
        String password = params.getParameterAsString("password");
        String checkcode = params.getParameterAsString("checkcode");
        Cookie pwdErrorTimes = this.getErrorTimes();
        int count = 0;
        if (pwdErrorTimes != null) {
            String i = pwdErrorTimes.getValue();
            count = Integer.parseInt(i);
        }
        try {
            UserVO user;
            block12: {
                HttpSession session = this.request.getSession();
                if (pwdErrorTimes != null && this.isExceedTimes(pwdErrorTimes)) {
                    String code = (String)session.getAttribute("CheckCode");
                    if (code == null) {
                        throw new Exception("\u9a8c\u8bc1\u7801\u9519\u8bef");
                    }
                    if (code != null && !code.equalsIgnoreCase(checkcode)) {
                        throw new Exception("\u9a8c\u8bc1\u7801\u9519\u8bef");
                    }
                }
                UserProcess up = AuthTimeServiceManager.userRuntimeService();
                user = null;
                try {
                    user = up.login(username, password, domainName, count);
                }
                catch (Exception e) {
                    if (user != null) break block12;
                    password = Security.decodeBASE64((String)password);
                    user = up.login(username, password, domainName, count);
                }
            }
            if (user != null && Security.decryptPassword((String)user.getLoginpwd()).equals(password)) {
                this.getWebCooikes().destroyCookie("pwdErrorTimes");
                HashMap<String, String> token = new HashMap<String, String>();
                String theToken = Security.getToken((String)user.getId());
                token.put("access_token", theToken);
                token.put("userId", user.getId());
                token.put("username", user.getName());
                token.put("loginno", user.getLoginno());
                token.put("email", user.getEmail());
                token.put("mobile", user.getTelephone());
                token.put("mobile2", user.getTelephone2());
                if (StringUtil.isBlank((String)user.getAvatarUri())) {
                    token.put("avatar", "");
                } else {
                    token.put("avatar", user.getAvatarUri());
                }
                token.put("domain", user.getDomain().getName());
                token.put("department", user.getDefaultDepartment());
                token.put("accessToken", theToken);
                Cookie cookie = new Cookie("accessToken", theToken);
                cookie.setPath("/");
                this.response.addCookie(cookie);
                WebUser.setWebUser((WebUser)new WebUser((IUser)user), (HttpServletRequest)this.request);
                jsonResult = this.addActionResult(true, "\u767b\u5f55\u6210\u529f", token);
            }
            return jsonResult;
        }
        catch (Exception e) {
            this.increaseErrorTimes();
            if (this.isExceedTimes(pwdErrorTimes)) {
                this.request.setAttribute("showCode", (Object)true);
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put("showCode", true);
                return this.addActionResult(false, e.getMessage(), map);
            }
            this.destroyLoginPassword(this.response, this.request);
            return this.addActionResult(false, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef", new JSONObject());
        }
    }

    private Cookie getErrorTimes() {
        WebCookies webCookies = this.getWebCooikes();
        Cookie pwdErrorTimes = webCookies.getCookie("pwdErrorTimes");
        return pwdErrorTimes;
    }

    public WebCookies getWebCooikes() {
        if (this.webCookies == null) {
            this.webCookies = new WebCookies(this.request, this.response, "url");
        }
        return this.webCookies;
    }

    private void increaseErrorTimes() {
        WebCookies webCookies = this.getWebCooikes();
        Cookie pwdErrorTimes = webCookies.getCookie("pwdErrorTimes");
        try {
            if (pwdErrorTimes != null) {
                int times = Integer.valueOf(webCookies.getValue("pwdErrorTimes"));
                webCookies.addCookie("pwdErrorTimes", times + 1 + "", 86400);
            } else {
                webCookies.addCookie("pwdErrorTimes", "1", 86400);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isExceedTimes(Cookie cookie) {
        if (cookie != null) {
            try {
                String val = this.webCookies.getValue(cookie.getName());
                int errorTime = Integer.parseInt(val);
                if (errorTime >= 3) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private void destroyLoginPassword(HttpServletResponse response, HttpServletRequest request) {
        WebCookies webCookies = this.getWebCooikes();
        webCookies.destroyCookie("password");
    }
}

