/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.mobile.notice.controller;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.NoticeApi;
import cn.myapps.runtime.mobile.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="NoticeController")
@RequestMapping(value={"/runtime/app/notice"})
@Scope(value="prototype")
@Api(tags={"\u4e8b\u4ef6\u901a\u77e5\u6a21\u5757"})
public class NoticeController
extends BaseController {
    @RequestMapping(value={"/list.action"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u901a\u77e5", notes="\u83b7\u53d6\u901a\u77e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doList() {
        if (this.getUserId() == null) {
            return this.addActionResult(false, "access_token invalid", null);
        }
        try {
            ParamsTable params = this.getParams();
            FeignConfig.ACCESS_TOKEN = Security.getToken((String)this.getUserId());
            NoticeApi noticeApi = (NoticeApi)SpringApplicationContextUtil.getBean(NoticeApi.class);
            int pageNum = params.getParameterAsInteger("pageNum") == null ? 1 : params.getParameterAsInteger("pageNum");
            int pageSize = params.getParameterAsInteger("pageSize") == null ? Integer.MAX_VALUE : params.getParameterAsInteger("pageSize");
            JSONArray datas = JSONObject.fromObject(noticeApi.getNotices("0", pageNum, pageSize)).getJSONObject("data").getJSONArray("datas");
            ArrayList result = new ArrayList();
            for (JSONObject notice : datas) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", notice.get("id"));
                String content = notice.getString("content");
                if (StringUtil.isBlank((String)content)) {
                    map.put("content", new JSONObject());
                } else {
                    map.put("content", JSONObject.fromObject((Object)content));
                }
                String linkParams = notice.getString("linkParams");
                if (StringUtil.isBlank((String)linkParams)) {
                    map.put("linkParams", new JSONObject());
                } else {
                    map.put("linkParams", JSONObject.fromObject((Object)linkParams));
                }
                map.put("toUserId", notice.get("toUserId"));
                map.put("createTime", notice.get("createTime"));
                map.put("read", false);
                map.put("module", notice.get("module"));
                map.put("subjectType", notice.get("subjectType"));
                map.put("messageType", 1);
                result.add(map);
            }
            return this.addActionResult(true, "ok", result);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/delete.action"})
    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u901a\u77e5", notes="\u5220\u9664\u901a\u77e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u7528\u6237id", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doDelete() {
        try {
            FeignConfig.ACCESS_TOKEN = Security.getToken((String)this.getUserId());
            NoticeApi noticeApi = (NoticeApi)SpringApplicationContextUtil.getBean(NoticeApi.class);
            ParamsTable params = this.getParams();
            String id = params.getParameterAsString("id");
            noticeApi.removeNotice(id);
            return this.addActionResult(true, "ok", null);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/read.action"})
    @ResponseBody
    @ApiOperation(value="\u6807\u8bb0\u5df2\u8bfb", notes="\u6807\u8bb0\u5df2\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="ids", value="\u8054\u7cfb\u4eba\u4e3b\u952e", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doRead() {
        try {
            ParamsTable params = this.getParams();
            String ids = params.getParameterAsString("ids");
            FeignConfig.ACCESS_TOKEN = Security.getToken((String)this.getUserId());
            NoticeApi noticeApi = (NoticeApi)SpringApplicationContextUtil.getBean(NoticeApi.class);
            noticeApi.readNotice(ids);
            return this.addActionResult(true, "ok", null);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }
}

