/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.mobile.contacts.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.mobile.common.controller.BaseController;
import cn.myapps.runtime.mobile.contacts.model.Department;
import cn.myapps.runtime.mobile.contacts.model.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="ContactsController")
@RequestMapping(value={"/runtime/app/contacts"})
@Scope(value="prototype")
@Api(tags={"\u901a\u8baf\u5f55\u6a21\u5757"})
public class ContactsController
extends BaseController {
    @RequestMapping(value={"/tree.action"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u901a\u8baf\u5f55", notes="\u83b7\u53d6\u901a\u8baf\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="parentId", value="\u7236\u7ea7\u90e8\u95e8id", required=false, paramType="query", dataType="string")})
    public Map<String, Object> getContactsTree() {
        if (this.getUserId() == null) {
            return this.addActionResult(false, "access_token invalid", null);
        }
        try {
            int count = 0;
            ArrayList<Object> avatars = new ArrayList<Object>();
            WebUser webUser = this.getUser();
            ParamsTable params = this.getParams();
            String parentId = params.getParameterAsString("parentId");
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (StringUtil.isBlank((String)parentId)) {
                DepartmentVO dept = process.getRootDepartmentByDomainId(webUser.getDomainid());
                Department d = new Department();
                d.setId(dept.getId());
                d.setName(dept.getName());
                d.setUserCount(userProcess.getCountsByDepartment(dept.getId()));
                avatars.add(d);
                Collection users = userProcess.queryByDepartment(dept.getId(), true);
                count += users.size();
            } else {
                DepartmentVO parent = (DepartmentVO)process.doView(parentId);
                Collection departments = process.getDatasByParent(parentId);
                Collection users = userProcess.queryByDepartment(parentId, true);
                UserVO me = (UserVO)userProcess.doView(webUser.getId());
                count += users.size();
                for (UserVO userVO : users) {
                    if (userVO.getStatus() == 0 || userVO.getPermissionType().equals("private")) continue;
                    User u = new User();
                    u.setId(userVO.getId());
                    u.setName(userVO.getName());
                    u.setMobile(userVO.getTelephone());
                    u.setMobile2(userVO.getTelephone2());
                    u.setEmail(userVO.getEmail());
                    if (!StringUtil.isBlank((String)userVO.getAvatar())) {
                        String avatar = userVO.getAvatarUri();
                        u.setAvatar(avatar + "?accessToken=" + this.getAccess_token());
                    } else {
                        u.setAvatar("");
                    }
                    u.setDomain(userVO.getDomain().getName());
                    u.setDept(parent.getName());
                    if (me.getFavoriteContacts() != null && me.getFavoriteContacts().indexOf(userVO.getId()) >= 0) {
                        u.setFavoriteContact(true);
                    } else {
                        u.setFavoriteContact(false);
                    }
                    avatars.add(u);
                }
                for (DepartmentVO departmentVO : departments) {
                    Department d = new Department();
                    d.setId(departmentVO.getId());
                    d.setName(departmentVO.getName());
                    avatars.add(d);
                    Collection user = userProcess.queryByDepartment(departmentVO.getId(), true);
                    count += user.size();
                }
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("datas", avatars);
            map.put("count", Integer.valueOf(count));
            return this.addActionResult(true, "ok", map);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getContactsBySearch.action"})
    @ResponseBody
    @ApiOperation(value="\u6a21\u7cca\u641c\u7d22\u8054\u7cfb\u4eba", notes="\u6a21\u7cca\u641c\u7d22\u8054\u7cfb\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="keyWord", value="\u8054\u7cfb\u4eba\u59d3\u540d,\u9996\u5b57\u6bcd,\u7535\u8bdd", required=false, paramType="query", dataType="string")})
    public Map<String, Object> getContactsBySearch() {
        ArrayList<User> users = new ArrayList<User>();
        WebUser webUser = this.getUser();
        ParamsTable params = this.getParams();
        String keyWord = params.getParameterAsString("keyWord");
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection user = userProcess.queryByFuzzy(keyWord, webUser.getDomainid());
            UserVO me = (UserVO)userProcess.doView(webUser.getId());
            for (UserVO userVO : user) {
                User u = new User();
                u.setId(userVO.getId());
                u.setName(userVO.getName());
                u.setMobile(userVO.getTelephone());
                u.setMobile2(userVO.getTelephone2());
                u.setEmail(userVO.getEmail());
                if (!StringUtil.isBlank((String)userVO.getAvatar())) {
                    String avatar = userVO.getAvatarUri();
                    u.setAvatar(avatar + "?accessToken=" + this.getAccess_token());
                } else {
                    u.setAvatar("");
                }
                u.setDomain(userVO.getDomain().getName());
                DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
                DepartmentVO dept = (DepartmentVO)deptProcess.doView(userVO.getDefaultDepartment());
                u.setDept(dept.getName());
                if (me.getFavoriteContacts() != null && me.getFavoriteContacts().indexOf(userVO.getId()) >= 0) {
                    u.setFavoriteContact(true);
                } else {
                    u.setFavoriteContact(false);
                }
                users.add(u);
            }
            return this.addActionResult(true, "ok", users);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getDepartmentsBySearch.action"})
    @ResponseBody
    @ApiOperation(value="\u6a21\u7cca\u641c\u7d22\u90e8\u95e8", notes="\u6a21\u7cca\u641c\u7d22\u90e8\u95e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="keyWord", value="\u8054\u7cfb\u4eba\u59d3\u540d,\u9996\u5b57\u6bcd,\u7535\u8bdd", required=false, paramType="query", dataType="string")})
    public Map<String, Object> getDepartmentsBySearch() {
        ArrayList<Department> deptList = new ArrayList<Department>();
        WebUser webUser = this.getUser();
        ParamsTable params = this.getParams();
        String keyWord = params.getParameterAsString("keyWord");
        try {
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            List depts = (List)deptProcess.doQueryByDomainLikeName(webUser.getDomainid(), keyWord);
            for (DepartmentVO deptVO : depts) {
                Department dept = new Department();
                dept.setId(deptVO.getId());
                dept.setName(deptVO.getName());
                deptList.add(dept);
            }
            return this.addActionResult(true, "ok", deptList);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getContactsAndDeptsBySearch.action"})
    @ResponseBody
    @ApiOperation(value="\u6a21\u7cca\u641c\u7d22\u8054\u7cfb\u4eba\u548c\u90e8\u95e8", notes="\u6a21\u7cca\u641c\u7d22\u8054\u7cfb\u4eba\u548c\u90e8\u95e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="keyWord", value="\u8054\u7cfb\u4eba\u59d3\u540d,\u9996\u5b57\u6bcd,\u7535\u8bdd", required=false, paramType="query", dataType="string")})
    public Map<String, Object> getContactsAndDeptsBySearch() {
        ArrayList<Object> list = new ArrayList<Object>();
        WebUser webUser = this.getUser();
        ParamsTable params = this.getParams();
        String keyWord = params.getParameterAsString("keyWord");
        try {
            Department dept;
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection user = userProcess.queryByFuzzy(keyWord, webUser.getId());
            UserVO me = (UserVO)userProcess.doView(webUser.getId());
            for (UserVO userVO : user) {
                User u = new User();
                u.setId(userVO.getId());
                u.setName(userVO.getName());
                u.setMobile(userVO.getTelephone());
                u.setMobile2(userVO.getTelephone2());
                u.setEmail(userVO.getEmail());
                if (!StringUtil.isBlank((String)userVO.getAvatar())) {
                    String avatar = userVO.getAvatarUri();
                    u.setAvatar(avatar + "?accessToken=" + this.getAccess_token());
                } else {
                    u.setAvatar("");
                }
                u.setDomain(userVO.getDomain().getName());
                DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
                dept = (DepartmentVO)deptProcess.doView(userVO.getDefaultDepartment());
                u.setDept(dept.getName());
                if (me.getFavoriteContacts() != null && me.getFavoriteContacts().indexOf(userVO.getId()) >= 0) {
                    u.setFavoriteContact(true);
                } else {
                    u.setFavoriteContact(false);
                }
                list.add(u);
            }
            DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
            List depts = (List)deptProcess.doQueryByDomainLikeName(webUser.getDomainid(), keyWord);
            for (DepartmentVO deptVO : depts) {
                dept = new Department();
                dept.setId(deptVO.getId());
                dept.setName(deptVO.getName());
                list.add(dept);
            }
            return this.addActionResult(true, "ok", list);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/getFavoriteContacts.action"})
    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5e38\u7528\u8054\u7cfb\u4eba", notes="\u83b7\u53d6\u5e38\u7528\u8054\u7cfb\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string")})
    public Map<String, Object> getFavoriteContacts() {
        try {
            ArrayList<User> list = new ArrayList<User>();
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebUser user = this.getUser();
            UserVO vo = (UserVO)userProcess.doView(user.getId());
            int count = 0;
            if (!StringUtil.isBlank((String)vo.getFavoriteContacts())) {
                String[] ids = vo.getFavoriteContacts().split(";");
                List users = (List)userProcess.queryByUserIds(ids, user.getDomainid());
                UserVO me = (UserVO)userProcess.doView(user.getId());
                for (UserVO userVO : users) {
                    if (userVO.getStatus() != 1 || !"public".equals(userVO.getPermissionType())) continue;
                    User u = new User();
                    u.setId(userVO.getId());
                    u.setName(userVO.getName());
                    u.setMobile(userVO.getTelephone());
                    u.setMobile2(userVO.getTelephone2());
                    u.setEmail(userVO.getEmail());
                    if (!StringUtil.isBlank((String)userVO.getAvatar())) {
                        String avatar = userVO.getAvatarUri();
                        u.setAvatar(avatar + "?accessToken=" + this.getAccess_token());
                    } else {
                        u.setAvatar("");
                    }
                    u.setDomain(userVO.getDomain().getName());
                    DepartmentProcess deptProcess = AuthTimeServiceManager.departmentRuntimeService();
                    DepartmentVO dept = (DepartmentVO)deptProcess.doView(userVO.getDefaultDepartment());
                    u.setDept(dept.getName());
                    if (me.getFavoriteContacts() != null && me.getFavoriteContacts().indexOf(userVO.getId()) >= 0) {
                        u.setFavoriteContact(true);
                    } else {
                        u.setFavoriteContact(false);
                    }
                    list.add(u);
                    ++count;
                }
            }
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            map.put("datas", list);
            map.put("count", Integer.valueOf(count));
            return this.addActionResult(true, "ok", map);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/addFavoriteContact.action"})
    @ResponseBody
    @ApiOperation(value="\u6dfb\u52a0\u5e38\u7528\u8054\u7cfb\u4eba", notes="\u6dfb\u52a0\u5e38\u7528\u8054\u7cfb\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userId", value="\u8054\u7cfb\u4eba\u4e3b\u952e", required=true, paramType="query", dataType="string")})
    public Map<String, Object> addFavoriteContact() {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String userId = params.getParameterAsString("userId");
            UserVO userVO = (UserVO)userProcess.doView(user.getId());
            if (StringUtil.isBlank((String)userVO.getFavoriteContacts())) {
                userVO.setFavoriteContacts(userId);
            } else {
                userVO.setFavoriteContacts(userVO.getFavoriteContacts() + ";" + userId);
            }
            userProcess.doUpdate((AuthtimeValueObject)userVO);
            return this.addActionResult(true, "\u6dfb\u52a0\u6210\u529f", null);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @RequestMapping(value={"/removeFavoriteContact.action"})
    @ResponseBody
    @ApiOperation(value=" \u79fb\u9664\u5e38\u7528\u8054\u7cfb\u4eba", notes=" \u79fb\u9664\u5e38\u7528\u8054\u7cfb\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="access_token", value="access_token", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="userId", value="\u8054\u7cfb\u4eba\u4e3b\u952e", required=true, paramType="query", dataType="string")})
    public Map<String, Object> removeFavoriteContact() {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String userId = params.getParameterAsString("userId");
            UserVO userVO = (UserVO)userProcess.doView(user.getId());
            if (userVO.getFavoriteContacts().indexOf(userId) == 0) {
                userVO.setFavoriteContacts(userVO.getFavoriteContacts().replace(userId, ""));
            } else {
                userVO.setFavoriteContacts(userVO.getFavoriteContacts().replace(";" + userId, ""));
            }
            userProcess.doUpdate((AuthtimeValueObject)userVO);
            return this.addActionResult(true, "\u79fb\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            return this.addActionResult(false, e.getMessage(), null);
        }
    }
}

