/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.mobile.common.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseController {
    private static final Logger logger = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    protected HttpServletRequest request;
    protected static final long ACCESS_TOKEN_EXPIRES = 2592000000L;
    protected static final String ACTION_RESULT_KEY = "status";
    protected static final int ACTION_RESULT_VALUE_SUCCESS = 0;
    protected static final int ACTION_RESULT_VALUE_FAULT = 1;
    protected static final String ACTION_MESSAGE_KEY = "message";
    protected static final String ACTION_DATA_KEY = "data";
    protected Map<String, Object> dataMap = new HashMap<String, Object>();
    protected String[] _selects = null;
    protected String access_token = null;
    protected ParamsTable params;
    protected DataPackage<?> datas = null;
    protected Collection<?> list = null;

    public String[] get_selects() {
        return this._selects;
    }

    public void set_selects(String[] selects) {
        this._selects = selects;
    }

    public ParamsTable getParams() {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)this.request);
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public ParamsTable getParams(HttpServletRequest request) {
        if (this.params == null) {
            this.params = ParamsTable.convertHTTP((HttpServletRequest)request);
            String sessionId = "";
            this.params.setSessionid(sessionId);
            if (this.params.getParameter("_pagelines") == null) {
                this.params.setParameter("_pagelines", (Object)"10");
            }
        }
        return this.params;
    }

    public DataPackage<?> getDatas() {
        return this.datas;
    }

    public void setDatas(DataPackage<?> datas) {
        this.datas = datas;
    }

    public String getAccess_token() {
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public WebUser getUser() {
        WebUser webUser = null;
        try {
            webUser = AuthTimeServiceManager.getWebUser((HttpServletRequest)this.request);
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u8bf7\u6c42\u7528\u6237\u53d1\u751f\u5f02\u5e38:{}", (Object)Security.getTokenFromRequest((HttpServletRequest)this.request), (Object)ex);
        }
        return webUser;
    }

    public String getUserId() {
        return Security.getUserIdFromToken((HttpServletRequest)this.request);
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    public Collection<?> getList() {
        return this.list;
    }

    public void setList(Collection<?> list) {
        this.list = list;
    }

    public Map<String, Object> addActionResult(boolean isSuccess, String message, Object data) {
        this.dataMap.put(ACTION_RESULT_KEY, isSuccess ? 0 : 1);
        this.dataMap.put(ACTION_MESSAGE_KEY, message);
        if (data != null) {
            this.dataMap.put(ACTION_DATA_KEY, data);
        }
        return this.dataMap;
    }
}

