/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.menu.controller;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.resource.service.ResourceDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ResourceUtil {
    public boolean isLinkToView(String resourceid) throws Exception {
        ResourceDesignTimeService rosourceprocess = DesignTimeServiceManager.resourceDesignTimeService();
        ResourceVO resource = rosourceprocess.doView(resourceid);
        return resource != null && resource.getLinkType() != null && resource.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode());
    }

    public String getTotalRowByResourceid(String resourceid, HttpServletRequest request) {
        if (resourceid.length() <= 0) {
            return "0";
        }
        StringBuffer html = new StringBuffer();
        try {
            ViewDesignTimeService viewprocess = DesignTimeServiceManager.viewDesignTimeService();
            ResourceDesignTimeService resourceprocess = DesignTimeServiceManager.resourceDesignTimeService();
            ResourceVO resource = resourceprocess.doView(resourceid);
            if (resource == null) {
                return "0";
            }
            WebUser user = AuthTimeServiceManager.getWebUser((HttpServletRequest)request);
            if (resource.getLinkType().equals(ResourceVO.LinkType.VIEW.getCode())) {
                if (resource.getActionContent() == null || resource.getActionContent().equals("")) {
                    return "0";
                }
                AbstractView view = viewprocess.doView(resource.getActionContent());
                if (view != null) {
                    DataPackage datas = view.getViewTypeImpl().getViewDatas(new ParamsTable(), (IUser)user, new Document());
                    html.append(String.valueOf(datas.rowCount));
                    return html.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "0";
    }

    public static Map<String, String> deepSearchMenuTree(Collection<ResourceVO> cols, ResourceVO startNode, String excludeNodeId, int deep) throws Exception {
        Map<String, String> tmp;
        LinkedHashMap<String, String> list = new LinkedHashMap<String, String>();
        String prefix = "|------------------------------------------------";
        Iterator<ResourceVO> iter = cols.iterator();
        if (startNode == null) {
            list.put("", "{*[cn.myapps.core.resource.none]*}");
            while (iter.hasNext()) {
                ResourceVO vo = iter.next();
                if (vo.getId().equals(excludeNodeId) || !(vo.getParent() instanceof Application)) continue;
                if (!vo.getId().equals(excludeNodeId)) {
                    list.put(vo.getId(), prefix.substring(0, deep * 2) + vo.getName());
                }
                tmp = ResourceUtil.deepSearchMenuTree(cols, vo, excludeNodeId, deep + 2);
                list.putAll(tmp);
            }
        }
        if (startNode != null) {
            for (ResourceVO vo : cols) {
                if (vo.getId().equals(excludeNodeId) || !startNode.getId().equals(vo.getSuperior())) continue;
                list.put(vo.getId(), prefix.substring(0, deep * 2) + vo.getName());
                tmp = ResourceUtil.deepSearchMenuTree(cols, vo, excludeNodeId, deep + 2);
                list.putAll(tmp);
            }
        }
        return list;
    }
}

